/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.cde.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ve.internal.cde.core.IImageListener;
import org.eclipse.ve.internal.cde.core.IImageNotifier;
import org.eclipse.ve.internal.cde.core.ImageDataHelper;
import org.eclipse.ve.internal.cde.core.ImageFigure;
import org.eclipse.ve.internal.cde.core.OutlineBorder;

public class ImageFigureController {
    protected ImageFigure figure;
    protected IImageNotifier imageNotifier;
    protected Image image;
    private List lightenFigures;
    private List unlightenFigures;
    private ImageData imageData;
    private byte refreshState = 0;
    private boolean crossHatch;
    private static final RGB DEFAULT_LIGHTEN_RGB = new RGB(255, 255, 255);
    private RGB lightenColor = DEFAULT_LIGHTEN_RGB;
    private static final RGB DEFAULT_CROSSHATCH_COLOR = new RGB(128, 128, 128);
    private RGB crossHatchColor = DEFAULT_CROSSHATCH_COLOR;
    private double DEFAULT_ALPHA;
    private double alpha = this.DEFAULT_ALPHA = 0.5;
    private static final byte NO_REFRESH_PENDING = 0;
    private static final byte RECREATE_IMAGE = 1;
    private static final byte FIGURE_MOVED = 2;
    private Listeners listener;

    public void finalize() {
        this.deactivate();
        if (this.figure != null) {
            this.figure.setToolTip(null);
        }
    }

    public IFigure getFigure() {
        return this.figure;
    }

    public void setImageFigure(ImageFigure figure) {
        this.figure = figure;
    }

    public void deactivate() {
        if (this.imageNotifier != null) {
            this.imageNotifier.removeImageListener(this.getListener());
            this.imageNotifier = null;
        }
        ImageFigureController imageFigureController = this;
        synchronized (imageFigureController) {
            IFigure fig;
            Iterator itr;
            if (this.lightenFigures != null) {
                itr = this.lightenFigures.iterator();
                while (itr.hasNext()) {
                    fig = (IFigure)itr.next();
                    fig.removeFigureListener((FigureListener)this.getListener());
                    this.setBorderEanbleStates(fig, false);
                }
                this.lightenFigures = null;
            }
            if (this.unlightenFigures != null) {
                itr = this.unlightenFigures.iterator();
                while (itr.hasNext()) {
                    fig = (IFigure)itr.next();
                    fig.removeFigureListener((FigureListener)this.getListener());
                }
                this.unlightenFigures = null;
            }
            this.refreshState = 0;
        }
        this.disposeImage();
    }

    protected void disposeImage() {
        this.figure.setImage(null);
        if (this.image != null) {
            this.image.dispose();
            this.image = null;
        }
        this.imageData = null;
    }

    protected Listeners getListener() {
        if (this.listener == null) {
            this.listener = new Listeners();
        }
        return this.listener;
    }

    public void setImageNotifier(IImageNotifier notifier) {
        this.deactivate();
        if (notifier != null) {
            this.imageNotifier = notifier;
            this.imageNotifier.addImageListener(this.getListener());
            this.imageNotifier.invalidateImage();
            this.imageNotifier.refreshImage();
        }
    }

    protected synchronized void scheduleRefresh(byte refreshType) {
        if (refreshType == 2 && this.lightenFigures == null) {
            return;
        }
        this.refreshState = (byte)(this.refreshState | refreshType);
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                ImageFigureController imageFigureController = ImageFigureController.this;
                synchronized (imageFigureController) {
                    if (ImageFigureController.this.refreshState != 0) {
                        if (ImageFigureController.this.lightenFigures != null) {
                            ImageFigureController.this.refreshState = (byte)0;
                            this.setAndLightenImageData();
                        }
                        if ((ImageFigureController.this.refreshState & 1) != 0) {
                            ImageFigureController.this.refreshState = (byte)0;
                            this.recreateImage();
                        }
                    }
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            private void setAndLightenImageData() {
                Image newImage = null;
                if (ImageFigureController.this.imageData != null) {
                    ImageData lightenImageData = null;
                    org.eclipse.draw2d.geometry.Rectangle myRect = ImageFigureController.this.figure.getBounds();
                    int myOriginX = myRect.x;
                    int myOriginY = myRect.y;
                    Region region = new Region();
                    try {
                        org.eclipse.draw2d.geometry.Rectangle figRect;
                        IFigure fig;
                        Iterator itr = ImageFigureController.this.lightenFigures.iterator();
                        while (itr.hasNext()) {
                            fig = (IFigure)itr.next();
                            figRect = fig.getBounds();
                            region.add(new Rectangle(figRect.x - myOriginX, figRect.y - myOriginY, figRect.width, figRect.height));
                        }
                        itr = ImageFigureController.this.unlightenFigures.iterator();
                        while (itr.hasNext()) {
                            fig = (IFigure)itr.next();
                            figRect = fig.getBounds();
                            region.subtract(new Rectangle(figRect.x - myOriginX, figRect.y - myOriginY, figRect.width, figRect.height));
                        }
                        lightenImageData = !ImageFigureController.this.isCrossHatch() ? ImageDataHelper.mixAlphaWithinRegion(ImageFigureController.this.imageData, region, ImageFigureController.this.getAlpha(), ImageFigureController.this.getLightenColor()) : ImageDataHelper.mixAlphaAndCrossHatchWithinRegion(ImageFigureController.this.imageData, region, ImageFigureController.this.getAlpha(), ImageFigureController.this.getLightenColor(), ImageFigureController.this.getCrossHatchColor());
                        Object var10_12 = null;
                    }
                    catch (Throwable throwable) {
                        Object var10_11 = null;
                        region.dispose();
                        throw throwable;
                    }
                    region.dispose();
                    newImage = new Image((Device)Display.getCurrent(), lightenImageData);
                }
                ImageFigureController.this.figure.setImage(newImage);
                if (ImageFigureController.this.image != null) {
                    ImageFigureController.this.image.dispose();
                }
                ImageFigureController.this.image = newImage;
            }

            private void recreateImage() {
                Image newImage = null;
                if (ImageFigureController.this.imageData != null) {
                    newImage = new Image((Device)Display.getCurrent(), ImageFigureController.this.imageData);
                }
                ImageFigureController.this.figure.setImage(newImage);
                if (ImageFigureController.this.image != null) {
                    ImageFigureController.this.image.dispose();
                }
                ImageFigureController.this.image = newImage;
            }
        });
    }

    public void addLightenFigure(IFigure fig) {
        ImageFigureController imageFigureController = this;
        synchronized (imageFigureController) {
            if (this.lightenFigures == null) {
                this.lightenFigures = new ArrayList(2);
            }
            if (this.lightenFigures.contains(fig)) {
                return;
            }
            this.lightenFigures.add(fig);
            if (fig != this.figure) {
                fig.addFigureListener((FigureListener)this.getListener());
                this.setBorderEanbleStates(fig, true);
            }
        }
        if (this.imageNotifier != null) {
            this.scheduleRefresh((byte)2);
        }
    }

    private void setBorderEanbleStates(IFigure fig, boolean disableBorder) {
        if (fig instanceof ImageFigure) {
            Border border = fig.getBorder();
            if (border instanceof OutlineBorder) {
                ((OutlineBorder)border).setOverrideAndDisable(disableBorder);
            }
            List children = fig.getChildren();
            int i = 0;
            while (i < children.size()) {
                this.setBorderEanbleStates((IFigure)children.get(i), disableBorder);
                ++i;
            }
        }
    }

    public synchronized void removeLightenFigure(IFigure fig) {
        if (this.lightenFigures != null && this.lightenFigures.remove(fig)) {
            if (fig != this.figure) {
                fig.removeFigureListener((FigureListener)this.getListener());
            }
            if (this.lightenFigures.isEmpty()) {
                this.lightenFigures = null;
                this.scheduleRefresh((byte)1);
            } else {
                this.scheduleRefresh((byte)2);
            }
        }
    }

    public void addUnlightenFigure(IFigure aFigure) {
        ImageFigureController imageFigureController = this;
        synchronized (imageFigureController) {
            if (this.unlightenFigures == null) {
                this.unlightenFigures = new ArrayList(2);
            }
            if (this.unlightenFigures.contains(aFigure)) {
                return;
            }
            this.unlightenFigures.add(aFigure);
            if (aFigure != this.figure) {
                aFigure.addFigureListener((FigureListener)this.getListener());
                this.setBorderEanbleStates(aFigure, false);
            }
        }
        if (this.imageNotifier != null) {
            this.scheduleRefresh((byte)2);
        }
    }

    public synchronized void removeUnLightenFigure(IFigure fig) {
        if (this.unlightenFigures != null && this.unlightenFigures.remove(fig)) {
            if (fig != this.figure) {
                fig.removeFigureListener((FigureListener)this.getListener());
            }
            if (this.unlightenFigures.isEmpty() && this.lightenFigures == null) {
                this.unlightenFigures = null;
                this.scheduleRefresh((byte)1);
            } else {
                this.scheduleRefresh((byte)2);
            }
        }
    }

    public boolean hasUnlightenedFigures() {
        return this.unlightenFigures == null ? false : this.unlightenFigures.size() > 0;
    }

    public void setCrossHatch(boolean crossHatch) {
        this.crossHatch = crossHatch;
    }

    public boolean isCrossHatch() {
        return this.crossHatch;
    }

    public void setLightenColor(RGB lightenColor) {
        this.lightenColor = lightenColor == null ? DEFAULT_LIGHTEN_RGB : lightenColor;
    }

    public RGB getLightenColor() {
        return this.lightenColor;
    }

    public void setCrossHatchColor(RGB crossHatchColor) {
        this.crossHatchColor = crossHatchColor == null ? DEFAULT_CROSSHATCH_COLOR : crossHatchColor;
    }

    public RGB getCrossHatchColor() {
        return this.crossHatchColor;
    }

    public void setAlpha(double alpha) {
        this.alpha = alpha < 0.0 || alpha > 1.0 ? this.DEFAULT_ALPHA : alpha;
    }

    public double getAlpha() {
        return this.alpha;
    }

    private class Listeners
    implements IImageListener,
    FigureListener {
        Listeners() {
        }

        public void imageChanged(ImageData data) {
            ImageFigureController imageFigureController = ImageFigureController.this;
            synchronized (imageFigureController) {
                ImageFigureController.this.imageData = data;
                ImageFigureController.this.scheduleRefresh((byte)1);
            }
        }

        public void figureMoved(IFigure figure) {
            ImageFigureController.this.scheduleRefresh((byte)2);
        }
    }
}

