/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.cde.core;

import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.ve.internal.cde.core.ContainerPolicy;

public class TreeContainerEditPolicy
extends org.eclipse.gef.editpolicies.TreeContainerEditPolicy {
    protected ContainerPolicy containerPolicy;

    public TreeContainerEditPolicy(ContainerPolicy containerPolicy) {
        this.containerPolicy = containerPolicy;
    }

    public void activate() {
        super.activate();
        this.containerPolicy.setContainer(this.getHost().getModel());
    }

    public void deactivate() {
        super.deactivate();
        this.containerPolicy.setContainer(null);
    }

    protected EditPart findBeforePart(int index, List movingparts, List children) {
        EditPart beforePart = null;
        if (index >= 0 && index < children.size()) {
            ListIterator lItr = children.listIterator(index);
            beforePart = (EditPart)lItr.next();
            while (movingparts.contains(beforePart)) {
                if (lItr.hasNext()) {
                    beforePart = (EditPart)lItr.next();
                    continue;
                }
                beforePart = null;
                break;
            }
        }
        return beforePart;
    }

    public Command getCommand(Request req) {
        if (req.getType().equals("orphan children") || "delete".equals(req.getType())) {
            return this.containerPolicy.getCommand(req);
        }
        if ("delete dependant".equals(req.getType())) {
            return this.getDeleteDependantCommand(req);
        }
        return super.getCommand(req);
    }

    protected Command getAddCommand(ChangeBoundsRequest request) {
        EditPart beforePart = this.findBeforePart(this.findIndexOfTreeItemAt(request.getLocation()), Collections.EMPTY_LIST, this.getHost().getChildren());
        return this.containerPolicy.getAddCommand(ContainerPolicy.getChildren((GroupRequest)request), beforePart != null ? beforePart.getModel() : null);
    }

    protected Command getCreateCommand(CreateRequest request) {
        EditPart beforePart = this.findBeforePart(this.findIndexOfTreeItemAt(request.getLocation()), Collections.EMPTY_LIST, this.getHost().getChildren());
        return this.containerPolicy.getCreateCommand(request.getNewObject(), beforePart != null ? beforePart.getModel() : null);
    }

    protected Command getDeleteDependantCommand(Request request) {
        return this.containerPolicy.getCommand(request);
    }

    protected Command getMoveChildrenCommand(ChangeBoundsRequest request) {
        Command cmd1;
        List editparts = request.getEditParts();
        List children = this.getHost().getChildren();
        EditPart parent = this.getHost();
        int newIndex = this.findIndexOfTreeItemAt(request.getLocation());
        EditPart beforePart = this.findBeforePart(newIndex, editparts, children);
        boolean isMove = true;
        boolean isChanged = false;
        int index = newIndex;
        int i = 0;
        while (i < editparts.size()) {
            int oldIndex;
            EditPart child = (EditPart)editparts.get(i);
            if (isMove && child.getParent() != parent) {
                isMove = false;
            }
            if (isMove && !isChanged && (oldIndex = children.indexOf(child)) != index && oldIndex + 1 != index) {
                isChanged = true;
            }
            ++i;
            ++index;
        }
        if (isMove && !isChanged) {
            return UnexecutableCommand.INSTANCE;
        }
        if (isMove) {
            return this.containerPolicy.getMoveChildrenCommand(ContainerPolicy.getChildren((GroupRequest)request), beforePart != null ? beforePart.getModel() : null);
        }
        List childrenModels = ContainerPolicy.getChildren((GroupRequest)request);
        Command cmd = this.containerPolicy.getOrphanChildrenCommand(childrenModels);
        if (cmd != null) {
            cmd1 = this.containerPolicy.getAddCommand(childrenModels, beforePart != null ? beforePart.getModel() : null);
            if (cmd1 == null) {
                return UnexecutableCommand.INSTANCE;
            }
        } else {
            return UnexecutableCommand.INSTANCE;
        }
        cmd = cmd.chain(cmd1);
        return cmd;
    }
}

