/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.cde.core;

import org.eclipse.jface.util.ListenerList;
import org.eclipse.ve.internal.cde.core.IVisualComponentListener;

public class VisualComponentSupport {
    protected ListenerList componentListeners = null;

    public synchronized void addComponentListener(IVisualComponentListener aListener) {
        if (this.componentListeners == null) {
            this.componentListeners = new ListenerList(2);
        }
        this.componentListeners.add((Object)aListener);
    }

    public void fireComponentHidden() {
        if (this.componentListeners != null) {
            Object[] lists = null;
            VisualComponentSupport visualComponentSupport = this;
            synchronized (visualComponentSupport) {
                lists = this.componentListeners.getListeners();
            }
            int i = 0;
            while (i < lists.length) {
                IVisualComponentListener listener = (IVisualComponentListener)lists[i];
                listener.componentHidden();
                ++i;
            }
        }
    }

    public void fireComponentMoved(int x, int y) {
        if (this.componentListeners != null) {
            Object[] lists = null;
            VisualComponentSupport visualComponentSupport = this;
            synchronized (visualComponentSupport) {
                lists = this.componentListeners.getListeners();
            }
            int i = 0;
            while (i < this.componentListeners.size()) {
                IVisualComponentListener listener = (IVisualComponentListener)lists[i];
                listener.componentMoved(x, y);
                ++i;
            }
        }
    }

    public void fireComponentRefreshed() {
        if (this.componentListeners != null) {
            Object[] lists = null;
            VisualComponentSupport visualComponentSupport = this;
            synchronized (visualComponentSupport) {
                lists = this.componentListeners.getListeners();
            }
            int i = 0;
            while (i < this.componentListeners.size()) {
                IVisualComponentListener listener = (IVisualComponentListener)lists[i];
                listener.componentRefreshed();
                ++i;
            }
        }
    }

    public void fireComponentResized(int width, int height) {
        if (this.componentListeners != null) {
            Object[] lists = null;
            VisualComponentSupport visualComponentSupport = this;
            synchronized (visualComponentSupport) {
                lists = this.componentListeners.getListeners();
            }
            int i = 0;
            while (i < this.componentListeners.size()) {
                IVisualComponentListener listener = (IVisualComponentListener)lists[i];
                listener.componentResized(width, height);
                ++i;
            }
        }
    }

    public void fireComponentShown() {
        if (this.componentListeners != null) {
            Object[] lists = null;
            VisualComponentSupport visualComponentSupport = this;
            synchronized (visualComponentSupport) {
                lists = this.componentListeners.getListeners();
            }
            int i = 0;
            while (i < this.componentListeners.size()) {
                IVisualComponentListener listener = (IVisualComponentListener)lists[i];
                listener.componentShown();
                ++i;
            }
        }
    }

    public synchronized void removeComponentListener(IVisualComponentListener aListener) {
        this.componentListeners.remove((Object)aListener);
    }
}

