/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.cde.core;

import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.ve.internal.cde.core.GridFigure;

public class XYLayoutGridConstrainer {
    protected GridFigure gridFigure;

    public XYLayoutGridConstrainer(GridFigure gridFigure) {
        this.gridFigure = gridFigure;
    }

    public Rectangle adjustConstraintFor(Rectangle constraint) {
        int gridNum;
        int maxGridNum;
        GridFigure.GridData gd = new GridFigure.GridData();
        this.gridFigure.getGridData(gd);
        Rectangle result = constraint.getCopy();
        int gridMargin = gd.gridController.getGridMargin();
        if (constraint.x < gridMargin) {
            result.x = gridMargin;
        } else {
            maxGridNum = (int)Math.round((double)gd.gridBorder.width / gd.gridWidth);
            gridNum = (int)Math.round((double)(result.x - gridMargin) / (double)gd.gridController.getGridWidth());
            if (gridNum > maxGridNum) {
                gridNum = maxGridNum;
            }
            result.x = gridNum * gd.gridController.getGridWidth() + gridMargin;
        }
        if (constraint.y < gridMargin) {
            result.y = gridMargin;
        } else {
            maxGridNum = (int)Math.round((double)gd.gridBorder.height / gd.gridHeight);
            gridNum = (int)Math.round((double)(result.y - gridMargin) / (double)gd.gridController.getGridHeight());
            if (gridNum > maxGridNum) {
                gridNum = maxGridNum;
            }
            result.y = gridNum * gd.gridController.getGridHeight() + gridMargin;
        }
        return result;
    }
}

