/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.cde.core;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ve.internal.cde.core.CDEMessages;

public class ZoomHelperDialog
extends Dialog {
    public static final int NO_CHANGE = 0;
    List zoomlist;
    static String[] ZoomPercents = new String[]{"20", "40", "60", "80", "100", "120", "140", "160", "180", "200"};
    int oldValue;
    int newValue = 0;

    public ZoomHelperDialog(Shell parent, int zoomValue) {
        super(parent);
        this.oldValue = zoomValue;
    }

    public int getZoomValue() {
        return this.newValue;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(CDEMessages.getString("ZoomHelperDialog.label"));
        newShell.setImage(newShell.getDisplay().getSystemImage(4));
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Label label = new Label(area, 4);
        label.setText(CDEMessages.getString("ZoomHelperDialog.PERCENT"));
        this.zoomlist = new List(area, 2048);
        this.zoomlist.setLayoutData((Object)new GridData(1808));
        this.zoomlist.setItems(ZoomPercents);
        String value = Integer.toString(this.oldValue);
        if (this.zoomlist.indexOf(value) != -1) {
            this.zoomlist.setSelection(this.zoomlist.indexOf(value));
        }
        this.zoomlist.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                ZoomHelperDialog.this.okPressed();
            }

            public void widgetSelected(SelectionEvent e) {
            }
        });
        return area;
    }

    protected void okPressed() {
        if (this.zoomlist.getSelectionIndex() == -1) {
            this.newValue = 0;
        } else {
            String value = this.zoomlist.getItem(this.zoomlist.getSelectionIndex());
            this.newValue = Integer.parseInt(value);
            if (this.newValue == this.oldValue) {
                this.newValue = 0;
            }
        }
        super.okPressed();
    }

    protected Point getInitialLocation(Point initialSize) {
        return Display.getCurrent().getCursorLocation();
    }
}

