/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.cde.emf;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.parts.ScrollableThumbnail;
import org.eclipse.draw2d.parts.Thumbnail;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.KeyStroke;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CommandStackListener;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.DeleteAction;
import org.eclipse.gef.ui.actions.RedoAction;
import org.eclipse.gef.ui.actions.SaveAction;
import org.eclipse.gef.ui.actions.UndoAction;
import org.eclipse.gef.ui.actions.WorkbenchPartAction;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.gef.ui.parts.ContentOutlinePage;
import org.eclipse.gef.ui.parts.GraphicalViewerKeyHandler;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.gef.ui.parts.SelectionSynchronizer;
import org.eclipse.gef.ui.parts.TreeViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.ContainerGenerator;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.views.properties.IPropertySheetEntry;
import org.eclipse.ve.internal.cde.core.AnnotationLinkagePolicy;
import org.eclipse.ve.internal.cde.core.CDEMessages;
import org.eclipse.ve.internal.cde.core.CDEPlugin;
import org.eclipse.ve.internal.cde.core.DistributeController;
import org.eclipse.ve.internal.cde.core.GridController;
import org.eclipse.ve.internal.cde.core.GridPropertiesAction;
import org.eclipse.ve.internal.cde.core.IModelChangeController;
import org.eclipse.ve.internal.cde.core.ShowGridAction;
import org.eclipse.ve.internal.cde.core.SnapToGridAction;
import org.eclipse.ve.internal.cde.core.ZoomAction;
import org.eclipse.ve.internal.cde.core.ZoomController;
import org.eclipse.ve.internal.cde.core.ZoomInAction;
import org.eclipse.ve.internal.cde.core.ZoomOutAction;
import org.eclipse.ve.internal.cde.emf.CDEEmfMessages;
import org.eclipse.ve.internal.cde.emf.EMFAnnotationLinkagePolicy;
import org.eclipse.ve.internal.cde.emf.EMFEditDomainHelper;
import org.eclipse.ve.internal.cde.palette.Palette;
import org.eclipse.ve.internal.cde.rules.IRuleRegistry;
import org.eclipse.ve.internal.cdm.Diagram;
import org.eclipse.ve.internal.cdm.DiagramData;
import org.eclipse.ve.internal.propertysheet.AbstractPropertySheetEntry;
import org.eclipse.ve.internal.propertysheet.EToolsPropertySheetPage;
import org.eclipse.ve.internal.propertysheet.command.CommandStackPropertySheetEntry;
import org.osgi.framework.Bundle;

public abstract class EMFGraphicalEditorPart
extends EditorPart {
    protected boolean wantResourceListener = true;
    private ActionRegistry actionRegistry;
    private DefaultEditDomain domain;
    protected EToolsPropertySheetPage fPropertySheetPage;
    protected ListenerList fPropertySheetSelectionListeners = new ListenerList(1);
    protected EditPartViewer primaryViewer;
    protected PaletteViewer paletteViewer;
    protected Resource fResource;
    protected ResourceSet fResourceSet;
    protected SelectionSynchronizer selectionSynchronizer;
    private boolean fDirtyState = false;
    private boolean needToCloseEditor = false;
    private String filenameOfChangedResource = "";
    protected CommandStackListener fDirtyListener = new CommandStackListener(){

        public void commandStackChanged(EventObject event) {
            EMFGraphicalEditorPart.this.setDirty(true);
        }
    };
    protected IResourceChangeListener resourceListener;
    private KeyHandler outlineKeyHandler;
    private KeyHandler canvasKeyHandler;
    protected WorkbenchPartAction fOutlineDeleteAction;
    protected WorkbenchPartAction fCanvasDeleteAction;
    public static String GEF_DELETE_LABEL;
    public static String GEF_DELETE_TOOLTIP;
    protected AbstractPropertySheetEntry rootPropertySheetEntry;
    protected EMFContentOutlinePage outlinePage;
    private IPartListener partListener;
    private static ResourceSet sGlobalResourceSet;
    private static final Map XML_TEXT_OPTIONS;
    private EObject rootModel;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;

    static {
        XML_TEXT_OPTIONS = new HashMap(2);
        XML_TEXT_OPTIONS.put("PROCESS_DANGLING_HREF", "RECORD");
        XML_TEXT_OPTIONS.put("LINE_WIDTH", new Integer(100));
    }

    protected KeyHandler getOutlineKeyHandler() {
        if (this.outlineKeyHandler == null) {
            this.outlineKeyHandler = new KeyHandler();
            this.outlineKeyHandler.put(KeyStroke.getPressed((char)'\u007f', (int)127, (int)0), (IAction)this.getOutlineDeleteAction());
        }
        return this.outlineKeyHandler;
    }

    protected KeyHandler getCanvasKeyHandler() {
        if (this.canvasKeyHandler == null) {
            this.canvasKeyHandler = new KeyHandler();
            this.canvasKeyHandler.put(KeyStroke.getPressed((char)'\u007f', (int)127, (int)0), (IAction)this.getCanvasDeleteAction());
        }
        return this.canvasKeyHandler;
    }

    protected WorkbenchPartAction getOutlineDeleteAction() {
        if (this.fOutlineDeleteAction == null) {
            this.fOutlineDeleteAction = new DeleteAction((IWorkbenchPart)this);
            ((DeleteAction)this.fOutlineDeleteAction).setSelectionProvider((ISelectionProvider)this.getContentOutlinePage());
        }
        return this.fOutlineDeleteAction;
    }

    protected WorkbenchPartAction getCanvasDeleteAction() {
        if (this.fCanvasDeleteAction == null) {
            this.fCanvasDeleteAction = new DeleteAction((IWorkbenchPart)this);
            ((DeleteAction)this.fCanvasDeleteAction).setSelectionProvider((ISelectionProvider)this.getPrimaryViewer());
        }
        return this.fCanvasDeleteAction;
    }

    public static String getGEFDeleteLabel() {
        if (GEF_DELETE_LABEL == null) {
            GEF_DELETE_LABEL = Platform.getResourceString((Bundle)Platform.getBundle((String)"org.eclipse.gef"), (String)"%DeleteAction.Label");
        }
        return GEF_DELETE_LABEL;
    }

    public static String getGEFDeleteTooltip() {
        if (GEF_DELETE_TOOLTIP == null) {
            GEF_DELETE_TOOLTIP = Platform.getResourceString((Bundle)Platform.getBundle((String)"org.eclipse.gef"), (String)"%DeleteAction.Tooltip");
        }
        return GEF_DELETE_TOOLTIP;
    }

    protected void closeEditor(final boolean save) {
        Display display = this.getSite().getShell().getDisplay();
        display.asyncExec(new Runnable(){

            public void run() {
                EMFGraphicalEditorPart.this.getSite().getPage().closeEditor((IEditorPart)EMFGraphicalEditorPart.this, save);
            }
        });
    }

    protected ActionRegistry createActionRegistry() {
        return new ActionRegistry();
    }

    protected DefaultEditDomain createEditDomain() {
        org.eclipse.ve.internal.cde.core.EditDomain dom = new org.eclipse.ve.internal.cde.core.EditDomain((IEditorPart)this);
        dom.setRuleRegistry(this.createRuleRegistry());
        dom.setAnnotationLinkagePolicy(this.createLinkagePolicy());
        dom.setData("org.eclipse.ve.internal.cde.core.IModelChangeController", new IModelChangeController(){
            private int compoundChangeCount = 0;
            private int holdState = 0;
            private String holdMsg = null;

            public synchronized boolean inTransaction() {
                return this.compoundChangeCount > 0;
            }

            public void setHoldChanges(boolean flag, String msg) {
            }

            public boolean isHoldChanges() {
                return false;
            }

            public int getHoldState() {
                return this.holdState;
            }

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public boolean run(Runnable runnable, boolean updatePS) {
                if (this.getHoldState() != 0) {
                    return false;
                }
                try {
                    this.startChange();
                    runnable.run();
                    if (updatePS && EMFGraphicalEditorPart.this.rootPropertySheetEntry != null) {
                        EMFGraphicalEditorPart.this.rootPropertySheetEntry.refreshFromRoot();
                    }
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    this.stopChange();
                    throw throwable;
                }
                {
                    Object var3_5 = null;
                    this.stopChange();
                    return true;
                }
            }

            private synchronized void startChange() {
                ++this.compoundChangeCount;
            }

            private synchronized void stopChange() {
                if (--this.compoundChangeCount <= 0) {
                    this.compoundChangeCount = 0;
                }
            }

            public String getHoldMsg() {
                return this.holdMsg;
            }

            public void setHoldState(int stateFlag, String msg) {
                this.holdState = stateFlag;
                this.holdMsg = this.holdState != 0 ? (msg != null ? msg : "Editor cannot be changed at this time.") : null;
            }
        });
        return dom;
    }

    protected IRuleRegistry createRuleRegistry() {
        return null;
    }

    protected AnnotationLinkagePolicy createLinkagePolicy() {
        return new EMFAnnotationLinkagePolicy();
    }

    protected void addToCanvasContextMenu(IMenuManager menu) {
        WorkbenchPartAction deleteAction = this.getCanvasDeleteAction();
        if (deleteAction.isEnabled()) {
            menu.add((IAction)deleteAction);
        }
    }

    protected void addToOutlineContextMenu(IMenuManager menu) {
        WorkbenchPartAction deleteAction = this.getOutlineDeleteAction();
        if (deleteAction.isEnabled()) {
            menu.add((IAction)deleteAction);
        }
    }

    protected void contextMenuAboutToShow(IMenuManager menu, ISelectionProvider aSelectionProvider) {
    }

    protected void createPrimaryViewer() {
        this.primaryViewer = new ScrollingGraphicalViewer();
        this.primaryViewer.setRootEditPart((RootEditPart)new ScalableFreeformRootEditPart());
        this.primaryViewer.setEditDomain((EditDomain)this.getDomain());
        ((org.eclipse.ve.internal.cde.core.EditDomain)this.getDomain()).setViewerData(this.primaryViewer, "org.eclipse.ve.internal.cde.core.zoomkey", new ZoomController());
        ((org.eclipse.ve.internal.cde.core.EditDomain)this.getDomain()).setViewerData(this.primaryViewer, "org.eclipse.ve.internal.cde.core.gridkey", new GridController());
        ((org.eclipse.ve.internal.cde.core.EditDomain)this.getDomain()).setViewerData(this.primaryViewer, "org.eclipse.ve.internal.cde.core.distributekey", new DistributeController((GraphicalViewer)this.primaryViewer));
        this.primaryViewer.setKeyHandler(new GraphicalViewerKeyHandler((GraphicalViewer)this.primaryViewer).setParent(this.getCanvasKeyHandler()));
        this.actionRegistry.registerAction((IAction)this.getCanvasDeleteAction());
        this.getDomain().addViewer(this.primaryViewer);
    }

    public void createPrimaryViewerControl(Composite parent) {
        Canvas canvas = new Canvas(parent, 2048);
        StackLayout stack = new StackLayout();
        stack.topControl = this.getPrimaryViewer().createControl((Composite)canvas);
        canvas.setLayout((Layout)stack);
        MenuManager menuMgr = this.createMenuManager(stack.topControl);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menuMgr) {
                EMFGraphicalEditorPart.this.addToCanvasContextMenu(menuMgr);
                EMFGraphicalEditorPart.this.contextMenuAboutToShow(menuMgr, (ISelectionProvider)EMFGraphicalEditorPart.this.getPrimaryViewer());
                menuMgr.add((IContributionItem)new GroupMarker("additions"));
            }
        });
        this.getSite().registerContextMenu("EMFGraphicalEditorPart.graphviewer", menuMgr, (ISelectionProvider)this.getPrimaryViewer());
    }

    protected MenuManager createMenuManager(Control control) {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        Menu menu = menuMgr.createContextMenu(control);
        control.setMenu(menu);
        return menuMgr;
    }

    public void createPaletteControl(Composite parent) {
        this.primCreatePaletteControl(parent);
    }

    protected void primCreatePaletteControl(Composite parent) {
        if (this.paletteViewer == null) {
            this.paletteViewer = new PaletteViewer();
            this.paletteViewer.createControl(parent);
        }
        this.getDomain().setPaletteViewer(this.paletteViewer);
        this.setPaletteRoot();
    }

    public void createPartControl(Composite c) {
        SashForm splitter = new SashForm(c, 256);
        this.createPaletteControl((Composite)splitter);
        this.createPrimaryViewerControl((Composite)splitter);
        splitter.setWeights(new int[]{1, 4});
    }

    protected void createPartControlWithErrors(Composite parent, IMarker[] markers) {
        String[] errorMessages = new String[markers.length];
        int i = 0;
        while (i < markers.length) {
            try {
                if (markers[i].exists() || markers[i].getAttribute("message") != null) {
                    String msg = (String)markers[i].getAttribute("message");
                    if (markers[i].getAttribute("lineNumber") != null) {
                        Integer linenum = (Integer)markers[i].getAttribute("lineNumber");
                        msg = MessageFormat.format(CDEEmfMessages.getString("Line_number"), msg, linenum.toString());
                    }
                    errorMessages[i] = msg;
                }
            }
            catch (CoreException exc) {
                CDEPlugin.getPlugin().getLog().log(exc.getStatus());
            }
            ++i;
        }
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData());
        Text text = new Text(composite, 74);
        text.setForeground(text.getDisplay().getSystemColor(3));
        text.setBackground(text.getDisplay().getSystemColor(15));
        text.setText(this.getErrorTextMessage());
        text.setLayoutData((Object)new GridData());
        text = new Text(composite, 12);
        text.setForeground(text.getDisplay().getSystemColor(9));
        text.setBackground(text.getDisplay().getSystemColor(15));
        text.setText(CDEEmfMessages.getString("List_of_errors"));
        text.setLayoutData((Object)new GridData());
        org.eclipse.swt.widgets.List list = new org.eclipse.swt.widgets.List(composite, 2816);
        list.setItems(errorMessages);
        list.setLayoutData((Object)new GridData(768));
    }

    public void dispose() {
        try {
            if (this.getEditorInput() != null && this.resourceListener != null) {
                IFile file = ((IFileEditorInput)this.getEditorInput()).getFile();
                file.getWorkspace().removeResourceChangeListener(this.resourceListener);
            }
            if (this.partListener != null) {
                this.getSite().getWorkbenchWindow().getPartService().removePartListener(this.partListener);
            }
        }
        catch (Throwable t) {
            CDEPlugin.getPlugin().getLog().log((IStatus)new Status(2, CDEPlugin.getPlugin().getPluginID(), 0, "", t));
        }
        try {
            this.getDomain().setDefaultTool(null);
        }
        catch (Throwable t) {
            CDEPlugin.getPlugin().getLog().log((IStatus)new Status(2, CDEPlugin.getPlugin().getPluginID(), 0, "", t));
        }
        this.getActionRegistry().dispose();
        try {
            ((org.eclipse.ve.internal.cde.core.EditDomain)this.getDomain()).dispose();
        }
        catch (Throwable throwable) {}
        super.dispose();
    }

    protected ActionRegistry getActionRegistry() {
        if (this.actionRegistry == null) {
            this.actionRegistry = this.createActionRegistry();
        }
        return this.actionRegistry;
    }

    public Object getAdapter(Class type) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.views.properties.IPropertySheetPage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (type == clazz) {
            return this.getPropertySheetPage();
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.gef.GraphicalViewer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (type == clazz2) {
            return this.getPrimaryViewer();
        }
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("org.eclipse.ui.views.contentoutline.IContentOutlinePage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (type == clazz3) {
            return this.getContentOutlinePage();
        }
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("org.eclipse.gef.commands.CommandStack");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (type == clazz4) {
            return this.getDomain().getCommandStack();
        }
        Class<?> clazz5 = class$4;
        if (clazz5 == null) {
            try {
                clazz5 = class$4 = Class.forName("org.eclipse.gef.ui.actions.ActionRegistry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (type == clazz5) {
            return this.getActionRegistry();
        }
        Class<?> clazz6 = class$5;
        if (clazz6 == null) {
            try {
                clazz6 = class$5 = Class.forName("org.eclipse.ve.internal.cde.core.EditDomain");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (type == clazz6) {
            return (org.eclipse.ve.internal.cde.core.EditDomain)this.getDomain();
        }
        Class<?> clazz7 = class$6;
        if (clazz7 == null) {
            try {
                clazz7 = class$6 = Class.forName("org.eclipse.gef.palette.PaletteRoot");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (type == clazz7) {
            return ((org.eclipse.ve.internal.cde.core.EditDomain)this.getDomain()).getPaletteRoot();
        }
        return super.getAdapter(type);
    }

    public void addPropertySheetSelectionChangeListener(ISelectionChangedListener aSelectionListener) {
        if (this.fPropertySheetPage != null) {
            this.fPropertySheetPage.addSelectionChangedListener(aSelectionListener);
        }
        this.fPropertySheetSelectionListeners.add((Object)aSelectionListener);
    }

    public void removePropertySheetSelectionChangelListener(ISelectionChangedListener aSelectionListener) {
        if (this.fPropertySheetPage != null) {
            this.fPropertySheetPage.removeSelectionChangedListener(aSelectionListener);
        }
        this.fPropertySheetSelectionListeners.remove((Object)aSelectionListener);
    }

    public final boolean isPropertySheetCreated() {
        return this.fPropertySheetPage != null;
    }

    public final EToolsPropertySheetPage getPropertySheetPage() {
        if (this.fPropertySheetPage == null) {
            this.fPropertySheetPage = this.createPropertySheetPage();
            if (!this.fPropertySheetSelectionListeners.isEmpty()) {
                Object[] listeners = this.fPropertySheetSelectionListeners.getListeners();
                int i = 0;
                while (i < listeners.length) {
                    this.fPropertySheetPage.addSelectionChangedListener((ISelectionChangedListener)listeners[i]);
                    ++i;
                }
            }
            this.fPropertySheetPage.setRootEntry((IPropertySheetEntry)this.createRootPropertySheetEntry());
            this.fPropertySheetPage.addListener(new EToolsPropertySheetPage.Listener(){

                public void controlCreated(Control control) {
                    control.addDisposeListener(new DisposeListener(this){
                        final /* synthetic */ 9 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void widgetDisposed(DisposeEvent e) {
                            9.access$0(this.this$1).fPropertySheetPage = null;
                            9.access$0(this.this$1).rootPropertySheetEntry = null;
                        }
                    });
                }

                static /* synthetic */ EMFGraphicalEditorPart access$0(9 var0) {
                    return var0.EMFGraphicalEditorPart.this;
                }
            });
        }
        return this.fPropertySheetPage;
    }

    protected EToolsPropertySheetPage createPropertySheetPage() {
        return new EToolsPropertySheetPage(){

            public void setActionBars(IActionBars actionBars) {
                super.setActionBars(actionBars);
                ActionRegistry registry = EMFGraphicalEditorPart.this.getActionRegistry();
                actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), registry.getAction((Object)ActionFactory.UNDO.getId()));
                actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), registry.getAction((Object)ActionFactory.REDO.getId()));
            }
        };
    }

    protected AbstractPropertySheetEntry createRootPropertySheetEntry() {
        this.rootPropertySheetEntry = new CommandStackPropertySheetEntry(this.getCommandStack(), null, null);
        return this.rootPropertySheetEntry;
    }

    protected CommandStack getCommandStack() {
        return this.getDomain().getCommandStack();
    }

    public final DefaultEditDomain getDomain() {
        if (this.domain == null) {
            this.domain = this.createEditDomain();
            this.getDomain().getCommandStack().addCommandStackListener(this.fDirtyListener);
        }
        return this.domain;
    }

    public EditPartViewer getPrimaryViewer() {
        return this.primaryViewer;
    }

    public EditPartViewer getPaletteViewer() {
        return this.paletteViewer;
    }

    protected EMFContentOutlinePage getContentOutlinePage() {
        if (this.outlinePage == null) {
            this.outlinePage = this.createOutlinePage();
        }
        return this.outlinePage;
    }

    protected EMFContentOutlinePage createOutlinePage() {
        return new EMFContentOutlinePage((EditPartViewer)new TreeViewer());
    }

    protected final void setPaletteRoot() {
        PaletteRoot palette = this.getPaletteRoot();
        if (palette == null) {
            try {
                palette = (PaletteRoot)this.getResourceSet().getEObject(URI.createURI((String)"platform:/plugin/org.eclipse.ve.cde/cde_palette.xmi#cde_palette"), true);
            }
            catch (RuntimeException e) {
                CDEPlugin.getPlugin().getLog().log((IStatus)new Status(2, CDEPlugin.getPlugin().getBundle().getSymbolicName(), 0, "", (Throwable)e));
            }
        }
        this.closeDrawers((PaletteContainer)palette);
        this.getDomain().setPaletteRoot(palette);
    }

    protected String getPaletteHRef() {
        return this.getConfigurationElement().getAttributeAsIs("palette");
    }

    protected PaletteRoot getPaletteRoot() {
        String paletteHRef = this.getPaletteHRef();
        if (paletteHRef != null) {
            try {
                Palette ref = (Palette)this.getResourceSet().getEObject(URI.createURI((String)paletteHRef), true);
                return (PaletteRoot)ref.getEntry();
            }
            catch (RuntimeException e) {
                CDEPlugin.getPlugin().getLog().log((IStatus)new Status(2, CDEPlugin.getPlugin().getBundle().getSymbolicName(), 0, "", (Throwable)e));
            }
        }
        return null;
    }

    protected void closeDrawers(PaletteContainer ctr) {
        if (ctr instanceof PaletteDrawer) {
            ((PaletteDrawer)ctr).setInitialState(1);
        }
        List c = ctr.getChildren();
        int i = 0;
        while (i < c.size()) {
            PaletteEntry e = (PaletteEntry)c.get(i);
            if (e instanceof PaletteContainer) {
                this.closeDrawers((PaletteContainer)e);
            }
            ++i;
        }
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (!(input instanceof IFileEditorInput)) {
            throw new PartInitException(MessageFormat.format(CDEMessages.getString("NOT_FILE_INPUT_ERROR_"), input.getName()));
        }
        this.setSite((IWorkbenchPartSite)site);
        this.initialize();
        this.setInput(input);
    }

    protected void initialize() {
        this.initActionRegistry();
        this.initViewers();
        if (this.wantResourceListener) {
            this.partListener = new IPartListener(){

                public void partActivated(IWorkbenchPart part) {
                    if (part != EMFGraphicalEditorPart.this) {
                        return;
                    }
                    if (!((IFileEditorInput)EMFGraphicalEditorPart.this.getEditorInput()).getFile().exists()) {
                        Shell shell = EMFGraphicalEditorPart.this.getSite().getShell();
                        String title = CDEEmfMessages.getString("FILE_DELETED_TITLE_UI_");
                        String message = CDEEmfMessages.getString("FILE_DELETED_WITHOUT_SAVE_INFO_");
                        String[] buttons = new String[]{CDEEmfMessages.getString("SAVE_BUTTON_UI_"), CDEEmfMessages.getString("CLOSE_BUTTON_UI")};
                        MessageDialog dialog = new MessageDialog(shell, title, null, message, 3, buttons, 0);
                        if (dialog.open() == 0) {
                            if (!EMFGraphicalEditorPart.this.performSaveAs()) {
                                this.partActivated(part);
                            }
                        } else {
                            EMFGraphicalEditorPart.this.closeEditor(false);
                        }
                    }
                }

                public void partBroughtToTop(IWorkbenchPart part) {
                }

                public void partClosed(IWorkbenchPart part) {
                }

                public void partDeactivated(IWorkbenchPart part) {
                }

                public void partOpened(IWorkbenchPart part) {
                }
            };
            this.getSite().getWorkbenchWindow().getPartService().addPartListener(this.partListener);
        }
    }

    public boolean isDirty() {
        return this.fDirtyState;
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    protected void initActionRegistry() {
        this.getActionRegistry();
        this.actionRegistry.registerAction((IAction)new UndoAction((IEditorPart)this));
        this.actionRegistry.registerAction((IAction)new RedoAction((IEditorPart)this));
        this.actionRegistry.registerAction((IAction)new SaveAction((IEditorPart)this));
        this.actionRegistry.registerAction((IAction)new ZoomAction((IEditorPart)this));
        this.actionRegistry.registerAction((IAction)new ZoomInAction((IEditorPart)this));
        this.actionRegistry.registerAction((IAction)new ZoomOutAction((IEditorPart)this));
        ShowGridAction sgAction = new ShowGridAction((IEditorPart)this);
        this.actionRegistry.registerAction((IAction)sgAction);
        this.actionRegistry.registerAction((IAction)new GridPropertiesAction((IEditorPart)this, sgAction));
        this.actionRegistry.registerAction((IAction)new SnapToGridAction((IEditorPart)this, sgAction));
    }

    protected void initViewers() {
        this.createPrimaryViewer();
        this.getSite().setSelectionProvider((ISelectionProvider)this.getPrimaryViewer());
        this.getSelectionSynchronizer().addViewer(this.getPrimaryViewer());
    }

    protected SelectionSynchronizer getSelectionSynchronizer() {
        if (this.selectionSynchronizer == null) {
            this.selectionSynchronizer = new SelectionSynchronizer();
        }
        return this.selectionSynchronizer;
    }

    public void setActionRegistry(ActionRegistry registry) {
        this.actionRegistry = registry;
    }

    public void setFocus() {
        Control c = this.getPrimaryViewer().getControl();
        if (c != null && !c.isDisposed()) {
            if (this.needToCloseEditor) {
                String msg = MessageFormat.format(CDEEmfMessages.getString("Resource_changed_please_close_editor_message_WARN_"), this.filenameOfChangedResource);
                Shell shell = this.getSite().getShell();
                MessageDialog.openWarning((Shell)shell, (String)CDEEmfMessages.getString("Warning_message_dialog_title_WARN_"), (String)msg);
                this.needToCloseEditor = false;
                return;
            }
            c.setFocus();
        }
    }

    protected void setDirty(boolean dirty) {
        if (!dirty || !this.fDirtyState) {
            this.fDirtyState = dirty;
            this.firePropertyChange(257);
        }
    }

    protected abstract Resource createEmptyResource(String var1, ResourceSet var2);

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected EObject getModel(IFile file) throws CoreException, IOException, Exception {
        EObject rootModel = null;
        InputStream is = null;
        try {
            is = file.getContents();
        }
        catch (CoreException exc) {
            if (exc.getStatus().getCode() != 274) throw exc;
            file.refreshLocal(0, null);
            is = file.getContents();
        }
        try {
            this.fResource = is.available() == 0 ? this.createEmptyResource(file.getLocation().toString(), this.getResourceSet()) : this.readDocument(file.getFullPath().toString(), is);
            if (this.fResource != null) {
                rootModel = this.getModel(this.fResource);
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            try {
                is.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        try {}
        catch (IOException iOException) {
            return rootModel;
        }
        is.close();
        return rootModel;
    }

    protected void setupDiagramData(DiagramData dd) {
        ((org.eclipse.ve.internal.cde.core.EditDomain)this.getDomain()).setDiagramData(dd);
        Diagram d = null;
        Iterator iter = dd.getDiagrams().iterator();
        while (iter.hasNext()) {
            Diagram element = (Diagram)iter.next();
            if (!"org.eclipse.ve.internal.cdm.primarydiagram".equals(element.getId())) continue;
            d = element;
            break;
        }
        if (d != null) {
            ((org.eclipse.ve.internal.cde.core.EditDomain)this.getDomain()).setViewerData(this.getPrimaryViewer(), "org.eclipse.ve.internal.cde.core.diagramkey", d);
        }
    }

    protected abstract EObject getModel(Resource var1);

    protected abstract EditPart getEditPart(EObject var1);

    protected abstract EditPart getTreeEditPart(EObject var1);

    public final ResourceSet getResourceSet() {
        if (this.fResourceSet == null) {
            this.fResourceSet = this.createResourceSet();
            this.initializeResourceSet(this.fResourceSet);
        }
        return this.fResourceSet;
    }

    public final Resource getResource() {
        return this.fResource;
    }

    protected ResourceSet createResourceSet() {
        ResourceSetImpl rs = new ResourceSetImpl();
        return rs;
    }

    protected void initializeResourceSet(ResourceSet rs) {
        EMFEditDomainHelper.setResourceSet(rs, (org.eclipse.ve.internal.cde.core.EditDomain)this.getDomain());
    }

    public static final ResourceSet getGlobalResourceSet() {
        if (sGlobalResourceSet == null) {
            sGlobalResourceSet = new ResourceSetImpl();
        }
        return sGlobalResourceSet;
    }

    protected Resource readDocument(String uri, InputStream is) throws Exception {
        Resource res = null;
        res = this.getResourceSet().createResource(URI.createURI((String)uri));
        res.load(is, Collections.EMPTY_MAP);
        return res;
    }

    protected String getErrorTextMessage() {
        return CDEEmfMessages.getString("Error_text_message_ERROR_");
    }

    public abstract void gotoMarker(IMarker var1);

    protected abstract void handleResourceChanged();

    public void doSave(IProgressMonitor monitor) {
        if (this.getEditorInput() == null || ((IFileEditorInput)this.getEditorInput()).getFile() == null || !((IFileEditorInput)this.getEditorInput()).getFile().exists()) {
            if (this.isSaveAsAllowed()) {
                this.doSaveAs();
            }
            return;
        }
        this.save(monitor);
    }

    protected void save(IProgressMonitor monitor) {
        org.eclipse.ve.internal.cde.core.EditDomain dom = (org.eclipse.ve.internal.cde.core.EditDomain)this.getDomain();
        Command cmd = dom.getAnnotationLinkagePolicy().cleanupDiagramData(dom.getDiagramData());
        if (cmd != null) {
            cmd.execute();
        }
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) throws CoreException {
                monitor.beginTask(CDEMessages.getString("SAVING_UI_"), 2000);
                try {
                    IFile file = ((IFileEditorInput)EMFGraphicalEditorPart.this.getEditorInput()).getFile();
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    try {
                        EObject rootmodel = EMFGraphicalEditorPart.this.getModel(EMFGraphicalEditorPart.this.fResource);
                        if (rootmodel != null) {
                            EMFGraphicalEditorPart.this.validateModel(rootmodel);
                        }
                        EMFGraphicalEditorPart.this.fResource.save((OutputStream)os, XML_TEXT_OPTIONS);
                    }
                    catch (Exception e) {
                        throw new CoreException((IStatus)new Status(4, CDEPlugin.getPlugin().getBundle().getSymbolicName(), 0, MessageFormat.format(CDEMessages.getString("SAVE_FAIL_ERROR_"), file.getFullPath().toString()), (Throwable)e));
                    }
                    monitor.worked(1000);
                    ByteArrayInputStream stream = new ByteArrayInputStream(os.toByteArray());
                    file.setContents((InputStream)stream, false, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
                }
                catch (Exception e) {
                    throw new CoreException((IStatus)new Status(4, CDEPlugin.getPlugin().getBundle().getSymbolicName(), 0, MessageFormat.format(CDEMessages.getString("SAVE_FAIL_ERROR_"), EMFGraphicalEditorPart.this.fResource.getURI().toString()), (Throwable)e));
                }
                EMFGraphicalEditorPart.this.setDirty(false);
                monitor.done();
            }
        };
        try {
            op.run(monitor);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException e) {
            Throwable eReal = e.getTargetException();
            Object status = null;
            status = eReal instanceof CoreException ? ((CoreException)eReal).getStatus() : new Status(4, CDEPlugin.getPlugin().getBundle().getSymbolicName(), 0, MessageFormat.format(CDEMessages.getString("SAVE_FAIL_ERROR_"), this.fResource.getURI().toString()), eReal);
            CDEPlugin.getPlugin().getLog().log(status);
            this.showErrorMessage(status.getMessage());
        }
    }

    public void doSaveAs() {
        this.performSaveAs();
    }

    protected boolean performSaveAs() {
        Shell shell = this.getSite().getShell();
        SaveAsDialog dialog = new SaveAsDialog(shell);
        dialog.setOriginalFile(((IFileEditorInput)this.getEditorInput()).getFile());
        dialog.open();
        IPath path = dialog.getResult();
        if (path == null) {
            return false;
        }
        final IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
        org.eclipse.ve.internal.cde.core.EditDomain dom = (org.eclipse.ve.internal.cde.core.EditDomain)this.getDomain();
        Command cmd = dom.getAnnotationLinkagePolicy().cleanupDiagramData(dom.getDiagramData());
        if (cmd != null) {
            cmd.execute();
        }
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) throws CoreException {
                monitor.beginTask(CDEMessages.getString("SAVING_AS_UI_"), 2000);
                EMFGraphicalEditorPart.this.saveAs((IProgressMonitor)new SubProgressMonitor(monitor, 1000), file, EMFGraphicalEditorPart.this.fResource);
                EMFGraphicalEditorPart.this.setInput((IEditorInput)new FileEditorInput(file));
                monitor.done();
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().run(false, false, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException e) {
            Throwable eReal = e.getTargetException();
            Object status = null;
            status = eReal instanceof CoreException ? ((CoreException)eReal).getStatus() : new Status(4, CDEPlugin.getPlugin().getBundle().getSymbolicName(), 0, MessageFormat.format(CDEMessages.getString("SAVE_FAIL_ERROR_"), path.toString()), eReal);
            CDEPlugin.getPlugin().getLog().log(status);
            this.showErrorMessage(status.getMessage());
        }
        return true;
    }

    protected void saveAs(IProgressMonitor monitor, IFile file, Resource resource) throws CoreException {
        monitor.beginTask("", 3000);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            resource.save((OutputStream)os, XML_TEXT_OPTIONS);
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, CDEPlugin.getPlugin().getBundle().getSymbolicName(), 0, MessageFormat.format(CDEMessages.getString("SAVE_FAIL_ERROR_"), file.getFullPath().toString()), (Throwable)e));
        }
        ByteArrayInputStream stream = new ByteArrayInputStream(os.toByteArray());
        if (file.exists()) {
            file.setContents((InputStream)stream, false, true, (IProgressMonitor)new SubProgressMonitor(monitor, 2000));
        } else {
            ContainerGenerator locator = new ContainerGenerator(file.getParent().getFullPath());
            locator.generateContainer((IProgressMonitor)new SubProgressMonitor(monitor, 1000));
            file.create((InputStream)stream, false, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
        }
        monitor.done();
    }

    protected EditPart getRootTreeEditPart() {
        return this.getTreeEditPart(this.getRootModel());
    }

    protected EObject getRootModel() {
        return this.rootModel;
    }

    protected void setInput(IEditorInput input) {
        if (!input.equals(this.getEditorInput())) {
            this.superSetInput(input);
            IFileEditorInput fileInput = (IFileEditorInput)input;
            IFile file = fileInput.getFile();
            try {
                Resource oldResource = this.fResource;
                org.eclipse.ve.internal.cde.core.EditDomain dom = (org.eclipse.ve.internal.cde.core.EditDomain)this.getDomain();
                dom.setDiagramData(null);
                this.getResourceSet();
                this.rootModel = this.getModel(file);
                try {
                    this.initializeWithNewRoot(this.rootModel);
                }
                catch (Exception exc) {
                    CDEPlugin.getPlugin().getLog().log((IStatus)new Status(2, CDEPlugin.getPlugin().getBundle().getSymbolicName(), 0, "", (Throwable)exc));
                }
                if (this.rootModel != null) {
                    EditPart baseEditPart = this.getEditPart(this.rootModel);
                    this.getPrimaryViewer().setContents(baseEditPart);
                    this.validateModel(this.rootModel);
                    this.getCommandStack().flush();
                    if (oldResource != null) {
                        this.getResourceSet().getResources().remove((Object)oldResource);
                    }
                }
            }
            catch (Exception exc) {
                CDEPlugin.getPlugin().getLog().log((IStatus)new Status(2, CDEPlugin.getPlugin().getBundle().getSymbolicName(), 0, "", (Throwable)exc));
            }
        }
        this.setDirty(false);
    }

    protected void initializeWithNewRoot(EObject newModel) {
    }

    protected void showErrorMessage(String message) {
        Shell shell = this.getSite().getShell();
        MessageDialog.openError((Shell)shell, (String)CDEMessages.getString("ERROR_TITLE_UI_"), (String)message);
    }

    protected void superSetInput(IEditorInput input) {
        IFile file;
        if (this.getEditorInput() != null && this.resourceListener != null) {
            file = ((IFileEditorInput)this.getEditorInput()).getFile();
            file.getWorkspace().removeResourceChangeListener(this.resourceListener);
        }
        super.setInput(input);
        if (this.getEditorInput() != null) {
            file = ((IFileEditorInput)this.getEditorInput()).getFile();
            if (this.wantResourceListener) {
                if (this.resourceListener == null) {
                    this.resourceListener = new ResourceTracker();
                }
                file.getWorkspace().addResourceChangeListener(this.resourceListener);
            }
            this.setPartName(file.getName());
        }
    }

    protected abstract void validateModel(EObject var1);

    protected void createWarningMessage(String filename) {
        this.needToCloseEditor = true;
        this.filenameOfChangedResource = filename;
    }

    class ResourceTracker
    implements IResourceChangeListener,
    IResourceDeltaVisitor {
        protected boolean resourcesChanged = false;

        ResourceTracker() {
        }

        public void resourceChanged(IResourceChangeEvent e) {
            IResourceDelta delta = e.getDelta();
            try {
                if (delta != null) {
                    delta.accept((IResourceDeltaVisitor)this);
                    if (this.resourcesChanged) {
                        Display display = EMFGraphicalEditorPart.this.getSite().getShell().getDisplay();
                        display.asyncExec(new Runnable(this){
                            final /* synthetic */ ResourceTracker this$1;
                            {
                                this.this$1 = resourceTracker;
                            }

                            public void run() {
                                ResourceTracker.access$0(this.this$1).handleResourceChanged();
                            }
                        });
                        this.resourcesChanged = false;
                    }
                }
            }
            catch (CoreException coreException) {}
        }

        public boolean visit(IResourceDelta delta) {
            block5: {
                block4: {
                    block6: {
                        if (delta == null) {
                            return true;
                        }
                        if (!delta.getResource().equals((Object)((IFileEditorInput)EMFGraphicalEditorPart.this.getEditorInput()).getFile())) break block4;
                        if (delta.getKind() != 2) break block5;
                        if ((0x2000 & delta.getFlags()) != 0) break block6;
                        if (EMFGraphicalEditorPart.this.isDirty()) break block5;
                        EMFGraphicalEditorPart.this.closeEditor(false);
                        break block5;
                    }
                    IFile newFile = ResourcesPlugin.getWorkspace().getRoot().getFile(delta.getMovedToPath());
                    Display display = EMFGraphicalEditorPart.this.getSite().getShell().getDisplay();
                    display.asyncExec(new Runnable(this, newFile){
                        final /* synthetic */ ResourceTracker this$1;
                        private final /* synthetic */ IFile val$newFile;
                        {
                            this.this$1 = resourceTracker;
                            this.val$newFile = iFile;
                        }

                        public void run() {
                            ResourceTracker.access$0(this.this$1).superSetInput((IEditorInput)new FileEditorInput(this.val$newFile));
                        }
                    });
                    break block5;
                }
                if (delta.getKind() == 4 && (0x20000 & delta.getFlags()) == 0 && delta.getResource().getType() == 1) {
                    String filename = delta.getResource().getFullPath().makeRelative().toString();
                    if (EMFGraphicalEditorPart.this.fResourceSet != null) {
                        Iterator iter = EMFGraphicalEditorPart.this.fResourceSet.getResources().iterator();
                        while (iter.hasNext()) {
                            Resource res = (Resource)iter.next();
                            if (!res.getURI().toFileString().equals(filename)) continue;
                            this.resourcesChanged = true;
                            EMFGraphicalEditorPart.this.createWarningMessage(filename);
                            break;
                        }
                    }
                }
            }
            return true;
        }

        static /* synthetic */ EMFGraphicalEditorPart access$0(ResourceTracker resourceTracker) {
            return resourceTracker.EMFGraphicalEditorPart.this;
        }
    }

    public class EMFContentOutlinePage
    extends ContentOutlinePage {
        private PageBook pageBook;
        private Control outline;
        private Canvas overview;
        private IAction showOverviewAction;
        static final int ID_OUTLINE = 0;
        static final int ID_OVERVIEW = 1;
        private boolean overviewInitialized;
        private Thumbnail thumbnail;
        static /* synthetic */ Class class$0;

        public EMFContentOutlinePage(EditPartViewer viewer) {
            super(viewer);
        }

        public void setActionBars(IActionBars actionBars) {
            ActionRegistry registry = EMFGraphicalEditorPart.this.getActionRegistry();
            super.setActionBars(actionBars);
            actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)EMFGraphicalEditorPart.this.getOutlineDeleteAction());
            actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), registry.getAction((Object)ActionFactory.UNDO.getId()));
            actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), registry.getAction((Object)ActionFactory.REDO.getId()));
        }

        protected void configureOutlineViewer() {
            this.getViewer().setEditDomain((EditDomain)EMFGraphicalEditorPart.this.getDomain());
            EMFGraphicalEditorPart.this.getDomain().addViewer(this.getViewer());
            this.getViewer().setKeyHandler(EMFGraphicalEditorPart.this.getOutlineKeyHandler());
            IToolBarManager tbm = this.getSite().getActionBars().getToolBarManager();
            this.showOverviewAction = new Action(this, "", 2){
                final /* synthetic */ EMFContentOutlinePage this$1;
                {
                    this.this$1 = eMFContentOutlinePage;
                }

                public void run() {
                    this.this$1.showPage(this.isChecked() ? 1 : 0);
                }
            };
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ve.internal.cde.core.CDEPlugin");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.showOverviewAction.setImageDescriptor(ImageDescriptor.createFromFile((Class)clazz, (String)"images/overview.gif"));
            tbm.add(this.showOverviewAction);
            this.showPage(0);
        }

        public void createControl(Composite parent) {
            this.pageBook = new PageBook(parent, 0);
            this.outline = this.getViewer().createControl((Composite)this.pageBook);
            this.overview = new Canvas((Composite)this.pageBook, 0);
            this.pageBook.showPage(this.outline);
            this.configureOutlineViewer();
            this.hookOutlineViewer();
            this.initializeOutlineViewer();
            Control control = this.getViewer().getControl();
            MenuManager menuMgr = EMFGraphicalEditorPart.this.createMenuManager(control);
            menuMgr.addMenuListener(new IMenuListener(this){
                final /* synthetic */ EMFContentOutlinePage this$1;
                {
                    this.this$1 = eMFContentOutlinePage;
                }

                public void menuAboutToShow(IMenuManager menuMgr) {
                    EMFContentOutlinePage.access$1(this.this$1).addToOutlineContextMenu(menuMgr);
                    EMFContentOutlinePage.access$1(this.this$1).contextMenuAboutToShow(menuMgr, (ISelectionProvider)EMFContentOutlinePage.access$0(this.this$1));
                    menuMgr.add((IContributionItem)new GroupMarker("additions"));
                }
            });
            this.getSite().registerContextMenu("EMFGraphicalEditorPart.beansViewer", menuMgr, (ISelectionProvider)this.getViewer());
        }

        public void dispose() {
            this.unhookOutlineViewer();
            EMFGraphicalEditorPart.this.getDomain().removeViewer(this.getViewer());
            super.dispose();
        }

        protected void hookOutlineViewer() {
            EMFGraphicalEditorPart.this.getSelectionSynchronizer().addViewer(this.getViewer());
        }

        protected void initializeOutlineViewer() {
            this.getViewer().setContents(EMFGraphicalEditorPart.this.getRootTreeEditPart());
        }

        protected void unhookOutlineViewer() {
            EMFGraphicalEditorPart.this.getSelectionSynchronizer().removeViewer(this.getViewer());
        }

        public Control getControl() {
            return this.pageBook;
        }

        protected void initializeOverview() {
            LightweightSystem lws = new LightweightSystem(this.overview);
            RootEditPart rep = EMFGraphicalEditorPart.this.primaryViewer.getRootEditPart();
            if (rep instanceof ScalableFreeformRootEditPart) {
                ScalableFreeformRootEditPart root = (ScalableFreeformRootEditPart)rep;
                this.thumbnail = new ScrollableThumbnail((Viewport)root.getFigure());
                this.thumbnail.setSource(root.getLayer((Object)"Printable Layers"));
                lws.setContents((IFigure)this.thumbnail);
            }
        }

        protected void showPage(int id) {
            if (id == 0) {
                this.showOverviewAction.setChecked(false);
                this.pageBook.showPage(this.outline);
                if (this.thumbnail != null) {
                    this.thumbnail.setVisible(false);
                }
            } else if (id == 1) {
                if (!this.overviewInitialized) {
                    this.initializeOverview();
                }
                this.showOverviewAction.setChecked(true);
                this.pageBook.showPage((Control)this.overview);
                this.thumbnail.setVisible(true);
            }
        }

        static /* synthetic */ EditPartViewer access$0(EMFContentOutlinePage eMFContentOutlinePage) {
            return eMFContentOutlinePage.getViewer();
        }

        static /* synthetic */ EMFGraphicalEditorPart access$1(EMFContentOutlinePage eMFContentOutlinePage) {
            return eMFContentOutlinePage.EMFGraphicalEditorPart.this;
        }
    }
}

