/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.codegen.editorpart;

import java.util.logging.Level;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ve.internal.java.codegen.editorpart.CodegenEditorPartMessages;
import org.eclipse.ve.internal.java.codegen.java.AnnotationDecoderAdapter;
import org.eclipse.ve.internal.java.codegen.java.BeanDecoderAdapter;
import org.eclipse.ve.internal.java.codegen.java.IAnnotationDecoder;
import org.eclipse.ve.internal.java.codegen.java.ICodeGenAdapter;
import org.eclipse.ve.internal.java.codegen.model.BeanPart;
import org.eclipse.ve.internal.java.codegen.model.CodeMethodRef;
import org.eclipse.ve.internal.java.codegen.util.CodeGenUtil;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;
import org.eclipse.ve.internal.propertysheet.ISourced;
import org.eclipse.ve.internal.propertysheet.ISourcedPropertyDescriptor;

public class FieldNameValidator
implements ICellEditorValidator,
ISourced {
    private Object[] sources = null;
    private IPropertySource[] propertySources = null;
    private IPropertyDescriptor[] propertyDescriptors = null;

    protected BeanPart getBeanPart(EObject obj) {
        IAnnotationDecoder decoder;
        Adapter beanAdapter = EcoreUtil.getExistingAdapter((Notifier)obj, (Object)ICodeGenAdapter.JVE_CODEGEN_BEAN_PART_ADAPTER);
        if (beanAdapter != null && beanAdapter instanceof BeanDecoderAdapter && ((BeanDecoderAdapter)beanAdapter).getBeanPart() != null) {
            return ((BeanDecoderAdapter)beanAdapter).getBeanPart();
        }
        Adapter annotationAdapter = EcoreUtil.getExistingAdapter((Notifier)obj, (Object)ICodeGenAdapter.JVE_CODEGEN_ANNOTATION_ADAPTER);
        if (annotationAdapter != null && annotationAdapter instanceof AnnotationDecoderAdapter && (decoder = ((AnnotationDecoderAdapter)annotationAdapter).getDecoder()) != null && decoder.getBeanPart() != null) {
            return decoder.getBeanPart();
        }
        return null;
    }

    public String isValid(Object value) {
        if (value instanceof String) {
            EObject instance;
            BeanPart bp;
            String name = (String)value;
            if (name.equals(this.getCurrentName())) {
                return null;
            }
            if (name == null || name.length() < 1) {
                return CodegenEditorPartMessages.getString("FieldNameValidator.InvalidVariableName_INFO_");
            }
            if (name.length() > 0 && !Character.isJavaIdentifierStart(name.charAt(0))) {
                return CodegenEditorPartMessages.getString("FieldNameValidator.InvalidVariableName_INFO_");
            }
            if (name.length() > 1) {
                int cc = 1;
                while (cc < name.length()) {
                    if (!Character.isJavaIdentifierPart(name.charAt(cc))) {
                        return CodegenEditorPartMessages.getString("FieldNameValidator.InvalidVariableName_INFO_");
                    }
                    ++cc;
                }
            }
            if (this.sources != null && this.sources.length > 0 && this.sources[0] instanceof EObject && (bp = this.getBeanPart(instance = (EObject)this.sources[0])) != null && bp.getModel().getCompilationUnit() != null) {
                ICompilationUnit cu = bp.getModel().getCompilationUnit();
                if (bp.isInstanceVar() ? this.isDuplicateField(cu, name) : this.isDuplicateField(cu, name) || this.isDuplicateLocalVar(cu, bp, name)) {
                    return CodegenEditorPartMessages.getString("FieldNameValidator.VariableNameExists_INFO_");
                }
            }
        }
        return null;
    }

    protected boolean isDuplicateField(ICompilationUnit cu, String name) {
        IType type = CodeGenUtil.getMainType(cu);
        if (type != null) {
            try {
                IField[] fields = type.getFields();
                int fc = 0;
                while (fc < fields.length) {
                    if (fields[fc].getElementName().equals(name)) {
                        return true;
                    }
                    ++fc;
                }
            }
            catch (JavaModelException e) {
                JavaVEPlugin.log((Throwable)e, (Level)Level.FINER);
            }
        }
        return false;
    }

    protected boolean isDuplicateLocalVar(ICompilationUnit cu, BeanPart bp, String name) {
        CodeMethodRef initMethod;
        IMethod iInitmethod;
        IType mainType = CodeGenUtil.getMainType(cu);
        if (bp.getInitMethod() != null && mainType != null && (iInitmethod = CodeGenUtil.getMethod(mainType, (initMethod = bp.getInitMethod()).getMethodHandle())) != null) {
            try {
                ASTParser parser = ASTParser.newParser((int)2);
                String wrapperSource = "class WRAPPER_CLASS{\r\n" + iInitmethod.getSource() + "\r\n}";
                parser.setSource(wrapperSource.toCharArray());
                ASTNode wrapperNode = parser.createAST(null);
                VarNameVisitor varNameVisitor = new VarNameVisitor(name);
                wrapperNode.accept((ASTVisitor)varNameVisitor);
                return varNameVisitor.nameFound();
            }
            catch (JavaModelException e) {
                JavaVEPlugin.log((Throwable)e, (Level)Level.FINER);
            }
        }
        return false;
    }

    private String getCurrentName() {
        if (this.propertyDescriptors[0] instanceof ISourcedPropertyDescriptor) {
            return (String)((ISourcedPropertyDescriptor)this.propertyDescriptors[0]).getValue(this.propertySources[0]);
        }
        return (String)this.propertySources[0].getPropertyValue((Object)this.propertyDescriptors[0]);
    }

    public void setSources(Object[] sources, IPropertySource[] propertySources, IPropertyDescriptor[] descriptors) {
        this.sources = sources;
        this.propertySources = propertySources;
        this.propertyDescriptors = descriptors;
    }

    static class VarNameVisitor
    extends ASTVisitor {
        private boolean nameFound = false;
        private String name = null;

        public VarNameVisitor(String name) {
            this.name = name;
        }

        public boolean visit(VariableDeclarationFragment node) {
            if (node.getName().getIdentifier().equals(this.name)) {
                this.nameFound = true;
            }
            return super.visit(node);
        }

        public boolean nameFound() {
            return this.nameFound;
        }
    }
}

