/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.codegen.editorpart;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.draw2d.AbstractBorder;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.ve.internal.java.codegen.core.CodegenMessages;

class JaveVisualEditorLoadingFigureController {
    protected static final Insets INSETS = new Insets(10, 25, 10, 25);
    protected GraphicalViewer viewer;
    protected Label loadingFigure;
    protected boolean showingLoadingFigure = true;
    private FigureListener rootFigureListener = new FigureListener(){

        public void figureMoved(IFigure source) {
            JaveVisualEditorLoadingFigureController.this.loadingFigure.revalidate();
        }
    };
    private PropertyChangeListener scrolledListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            if ("value".equals(evt.getPropertyName())) {
                JaveVisualEditorLoadingFigureController.this.loadingFigure.revalidate();
            }
        }
    };

    public IFigure getRootFigure(IFigure target) {
        IFigure parent = target.getParent();
        while (parent.getParent() != null) {
            parent = parent.getParent();
        }
        return parent;
    }

    public void startListener(GraphicalViewer viewer) {
        this.viewer = viewer;
        this.loadingFigure = new Label(CodegenMessages.getString("CodeGenVisualGraphicalEditorPart.StatusChangeListener.loading")){
            Locator locator = new Locator(this){
                final /* synthetic */ 3 this$1;
                {
                    this.this$1 = var1_1;
                }

                public void relocate(IFigure target) {
                    Dimension canvasSize = 3.access$0(this.this$1).getRootFigure(target).getSize();
                    Dimension prefSize = target.getPreferredSize();
                    int newX = (canvasSize.width - prefSize.width) / 2;
                    int newY = (canvasSize.height - prefSize.height) / 2;
                    Rectangle b = new Rectangle(newX, newY, prefSize.width, prefSize.height);
                    target.translateToRelative((Translatable)b);
                    target.setBounds(b);
                }
            };

            public void validate() {
                if (!this.isValid()) {
                    this.locator.relocate((IFigure)this);
                }
                super.validate();
            }

            static /* synthetic */ JaveVisualEditorLoadingFigureController access$0(3 var0) {
                return var0.JaveVisualEditorLoadingFigureController.this;
            }
        };
        this.loadingFigure.setEnabled(true);
        this.loadingFigure.setOpaque(true);
        this.loadingFigure.setBorder((Border)new AbstractBorder(){

            public Insets getInsets(IFigure figure) {
                return INSETS;
            }

            public void paint(IFigure figure, Graphics graphics, Insets insets) {
                graphics.setLineWidth(1);
                graphics.setLineStyle(1);
                graphics.setXORMode(false);
                Rectangle rect = AbstractBorder.getPaintRectangle((IFigure)figure, (Insets)insets);
                graphics.setForegroundColor(ColorConstants.black);
                rect.resize(-1, -1);
                graphics.drawRectangle(rect);
                graphics.setForegroundColor(ColorConstants.white);
                rect.translate(1, 1);
                rect.resize(-2, -2);
                graphics.drawRectangle(rect);
            }
        });
        if (this.showingLoadingFigure) {
            this.showLoadingFigure();
        }
    }

    public void showLoadingFigure(boolean show) {
        if (show) {
            if (!this.showingLoadingFigure) {
                this.showLoadingFigure();
            }
        } else if (this.showingLoadingFigure) {
            this.removeLoadingFigure();
        }
    }

    protected Layer getLoadingLayer() {
        return (Layer)((LayerManager)this.viewer.getEditPartRegistry().get(LayerManager.ID)).getLayer((Object)"Handle Layer");
    }

    protected void removeLoadingFigure() {
        this.showingLoadingFigure = false;
        if (this.viewer != null) {
            Viewport vp;
            Layer layer = this.getLoadingLayer();
            if (layer.getChildren().contains(this.loadingFigure)) {
                layer.remove((IFigure)this.loadingFigure);
            }
            if ((vp = this.getViewport((IFigure)layer)) != null) {
                vp.getHorizontalRangeModel().removePropertyChangeListener(this.scrolledListener);
                vp.getVerticalRangeModel().removePropertyChangeListener(this.scrolledListener);
            }
            this.getRootFigure((IFigure)layer).removeFigureListener(this.rootFigureListener);
        }
    }

    protected Viewport getViewport(IFigure figure) {
        IFigure f = figure;
        while (f != null && !(f instanceof Viewport)) {
            f = f.getParent();
        }
        return (Viewport)f;
    }

    protected void showLoadingFigure() {
        this.showingLoadingFigure = true;
        if (this.viewer != null) {
            Layer layer = this.getLoadingLayer();
            layer.add((IFigure)this.loadingFigure);
            Viewport vp = this.getViewport((IFigure)layer);
            if (vp != null) {
                vp.getHorizontalRangeModel().addPropertyChangeListener(this.scrolledListener);
                vp.getVerticalRangeModel().addPropertyChangeListener(this.scrolledListener);
            }
            this.getRootFigure((IFigure)layer).addFigureListener(this.rootFigureListener);
            this.loadingFigure.revalidate();
        }
    }
}

