/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.codegen.java;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jem.internal.instantiation.base.IJavaObjectInstance;
import org.eclipse.ve.internal.java.codegen.core.CodegenMessages;
import org.eclipse.ve.internal.java.codegen.java.BeanPartFactory;
import org.eclipse.ve.internal.java.codegen.java.ExpressionRefFactory;
import org.eclipse.ve.internal.java.codegen.java.rules.IThisReferenceRule;
import org.eclipse.ve.internal.java.codegen.model.BeanPart;
import org.eclipse.ve.internal.java.codegen.model.CodeCallBackRef;
import org.eclipse.ve.internal.java.codegen.model.CodeEventHandlerRef;
import org.eclipse.ve.internal.java.codegen.model.CodeEventRef;
import org.eclipse.ve.internal.java.codegen.model.CodeExpressionRef;
import org.eclipse.ve.internal.java.codegen.model.CodeMethodRef;
import org.eclipse.ve.internal.java.codegen.model.IBeanDeclModel;
import org.eclipse.ve.internal.java.codegen.util.CodeGenException;
import org.eclipse.ve.internal.java.codegen.util.CodeGenUtil;
import org.eclipse.ve.internal.java.codegen.util.TypeResolver;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;
import org.eclipse.ve.internal.jcm.BeanSubclassComposition;

public class BDMMerger {
    protected IBeanDeclModel mainModel = null;
    protected IBeanDeclModel newModel = null;
    protected List changedHandles = null;
    protected List needToRedecodeExpressions = new ArrayList();

    public BDMMerger(IBeanDeclModel mainModel, IBeanDeclModel newModel, List changedHandles) {
        this.mainModel = mainModel;
        this.newModel = newModel;
        this.changedHandles = changedHandles;
        this.needToRedecodeExpressions.clear();
    }

    public boolean merge() throws CodeGenException {
        boolean merged = true;
        if (this.mainModel != null && this.newModel != null) {
            if (this.mainModel.isStateSet(1)) {
                return true;
            }
            boolean bl = merged = merged && this.removeDeletedBeans();
            if (this.mainModel.isStateSet(1)) {
                return true;
            }
            boolean bl2 = merged = merged && this.removeDeletedMethods();
            if (this.mainModel.isStateSet(1)) {
                return true;
            }
            boolean bl3 = merged = merged && this.updateEventHandlers();
            if (this.mainModel.isStateSet(1)) {
                return true;
            }
            boolean bl4 = merged = merged && this.addNewBeans();
            if (this.mainModel.isStateSet(1)) {
                return true;
            }
            boolean bl5 = merged = merged && this.addThisMethod();
            if (this.mainModel.isStateSet(1)) {
                return true;
            }
            boolean bl6 = merged = merged && this.updateMethods();
            if (this.mainModel.isStateSet(1)) {
                return true;
            }
            boolean bl7 = merged = merged && this.mergeAllBeans();
            if (this.mainModel.isStateSet(1)) {
                return true;
            }
            boolean bl8 = merged = merged && this.updateFreeForm();
            if (this.mainModel.isStateSet(1)) {
                return true;
            }
            merged = merged && this.clean();
        }
        this.needToRedecodeExpressions.clear();
        return merged;
    }

    private boolean clean() {
        boolean cleaned = true;
        if (this.mainModel.getBeans() != null) {
            Iterator beanItr = this.mainModel.getBeans().iterator();
            while (beanItr.hasNext()) {
                BeanPart bp = (BeanPart)beanItr.next();
                List badExpressions = bp.getBadExpressions();
                if (badExpressions == null || badExpressions.size() <= 0) continue;
                int badExpCount = 0;
                while (badExpCount < badExpressions.size()) {
                    CodeExpressionRef exp = (CodeExpressionRef)badExpressions.get(badExpCount);
                    badExpressions.remove(exp);
                    exp.dispose();
                    --badExpCount;
                    ++badExpCount;
                }
            }
        }
        return cleaned;
    }

    protected boolean updateMethods() {
        if (this.newModel.getTypeRef() != null) {
            Iterator newMethodsItr = this.newModel.getTypeRef().getMethods();
            while (newMethodsItr.hasNext()) {
                CodeMethodRef updMethod = (CodeMethodRef)newMethodsItr.next();
                CodeMethodRef mainMethod = this.mainModel.getMethod(updMethod.getMethodHandle());
                if (mainMethod == null) {
                    this.createNewMainMethodRef(updMethod);
                    continue;
                }
                this.updateMethodOffsetAndContent(mainMethod, updMethod);
            }
        }
        return true;
    }

    protected boolean updateFreeForm() {
        try {
            Iterator itr = this.mainModel.getBeans().iterator();
            while (itr.hasNext()) {
                if (this.mainModel.isStateSet(1)) {
                    return true;
                }
                BeanPart bean = (BeanPart)itr.next();
                this.connectBeanToBSC(bean, this.mainModel.getCompositionModel().getModelRoot());
                if (bean.getFFDecoder() == null) continue;
                bean.getFFDecoder().decode();
            }
        }
        catch (CodeGenException e) {
            JavaVEPlugin.log((Throwable)((Object)e), (Level)Level.WARNING);
            return false;
        }
        return true;
    }

    protected void connectBeanToBSC(BeanPart bp, BeanSubclassComposition bsc) throws CodeGenException {
        boolean thisPart;
        boolean bl = thisPart = bp.getSimpleName().equals("this");
        if (!bp.isInJVEModel()) {
            bp.addToJVEModel();
        }
        if (thisPart) {
            if (bsc.getThisPart() == null || !bsc.getThisPart().equals(bp.getEObject())) {
                bsc.setThisPart((IJavaObjectInstance)bp.getEObject());
            }
        } else if (bp.getContainer() == null && bp.isInstanceVar()) {
            if (bp.getFFDecoder().isVisualOnFreeform()) {
                if (!bsc.getComponents().contains((Object)bp.getEObject())) {
                    bsc.getComponents().add((Object)bp.getEObject());
                }
            } else if (bsc.getComponents().contains((Object)bp.getEObject())) {
                bsc.getComponents().remove((Object)bp.getEObject());
            }
        }
    }

    protected boolean removeMethodRef(CodeMethodRef m) {
        if (m != null) {
            Collection initBPs = this.mainModel.getBeansInitilizedByMethod(m);
            BeanPart retBP = this.mainModel.getBeanReturned(m.getMethodName());
            Iterator iter = initBPs.iterator();
            while (iter.hasNext()) {
                BeanPart bp = (BeanPart)iter.next();
                if (JavaVEPlugin.isLoggingLevel((Level)Level.FINER)) {
                    JavaVEPlugin.log((Object)("BDM Merger >> Disposing init bean " + bp.getSimpleName() + " when disposing method " + m.getMethodHandle()), (Level)Level.FINER);
                }
                if ("this".equals(bp.getSimpleName())) continue;
                bp.dispose();
            }
            if (retBP != null && !initBPs.contains(retBP)) {
                if (JavaVEPlugin.isLoggingLevel((Level)Level.FINER)) {
                    JavaVEPlugin.log((Object)("BDM Merger >> Disposing return bean " + retBP.getSimpleName() + " when disposing method " + m.getMethodHandle()), (Level)Level.FINER);
                }
                if (!"this".equals(retBP.getSimpleName())) {
                    retBP.dispose();
                }
            }
            m.dispose();
            return true;
        }
        return false;
    }

    protected boolean removeDeletedMethods() {
        boolean removed = true;
        Iterator methods = this.mainModel.getAllMethods();
        while (methods.hasNext()) {
            if (this.mainModel.isStateSet(1)) {
                return true;
            }
            CodeMethodRef m = (CodeMethodRef)methods.next();
            if (this.newModel.getMethod(m.getMethodHandle()) != null) continue;
            if (JavaVEPlugin.isLoggingLevel((Level)Level.FINER)) {
                JavaVEPlugin.log((Object)("BDM Merger >> Removing method " + m.getMethodHandle() + "since it is not found in update"), (Level)Level.FINER);
            }
            boolean bl = removed = removed && this.removeMethodRef(m);
        }
        return removed;
    }

    protected HashMap getUniquenameToBeanMap(List beanParts) {
        HashMap<String, BeanPart> map = new HashMap<String, BeanPart>(beanParts.size());
        Iterator bpItr = beanParts.iterator();
        while (bpItr.hasNext()) {
            BeanPart bp = (BeanPart)bpItr.next();
            map.put(bp.getUniqueName(), bp);
        }
        return map;
    }

    protected boolean updateMethodOffsetAndContent(CodeMethodRef mainMethod, CodeMethodRef updatedMethod) {
        if (mainMethod == null || updatedMethod == null) {
            return false;
        }
        if (mainMethod.getOffset() != updatedMethod.getOffset()) {
            mainMethod.setOffset(updatedMethod.getOffset());
        }
        if (updatedMethod.getContent() != null && updatedMethod.getContent().equals(mainMethod.getContent())) {
            mainMethod.setContent(updatedMethod.getContent());
        }
        return true;
    }

    protected void updateReturnMethod(BeanPart mainBP, BeanPart updatedBP) {
        CodeMethodRef retMainBP = mainBP.getReturnedMethod();
        CodeMethodRef retUpdatedBP = updatedBP.getReturnedMethod();
        if (retMainBP == null && retUpdatedBP == null) {
            return;
        }
        if (retMainBP == null && retUpdatedBP != null) {
            CodeMethodRef mainRetM = this.mainModel.getMethod(retUpdatedBP.getMethodHandle());
            if (mainRetM != null) {
                mainBP.addReturnMethod(mainRetM);
            }
            return;
        }
        if (retMainBP != null && retUpdatedBP == null) {
            mainBP.removeReturnMethod(retMainBP);
            return;
        }
        if (!retMainBP.getMethodHandle().equals(retUpdatedBP.getMethodHandle())) {
            mainBP.removeReturnMethod(retMainBP);
            CodeMethodRef mainRetM = this.mainModel.getMethod(retUpdatedBP.getMethodHandle());
            if (mainRetM != null) {
                mainBP.addReturnMethod(mainRetM);
            }
            return;
        }
    }

    protected boolean removeDeletedCallBackExpression(CodeCallBackRef mainExp) {
        mainExp.dispose();
        return true;
    }

    protected void checkEventExpNeedsRedecoding(CodeCallBackRef mainCBExp) {
        if (mainCBExp != null && mainCBExp.getBean() != null) {
            Collection eventExps = mainCBExp.getBean().getRefEventExpressions();
            Iterator iter = eventExps.iterator();
            while (iter.hasNext()) {
                CodeExpressionRef exp = (CodeExpressionRef)iter.next();
                if (this.needToRedecodeExpressions.contains(exp)) continue;
                this.needToRedecodeExpressions.add(exp);
            }
        }
    }

    protected boolean processSameCallBackExpression(CodeCallBackRef main, CodeCallBackRef updExp) {
        if (main.getOffset() != updExp.getOffset()) {
            main.setOffset(updExp.getOffset());
        }
        main.setContent(updExp.getContent());
        main.setExprStmt(updExp.getExprStmt());
        return true;
    }

    protected boolean addNewCallBackExpression(CodeCallBackRef newExp) {
        boolean added = false;
        CodeMethodRef newMethodRef = newExp.getMethod();
        BeanPart newBean = newExp.getBean();
        if (newMethodRef != null && newExp != null) {
            CodeMethodRef mainMethod = this.mainModel.getMethod(newMethodRef.getMethodHandle());
            BeanPart mainBean = this.mainModel.getABean(newBean.getUniqueName());
            if (mainMethod != null && mainBean != null) {
                CodeCallBackRef callBack = new CodeCallBackRef(newExp.getExprStmt(), mainMethod);
                callBack.setBean(mainBean);
                this.checkEventExpNeedsRedecoding(callBack);
                added = true;
            }
        }
        return added;
    }

    protected boolean updateCallBackExpressions(BeanPart mainBeanPart, BeanPart updatedBeanPart) {
        boolean processed = true;
        ArrayList mainCallBackExpressions = new ArrayList(mainBeanPart.getRefCallBackExpressions());
        ArrayList updatedCallBackExpressions = new ArrayList(updatedBeanPart.getRefCallBackExpressions());
        int mainExpCount = 0;
        while (mainExpCount < mainCallBackExpressions.size()) {
            CodeCallBackRef mainExp = (CodeCallBackRef)mainCallBackExpressions.get(mainExpCount);
            boolean equivalentExpFound = false;
            int updatedExpCount = 0;
            while (updatedExpCount < updatedCallBackExpressions.size()) {
                CodeCallBackRef updExp = (CodeCallBackRef)updatedCallBackExpressions.get(updatedExpCount);
                if (mainExp != null && updExp != null && !updExp.isStateSet(256)) {
                    boolean contentSame = false;
                    contentSame = mainExp.getContent().equals(updExp.getContent());
                    if (contentSame) {
                        equivalentExpFound = true;
                        processed = processed && this.processSameCallBackExpression(mainExp, updExp);
                        mainCallBackExpressions.remove(mainCallBackExpressions.indexOf(mainExp));
                        updatedCallBackExpressions.remove(updatedCallBackExpressions.indexOf(updExp));
                        --mainExpCount;
                        --updatedExpCount;
                        break;
                    }
                }
                ++updatedExpCount;
            }
            if (!equivalentExpFound) {
                mainCallBackExpressions.remove(mainCallBackExpressions.indexOf(mainExp));
                --mainExpCount;
                this.checkEventExpNeedsRedecoding(mainExp);
                this.removeDeletedCallBackExpression(mainExp);
            }
            ++mainExpCount;
        }
        int newExpCount = 0;
        while (newExpCount < updatedCallBackExpressions.size()) {
            CodeCallBackRef exp = (CodeCallBackRef)updatedCallBackExpressions.get(newExpCount);
            processed = processed && this.addNewCallBackExpression(exp);
            ++newExpCount;
        }
        return processed;
    }

    protected boolean updateEventExpressions(BeanPart mainBeanPart, BeanPart updatedBeanPart) {
        ArrayList allMainBPExpressions = new ArrayList(mainBeanPart.getRefEventExpressions());
        ArrayList allUpdateBPExpressions = new ArrayList(updatedBeanPart.getRefEventExpressions());
        return this.processExpressions(allMainBPExpressions, allUpdateBPExpressions);
    }

    protected boolean updateBeanPart(BeanPart mainBeanPart, BeanPart updatedBeanPart) {
        this.updateMethodOffsetAndContent(mainBeanPart.getInitMethod(), updatedBeanPart.getInitMethod());
        this.updateReturnMethod(mainBeanPart, updatedBeanPart);
        boolean update = this.updateCallBackExpressions(mainBeanPart, updatedBeanPart);
        update = update && this.updateParentExpressions(mainBeanPart, updatedBeanPart);
        update = update && this.updateEventExpressions(mainBeanPart, updatedBeanPart);
        return update;
    }

    protected boolean updateParentExpressions(BeanPart mainBeanPart, BeanPart updatedBeanPart) {
        boolean updated = true;
        ArrayList updatedParentExpressions = new ArrayList(updatedBeanPart.getParentExpressons());
        int uc = 0;
        while (uc < updatedParentExpressions.size()) {
            CodeMethodRef newExpMethod;
            CodeExpressionRef updateParentExpression = (CodeExpressionRef)updatedParentExpressions.get(uc);
            if (updateParentExpression != null && updateParentExpression.getExprStmt() != null && updateParentExpression.getMethod() != null && updateParentExpression.getMethod().getMethodHandle() != null && (newExpMethod = this.mainModel.getMethod(updateParentExpression.getMethod().getMethodHandle())) != null) {
                CodeExpressionRef newExp = new CodeExpressionRef(updateParentExpression.getExprStmt(), newExpMethod);
                mainBeanPart.addParentExpression(newExp);
            }
            ++uc;
        }
        return updated;
    }

    protected boolean processEquivalentExpressions(CodeExpressionRef mainExp, CodeExpressionRef newExp, int equivalencyLevel) {
        if (newExp.getBean() != null) {
            newExp.getBean().setProxy(mainExp.getBean());
        }
        switch (equivalencyLevel) {
            case 0: {
                if (JavaVEPlugin.isLoggingLevel((Level)Level.FINER)) {
                    JavaVEPlugin.log((Object)("BDM Merger >> Updating changed expression " + newExp.getCodeContent()), (Level)Level.FINER);
                }
                if (mainExp.isStateSet(4)) break;
                if (mainExp.getOffset() != newExp.getOffset()) {
                    mainExp.setOffset(newExp.getOffset());
                }
                mainExp.refreshFromJOM(newExp);
                break;
            }
            case 1: {
                if (mainExp.getOffset() == newExp.getOffset()) {
                    mainExp.setContent(newExp.getContentParser());
                    if (!this.needToRedecodeExpressions.contains(mainExp)) break;
                    mainExp.refreshFromJOM(newExp);
                    break;
                }
                mainExp.setOffset(newExp.getOffset());
                if (newExp instanceof CodeEventRef && !this.needToRedecodeExpressions.contains(mainExp)) break;
                if (JavaVEPlugin.isLoggingLevel((Level)Level.FINER)) {
                    JavaVEPlugin.log((Object)("BDM Merger >> Updating because of changed offset " + newExp.getCodeContent()), (Level)Level.FINER);
                }
                mainExp.refreshFromJOM(newExp);
            }
        }
        if (newExp.getBean() != null) {
            newExp.getBean().setProxy(null);
        }
        return true;
    }

    protected void removeDeletedExpression(CodeExpressionRef deletedExp) {
        if (JavaVEPlugin.isLoggingLevel((Level)Level.FINER)) {
            JavaVEPlugin.log((Object)("BDM Merger >> Remove deleted expression " + deletedExp.getCodeContent()), (Level)Level.FINER);
        }
        deletedExp.dispose();
    }

    protected void updateChangedOffsetsAndMarkExpressions(Collection mainExpressions, Collection updatedExpressions) {
        ArrayList mainExpTobeProcessed = new ArrayList(mainExpressions);
        ArrayList updatedExpTobeProcessed = new ArrayList(updatedExpressions);
        int updatedExpCount = 0;
        while (updatedExpCount < updatedExpTobeProcessed.size()) {
            CodeExpressionRef updExp = (CodeExpressionRef)updatedExpTobeProcessed.get(updatedExpCount);
            boolean equivalentExpFound = false;
            int mainExpCount = 0;
            while (mainExpCount < mainExpTobeProcessed.size()) {
                CodeExpressionRef mainExp = (CodeExpressionRef)mainExpTobeProcessed.get(mainExpCount);
                if (mainExp != null && updExp != null && !updExp.isStateSet(256)) {
                    int equivalency = -1;
                    try {
                        equivalency = mainExp.isEquivalent(updExp);
                    }
                    catch (CodeGenException codeGenException) {}
                    if (equivalency >= 0) {
                        equivalentExpFound = true;
                        switch (equivalency) {
                            case 0: {
                                if (mainExp.isStateSet(4)) break;
                                if (mainExp.getOffset() != updExp.getOffset()) {
                                    mainExp.setOffset(updExp.getOffset());
                                }
                                this.needToRedecodeExpressions.add(mainExp);
                                break;
                            }
                            case 1: {
                                if (mainExp.getOffset() == updExp.getOffset()) break;
                                mainExp.setOffset(updExp.getOffset());
                                this.needToRedecodeExpressions.add(mainExp);
                            }
                        }
                        mainExpTobeProcessed.remove(mainExpTobeProcessed.indexOf(mainExp));
                        updatedExpTobeProcessed.remove(updatedExpTobeProcessed.indexOf(updExp));
                        --mainExpCount;
                        --updatedExpCount;
                        break;
                    }
                }
                ++mainExpCount;
            }
            if (!equivalentExpFound) {
                updatedExpTobeProcessed.remove(updatedExpTobeProcessed.indexOf(updExp));
                --updatedExpCount;
            }
            ++updatedExpCount;
        }
    }

    protected boolean processExpressions(Collection mainExpressions, Collection updatedExpressions) {
        this.updateChangedOffsetsAndMarkExpressions(mainExpressions, updatedExpressions);
        boolean processed = true;
        ArrayList mainExpTobeProcessed = new ArrayList(mainExpressions);
        ArrayList updatedExpTobeProcessed = new ArrayList(updatedExpressions);
        int updatedExpCount = 0;
        while (updatedExpCount < updatedExpTobeProcessed.size()) {
            CodeExpressionRef updExp = (CodeExpressionRef)updatedExpTobeProcessed.get(updatedExpCount);
            boolean equivalentExpFound = false;
            int mainExpCount = 0;
            while (mainExpCount < mainExpTobeProcessed.size()) {
                CodeExpressionRef mainExp = (CodeExpressionRef)mainExpTobeProcessed.get(mainExpCount);
                if (mainExp != null && updExp != null && !updExp.isStateSet(256)) {
                    int equivalency = -1;
                    try {
                        equivalency = mainExp.isEquivalent(updExp);
                    }
                    catch (CodeGenException codeGenException) {}
                    if (equivalency >= 0) {
                        equivalentExpFound = true;
                        processed = processed && this.processEquivalentExpressions(mainExp, updExp, equivalency);
                        mainExpTobeProcessed.remove(mainExpTobeProcessed.indexOf(mainExp));
                        updatedExpTobeProcessed.remove(updatedExpTobeProcessed.indexOf(updExp));
                        --mainExpCount;
                        --updatedExpCount;
                        break;
                    }
                }
                ++mainExpCount;
            }
            if (!equivalentExpFound) {
                updatedExpTobeProcessed.remove(updatedExpTobeProcessed.indexOf(updExp));
                --updatedExpCount;
                processed = processed && this.addNewExpression(updExp);
            }
            ++updatedExpCount;
        }
        int delExpCount = 0;
        while (delExpCount < mainExpTobeProcessed.size()) {
            CodeExpressionRef mainExp = (CodeExpressionRef)mainExpTobeProcessed.get(delExpCount);
            CodeExpressionRef parentExpression = null;
            Iterator newBeansItr = this.newModel.getBeans().iterator();
            block5: while (newBeansItr.hasNext() && parentExpression == null) {
                BeanPart newBean = (BeanPart)newBeansItr.next();
                List newBPParentExps = newBean.getParentExpressons();
                if (newBPParentExps == null || newBPParentExps.size() <= 0) continue;
                int ec = 0;
                while (ec < newBPParentExps.size()) {
                    String newExpInMethod;
                    CodeExpressionRef newParentExp = (CodeExpressionRef)newBPParentExps.get(ec);
                    String mainExpMethodName = mainExp.getMethodNameContent();
                    String mainExpInMethod = mainExp.getMethod() == null ? null : mainExp.getMethod().getMethodName();
                    String string = newExpInMethod = newParentExp.getMethod() == null ? null : newParentExp.getMethod().getMethodName();
                    if (mainExpMethodName != null && mainExpMethodName.equals(newParentExp.getMethodNameContent()) && mainExpInMethod != null && newExpInMethod != null && mainExpInMethod.equals(newExpInMethod)) {
                        parentExpression = newParentExp;
                        continue block5;
                    }
                    ++ec;
                }
            }
            if (parentExpression == null) {
                this.removeDeletedExpression(mainExp);
            } else {
                this.processEquivalentExpressions(mainExp, parentExpression, 1);
            }
            ++delExpCount;
        }
        return processed;
    }

    private List getExpressions(CodeMethodRef m) {
        ArrayList l = new ArrayList();
        Iterator itr = m.getAllExpressions();
        while (itr.hasNext()) {
            l.add(itr.next());
        }
        return l;
    }

    private CodeExpressionRef getMainBDMExpression(CodeExpressionRef exp) throws CodeGenException {
        if (exp == null || exp.getMethod() == null) {
            return null;
        }
        CodeMethodRef m = this.mainModel.getMethod(exp.getMethod().getMethodHandle());
        if (m == null) {
            return null;
        }
        Iterator itr = this.getExpressions(m).iterator();
        CodeExpressionRef result = null;
        while (itr.hasNext()) {
            CodeExpressionRef e = (CodeExpressionRef)itr.next();
            if (e == exp) {
                result = e;
                break;
            }
            int eqv = e.isEquivalent(exp);
            if (eqv < 0) continue;
            if (eqv == 1) {
                result = e;
                break;
            }
            if (result != null) continue;
            result = e;
        }
        if (result != null) {
            this.getExpressions(m).remove(result);
            return result;
        }
        return null;
    }

    private CodeEventRef createNewEventExpression(CodeEventRef e, CodeMethodRef m, boolean decode) throws CodeGenException {
        BeanPart b = this.getMainBDMBean(e.getBean());
        if (b == null) {
            throw new CodeGenException("No Bean Part");
        }
        CodeEventRef newe = new CodeEventRef(m, b);
        newe.setState(4, e.isStateSet(4));
        newe.setState(4096, e.isStateSet(4096));
        newe.setState(128, true);
        newe.setExprStmt(e.getExprStmt());
        newe.setContent(e.getContentParser());
        newe.setOffset(e.getOffset());
        newe.setEventInvocation(e.getEventInvocation());
        if (decode && !newe.decodeExpression()) {
            newe.dispose();
            newe = null;
        }
        return newe;
    }

    private CodeExpressionRef createNewExpression(CodeExpressionRef e, CodeMethodRef m, boolean decode) throws CodeGenException {
        if (this.getMainBDMExpression(e) != null) {
            if (JavaVEPlugin.isLoggingLevel((Level)Level.FINER)) {
                JavaVEPlugin.log((Object)("BDM Merger >> Ignoring creation of duplicate Expression" + e.getCodeContent()), (Level)Level.FINER);
            }
            return null;
        }
        BeanPart b = this.getMainBDMBean(e.getBean());
        if (b == null) {
            throw new CodeGenException("No Bean Part");
        }
        ExpressionRefFactory gen = new ExpressionRefFactory(b, null);
        CodeExpressionRef newe = gen.createFromSource(e, m);
        newe.setState(4, e.isStateSet(4));
        newe.setState(4096, e.isStateSet(4096));
        if (decode && !newe.decodeExpression()) {
            newe.dispose();
            newe = null;
        }
        return newe;
    }

    protected boolean addNewExpression(CodeExpressionRef updateExp) {
        if (JavaVEPlugin.isLoggingLevel((Level)Level.FINER)) {
            JavaVEPlugin.log((Object)("BDM Merger >> Adding new expression " + updateExp.getCodeContent()), (Level)Level.FINER);
        }
        try {
            if (updateExp == null || updateExp.getMethod() == null) {
                return true;
            }
            CodeMethodRef mainMethod = this.mainModel.getMethod(updateExp.getMethod().getMethodHandle());
            if (mainMethod == null) {
                return true;
            }
            CodeExpressionRef newExp = this.createNewExpression(updateExp, mainMethod, !updateExp.isStateSet(4));
            if (newExp == null && updateExp instanceof CodeEventRef) {
                newExp = this.createNewEventExpression((CodeEventRef)updateExp, mainMethod, !updateExp.isStateSet(4));
            }
        }
        catch (CodeGenException e) {
            JavaVEPlugin.log((Throwable)((Object)e), (Level)Level.WARNING);
            return false;
        }
        return true;
    }

    private BeanPart getMainBDMBean(BeanPart b) {
        Iterator itr = this.mainModel.getBeans().iterator();
        while (itr.hasNext()) {
            BeanPart bean = (BeanPart)itr.next();
            if (!bean.isEquivalent(b) || !bean.getUniqueName().equals(b.getUniqueName())) continue;
            return bean;
        }
        return null;
    }

    protected boolean mergeAllBeans() {
        boolean merge = true;
        List mainModelBeans = this.mainModel.getBeans();
        mainModelBeans = this.orderBeansToMerge(mainModelBeans);
        Iterator mainModelBeansItr = mainModelBeans.iterator();
        while (mainModelBeansItr.hasNext()) {
            if (this.mainModel.isStateSet(1)) {
                return true;
            }
            BeanPart mainBP = (BeanPart)mainModelBeansItr.next();
            if (mainBP.getModel() == null) continue;
            BeanPart updateBP = this.newModel.getABean(mainBP.getUniqueName());
            if (updateBP != null) {
                merge = merge && this.updateBeanPart(mainBP, updateBP);
                continue;
            }
            JavaVEPlugin.log((Object)"BDM Merger: Unable to find main BDM bean in new BDM at this point", (Level)Level.WARNING);
        }
        merge = merge && this.updateBeanPartRegularExpressions();
        return merge;
    }

    protected void orderBeanPartExpressions(BeanPart bp, List orderedList) {
        if (bp == null || bp.getRefExpressions() == null) {
            return;
        }
        Iterator bpExpItr = bp.getRefExpressions().iterator();
        while (bpExpItr.hasNext()) {
            CodeExpressionRef bpExp = (CodeExpressionRef)bpExpItr.next();
            int index = 0;
            index = 0;
            while (index < orderedList.size()) {
                CodeExpressionRef orderedExp = (CodeExpressionRef)orderedList.get(index);
                if (orderedExp.getOffset() > bpExp.getOffset()) break;
                ++index;
            }
            if (index < orderedList.size()) {
                orderedList.add(index, bpExp);
                continue;
            }
            orderedList.add(bpExp);
        }
    }

    protected boolean updateBeanPartRegularExpressions() {
        boolean update = true;
        HashMap beansInMethodMap = new HashMap();
        Iterator mainModelBeansItr = this.mainModel.getBeans().iterator();
        while (mainModelBeansItr.hasNext()) {
            BeanPart bp = (BeanPart)mainModelBeansItr.next();
            String key = "null";
            if (bp.getInitMethod() != null && bp.getInitMethod().getMethodHandle() != null) {
                key = bp.getInitMethod().getMethodHandle();
            }
            if (!beansInMethodMap.containsKey(key)) {
                beansInMethodMap.put(key, new ArrayList());
            }
            List list = (List)beansInMethodMap.get(key);
            list.add(bp);
        }
        Iterator methodHandleItr = beansInMethodMap.keySet().iterator();
        while (methodHandleItr.hasNext()) {
            ArrayList orderedMainExpressions = new ArrayList();
            ArrayList orderedUpdatedExpressions = new ArrayList();
            String key = (String)methodHandleItr.next();
            List beans = (List)beansInMethodMap.get(key);
            Iterator mainBeansItr = beans.iterator();
            while (mainBeansItr.hasNext()) {
                BeanPart mainBP = (BeanPart)mainBeansItr.next();
                if (mainBP.getModel() == null) continue;
                BeanPart updateBP = this.newModel.getABean(mainBP.getUniqueName());
                if (updateBP != null) {
                    this.orderBeanPartExpressions(mainBP, orderedMainExpressions);
                    this.orderBeanPartExpressions(updateBP, orderedUpdatedExpressions);
                    continue;
                }
                JavaVEPlugin.log((Object)"BDM Merger: Unable to find main BDM bean in new BDM at this point", (Level)Level.WARNING);
            }
            boolean bl = update = update && this.processExpressions(orderedMainExpressions, orderedUpdatedExpressions);
        }
        return update;
    }

    protected List orderBeansToMerge(List mainModelBeans) {
        ArrayList<BeanPart> orderedBeans = new ArrayList<BeanPart>();
        if (mainModelBeans != null && mainModelBeans.size() > 0 && this.changedHandles != null && this.changedHandles.size() > 0) {
            Iterator mBeans = mainModelBeans.iterator();
            while (mBeans.hasNext()) {
                BeanPart mainBean = (BeanPart)mBeans.next();
                if (mainBean == null) continue;
                if (this.changedHandles.contains(mainBean.getFieldDeclHandle()) || mainBean.getInitMethod() != null && this.changedHandles.contains(mainBean.getInitMethod().getMethodHandle()) || mainBean.getReturnedMethod() != null && this.changedHandles.contains(mainBean.getReturnedMethod().getMethodHandle())) {
                    orderedBeans.add(0, mainBean);
                    continue;
                }
                orderedBeans.add(mainBean);
            }
        } else {
            orderedBeans.addAll(mainModelBeans);
        }
        return orderedBeans;
    }

    protected ISourceRange createSourceRange(final int offset, final int len) {
        return new ISourceRange(){

            public int getLength() {
                return len;
            }

            public int getOffset() {
                return offset;
            }
        };
    }

    /*
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected List createNewBeanJavaInstance(BeanPart newBP) {
        err = new ArrayList<BeanPart>();
        try {
            comp = this.mainModel.getCompositionModel().getModelRoot();
            obj = newBP.createEObject();
            annotatedName = newBP.getSimpleName();
            if (!newBP.getSimpleName().equals("this")) {
                if (!(obj instanceof IJavaObjectInstance)) {
                    obj = null;
                    if (JavaVEPlugin.isLoggingLevel((Level)Level.WARNING)) {
                        JavaVEPlugin.log((Object)("Bad Object: " + newBP.getType() + ": " + newBP.getUniqueName()), (Level)Level.WARNING);
                    }
                }
            } else if (obj != null) {
                ((XMIResource)comp.eResource()).setID(obj, MessageFormat.format("this" + CodegenMessages.getString("CodegenMessages.ThisPart.uriID"), new Object[]{this.mainModel.getWorkingCopyProvider().getFile().getFullPath().toString()}));
                annotatedName = null;
            }
            if (obj == null) {
                if (JavaVEPlugin.isLoggingLevel((Level)Level.FINE)) {
                    JavaVEPlugin.log((Object)("Could not create a JavaObjectInstance for: " + newBP.getType() + ": " + newBP.getUniqueName()), (Level)Level.FINE);
                }
                err.add(newBP);
                bItr = newBP.getChildren();
                if (bItr != null) {
                    while (bItr.hasNext()) {
                        err.add((BeanPart)bItr.next());
                    }
                }
                newBP.setEObject(null);
                return err;
            }
            an = CodeGenUtil.addAnnotation(obj);
            if (annotatedName != null) {
                CodeGenUtil.addAnnotatedName(an, annotatedName);
            }
            comp.getAnnotations().add((Object)an);
            try {
                BeanPartFactory.updateInstanceInitString(newBP);
                return err;
            }
            catch (IllegalArgumentException e) {
                JavaVEPlugin.log((Throwable)e, (Level)Level.FINE);
                if (err.contains(newBP)) return err;
                err.add(newBP);
                bItr = newBP.getChildren();
                if (bItr == null) return err;
                ** while (bItr.hasNext())
            }
lbl-1000:
            // 1 sources

            {
                err.add((BeanPart)bItr.next());
                continue;
lbl47:
                // 1 sources

                return err;
            }
        }
        catch (CodeGenException e) {
            if (!JavaVEPlugin.isLoggingLevel((Level)Level.WARNING)) return err;
            JavaVEPlugin.log((Object)("Exception when creating EObject for BeanPart " + newBP.getType() + " with message " + e.getMessage()), (Level)Level.WARNING);
        }
        return err;
    }

    protected boolean addNewBean(BeanPart referenceBP) {
        CodeMethodRef retMethod;
        BeanPart newBP = referenceBP.getFieldDecl() instanceof FieldDeclaration ? new BeanPart((FieldDeclaration)referenceBP.getFieldDecl()) : new BeanPart((VariableDeclarationStatement)referenceBP.getFieldDecl());
        newBP.setInstanceInstantiation(referenceBP.isInstanceInstantiation());
        newBP.setInstanceVar(referenceBP.isInstanceVar());
        newBP.setModel(this.mainModel);
        newBP.setIsInJVEModel(false);
        this.mainModel.addBean(newBP);
        if (JavaVEPlugin.isLoggingLevel((Level)Level.FINER)) {
            JavaVEPlugin.log((Object)("BDM Merger >> Created new BP " + newBP.getSimpleName()), (Level)Level.FINER);
        }
        CodeMethodRef initMethod = null;
        initMethod = this.mainModel.getMethod(referenceBP.getInitMethod().getMethodHandle());
        if (initMethod == null) {
            initMethod = this.createNewMainMethodRef(referenceBP.getInitMethod());
            if (JavaVEPlugin.isLoggingLevel((Level)Level.FINER)) {
                JavaVEPlugin.log((Object)("BDM Merger >> Created new init method " + initMethod.getMethodHandle() + " for new bean part" + newBP.getSimpleName()), (Level)Level.FINER);
            }
        }
        newBP.addInitMethod(initMethod);
        CodeMethodRef referenceReturnMethod = referenceBP.getReturnedMethod();
        if (referenceReturnMethod != null && (retMethod = this.mainModel.getMethod(referenceReturnMethod.getMethodHandle())) != null) {
            newBP.addReturnMethod(retMethod);
        }
        try {
            newBP.addToJVEModel();
        }
        catch (CodeGenException e) {
            JavaVEPlugin.log((Throwable)((Object)e));
            newBP.dispose();
            return false;
        }
        List errorBeans = this.createNewBeanJavaInstance(newBP);
        if (errorBeans.size() > 0) {
            Iterator iter = errorBeans.iterator();
            while (iter.hasNext()) {
                BeanPart errBP = (BeanPart)iter.next();
                errBP.dispose();
            }
        }
        return true;
    }

    protected boolean createThisBean(BeanPart referenceBP) {
        this.mainModel.setTypeDecleration(referenceBP.getModel().getTypeDecleration());
        IThisReferenceRule thisRule = (IThisReferenceRule)CodeGenUtil.getEditorStyle(this.mainModel).getRule("ruleIThisReference");
        TypeResolver resolver = referenceBP.getModel().getResolver();
        String typeName = resolver.resolveMain().getName();
        TypeResolver.ResolvedType superResolve = null;
        if (referenceBP.getModel().getTypeRef().getTypeDecl().getSuperclass() != null) {
            superResolve = resolver.resolveType(referenceBP.getModel().getTypeRef().getTypeDecl().getSuperclass());
        }
        ResourceSet rs = this.mainModel.getCompositionModel().getModelResourceSet();
        if (superResolve != null && thisRule.useInheritance(((TypeResolver.Resolved)superResolve).getName(), rs) || thisRule.useInheritance(typeName, rs)) {
            BeanPartFactory bpg = new BeanPartFactory(this.mainModel, null);
            BeanPart thisBP = bpg.createThisBeanPartIfNeeded(null);
            if (JavaVEPlugin.isLoggingLevel((Level)Level.FINER)) {
                JavaVEPlugin.log((Object)("BDM Merger >> Successfully created this bean part : " + thisBP.getSimpleName()), (Level)Level.FINER);
            }
            CodeMethodRef initMethod = null;
            initMethod = this.mainModel.getMethod(referenceBP.getInitMethod().getMethodHandle());
            if (initMethod == null) {
                CodeMethodRef updatedMethodRef = referenceBP.getInitMethod();
                initMethod = new CodeMethodRef(updatedMethodRef.getDeclMethod(), this.mainModel.getTypeRef(), updatedMethodRef.getMethodHandle(), this.createSourceRange(updatedMethodRef.getOffset(), updatedMethodRef.getLen()), updatedMethodRef.getContent());
                initMethod.setModel(this.mainModel);
                if (JavaVEPlugin.isLoggingLevel((Level)Level.FINER)) {
                    JavaVEPlugin.log((Object)("BDM Merger >> Successfully created init method for this bean part " + initMethod.getMethodHandle()), (Level)Level.FINER);
                }
            }
            thisBP.addInitMethod(initMethod);
            List errorBeans = this.createNewBeanJavaInstance(thisBP);
            if (errorBeans.size() > 0) {
                Iterator iter = errorBeans.iterator();
                while (iter.hasNext()) {
                    BeanPart errBP = (BeanPart)iter.next();
                    if (JavaVEPlugin.isLoggingLevel((Level)Level.FINER)) {
                        JavaVEPlugin.log((Object)("BDM Merger >> Disposing bean part " + errBP.getSimpleName() + " when createing java instance for " + referenceBP.getSimpleName()), (Level)Level.FINER);
                    }
                    errBP.dispose();
                }
            }
        }
        return true;
    }

    protected boolean addNewBeans() {
        boolean add = true;
        Iterator newBeansItr = this.newModel.getBeans().iterator();
        while (newBeansItr.hasNext()) {
            if (this.mainModel.isStateSet(1)) {
                return true;
            }
            BeanPart beanPart = (BeanPart)newBeansItr.next();
            if (this.mainModel.getABean(beanPart.getUniqueName()) != null || beanPart.getInitMethod() == null) continue;
            if (beanPart.getSimpleName().equals("this")) {
                add = add && this.createThisBean(beanPart);
                continue;
            }
            boolean bl = add = add && this.addNewBean(beanPart);
        }
        return add;
    }

    protected boolean removeDeletedBean(BeanPart b) {
        boolean remove = false;
        if (b != null) {
            b.dispose();
            remove = true;
        }
        return remove;
    }

    protected boolean removeDeletedBeans() {
        boolean removed = true;
        Iterator mainBeansItr = this.mainModel.getBeans().iterator();
        while (mainBeansItr.hasNext()) {
            boolean typeChanged;
            if (this.mainModel.isStateSet(1)) {
                return true;
            }
            BeanPart mainBean = (BeanPart)mainBeansItr.next();
            if (this.newModel.getABean(mainBean.getUniqueName()) == null) {
                if (JavaVEPlugin.isLoggingLevel((Level)Level.FINER)) {
                    JavaVEPlugin.log((Object)("BDM Merger >> Removing deleted bean " + mainBean.getSimpleName()), (Level)Level.FINER);
                }
                removed = removed && this.removeDeletedBean(mainBean);
                continue;
            }
            BeanPart newBean = this.newModel.getABean(mainBean.getUniqueName());
            boolean isMainBeanThisPart = mainBean.getSimpleName().equals("this");
            boolean isNewBeanThisPart = newBean.getSimpleName().equals("this");
            Name mainBeanExtendsName = isMainBeanThisPart && mainBean.getModel().getTypeDecleration() != null ? mainBean.getModel().getTypeDecleration().getSuperclass() : null;
            Name newBeanExtendsName = isNewBeanThisPart && newBean.getModel().getTypeDecleration() != null ? newBean.getModel().getTypeDecleration().getSuperclass() : null;
            TypeResolver resolver = mainBean.getModel().getResolver();
            String mainType = isMainBeanThisPart && mainBeanExtendsName != null ? resolver.resolveType(mainBeanExtendsName).getName() : mainBean.getType();
            String newType = isNewBeanThisPart && newBeanExtendsName != null ? resolver.resolveType(newBeanExtendsName).getName() : newBean.getType();
            boolean bl = typeChanged = !mainType.equals(newType);
            if (typeChanged) {
                if (isMainBeanThisPart) {
                    if (newBeanExtendsName == null) {
                        if (JavaVEPlugin.isLoggingLevel((Level)Level.FINER)) {
                            JavaVEPlugin.log((Object)"BDM Merger >> Removing THIS bean ", (Level)Level.FINER);
                        }
                        removed = removed && this.removeDeletedBean(mainBean);
                        continue;
                    }
                    if (JavaVEPlugin.isLoggingLevel((Level)Level.FINER)) {
                        JavaVEPlugin.log((Object)"BDM Merger >> This part's type has changed - will need to reload", (Level)Level.FINER);
                    }
                    return false;
                }
                if (JavaVEPlugin.isLoggingLevel((Level)Level.FINER)) {
                    JavaVEPlugin.log((Object)("BDM Merger >> Removing changed type bean " + mainBean.getSimpleName()), (Level)Level.FINER);
                }
                removed = removed && this.removeDeletedBean(mainBean);
                continue;
            }
            CodeMethodRef mainMethod = mainBean.getInitMethod();
            CodeMethodRef newMethod = newBean.getInitMethod();
            if (mainMethod == null || newMethod == null) continue;
            String mainMethodHandle = mainMethod.getMethodHandle();
            String newMethodHandle = newMethod.getMethodHandle();
            if (mainMethodHandle != null && newMethodHandle != null && mainMethodHandle.equals(newMethodHandle)) continue;
            if (JavaVEPlugin.isLoggingLevel((Level)Level.FINER)) {
                JavaVEPlugin.log((Object)("BDM Merger >> Removing changed init method bean " + mainBean.getSimpleName()), (Level)Level.FINER);
            }
            boolean bl2 = removed = removed && this.removeDeletedBean(mainBean);
        }
        return removed;
    }

    protected CodeMethodRef createNewMainMethodRef(CodeMethodRef newMethodRef) {
        BeanPart mainReturnedBP;
        CodeMethodRef mainMethodRef = new CodeMethodRef(newMethodRef.getDeclMethod(), this.mainModel.getTypeRef(), newMethodRef.getMethodHandle(), this.createSourceRange(newMethodRef.getOffset(), newMethodRef.getLen()), newMethodRef.getContent());
        mainMethodRef.setModel(this.mainModel);
        BeanPart updateReturnedBP = this.newModel.getBeanReturned(newMethodRef.getMethodName());
        if (updateReturnedBP != null && (mainReturnedBP = this.mainModel.getABean(updateReturnedBP.getUniqueName())) != null) {
            mainReturnedBP.addReturnMethod(mainMethodRef);
        }
        return mainMethodRef;
    }

    protected boolean addThisMethod() {
        boolean add = true;
        Iterator newBeansItr = this.newModel.getBeans().iterator();
        while (newBeansItr.hasNext()) {
            BeanPart mainBP;
            if (this.mainModel.isStateSet(1)) {
                return true;
            }
            BeanPart beanPart = (BeanPart)newBeansItr.next();
            if (!"this".equals(beanPart.getSimpleName()) || this.mainModel.getABean(beanPart.getSimpleName()) == null || (mainBP = this.mainModel.getABean(beanPart.getSimpleName())).getInitMethod() != null || beanPart.getInitMethod() == null) continue;
            CodeMethodRef initMethod = this.mainModel.getMethod(beanPart.getInitMethod().getMethodHandle());
            if (initMethod == null) {
                initMethod = this.createNewMainMethodRef(beanPart.getInitMethod());
                if (JavaVEPlugin.isLoggingLevel((Level)Level.FINER)) {
                    JavaVEPlugin.log((Object)("BDM Merger >> Created new init method " + initMethod.getMethodHandle() + " for THIS part"), (Level)Level.FINER);
                }
            }
            mainBP.addInitMethod(initMethod);
        }
        return add;
    }

    protected boolean updateEventHandler(CodeEventHandlerRef mainEH, CodeEventHandlerRef updatedEH) {
        ArrayList mainEHMethods = new ArrayList();
        ArrayList updatedEHMethods = new ArrayList();
        Iterator iter = mainEH.getMethods();
        while (iter.hasNext()) {
            mainEHMethods.add(iter.next());
        }
        iter = updatedEH.getMethods();
        while (iter.hasNext()) {
            updatedEHMethods.add(iter.next());
        }
        int mainMtdCount = 0;
        while (mainMtdCount < mainEHMethods.size()) {
            CodeMethodRef mainMethod = (CodeMethodRef)mainEHMethods.get(mainMtdCount);
            boolean suitableMethodFound = false;
            int updMtdCount = 0;
            while (updMtdCount < updatedEHMethods.size()) {
                CodeMethodRef updMethod = (CodeMethodRef)updatedEHMethods.get(updMtdCount);
                if (mainMethod.getMethodName().equals(updMethod.getMethodName())) {
                    suitableMethodFound = true;
                    mainEHMethods.remove(mainMethod);
                    --mainMtdCount;
                    updatedEHMethods.remove(updMethod);
                    --updMtdCount;
                    this.updateMethodOffsetAndContent(mainMethod, updMethod);
                }
                ++updMtdCount;
            }
            if (!suitableMethodFound) {
                mainEHMethods.remove(mainMethod);
                --mainMtdCount;
                mainMethod.dispose();
            }
            ++mainMtdCount;
        }
        int updMtdCount = 0;
        while (updMtdCount < updatedEHMethods.size()) {
            CodeMethodRef updMethod = (CodeMethodRef)updatedEHMethods.get(updMtdCount);
            new CodeMethodRef(updMethod.getDeclMethod(), mainEH, updMethod.getMethodHandle(), this.createSourceRange(updMethod.getOffset(), updMethod.getLen()), updMethod.getContent());
            ++updMtdCount;
        }
        return true;
    }

    protected boolean updateEventHandlers() {
        ArrayList mainEventHandlers = new ArrayList(this.mainModel.getEventHandlers());
        ArrayList updatedEventHandlers = new ArrayList(this.newModel.getEventHandlers());
        int mainEHC = 0;
        while (mainEHC < mainEventHandlers.size()) {
            CodeEventHandlerRef mainEventHandler = (CodeEventHandlerRef)mainEventHandlers.get(mainEHC);
            String mainEventHanlderName = mainEventHandler.getName();
            boolean suitableEventHandlerFound = false;
            int updEHC = 0;
            while (updEHC < updatedEventHandlers.size()) {
                CodeEventHandlerRef updEventHandler = (CodeEventHandlerRef)updatedEventHandlers.get(updEHC);
                if (mainEventHanlderName.equals(updEventHandler.getName())) {
                    suitableEventHandlerFound = true;
                    mainEventHandlers.remove(mainEventHandler);
                    --mainEHC;
                    updatedEventHandlers.remove(updEventHandler);
                    --updEHC;
                    this.updateEventHandler(mainEventHandler, updEventHandler);
                    break;
                }
                ++updEHC;
            }
            if (!suitableEventHandlerFound) {
                mainEventHandlers.remove(mainEventHandler);
                --mainEHC;
                mainEventHandler.dispose();
            }
            ++mainEHC;
        }
        int updEHC = 0;
        while (updEHC < updatedEventHandlers.size()) {
            CodeEventHandlerRef newEventHandler = (CodeEventHandlerRef)updatedEventHandlers.get(updEHC);
            this.createNewEventHandler(newEventHandler);
            ++updEHC;
        }
        return true;
    }

    private void createNewEventHandler(CodeEventHandlerRef updateEventHandler) {
        CodeEventHandlerRef newEventHandler = new CodeEventHandlerRef(updateEventHandler.getTypeDecl(), this.mainModel);
        this.mainModel.getEventHandlers().add(newEventHandler);
        Iterator iter = updateEventHandler.getMethods();
        while (iter.hasNext()) {
            CodeMethodRef updateEventHandlerMethod = (CodeMethodRef)iter.next();
            new CodeMethodRef(updateEventHandlerMethod.getDeclMethod(), newEventHandler, updateEventHandlerMethod.getMethodHandle(), this.createSourceRange(updateEventHandlerMethod.getOffset(), updateEventHandlerMethod.getLen()), updateEventHandlerMethod.getContent());
        }
    }
}

