/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.codegen.java;

import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.SynchronizedStatement;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jem.internal.beaninfo.EventSetDecorator;
import org.eclipse.ve.internal.java.codegen.java.EventExpressionVisitor;
import org.eclipse.ve.internal.java.codegen.java.MethodVisitor;
import org.eclipse.ve.internal.java.codegen.java.SourceVisitor;
import org.eclipse.ve.internal.java.codegen.java.TypeVisitor;
import org.eclipse.ve.internal.java.codegen.model.BeanPart;
import org.eclipse.ve.internal.java.codegen.model.CodeMethodRef;
import org.eclipse.ve.internal.java.codegen.model.CodeTypeRef;
import org.eclipse.ve.internal.java.codegen.model.IBeanDeclModel;
import org.eclipse.ve.internal.java.codegen.model.JavaElementInfo;
import org.eclipse.ve.internal.java.codegen.util.CodeGenException;
import org.eclipse.ve.internal.java.codegen.util.CodeGenUtil;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;

public class EventMethodVisitor
extends MethodVisitor {
    List fESigs;
    CompilationUnit fastDom;
    BeanPart fBean;
    String fPrefixConstraint = null;
    static final String fDefaultPrefix = "add";

    public EventMethodVisitor(BeanPart b, IBeanDeclModel model, List signitures, CompilationUnit dom) {
        this(b.getInitMethod().getDeclMethod(), b, model, signitures, dom);
    }

    public EventMethodVisitor(MethodDeclaration method, BeanPart b, IBeanDeclModel model, List signitures, CompilationUnit dom) {
        this(method, b.getInitMethod(), b, model, signitures, dom);
    }

    public EventMethodVisitor(MethodDeclaration method, CodeMethodRef m, BeanPart b, IBeanDeclModel model, List signitures, CompilationUnit dom) {
        super(method, model, null, m);
        this.fBean = b;
        this.fESigs = signitures;
        this.fastDom = dom;
        boolean useDefault = true;
        int i = 0;
        while (i < this.fESigs.size()) {
            try {
                EventSetDecorator dec = (EventSetDecorator)this.fESigs.get(i);
                if (dec.getAddListenerMethod() != null && dec.getAddListenerMethod().getName().startsWith(fDefaultPrefix)) {
                    useDefault = false;
                    break;
                }
            }
            catch (Exception e) {
                JavaVEPlugin.log((Throwable)e);
            }
            ++i;
        }
        if (useDefault) {
            this.fPrefixConstraint = fDefaultPrefix;
        }
    }

    protected void processStatementArray(Statement[] statements) throws CodeGenException {
        if (statements != null) {
            int i = 0;
            while (i < statements.length) {
                this.processAStatement(statements[i]);
                ++i;
            }
        }
    }

    protected CodeMethodRef getMethodRef(MethodDeclaration method, CodeTypeRef tRef, String methodHandle, ISourceRange range, String content) {
        CodeMethodRef m;
        Iterator itr = this.fMethod.getTypeRef().getMethods();
        while (itr.hasNext()) {
            m = (CodeMethodRef)itr.next();
            if (!methodHandle.equals(m.getMethodHandle())) continue;
            return m;
        }
        m = new CodeMethodRef(method, tRef, methodHandle, range, content);
        return m;
    }

    protected void processMessageSend(MethodInvocation stmt) throws CodeGenException {
        String selector;
        if (stmt.getExpression() instanceof ThisExpression && !(stmt.getExpression() instanceof SuperMethodInvocation)) {
            SourceVisitor newVisitor = null;
            if (stmt.arguments().size() == 0) {
                String method = stmt.getName().getIdentifier();
                MethodDeclaration[] methods = ((TypeDeclaration)this.fastDom.types().get(0)).getMethods();
                JavaElementInfo[] cuMethods = TypeVisitor.getCUMethods(methods, CodeGenUtil.getMethodsInfo(this.fModel.getCompilationUnit()), this.fModel);
                int idx = 0;
                while (idx < methods.length) {
                    MethodDeclaration md;
                    if (methods[idx] instanceof MethodDeclaration && (md = methods[idx]).parameters().size() <= 0 && method.equals(md.getName().getIdentifier())) {
                        if (!cuMethods[idx].getName().equals(md.getName().getIdentifier())) {
                            throw new CodeGenException("Not the same JCMMethod");
                        }
                        CodeMethodRef mref = this.getMethodRef(md, this.fMethod.getTypeRef(), cuMethods[idx].getHandle(), cuMethods[idx].getSourceRange(), cuMethods[idx].getContent());
                        newVisitor = new EventMethodVisitor(md, mref, this.fBean, this.fModel, this.fESigs, this.fastDom);
                        break;
                    }
                    ++idx;
                }
                return;
            }
            if (newVisitor != null) {
                newVisitor.setProgressMonitor(this.getProgressMonitor());
                ((MethodVisitor)newVisitor).visit();
            }
        }
        if (this.fPrefixConstraint != null && !(selector = stmt.getName().getIdentifier()).startsWith(this.fPrefixConstraint)) {
            return;
        }
        if (stmt.getExpression() instanceof MethodInvocation) {
            CodeMethodRef mref = this.fBean.getReturnedMethod();
            MethodInvocation ms = (MethodInvocation)stmt.getExpression();
            if (mref != null && mref.getMethodName().equals(ms.getName().getIdentifier())) {
                EventExpressionVisitor v = new EventExpressionVisitor(this.fBean, this.fMethod, (Statement)stmt.getParent(), this.fModel, this.fESigs, this.fastDom);
                v.setProgressMonitor(this.getProgressMonitor());
                v.visit();
            }
        } else if ((stmt.getExpression() instanceof SimpleName || stmt.getExpression() instanceof ThisExpression) && this.fBean.getSimpleName().equals(stmt.getExpression().toString())) {
            EventExpressionVisitor v = new EventExpressionVisitor(this.fBean, this.fMethod, (Statement)stmt.getParent(), this.fModel, this.fESigs, this.fastDom);
            v.setProgressMonitor(this.getProgressMonitor());
            v.visit();
        }
    }

    protected void processAStatement(Statement stmt) throws CodeGenException {
        if (stmt instanceof Block) {
            this.processBlockStatement((Block)stmt);
        } else if (stmt instanceof TryStatement) {
            this.processTryStatement((TryStatement)stmt);
        } else if (stmt instanceof IfStatement) {
            this.processIFStatement((IfStatement)stmt);
        } else if (stmt instanceof SynchronizedStatement) {
            this.processSynchStatement((SynchronizedStatement)stmt);
        } else if (stmt instanceof ExpressionStatement) {
            ExpressionStatement es = (ExpressionStatement)stmt;
            if (es.getExpression() instanceof MethodInvocation) {
                this.processMessageSend((MethodInvocation)es.getExpression());
            } else if (JavaVEPlugin.isLoggingLevel((Level)Level.FINE)) {
                JavaVEPlugin.log((Object)("\t[Event] MethodVisitor() skiping: " + stmt), (Level)Level.FINE);
            }
        } else if (JavaVEPlugin.isLoggingLevel((Level)Level.FINE)) {
            JavaVEPlugin.log((Object)("\t[Event] MethodVisitor() skiping: " + stmt), (Level)Level.FINE);
        }
    }

    public String toString() {
        return "EventMethodVisitor(" + this.fBean + "," + this.fMethod.getMethodName() + ")";
    }
}

