/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.codegen.java;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jem.internal.beaninfo.EventSetDecorator;
import org.eclipse.jem.internal.beaninfo.core.Utilities;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaEvent;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jem.java.JavaRefFactory;
import org.eclipse.ve.internal.java.codegen.java.EventMethodVisitor;
import org.eclipse.ve.internal.java.codegen.java.MethodVisitor;
import org.eclipse.ve.internal.java.codegen.java.SourceVisitor;
import org.eclipse.ve.internal.java.codegen.java.TypeVisitor;
import org.eclipse.ve.internal.java.codegen.java.rules.IEventProcessingRule;
import org.eclipse.ve.internal.java.codegen.model.BeanPart;
import org.eclipse.ve.internal.java.codegen.model.CodeMethodRef;
import org.eclipse.ve.internal.java.codegen.model.CodeTypeRef;
import org.eclipse.ve.internal.java.codegen.model.IBeanDeclModel;
import org.eclipse.ve.internal.java.codegen.model.JavaElementInfo;
import org.eclipse.ve.internal.java.codegen.util.CodeGenUtil;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;

public class EventsParser {
    IBeanDeclModel fModel;
    CompilationUnit fastDom;
    HashMap faddListeners = new HashMap();
    MethodDeclaration[] domMethods;
    JavaElementInfo[] cuMethods;
    IProgressMonitor progressMonitor;

    public EventsParser(IBeanDeclModel m, CompilationUnit dom) {
        this.fModel = m;
        this.fastDom = dom;
        this.domMethods = ((TypeDeclaration)this.fastDom.types().get(0)).getMethods();
        this.cuMethods = TypeVisitor.getCUMethods(this.domMethods, CodeGenUtil.getMethodsInfo(this.fModel.getCompilationUnit()), this.fModel);
    }

    private List getAddSignitures(JavaClass h) {
        ArrayList<EventSetDecorator> l = (ArrayList<EventSetDecorator>)this.faddListeners.get(h);
        if (l == null) {
            EList events = null;
            try {
                events = h.getAllEvents();
            }
            catch (Throwable t) {
                JavaVEPlugin.log((Throwable)t);
            }
            l = new ArrayList<EventSetDecorator>();
            if (events != null && events.size() > 0) {
                Iterator iter = events.iterator();
                while (iter.hasNext()) {
                    JavaEvent e = (JavaEvent)iter.next();
                    EventSetDecorator ed = Utilities.getEventSetDecorator((EModelElement)e);
                    if (ed == null) continue;
                    l.add(ed);
                }
            }
            this.faddListeners.put(h, l);
        }
        return l;
    }

    private CodeMethodRef getMethodRef(MethodDeclaration md, JavaElementInfo im) throws JavaModelException {
        CodeMethodRef m;
        String handle = im.getHandle();
        CodeTypeRef tr = this.fModel.getTypeRef();
        Iterator itr = tr.getMethods();
        while (itr.hasNext()) {
            m = (CodeMethodRef)itr.next();
            if (!handle.equals(m.getMethodHandle())) continue;
            return m;
        }
        m = new CodeMethodRef(md, tr, handle, im.getSourceRange(), im.getContent());
        return m;
    }

    protected void analyze(BeanPart b, JavaClass h) {
        List addSignitures = this.getAddSignitures(h);
        if (addSignitures == null || addSignitures.size() == 0) {
            return;
        }
        IEventProcessingRule rule = (IEventProcessingRule)CodeGenUtil.getEditorStyle(this.fModel).getRule("ruleEventProcessing");
        int idx = 0;
        while (idx < this.domMethods.length) {
            if (rule.parseForEvents(this.domMethods[idx], b)) {
                SourceVisitor v = null;
                if (b.isInitMethod(this.domMethods[idx])) {
                    v = new EventMethodVisitor(b, this.fModel, addSignitures, this.fastDom);
                } else {
                    try {
                        MethodDeclaration md = this.domMethods[idx];
                        CodeMethodRef mref = this.getMethodRef(md, this.cuMethods[idx]);
                        v = new EventMethodVisitor(md, mref, b, this.fModel, addSignitures, this.fastDom);
                    }
                    catch (JavaModelException javaModelException) {}
                }
                if (v != null) {
                    v.setProgressMonitor(this.getProgressMonitor());
                    ((MethodVisitor)v).visit();
                }
            }
            ++idx;
        }
    }

    public void addEvents(BeanPart b) {
        String t;
        JavaHelpers h;
        CodeMethodRef m = b.getInitMethod();
        if (m != null && (h = JavaRefFactory.eINSTANCE.reflectType(t = b.getType(), this.fModel.getCompositionModel().getModelResourceSet())) instanceof JavaClass) {
            this.analyze(b, (JavaClass)h);
        }
    }

    public IProgressMonitor getProgressMonitor() {
        if (this.progressMonitor == null) {
            this.progressMonitor = new NullProgressMonitor();
        }
        return this.progressMonitor;
    }

    public void setProgressMonitor(IProgressMonitor progressMonitor) {
        this.progressMonitor = progressMonitor;
    }
}

