/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.codegen.java;

import java.awt.Point;
import java.util.logging.Level;
import org.eclipse.emf.common.util.BasicEMap;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.core.IField;
import org.eclipse.ve.internal.cdm.CDMFactory;
import org.eclipse.ve.internal.cdm.CDMPackage;
import org.eclipse.ve.internal.cdm.impl.KeyedConstraintImpl;
import org.eclipse.ve.internal.cdm.model.Rectangle;
import org.eclipse.ve.internal.java.codegen.java.AbstractAnnotationDecoder;
import org.eclipse.ve.internal.java.codegen.java.AnnotationDecoderAdapter;
import org.eclipse.ve.internal.java.codegen.java.rules.InstanceVariableCreationRule;
import org.eclipse.ve.internal.java.codegen.model.BeanPart;
import org.eclipse.ve.internal.java.codegen.util.CodeGenException;
import org.eclipse.ve.internal.java.codegen.util.CodeGenUtil;
import org.eclipse.ve.internal.java.codegen.util.ExpressionParser;
import org.eclipse.ve.internal.java.codegen.util.FreeFormAnnotationTemplate;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;

public class FreeFormAnnoationDecoder
extends AbstractAnnotationDecoder {
    FreeFormAnnotationTemplate fFFtemplate = null;
    protected boolean visual = true;

    public FreeFormAnnoationDecoder(BeanPart bean) {
        super("org.eclipse.ve.internal.cdm.model.visualconstraintkey", bean);
    }

    FreeFormAnnotationTemplate getFFtemplate() {
        if (this.fFFtemplate != null) {
            return this.fFFtemplate;
        }
        this.fFFtemplate = new FreeFormAnnotationTemplate();
        this.fFFtemplate.setSeperator(this.fBeanpart.getModel().getLineSeperator());
        return this.fFFtemplate;
    }

    public boolean isVisualOnFreeform() {
        IField f = null;
        Object object = this.fBeanpart.getModel().getDocumentLock();
        synchronized (object) {
            f = CodeGenUtil.getFieldByName(this.fBeanpart.getSimpleName(), this.fBeanpart.getModel().getCompilationUnit());
        }
        if (f == null) {
            return false;
        }
        ExpressionParser p = new ExpressionParser(f);
        String comment = p.getComment();
        if (comment == null || comment.length() < 1) {
            return true;
        }
        return AnnotationDecoderAdapter.isBeanVisible(comment);
    }

    public String generate(EStructuralFeature sf, Object[] args) throws CodeGenException {
        Object constraint = this.getAnnotationValue();
        boolean isModelled = false;
        isModelled = this.fBeanpart != null && this.fBeanpart.getEObject() != null && this.fBeanpart.getEObject().eResource() != null && this.fBeanpart.getEObject().eResource().getResourceSet() != null ? InstanceVariableCreationRule.isModelled((EClassifier)this.fBeanpart.getEObject().eClass(), this.fBeanpart.getEObject().eResource().getResourceSet()) : false;
        if (!isModelled || constraint != null) {
            FreeFormAnnotationTemplate fft = this.getFFtemplate();
            if (constraint != null) {
                if (constraint instanceof Rectangle) {
                    Rectangle r = (Rectangle)constraint;
                    fft.setPosition(new Point(r.x, r.y));
                } else if (constraint instanceof Boolean && !((Boolean)constraint).booleanValue()) {
                    fft.setPosition(null);
                }
                this.fContent = fft.toString();
            } else {
                this.fContent = fft.toString();
            }
        } else {
            this.fContent = "";
        }
        return this.fContent;
    }

    protected boolean decode(String src) {
        int[] args;
        if (src == null) {
            return this.noAnnotationInSource(false);
        }
        String curAnnotation = FreeFormAnnotationTemplate.getCurrentAnnotation(src);
        if (curAnnotation == null) {
            return this.noAnnotationInSource(false);
        }
        if (JavaVEPlugin.isLoggingLevel((Level)Level.FINE)) {
            JavaVEPlugin.log((Object)(String.valueOf(this.fBeanpart.getUniqueName()) + " Decoding FF annotation"), (Level)Level.FINE);
        }
        if ((args = FreeFormAnnotationTemplate.getAnnotationArgs(src, 0)) == null) {
            if (src.indexOf("visual-constraint") > -1) {
                return this.noAnnotationInSource(true);
            }
            return this.noAnnotationInSource(false);
        }
        KeyedConstraintImpl c = (KeyedConstraintImpl)CDMFactory.eINSTANCE.create(CDMPackage.eINSTANCE.getKeyedConstraint());
        c.setValue((Object)new Rectangle(args[0], args[1], -1, -1));
        try {
            this.setAnnotationValue((BasicEMap.Entry)c);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public boolean decode() throws CodeGenException {
        Object object = this.fBeanpart.getModel().getDocumentLock();
        synchronized (object) {
            IField f;
            block6: {
                f = CodeGenUtil.getFieldByName(this.fBeanpart.getSimpleName(), this.fBeanpart.getModel().getCompilationUnit());
                if (f != null) break block6;
                return false;
            }
            this.fBeanpart.setFieldDeclHandle(f.getHandleIdentifier());
            try {
                ExpressionParser p = new ExpressionParser(f);
                String src = p.getComment();
                return this.decode(src);
            }
            catch (Exception e) {
                JavaVEPlugin.log((Throwable)e, (Level)Level.WARNING);
                return false;
            }
        }
    }

    public void reflectMOFchange() {
        Object object = this.fBeanpart.getModel().getDocumentLock();
        synchronized (object) {
            IField f = CodeGenUtil.getField(this.fBeanpart.getFieldDeclHandle(), this.fBeanpart.getModel().getCompilationUnit());
            if (f == null) {
                return;
            }
            try {
                int len;
                ExpressionParser p = new ExpressionParser(f);
                int srcStart = p.getCodeOff();
                int srcLen = p.getCodeLen();
                String src = this.fBeanpart.getModel().getDocumentBuffer().getContents().substring(srcStart + srcLen + 1);
                String newSrc = null;
                int start = srcStart + srcLen + 1;
                String curAnnotation = FreeFormAnnotationTemplate.getCurrentAnnotation(src);
                if (curAnnotation == null) {
                    newSrc = this.generate(null, null);
                    if (newSrc == null || newSrc.length() == 0) {
                        if (JavaVEPlugin.isLoggingLevel((Level)Level.WARNING)) {
                            JavaVEPlugin.log((Object)(String.valueOf(this.fBeanpart.getUniqueName()) + " No FF annotation."), (Level)Level.WARNING);
                        }
                        return;
                    }
                    newSrc = String.valueOf(FreeFormAnnotationTemplate.getAnnotationPrefix()) + newSrc;
                    int end = FreeFormAnnotationTemplate.getEOL(src, 0);
                    int pSpaces = FreeFormAnnotationTemplate.collectPrecedingSpaces(src, end);
                    start += pSpaces;
                    len = end - pSpaces;
                    if (JavaVEPlugin.isLoggingLevel((Level)Level.FINE)) {
                        JavaVEPlugin.log((Object)(String.valueOf(this.fBeanpart.getUniqueName()) + " Creating FF annotation"), (Level)Level.FINE);
                    }
                } else {
                    if (JavaVEPlugin.isLoggingLevel((Level)Level.FINE)) {
                        JavaVEPlugin.log((Object)(String.valueOf(this.fBeanpart.getUniqueName()) + " Updating FF annotation"), (Level)Level.FINE);
                    }
                    int s = FreeFormAnnotationTemplate.getAnnotationStart(src);
                    s = FreeFormAnnotationTemplate.collectPrecedingSpaces(src, s);
                    int end = FreeFormAnnotationTemplate.getAnnotationEnd(src, s);
                    newSrc = this.generate(null, null);
                    if (newSrc != null && newSrc.length() > 0) {
                        newSrc = String.valueOf(FreeFormAnnotationTemplate.getAnnotationPrefix()) + newSrc;
                    }
                    start += s;
                    len = end - s + 1;
                }
                this.fBeanpart.getModel().getDocumentBuffer().replace(start, len, newSrc);
                this.fBeanpart.getModel().driveExpressionChangedEvent(null, start, newSrc.length() - len);
                JavaVEPlugin.log((Object)newSrc, (Level)Level.FINE);
            }
            catch (Exception e) {
                JavaVEPlugin.log((Throwable)e, (Level)Level.WARNING);
            }
        }
    }
}

