/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.codegen.java;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ve.internal.java.codegen.core.CodegenLockManager;
import org.eclipse.ve.internal.java.codegen.core.ICodegenLockManager;
import org.eclipse.ve.internal.java.codegen.core.JavaSourceTranslator;
import org.eclipse.ve.internal.java.codegen.java.CodeGenJavaMessages;
import org.eclipse.ve.internal.java.codegen.java.ISynchronizerListener;
import org.eclipse.ve.internal.java.codegen.util.IBackGroundWorkStrategy;
import org.eclipse.ve.internal.java.codegen.util.ICancelMonitor;
import org.eclipse.ve.internal.java.codegen.util.IWorkingCopyProvider;
import org.eclipse.ve.internal.java.codegen.util.StrategyWorker;
import org.eclipse.ve.internal.java.codegen.util.WorkerPool;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;
import org.eclipse.ve.internal.java.vce.VCEPreferences;

public class JavaSourceSynchronizer {
    public static final int NO_OF_UPDATE_WORKERS = 2;
    public static final int DEFAULT_SYNC_DELAY = 1000;
    public static int L2R_DELAY_FACTOR = 1;
    public static final String RELOAD_HANDLE = "Reload Request";
    private Object fSyncPoint;
    private BackgroundThread fThread;
    private int fDelay = 1000;
    IWorkingCopyProvider fWorkingCopyProvider;
    Display fDisplay = null;
    WorkerPool fStrategyWorkers = new WorkerPool(2);
    CodegenLockManager lockManager = null;
    private List documentEventList = null;
    List notifierList = null;
    DocListener fDocListener = null;
    JavaSourceTranslator fsrcTranslator = null;
    int fDelayFactor = L2R_DELAY_FACTOR;

    public void appendReloadRequest() {
        this.documentEventList.add(RELOAD_HANDLE);
        this.fThread.reset();
    }

    public JavaSourceSynchronizer(IWorkingCopyProvider wcp, JavaSourceTranslator st) {
        Preferences store = VCEPreferences.getPlugin().getPluginPreferences();
        int newFactor = -1;
        try {
            newFactor = store.getInt("SOURCE_DELAY_FACTOR_NEW");
            if (newFactor >= 0) {
                L2R_DELAY_FACTOR = newFactor;
            }
        }
        catch (Exception exception) {
            L2R_DELAY_FACTOR = 1;
        }
        this.fWorkingCopyProvider = wcp;
        this.fsrcTranslator = st;
        this.fDisplay = Display.getCurrent();
        this.lockManager = new CodegenLockManager();
        this.documentEventList = new ArrayList();
        this.notifierList = new ArrayList();
        this.install();
    }

    private synchronized void install() {
        if (this.fThread != null) {
            return;
        }
        this.fSyncPoint = new Object();
        this.fThread = new BackgroundThread("CodeGen::" + this.getClass().getName() + "[" + this.fWorkingCopyProvider.getFile().getName() + "]");
        this.fThread.start();
        this.connect();
    }

    private Display getDisplay() {
        if (this.fDisplay != null) {
            return this.fDisplay;
        }
        IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        if (windows != null && windows.length > 0) {
            int i = 0;
            while (i < windows.length) {
                if (windows[i].getShell() != null && windows[i].getShell().getDisplay() != null) {
                    this.fDisplay = windows[i].getShell().getDisplay();
                    break;
                }
                ++i;
            }
        }
        return this.fDisplay;
    }

    private void driveStrategy(List allDocEvents, IBackGroundWorkStrategy strategy) throws InterruptedException {
        if (allDocEvents.isEmpty()) {
            return;
        }
        this.fsrcTranslator.fireStatusChanged(CodeGenJavaMessages.getString("JavaSourceSynchronizer.Synchronizing"));
        if (strategy == null) {
            if (JavaVEPlugin.isLoggingLevel((Level)Level.WARNING)) {
                JavaVEPlugin.log((Object)"JavaSourceSynchronizer.driveStrategy() - no strategy", (Level)Level.WARNING);
            }
            return;
        }
        CancelMonitor newMon = new CancelMonitor();
        StrategyWorker w = this.fStrategyWorkers.grabWorker();
        w.assignStrategy(strategy, this.lockManager, allDocEvents, this.fWorkingCopyProvider.getWorkingCopy(true), this.getDisplay(), newMon);
    }

    private void process() {
        if (this.documentEventList.size() > 0 && !this.getLockMgr().isGUIUpdating()) {
            try {
                if (!this.lockManager.isThreadScheduled()) {
                    this.lockManager.setThreadScheduled(true);
                    this.driveStrategy(this.documentEventList, this.fsrcTranslator.createSharedToLocalUpdater());
                }
            }
            catch (InterruptedException interruptedException) {}
        }
        while (this.notifierList.size() > 0) {
            ArrayList NotificationList = new ArrayList();
            List list = this.notifierList;
            synchronized (list) {
                if (this.notifierList.size() > 0) {
                    int i = this.notifierList.size() - 1;
                    while (i >= 0) {
                        NotificationList.add(this.notifierList.remove(i));
                        --i;
                    }
                }
            }
            try {
                if (this.fStrategyWorkers != null && !NotificationList.isEmpty()) {
                    this.fStrategyWorkers.waitForAllWorkersToComplete();
                }
                int i = NotificationList.size() - 1;
                while (i > -1) {
                    try {
                        NotifierElement elm = (NotifierElement)NotificationList.get(i);
                        elm.getListener().markerProcessed(elm.getMarker());
                    }
                    catch (Throwable t) {
                        JavaVEPlugin.log((Throwable)t);
                    }
                    --i;
                }
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void notifyOnMarker(ISynchronizerListener listener, String marker, boolean immediate) {
        if (listener == null || this.fThread == null) {
            return;
        }
        NotifierElement elm = new NotifierElement(listener, marker, immediate);
        List list = this.notifierList;
        synchronized (list) {
            this.notifierList.add(elm);
        }
        if (immediate) {
            this.fThread.goNow();
        } else {
            this.fThread.reset();
        }
    }

    public void setDelay(int delay) {
        if (delay > 1000) {
            this.fDelay = delay;
        }
    }

    public int getDelay() {
        return this.fDelay;
    }

    public synchronized void uninstall() {
        this.disconnect();
        if (this.fThread != null) {
            this.fThread.cancel();
            this.fThread = null;
        }
        if (this.fStrategyWorkers != null) {
            this.fStrategyWorkers.finish();
        }
        this.fStrategyWorkers = null;
    }

    public boolean isWorkQueued() {
        boolean result = false;
        if (this.documentEventList.size() > 0) {
            result = true;
        }
        return result;
    }

    public void suspendDocListener() {
        if (this.fDocListener != null) {
            this.fWorkingCopyProvider.getDocument().removeDocumentListener((IDocumentListener)this.fDocListener);
        }
    }

    public void resumeDocListener() {
        if (this.fDocListener != null) {
            this.fWorkingCopyProvider.getDocument().addDocumentListener((IDocumentListener)this.fDocListener);
        }
    }

    public synchronized void disconnect() {
        if (this.fDocListener != null) {
            this.fWorkingCopyProvider.getDocument().removeDocumentListener((IDocumentListener)this.fDocListener);
            this.fDocListener = null;
        }
        List list = this.notifierList;
        synchronized (list) {
            int i = 0;
            while (i < this.notifierList.size()) {
                NotifierElement elm = (NotifierElement)this.notifierList.get(i);
                if (elm != null) {
                    try {
                        elm.getListener().markerProcessed(elm.getMarker());
                    }
                    catch (Throwable throwable) {}
                }
                ++i;
            }
            this.notifierList.clear();
        }
        this.clearOutstandingWork();
    }

    public synchronized void connect() {
        if (this.fDocListener == null) {
            this.fDocListener = new DocListener();
            this.fWorkingCopyProvider.getDocument().addDocumentListener((IDocumentListener)this.fDocListener);
        }
    }

    protected void clearOutstandingWork() {
        this.documentEventList.clear();
        this.lockManager.resetGUIReadOnly();
    }

    public ICodegenLockManager getLockMgr() {
        return this.lockManager;
    }

    public void stallProcessing() {
        this.fThread.Stall();
    }

    public void resumeProcessing() {
        this.fThread.goNow();
    }

    class BackgroundThread
    extends Thread {
        private volatile boolean fCanceled = false;
        private volatile boolean fReset = false;
        private volatile boolean fStall = false;
        private volatile boolean fIsDirty = false;
        private volatile boolean fIsActive = false;
        private volatile boolean fgoNow = false;

        public BackgroundThread(String name) {
            super(name);
            this.setPriority(1);
            this.setDaemon(true);
        }

        public boolean isActive() {
            return this.fIsActive;
        }

        public void cancel() {
            this.fCanceled = true;
            Object object = JavaSourceSynchronizer.this.fSyncPoint;
            synchronized (object) {
                JavaSourceSynchronizer.this.fSyncPoint.notifyAll();
            }
        }

        public void reset() {
            if (JavaSourceSynchronizer.this.fDelay > 0) {
                BackgroundThread backgroundThread = this;
                synchronized (backgroundThread) {
                    this.fIsDirty = true;
                    if (!this.fgoNow) {
                        this.fReset = true;
                    }
                }
            } else {
                this.goNow();
            }
        }

        public void goNow() {
            BackgroundThread backgroundThread = this;
            synchronized (backgroundThread) {
                this.fIsDirty = true;
                this.fReset = false;
                Object object = JavaSourceSynchronizer.this.fSyncPoint;
                synchronized (object) {
                    this.fgoNow = true;
                    this.fStall = false;
                    JavaSourceSynchronizer.this.fSyncPoint.notifyAll();
                }
            }
        }

        public void Stall() {
            BackgroundThread backgroundThread = this;
            synchronized (backgroundThread) {
                this.fgoNow = false;
                this.fStall = true;
            }
        }

        public void run() {
            while (!this.fCanceled) {
                Object object = JavaSourceSynchronizer.this.fSyncPoint;
                synchronized (object) {
                    try {
                        if (!this.fgoNow) {
                            if (!this.fStall) {
                                JavaSourceSynchronizer.this.fSyncPoint.wait(JavaSourceSynchronizer.this.fDelay);
                            } else {
                                this.fStall = false;
                                JavaSourceSynchronizer.this.fSyncPoint.wait();
                            }
                        }
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (this.fCanceled) break;
                JavaSourceSynchronizer.this.fDelayFactor = this.fgoNow ? 0 : --JavaSourceSynchronizer.this.fDelayFactor;
                object = this;
                synchronized (object) {
                    if (!this.fIsDirty && !this.fgoNow) {
                        continue;
                    }
                }
                if (JavaSourceSynchronizer.this.fDelayFactor > 0) continue;
                JavaSourceSynchronizer.this.fDelayFactor = L2R_DELAY_FACTOR;
                if (this.fReset) {
                    object = this;
                    synchronized (object) {
                        this.fReset = false;
                    }
                    if (!this.fgoNow) continue;
                }
                this.fIsActive = true;
                JavaSourceSynchronizer.this.process();
                object = this;
                synchronized (object) {
                    this.fIsDirty = JavaSourceSynchronizer.this.notifierList.size() > 0;
                    this.fgoNow = this.fgoNow && this.fIsDirty;
                }
                this.fIsActive = false;
            }
        }
    }

    class NotifierElement {
        ISynchronizerListener fListener;
        String fMarker;
        boolean fImmediate;

        public NotifierElement(ISynchronizerListener sl, String marker, boolean immediate) {
            this.fListener = sl;
            this.fMarker = marker;
            this.fImmediate = immediate;
        }

        public ISynchronizerListener getListener() {
            return this.fListener;
        }

        public String getMarker() {
            return this.fMarker;
        }

        public boolean isImmediate() {
            return this.fImmediate;
        }
    }

    class DocListener
    implements IDocumentListener {
        DocListener() {
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
            JavaSourceSynchronizer.this.lockManager.setGUIReadonly(true);
        }

        public void documentChanged(DocumentEvent event) {
            JavaSourceSynchronizer.this.documentEventList.add(event);
            JavaSourceSynchronizer.this.fsrcTranslator.fireSnippetProcessing(true);
            JavaSourceSynchronizer.this.fThread.reset();
        }
    }

    class CancelMonitor
    implements ICancelMonitor {
        boolean fCancel = false;
        boolean fCompleted = false;

        CancelMonitor() {
        }

        public boolean isCanceled() {
            return this.fCancel;
        }

        public void setCancel(boolean flag) {
            this.fCancel = flag;
        }

        public synchronized void setCompleted() {
            this.fCompleted = true;
            this.notifyAll();
        }

        public synchronized boolean isCompleted(boolean wantToWait) {
            if (wantToWait && !this.fCompleted) {
                try {
                    this.wait();
                }
                catch (Exception exception) {}
            }
            return this.fCompleted;
        }
    }
}

