/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.codegen.java;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.core.jdom.IDOMMethod;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jem.internal.instantiation.base.IJavaObjectInstance;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.ve.internal.java.codegen.java.BeanDecoderAdapter;
import org.eclipse.ve.internal.java.codegen.java.ExpressionRefFactory;
import org.eclipse.ve.internal.java.codegen.java.ICodeGenAdapter;
import org.eclipse.ve.internal.java.codegen.model.BeanDeclModel;
import org.eclipse.ve.internal.java.codegen.model.BeanPart;
import org.eclipse.ve.internal.java.codegen.model.CodeExpressionRef;
import org.eclipse.ve.internal.java.codegen.model.CodeMethodRef;
import org.eclipse.ve.internal.java.codegen.model.IBeanDeclModel;
import org.eclipse.ve.internal.java.codegen.util.BeanMethodTemplate;
import org.eclipse.ve.internal.java.codegen.util.CodeGenException;
import org.eclipse.ve.internal.java.codegen.util.CodeGenUtil;
import org.eclipse.ve.internal.java.codegen.util.IMethodTextGenerator;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;

public class MethodTextGenerator
implements IMethodTextGenerator {
    protected IBeanDeclModel fModel;
    protected IDOMMethod fJdomMethod;
    protected CodeMethodRef fMethodRef;
    protected EObject fComponent;
    protected String freturnType;
    protected String fName;
    protected String fMethodName;
    protected String[] fComments = null;
    private boolean fsourceAppended = false;
    public static final String DEFAULT_PREFIX = "get";

    public MethodTextGenerator(EObject component, IBeanDeclModel model) {
        this.fModel = model;
        this.fComponent = component;
    }

    protected CodeExpressionRef GenerateAttribute(EStructuralFeature sf, BeanPart bean, Object[] args, boolean updateDoc) throws CodeGenException {
        ExpressionRefFactory egen = new ExpressionRefFactory(bean, sf);
        CodeExpressionRef exp = egen.createFromJVEModel(args);
        if (updateDoc) {
            if (exp.getMethod().getMethodHandle() != null) {
                exp.insertContentToDocument();
            } else {
                exp.setState(512, true);
            }
        }
        return exp;
    }

    public void setComments(String[] comments) {
        this.fComments = comments;
    }

    public static boolean isNotToBeCodedAttribute(EStructuralFeature sf, EObject component) {
        return sf == null || sf.isTransient() || sf.equals(CodeGenUtil.getComponentFeature(component)) || sf.equals(CodeGenUtil.getAllocationFeature(component));
    }

    protected boolean ignoreSF(EStructuralFeature sf) {
        return MethodTextGenerator.isNotToBeCodedAttribute(sf, this.fComponent);
    }

    public void generateExpressionsContent() throws CodeGenException {
        if (this.fsourceAppended) {
            return;
        }
        BeanPart bp = this.fModel.getABean(this.fComponent);
        BeanDecoderAdapter bda = (BeanDecoderAdapter)EcoreUtil.getExistingAdapter((Notifier)this.fComponent, (Object)ICodeGenAdapter.JVE_CODEGEN_BEAN_PART_ADAPTER);
        Iterator itr = ((JavaClass)this.fComponent.eClass()).getAllProperties().iterator();
        while (itr.hasNext()) {
            EStructuralFeature sf = (EStructuralFeature)itr.next();
            if (!this.fComponent.eIsSet(sf) || bda == null || sf.isMany() || this.ignoreSF(sf) || bda.getSettingAdapters(sf) != null) continue;
            CodeExpressionRef newExpr = this.GenerateAttribute(sf, bp, null, true);
            String src = newExpr.getContent();
            if (src == null) {
                throw new CodeGenException("Could not Generate Source");
            }
            if (!JavaVEPlugin.isLoggingLevel((Level)Level.FINE)) continue;
            JavaVEPlugin.log((Object)("\tAdding: " + src), (Level)Level.FINE);
        }
    }

    protected void appendNewSource(StringBuffer buf, BeanPart bean, List kids, boolean updateDoc) throws CodeGenException {
        EObject obj = bean.getEObject();
        BeanDecoderAdapter a = (BeanDecoderAdapter)EcoreUtil.getExistingAdapter((Notifier)bean.getEObject(), (Object)ICodeGenAdapter.JVE_CODEGEN_BEAN_PART_ADAPTER);
        Iterator itr = ((JavaClass)obj.eClass()).getEAllStructuralFeatures().iterator();
        while (itr.hasNext()) {
            EStructuralFeature sf = (EStructuralFeature)itr.next();
            if (!obj.eIsSet(sf) || sf.isMany() || this.ignoreSF(sf) || kids.contains(sf) || a.getSettingAdapters(sf) != null && a.getSettingAdapters(sf).length > 0) continue;
            CodeExpressionRef newExpr = this.GenerateAttribute(sf, bean, null, updateDoc);
            String src = newExpr.getContent();
            if (src == null) {
                throw new CodeGenException("Could not Generate Source");
            }
            if (JavaVEPlugin.isLoggingLevel((Level)Level.FINE)) {
                JavaVEPlugin.log((Object)("\tAdding: " + src), (Level)Level.FINE);
            }
            if (!updateDoc) {
                newExpr.setOffset(buf.length());
            }
            buf.append(src);
        }
        this.fsourceAppended = true;
    }

    CodeExpressionRef parseInitExpression(BeanPart bean) {
        ExpressionRefFactory eg = new ExpressionRefFactory(bean, null);
        return eg.parseInitExpression();
    }

    CodeExpressionRef createInitExpression(BeanPart bean) {
        ExpressionRefFactory eg = new ExpressionRefFactory(bean, null);
        return eg.createInitExpression();
    }

    protected Object getChildRoot(BeanPart bean, BeanPart child, EStructuralFeature sf) {
        if (bean == null || child == null) {
            return null;
        }
        if (child.getEObject().eContainer().equals(bean.getEObject())) {
            return child.getEObject();
        }
        return child.getEObject().eContainer();
    }

    protected void GenerateAChild(StringBuffer buf, BeanPart bean, BeanPart child, EStructuralFeature sf) throws CodeGenException {
        Object actualChild = this.getChildRoot(bean, child, sf);
        CodeExpressionRef newExpr = this.GenerateAttribute(sf, bean, new Object[]{actualChild}, false);
        String src = newExpr.getContent();
        if (src == null) {
            if (JavaVEPlugin.isLoggingLevel((Level)Level.WARNING)) {
                JavaVEPlugin.log((Object)("No Source Generated for " + bean.getUniqueName() + "(" + sf + ")"), (Level)Level.WARNING);
            }
            return;
        }
        CodeMethodRef mref = newExpr.getMethod();
        mref.removeExpressionRef(newExpr);
        newExpr.setOffset(buf.length());
        mref.addExpressionRef(newExpr);
        buf.append(src);
        JavaVEPlugin.log((Object)("\tAttribute source added: " + src), (Level)Level.FINE);
    }

    protected void setConstructorString(BeanMethodTemplate tp, Object component, List imports) {
        if (component instanceof IJavaObjectInstance) {
            IJavaObjectInstance obj = (IJavaObjectInstance)component;
            String st = CodeGenUtil.getInitString((IJavaInstance)obj, this.fModel, imports);
            tp.setBeanConstructorString(st);
        }
    }

    public void generateInLine(CodeMethodRef method, String beanName, List kids) throws CodeGenException {
        this.fMethodRef = method;
        this.freturnType = ((IJavaObjectInstance)this.fComponent).getJavaType().getQualifiedName();
        this.fName = beanName;
        BeanPart bp = this.fModel.getABean(this.fName);
        if (bp == null) {
            bp = this.fModel.getABean(BeanDeclModel.constructUniqueName(method, this.fName));
        }
        StringBuffer sb = new StringBuffer();
        CodeExpressionRef initExp = this.createInitExpression(bp);
        initExp.setState(128, false);
        initExp.setOffset(-1);
        try {
            method.updateExpressionOrder();
        }
        catch (Throwable e) {
            JavaVEPlugin.log((Throwable)e, (Level)Level.SEVERE);
            return;
        }
        if (method.getMethodHandle() != null) {
            initExp.insertContentToDocument();
        } else {
            initExp.setState(512, true);
        }
        this.appendNewSource(sb, bp, kids, true);
    }

    public String generateMethod(CodeMethodRef method, String methodName, String beanName, List imports) throws CodeGenException {
        this.fMethodRef = method;
        this.freturnType = ((IJavaObjectInstance)this.fComponent).getJavaType().getQualifiedName();
        this.fName = beanName;
        this.fMethodName = methodName;
        BeanPart bp = this.fModel.getABean(this.fName);
        BeanMethodTemplate template = new BeanMethodTemplate(this.freturnType, this.fName, this.fMethodName, this.fComments);
        this.setConstructorString(template, this.fComponent, imports);
        template.setSeperator(this.fModel.getLineSeperator());
        StringBuffer sb = new StringBuffer();
        sb.append(template.getPrefix());
        if (this.fMethodRef.getExpressions() != null && this.fMethodRef.getExpressions().hasNext()) {
            throw new CodeGenException("Init JCMMethod already has expressions in it");
        }
        method.setContent(String.valueOf(template.getPrefix()) + template.getPostfix());
        this.appendNewSource(sb, bp, new ArrayList(), true);
        sb.append(template.getPostfix());
        return sb.toString();
    }

    public String toString() {
        return String.valueOf(super.toString()) + this.fMethodName;
    }

    public void setBeanInitString(String str) {
    }

    public void setMethodArguments(String[] fmethodArguments) {
    }

    public String getMethodPrefix() {
        return DEFAULT_PREFIX;
    }

    public String generateMain(String className) {
        return null;
    }
}

