/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.codegen.java;

import java.util.List;
import java.util.logging.Level;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.SynchronizedStatement;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.ve.internal.java.codegen.java.ExpressionVisitor;
import org.eclipse.ve.internal.java.codegen.java.ISourceVisitor;
import org.eclipse.ve.internal.java.codegen.java.ReturnStmtVisitor;
import org.eclipse.ve.internal.java.codegen.java.SourceVisitor;
import org.eclipse.ve.internal.java.codegen.java.rules.IIfStatementRule;
import org.eclipse.ve.internal.java.codegen.java.rules.IMethodVariableRule;
import org.eclipse.ve.internal.java.codegen.java.rules.IOverideMethodVisitRule;
import org.eclipse.ve.internal.java.codegen.java.rules.IThisReferenceRule;
import org.eclipse.ve.internal.java.codegen.model.BeanPart;
import org.eclipse.ve.internal.java.codegen.model.CodeMethodRef;
import org.eclipse.ve.internal.java.codegen.model.CodeTypeRef;
import org.eclipse.ve.internal.java.codegen.model.IBeanDeclModel;
import org.eclipse.ve.internal.java.codegen.util.CodeGenException;
import org.eclipse.ve.internal.java.codegen.util.CodeGenUtil;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;

public class MethodVisitor
extends SourceVisitor {
    CodeMethodRef fMethod = null;

    protected void processLocalDecleration(VariableDeclarationStatement stmt) {
        IMethodVariableRule methodVarRule = (IMethodVariableRule)CodeGenUtil.getEditorStyle(this.fModel).getRule("ruleMethodVariable");
        if (methodVarRule != null && methodVarRule.ignoreVariable(stmt, this.fModel.getResolver(), this.fModel.getCompositionModel())) {
            return;
        }
        BeanPart bp = new BeanPart(stmt);
        bp.setModel(this.fModel);
        bp.setInstanceVar(false);
        bp.addInitMethod(this.fMethod);
        this.fModel.addBean(bp);
        VariableDeclaration vd = (VariableDeclaration)stmt.fragments().get(0);
        Expression init = vd.getInitializer();
        if (init instanceof ClassInstanceCreation || init instanceof ArrayCreation || init instanceof CastExpression || init instanceof MethodInvocation) {
            ExpressionVisitor v = new ExpressionVisitor(this.fMethod, (Statement)stmt, this.fModel, this.fReTryLater);
            v.setProgressMonitor(this.getProgressMonitor());
            v.visit();
        }
    }

    protected void processStatementArray(List statements) throws CodeGenException {
        if (statements == null || statements.size() == 0) {
            BeanPart bean;
            IThisReferenceRule thisRule = (IThisReferenceRule)CodeGenUtil.getEditorStyle(this.fModel).getRule("ruleIThisReference");
            String[] mNameModifier = thisRule.getThisInitMethodName(this.fModel.getClassHierarchy());
            if (this.fMethod.getMethodName().equals(mNameModifier[0]) && (bean = this.fModel.getABean("this")) != null) {
                bean.addInitMethod(this.fMethod);
            }
            return;
        }
        int i = 0;
        while (i < statements.size()) {
            this.processAStatement((Statement)statements.get(i));
            ++i;
        }
    }

    protected void processBlockStatement(Block stmt) throws CodeGenException {
        this.processStatementArray(stmt.statements());
    }

    protected void processSynchStatement(SynchronizedStatement stmt) throws CodeGenException {
        this.processBlockStatement(stmt.getBody());
    }

    protected void processTryStatement(TryStatement stmt) throws CodeGenException {
        if (stmt.getBody() != null) {
            this.processBlockStatement(stmt.getBody());
        }
        if (stmt.getFinally() != null) {
            this.processBlockStatement(stmt.getFinally());
        }
    }

    protected void processIFStatement(IfStatement stmt) throws CodeGenException {
        IIfStatementRule ifRule = (IIfStatementRule)CodeGenUtil.getEditorStyle(this.fModel).getRule("ruleIfStatement");
        if (ifRule == null) {
            throw new CodeGenException("No IIfStatementRule");
        }
        ISourceVisitor overideIf = ifRule.overideIFVisit(this.fMethod.getDeclMethod(), stmt, this.fModel);
        if (overideIf != null) {
            overideIf.visit();
            return;
        }
        int processPattern = ifRule.whichPartToProcess(this.fMethod.getDeclMethod(), stmt);
        if ((processPattern & 1) > 0) {
            this.processAStatement(stmt.getThenStatement());
        }
        if ((processPattern & 2) > 0) {
            this.processAStatement(stmt.getElseStatement());
        }
    }

    protected void processAStatement(Statement stmt) throws CodeGenException {
        if (stmt instanceof VariableDeclarationStatement) {
            this.processLocalDecleration((VariableDeclarationStatement)stmt);
        } else if (stmt instanceof Block) {
            this.processBlockStatement((Block)stmt);
        } else if (stmt instanceof TryStatement) {
            this.processTryStatement((TryStatement)stmt);
        } else if (stmt instanceof IfStatement) {
            this.processIFStatement((IfStatement)stmt);
        } else if (stmt instanceof SynchronizedStatement) {
            this.processSynchStatement((SynchronizedStatement)stmt);
        } else if (stmt instanceof ReturnStatement) {
            ReturnStmtVisitor visitor = new ReturnStmtVisitor(this.fMethod, (ReturnStatement)stmt, this.fModel, this.fReTryLater);
            visitor.setProgressMonitor(this.getProgressMonitor());
            visitor.visit();
        } else if (stmt instanceof ExpressionStatement) {
            ExpressionVisitor v = new ExpressionVisitor(this.fMethod, (Statement)((ExpressionStatement)stmt), this.fModel, this.fReTryLater);
            v.setProgressMonitor(this.getProgressMonitor());
            v.visit();
        } else if (JavaVEPlugin.isLoggingLevel((Level)Level.FINE)) {
            JavaVEPlugin.log((Object)("\t[JCMMethod] Visitor did not processAStatement : " + stmt), (Level)Level.FINE);
        }
    }

    public MethodVisitor(MethodDeclaration node, IBeanDeclModel model, List reTryList, CodeTypeRef typeRef, String methodHandle, ISourceRange range, String content) {
        super((ASTNode)node, model, reTryList);
        this.fMethod = new CodeMethodRef(node, typeRef, methodHandle, range, content);
    }

    public MethodVisitor(MethodDeclaration node, IBeanDeclModel model, List reTryList, CodeMethodRef m) {
        super((ASTNode)node, model, reTryList);
        this.fMethod = m;
    }

    public void visit() {
        ISourceVisitor overideVisitor;
        this.getProgressMonitor().subTask(String.valueOf(this.fMethod.getTypeRef().getSimpleName()) + " : " + this.fMethod.getMethodName() + "()");
        IOverideMethodVisitRule overideRule = (IOverideMethodVisitRule)CodeGenUtil.getEditorStyle(this.fModel).getRule("ruleOverideMethod");
        if (overideRule != null && (overideVisitor = overideRule.overideMethodVisit(this.fMethod.getDeclMethod(), this.fModel)) != null) {
            overideVisitor.visit();
            return;
        }
        if (this.fMethod.getDeclMethod().isConstructor()) {
            if (JavaVEPlugin.isLoggingLevel((Level)Level.FINEST)) {
                JavaVEPlugin.log((Object)("Skiping Custructor parsing: " + this.fMethod.getMethodName()));
            }
            return;
        }
        try {
            Block body = this.fMethod.getDeclMethod().getBody();
            if (body != null && body.statements() != null && body.statements().size() > 0) {
                this.processStatementArray(this.fMethod.getDeclMethod().getBody().statements());
            }
        }
        catch (CodeGenException e) {
            JavaVEPlugin.log((Throwable)((Object)e), (Level)Level.WARNING);
        }
        this.getProgressMonitor().worked(100);
    }

    public String toString() {
        return "MethodVisitor(" + this.fMethod.getMethodName() + ")";
    }

    public void setInitMethodFor(BeanPart bp) {
        bp.addInitMethod(this.fMethod);
    }
}

