/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.codegen.java;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaRefFactory;
import org.eclipse.jem.java.Method;
import org.eclipse.ve.internal.java.codegen.java.EventDecoderHelper;
import org.eclipse.ve.internal.java.codegen.java.ICodeGenAdapter;
import org.eclipse.ve.internal.java.codegen.java.IEventDecoder;
import org.eclipse.ve.internal.java.codegen.model.BeanPart;
import org.eclipse.ve.internal.java.codegen.util.CodeGenUtil;
import org.eclipse.ve.internal.java.codegen.util.TypeResolver;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;
import org.eclipse.ve.internal.jcm.PropertyChangeEventInvocation;
import org.eclipse.ve.internal.jcm.PropertyEvent;

public abstract class PropertyChangeInvocationHelper
extends EventDecoderHelper {
    public static final String DEFAULT_PROPERTY_CHANGED_ADD_METHOD = "addPropertyChangeListener";
    public static final String PROPERTY_CALLBACK_NAME = "propertyChange";
    public static final String PROPERTY_NAME_GETTER = "getPropertyName";
    public static List PropetyChangeCallbacks = null;
    Method fMethod = null;

    public PropertyChangeInvocationHelper(BeanPart bean, Statement exp, IEventDecoder owner) {
        super(bean, exp, owner);
    }

    protected Method getMethodName() {
        if (this.fMethod == null) {
            this.fMethod = ((PropertyChangeEventInvocation)this.fEventInvocation).getAddMethod();
        }
        return this.fMethod;
    }

    protected boolean isValidSelector(String selector) {
        boolean valid = DEFAULT_PROPERTY_CHANGED_ADD_METHOD.equals(selector);
        if (!valid) {
            CodeGenUtil.logParsingError(this.fExpr.toString(), this.fbeanPart.getInitMethod().getMethodName(), "Invalid Selector", true);
        }
        return valid;
    }

    protected boolean isValidArguments(List exps) {
        boolean valid;
        boolean bl = valid = exps != null && exps.size() > 0 && exps.size() <= 2;
        if (!valid) {
            CodeGenUtil.logParsingError(this.fExpr.toString(), this.fbeanPart.getInitMethod().getMethodName(), "Invalid Arguments", true);
        }
        return valid;
    }

    protected Method getAddMethod(MethodInvocation event) {
        JavaClass beanClass = (JavaClass)JavaRefFactory.eINSTANCE.reflectType(this.fbeanPart.getType(), this.fbeanPart.getModel().getCompositionModel().getModelResourceSet());
        JavaClass propChangeClass = (JavaClass)JavaRefFactory.eINSTANCE.reflectType("java.beans.PropertyChangeListener", this.fbeanPart.getModel().getCompositionModel().getModelResourceSet());
        ArrayList<String> argsList = new ArrayList<String>();
        TypeResolver resolver = this.fbeanPart.getModel().getResolver();
        int i = 0;
        while (i < event.arguments().size()) {
            SimpleName sn;
            if (event.arguments().get(i) instanceof StringLiteral) {
                argsList.add("java.lang.String");
            } else if (event.arguments().get(i) instanceof ClassInstanceCreation) {
                TypeResolver.ResolvedType resolveType = resolver.resolveType(((ClassInstanceCreation)event.arguments().get(i)).getName());
                if (resolveType == null) {
                    return null;
                }
                String t = resolveType.getName();
                JavaClass tclass = (JavaClass)JavaRefFactory.eINSTANCE.reflectType(t, this.fbeanPart.getModel().getCompositionModel().getModelResourceSet());
                if (propChangeClass.isAssignableFrom((EClassifier)tclass)) {
                    argsList.add("java.beans.PropertyChangeListener");
                }
            } else if (event.arguments().get(i) instanceof SimpleName && this.resolveInstance((sn = (SimpleName)event.arguments().get(i)).getIdentifier()) != null) {
                argsList.add("java.beans.PropertyChangeListener");
            }
            ++i;
        }
        Method listenRegMethod = null;
        while (listenRegMethod == null && beanClass != null) {
            listenRegMethod = beanClass.getMethod(DEFAULT_PROPERTY_CHANGED_ADD_METHOD, argsList);
            if (listenRegMethod != null) continue;
            beanClass = beanClass.getSupertype();
        }
        return listenRegMethod;
    }

    public void unadaptToCompositionModel() {
        super.unadaptToCompositionModel();
        EList propEevents = ((PropertyChangeEventInvocation)this.fEventInvocation).getProperties();
        int i = 0;
        while (i < propEevents.size()) {
            PropertyEvent pe = (PropertyEvent)propEevents.get(i);
            this.unadaptPropertyEvent(pe);
            ++i;
        }
    }

    public void adaptToCompositionModel(IEventDecoder decoder) {
        super.adaptToCompositionModel(decoder);
        EList propEevents = ((PropertyChangeEventInvocation)this.fEventInvocation).getProperties();
        int i = 0;
        while (i < propEevents.size()) {
            PropertyEvent pe = (PropertyEvent)propEevents.get(i);
            this.adaptPropertyEvent(pe);
            ++i;
        }
    }

    protected void adaptPropertyEvent(PropertyEvent pe) {
        if (this.feventAdapter != null) {
            pe.eAdapters().add((Object)this.feventAdapter.getPropertyEventSourceRangeAdapter(pe));
        } else {
            JavaVEPlugin.log((Object)"PropertyChangedAllocationStyleHellper.adaptPropertyEvent: NoAdapter", (Level)Level.WARNING);
        }
    }

    protected void unadaptPropertyEvent(PropertyEvent pe) {
        ICodeGenAdapter ca = (ICodeGenAdapter)EcoreUtil.getExistingAdapter((Notifier)pe, (Object)ICodeGenAdapter.JVE_CODEGEN_BEAN_PART_ADAPTER);
        if (ca != null) {
            pe.eAdapters().remove((Object)ca);
        }
    }

    protected List getCallBackList() {
        if (PropetyChangeCallbacks != null) {
            return PropetyChangeCallbacks;
        }
        JavaClass cb = (JavaClass)JavaRefFactory.eINSTANCE.reflectType("java.beans.PropertyChangeListener", this.fbeanPart.getModel().getCompositionModel().getModelResourceSet());
        PropetyChangeCallbacks = cb.getMethods();
        return PropetyChangeCallbacks;
    }
}

