/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.codegen.java.rules;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.ve.internal.cde.rules.IRule;
import org.eclipse.ve.internal.cde.rules.IRuleRegistry;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;
import org.eclipse.ve.internal.java.vce.rules.IRuleProvider;
import org.eclipse.ve.internal.java.vce.templates.JavaObjectEmiter;
import org.eclipse.ve.internal.java.vce.templates.TemplateUtil;

public class UserOverideRuleProvider
implements IRuleProvider {
    public static final IPath DEFAULT_SCRATCH_PATH = Platform.getPluginStateLocation((Plugin)JavaVEPlugin.getPlugin()).append("Rules");
    public static final IPath DEFAULT_SCRATCH_SRC_PATH = DEFAULT_SCRATCH_PATH.append("src");
    IRule fRule = null;
    Class fRuleClass = null;
    String fID = null;
    String fClassname = null;
    String fStyle = null;
    File fsrcFile = null;
    long fTimeStamp = -1L;
    JavaObjectEmiter fEmiter = null;
    String[] classPath = null;
    IRuleRegistry ruleRegistry;

    public UserOverideRuleProvider(String id, String className, String style, IRuleRegistry ruleRegistry) {
        this.fClassname = className;
        this.fStyle = style;
        this.fID = id;
        Path p = new Path(this.fClassname.replace('.', '/'));
        this.fsrcFile = DEFAULT_SCRATCH_SRC_PATH.append(String.valueOf(p.lastSegment()) + ".java").toFile();
        this.ruleRegistry = ruleRegistry;
    }

    protected String[] getClassPath() {
        if (this.classPath != null) {
            return this.classPath;
        }
        List list = TemplateUtil.getPluginAndPreReqJarPath((String)"org.eclipse.ve.java.core");
        try {
            list.addAll(TemplateUtil.getPlatformJREPath());
        }
        catch (CoreException coreException) {}
        this.classPath = new String[list.size()];
        int i = 0;
        while (i < list.size()) {
            this.classPath[i] = (String)list.get(i);
            ++i;
        }
        return this.classPath;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IRule getRule() {
        JavaObjectEmiter e = this.getEmiter(this.getTimeStamp());
        if (e == this.fEmiter) {
            return this.fRule;
        }
        UserOverideRuleProvider userOverideRuleProvider = this;
        synchronized (userOverideRuleProvider) {
            InputStreamReader in;
            block21: {
                IRule iRule;
                block20: {
                    in = null;
                    try {
                        try {
                            this.fRule = (IRule)e.generateObjectFromExisting(this.getClass().getClassLoader(), null);
                            if (this.fRule == null) {
                                if (!this.fsrcFile.canRead()) {
                                    if (JavaVEPlugin.isLoggingLevel((Level)Level.WARNING)) {
                                        JavaVEPlugin.log((Object)("UserOverideRuleProvider: Can not read source file: " + this.fsrcFile.getAbsolutePath()), (Level)Level.WARNING);
                                    }
                                    iRule = null;
                                    Object var7_5 = null;
                                    if (in == null) return iRule;
                                    break block20;
                                }
                                in = new FileReader(this.fsrcFile);
                                char[] buf = new char[4096];
                                StringBuffer sBuf = new StringBuffer();
                                while (true) {
                                    int len;
                                    if ((len = in.read(buf, 0, buf.length)) <= 0) {
                                        e.setSrc(sBuf.toString().toCharArray());
                                        this.fRule = (IRule)e.generateObject(this.getClassPath(), this.getClass().getClassLoader(), null);
                                        break;
                                    }
                                    sBuf.append(buf, 0, len);
                                }
                            }
                            this.fRule.setRegistry(this.ruleRegistry);
                        }
                        catch (Exception ex) {
                            if (JavaVEPlugin.isLoggingLevel((Level)Level.WARNING)) {
                                JavaVEPlugin.log((Object)("UserOverideRuleProvider.getRule(): " + ex.getMessage()), (Level)Level.WARNING);
                            }
                            break block21;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var7_6 = null;
                        if (in == null) throw throwable;
                        try {
                            in.close();
                            throw throwable;
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                }
                try {}
                catch (IOException iOException) {}
                in.close();
                return iRule;
            }
            Object var7_7 = null;
            if (in != null) {
                try {}
                catch (IOException iOException) {}
                in.close();
            }
            if (this.fRule == null) return this.fRule;
            this.fEmiter = e;
            this.fTimeStamp = this.fsrcFile.lastModified();
            return this.fRule;
        }
    }

    protected JavaObjectEmiter getEmiter(long ts) {
        if (this.fEmiter == null || this.fEmiter.getSrcTimeStamp() < ts) {
            Path p = new Path(this.fClassname.replace('.', '/'));
            return new JavaObjectEmiter(null, p.lastSegment(), p.removeLastSegments(1).toString().replace('/', '.'), DEFAULT_SCRATCH_PATH, this.getTimeStamp());
        }
        return this.fEmiter;
    }

    public long getTimeStamp() {
        if (this.fsrcFile.canRead()) {
            return this.fsrcFile.lastModified();
        }
        return -1L;
    }

    public String getSourceLocation() {
        return this.fsrcFile.getAbsolutePath();
    }

    public String getStyle() {
        return this.fStyle;
    }

    public String toString() {
        return "User Overide Rule(id=" + this.getRuleID() + ", source=" + this.getSourceLocation() + ")";
    }

    public String getRuleID() {
        return this.fID;
    }

    public String getProviderID() {
        return this.getSourceLocation();
    }
}

