/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.codegen.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.ve.internal.java.codegen.java.CodeGenSourceRange;
import org.eclipse.ve.internal.java.codegen.java.ICodeGenSourceRange;
import org.eclipse.ve.internal.java.codegen.java.IExpressionDecoder;
import org.eclipse.ve.internal.java.codegen.java.IJVEDecoder;
import org.eclipse.ve.internal.java.codegen.java.IJavaFeatureMapper;
import org.eclipse.ve.internal.java.codegen.model.AbstractCodeRef;
import org.eclipse.ve.internal.java.codegen.model.BeanPart;
import org.eclipse.ve.internal.java.codegen.model.CodeEventRef;
import org.eclipse.ve.internal.java.codegen.model.CodeMethodRef;
import org.eclipse.ve.internal.java.codegen.model.IBeanDeclModel;
import org.eclipse.ve.internal.java.codegen.util.BeanMethodTemplate;
import org.eclipse.ve.internal.java.codegen.util.CodeGenException;
import org.eclipse.ve.internal.java.codegen.util.CodeGenUtil;
import org.eclipse.ve.internal.java.codegen.util.ExpressionParser;
import org.eclipse.ve.internal.java.codegen.util.ExpressionTemplate;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;

public class CodeExpressionRef
extends AbstractCodeRef {
    protected Statement fexpStmt = null;
    protected CodeMethodRef fMethod = null;
    protected IExpressionDecoder fDecoder = null;
    protected BeanPart fBean = null;
    protected Object[] fArguments = null;
    private int fInternalState = 0;
    protected ExpressionParser fContentParser = null;
    protected IJavaFeatureMapper.VEexpressionPriority fPriority = null;
    protected CodeExpressionRef fMasteredExpression = null;
    protected List freqImports = new ArrayList();
    public static final int STATE_EXIST = 1;
    public static final int STATE_IN_SYNC = 2;
    public static final int STATE_NO_MODEL = 4;
    public static final int STATE_NO_SRC = 8;
    public static final int STATE_DELETE = 16;
    public static final int STATE_IMPLICIT = 32;
    public static final int STATE_UPDATING_SOURCE = 64;
    public static final int STATE_SRC_LOC_FIXED = 128;
    public static final int STATE_EXP_IN_LIMBO = 256;
    public static final int STATE_EXP_NOT_PERSISTED = 512;
    public static final int STATE_MASTER = 1024;
    public static final int STATE_MASTER_DELETED = 2048;
    public static final int STATE_INIT_EXPR = 4096;
    static /* synthetic */ Class class$0;

    public CodeExpressionRef(Statement exp, CodeMethodRef method, BeanPart bean) {
        this.setOffset(-1);
        this.setBean(bean);
    }

    public CodeExpressionRef(Statement exp, CodeMethodRef method, int delta) {
        super(-1, -1, null);
        int start = exp.getStartPosition() + delta;
        int end = exp.getStartPosition() + exp.getLength() + delta;
        String fromSource = method.getContent().substring(start - method.getOffset(), end - method.getOffset());
        end = ExpressionParser.indexOfLastSemiColon(fromSource) - 1 + start;
        ExpressionParser fCP = this.createExpressionParser(method.getContent(), start - method.getOffset(), end - start + 1);
        this.fMethod = method;
        this.fexpStmt = exp;
        this.setState(128, true);
        this.setContent(fCP);
        this.setOffset(this.getContentParser().getFillerOff());
    }

    public CodeExpressionRef(Statement exp, CodeMethodRef method) {
        this(exp, method, 0);
    }

    public CodeExpressionRef(CodeMethodRef method, BeanPart bean) {
        super(-1, -1, null);
        this.fMethod = method;
        this.fexpStmt = null;
        this.setBean(bean);
    }

    public CodeMethodRef getMethod() {
        return this.fMethod;
    }

    public IJavaFeatureMapper.VEexpressionPriority getPriority() {
        if (this.isStateSet(20)) {
            return IJavaFeatureMapper.NOPriority;
        }
        return this.primGetDecoder().determinePriority();
    }

    public String getCodeContent() {
        if (this.fContentParser != null) {
            return this.fContentParser.getCode();
        }
        return null;
    }

    public void setCodeContent(String code) throws CodeGenException {
        if (this.fContentParser == null) {
            throw new CodeGenException("No ExpressionParser");
        }
        this.fContentParser.replaceCode(code);
        this.setContent(this.fContentParser);
    }

    public void setCommentContent(String comment) throws CodeGenException {
        if (this.fContentParser == null) {
            throw new CodeGenException("No ExpressionParser");
        }
        this.fContentParser.replaceComments(comment);
        this.setContent(this.fContentParser);
    }

    public void setFillerContent(String filler) throws CodeGenException {
        if (this.fContentParser == null) {
            throw new CodeGenException("No ExpressionParser");
        }
        this.fContentParser.replaceFiller(filler);
        this.setContent(this.fContentParser);
    }

    public String getFillerContent() {
        if (this.fContentParser != null) {
            return this.fContentParser.getFiller();
        }
        return null;
    }

    public String getCommentsContent() {
        if (this.fContentParser != null) {
            return this.fContentParser.getComment();
        }
        return null;
    }

    public void setContent(ExpressionParser parser) {
        this.fContentParser = parser;
        if (parser != null) {
            super.setContent(this.fContentParser.getExpression());
        } else {
            super.setContent(null);
        }
    }

    public ExpressionParser getParser() {
        return this.fContentParser;
    }

    public void setContent(String content) {
        CodeGenException e = new CodeGenException("Use an ExpressionParser to set the content");
        JavaVEPlugin.log((Throwable)((Object)e), (Level)Level.WARNING);
    }

    protected IExpressionDecoder getExpressionDecoder() {
        if (this.fDecoder != null) {
            return this.fDecoder;
        }
        this.fDecoder = CodeGenUtil.getDecoderFactory(this.fBean.getModel()).getExpDecoder((IJavaInstance)this.fBean.getEObject());
        this.fDecoder.setBeanModel(this.fBean.getModel());
        this.fDecoder.setBeanPart(this.fBean);
        this.fDecoder.setCompositionModel(this.fBean.getModel().getCompositionModel());
        try {
            this.fDecoder.setExpression(this);
        }
        catch (CodeGenException e) {
            JavaVEPlugin.log((Throwable)((Object)e));
        }
        return this.fDecoder;
    }

    protected boolean isDuplicate() {
        boolean result = false;
        Iterator itr = this.fBean.getRefExpressions().iterator();
        while (itr.hasNext()) {
            CodeExpressionRef e = (CodeExpressionRef)itr.next();
            if (e == this) {
                return false;
            }
            try {
                if (e.isEquivalent(this) < 0) continue;
                return true;
            }
            catch (CodeGenException codeGenException) {
                if (!JavaVEPlugin.isLoggingLevel((Level)Level.FINEST)) continue;
                JavaVEPlugin.log((Object)("CodeExpressionRef.isDuplicate():  can not determine: " + this));
            }
        }
        return result;
    }

    public boolean decodeExpression() throws CodeGenException {
        if (!this.isAnyStateSet() || this.isStateSet(16)) {
            return true;
        }
        if (this.isStateSet(4)) {
            return true;
        }
        if (this.fBean.getInitMethod() == null || !this.fBean.getInitMethod().equals(this.fMethod)) {
            if (JavaVEPlugin.isLoggingLevel((Level)Level.FINE)) {
                JavaVEPlugin.log((Object)("CodeExpressionRef.decodeExpression(): Invalid init JCMMethod for" + this.fBean), (Level)Level.FINE);
            }
            return false;
        }
        if (this.isDuplicate()) {
            if (JavaVEPlugin.isLoggingLevel((Level)Level.FINE)) {
                JavaVEPlugin.log((Object)("CodeExpressionRef.decodeExpression(): Duplicate Expression" + this.fexpStmt), (Level)Level.FINE);
            }
            return false;
        }
        if (this.getExpressionDecoder() != null) {
            return this.getExpressionDecoder().decode();
        }
        return false;
    }

    protected ExpressionParser createExpressionParser(String sourceSnippet, int expOffset, int expLen) {
        return new ExpressionParser(sourceSnippet, expOffset, expLen);
    }

    protected String removeWhiteSpace(String s) {
        int i = 0;
        while (i < s.length()) {
            if (!Character.isWhitespace(s.charAt(i))) break;
            ++i;
        }
        return s.substring(i);
    }

    public String generateSource(EStructuralFeature sf) throws CodeGenException {
        if (!this.isStateSet(1)) {
            return null;
        }
        String result = this.getExpressionDecoder().generate(sf, this.fArguments);
        if (result == null) {
            return result;
        }
        result = this.removeWhiteSpace(result);
        String e = ExpressionTemplate.getExpression(result);
        ExpressionParser p = this.createExpressionParser(String.valueOf(BeanMethodTemplate.getInitExprFiller()) + result, BeanMethodTemplate.getInitExprFiller().length(), e.length());
        this.setContent(p);
        this.setOffset(-1);
        this.setFillerContent(BeanMethodTemplate.getInitExprFiller());
        try {
            this.refreshAST();
            this.getExpDecoder().setStatement(this.fexpStmt);
        }
        catch (Exception exception) {}
        return result;
    }

    public void setBean(BeanPart bean) {
        this.fBean = bean;
        this.fMethod.addExpressionRef(this);
        bean.addRefExpression(this);
    }

    public BeanPart getBean() {
        return this.fBean;
    }

    public Statement getExprStmt() {
        return this.fexpStmt;
    }

    public void setDecoder(IExpressionDecoder decoder) {
        if (this.fDecoder == decoder) {
            return;
        }
        if (this.fDecoder != null) {
            this.fDecoder.dispose();
        }
        this.fDecoder = decoder;
    }

    public IExpressionDecoder getExpDecoder() {
        if (this.fDecoder != null) {
            return this.fDecoder;
        }
        if (!this.isAnyStateSet() || this.isStateSet(16) || this.isStateSet(4)) {
            return null;
        }
        if (this instanceof CodeEventRef) {
            throw new RuntimeException("EventRef calling getExpDecoder");
        }
        return this.getExpressionDecoder();
    }

    public void refreshFromComposition() throws CodeGenException {
        if (!this.isAnyStateSet() || this.isStateSet(16)) {
            boolean isSrc = this.isStateSet(8);
            this.clearState();
            this.setState(16, true);
            this.setState(8, isSrc);
            this.setContent((ExpressionParser)null);
            return;
        }
        if (this.isStateSet(4)) {
            return;
        }
        if (this.fDecoder == null) {
            throw new CodeGenException("No Decoder");
        }
        if (this.fDecoder.isImplicit(this.fArguments)) {
            return;
        }
        if (this.fDecoder.isDeleted()) {
            boolean isSrc = this.isStateSet(8);
            boolean isMaster = this.isStateSet(1024);
            this.clearState();
            this.setState(16, true);
            this.setState(8, isSrc);
            this.setState(1024, isMaster);
            this.setContent((ExpressionParser)null);
            return;
        }
        String curContent = ExpressionTemplate.getExpression(this.fDecoder.reflectExpression(this.getCodeContent()));
        if (!curContent.equals(this.getCodeContent())) {
            this.setCodeContent(curContent);
            this.setOffset(-1);
        }
        this.setState(2, true);
        this.setState(1, true);
    }

    public String _debugExpressions() {
        return this.getMethod()._debugExpressions();
    }

    public void updateLimboState(CodeExpressionRef exp) {
        this.setState(256, exp.isStateSet(256));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void refreshFromJOM(CodeExpressionRef exp) {
        try {
            try {
                this.setState(64, true);
                int off = this.getOffset();
                int curState = this.primGetState();
                ExpressionParser curParser = this.getContentParser();
                Statement curStatement = this.getExprStmt();
                this.setContent(exp.getParser());
                this.updateLimboState(exp);
                if (exp.getExprStmt() != null) {
                    this.setExprStmt(exp.getExprStmt());
                }
                if (!this.isStateSet(256) && !this.isStateSet(4)) {
                    this.primGetDecoder().setExpression(this);
                    try {
                        if (!this.primGetDecoder().decode()) {
                            int len = this.getLen();
                            this.setContent(curParser);
                            this.primSetState(curState);
                            this.setExprStmt(curStatement);
                            this.primGetDecoder().setExpression(this);
                            this.setLen(len);
                        }
                    }
                    catch (Throwable t) {
                        JavaVEPlugin.log((Throwable)t);
                    }
                }
                this.setOffset(off);
                CodeGenUtil.snoozeAlarm(this.fBean.getEObject(), this.fBean.getModel().getCompositionModel().getModelResourceSet(), new HashMap());
            }
            catch (Exception e) {
                JavaVEPlugin.log((Throwable)e, (Level)Level.WARNING);
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            this.setState(64, false);
            throw throwable;
        }
        {
            Object var7_11 = null;
            this.setState(64, false);
            return;
        }
    }

    public void updateDocument(ExpressionParser newParser) {
        if (this.isStateSet(8)) {
            return;
        }
        Object object = this.fBean.getModel().getDocumentLock();
        synchronized (object) {
            this.setState(64, true);
            int off = this.getOffset();
            int len = this.getLen();
            this.setContent(newParser);
            this.getMethod().refreshIMethod();
            int docOff = off + this.getMethod().getOffset();
            String newContent = this.getContent();
            this.updateDocument(docOff, len, newContent);
            this.setOffset(off);
            this.setState(64, false);
            this.setState(512, false);
        }
    }

    public void updateDocument(boolean updateSharedDoc) {
        if (this.isStateSet(2)) {
            return;
        }
        StringBuffer trace = new StringBuffer();
        trace.append("CodeExpressionRef.updateDocument():\n");
        Object object = this.fBean.getModel().getDocumentLock();
        synchronized (object) {
            this.setState(64, true);
            int off = this.getOffset();
            int len = this.getLen();
            String prevContent = this.getContent() == null ? "" : this.getContent();
            trace.append(prevContent);
            try {
                this.refreshFromComposition();
            }
            catch (CodeGenException e) {
                JavaVEPlugin.log((Throwable)((Object)e), (Level)Level.WARNING);
                this.setState(64, false);
                return;
            }
            boolean isExpInLimbo = false;
            boolean prevContentFoundInCode = false;
            if (updateSharedDoc && this.isStateSet(256) && !this.isStateSet(8)) {
                isExpInLimbo = true;
                if (this.getMethod().getContent().indexOf(prevContent) == off) {
                    prevContentFoundInCode = true;
                }
                if (!prevContentFoundInCode) {
                    this.setOffset(off);
                    this.insertContentToDocument();
                }
                this.setState(256, false);
            }
            if ((!isExpInLimbo || isExpInLimbo && prevContentFoundInCode) && !this.isStateSet(8)) {
                if (this.getContent() != null && prevContent.equals(this.getContent())) {
                    if (JavaVEPlugin.isLoggingLevel((Level)Level.FINE)) {
                        JavaVEPlugin.log((Object)("CodeExpressionRef.updateDocument() : No change - " + prevContent), (Level)Level.FINE);
                    }
                    this.setState(64, false);
                    return;
                }
                int docOff = off + this.getMethod().getOffset();
                String newContent = !this.isAnyStateSet() || this.isStateSet(16) ? "" : this.getContent();
                trace.append("\t changed to: \n");
                trace.append(String.valueOf(newContent) + "\n");
                this.updateDocument(docOff, len, newContent);
            }
            this.setOffset(off);
            this.setState(64, false);
        }
        if (JavaVEPlugin.isLoggingLevel((Level)Level.FINE)) {
            JavaVEPlugin.log((Object)trace.toString(), (Level)Level.FINE);
        }
        if (!this.isAnyStateSet() || this.isStateSet(16)) {
            if (this.isStateSet(1024)) {
                CodeExpressionRef master = this.getMasteredExpression();
                master.setState(2048, this.isStateSet(16));
                master.setState(2, false);
                master.updateDocument(true);
            }
            this.dispose();
        }
    }

    protected void updateDocument(int docOff, int len, String newContent) {
        IBeanDeclModel model = this.fBean.getModel();
        try {
            model.getDocumentBuffer().replace(docOff, len, newContent);
            model.driveExpressionChangedEvent(this.getMethod(), docOff, newContent.length() - len);
            CodeExpressionRef.handleImportStatements(this.fBean.getModel().getCompilationUnit(), this.fBean.getModel(), this.freqImports);
            this.setState(512, false);
        }
        catch (Exception e) {
            JavaVEPlugin.log((Throwable)e);
        }
    }

    public static void handleImportStatements(ICompilationUnit cu, IBeanDeclModel model, List imports) {
        if (imports != null && imports.size() > 0) {
            try {
                String packageName = null;
                IPackageDeclaration[] pkg = cu.getPackageDeclarations();
                if (pkg != null && pkg.length > 0) {
                    packageName = pkg[0].getElementName();
                }
                int i = 0;
                while (i < imports.size()) {
                    String reqName = (String)imports.get(i);
                    int lastIndex = reqName.lastIndexOf(46);
                    if (reqName.indexOf(46) >= 0 && !reqName.substring(0, lastIndex).equals(packageName)) {
                        int preLen = cu.getSource().length();
                        IImportDeclaration[] cuImports = cu.getImports();
                        boolean found = false;
                        int j = 0;
                        while (j < cuImports.length) {
                            String iname = cuImports[j].getElementName();
                            boolean star = false;
                            StringTokenizer tk = new StringTokenizer(iname, ".");
                            String lastSeg = iname;
                            while (tk.hasMoreElements()) {
                                lastSeg = tk.nextToken();
                            }
                            if (lastSeg == "*") {
                                star = true;
                                iname = iname.substring(0, iname.length() - lastSeg.length());
                            }
                            if (star && reqName.startsWith(iname) || !star && reqName.equals(iname)) {
                                found = true;
                                break;
                            }
                            ++j;
                        }
                        if (!found) {
                            int offset = cu.createImport(reqName, null, null).getSourceRange().getOffset();
                            int delta = cu.getSource().length() - preLen;
                            if (model != null) {
                                model.driveExpressionChangedEvent(null, offset, delta);
                            }
                        }
                    }
                    ++i;
                }
            }
            catch (JavaModelException e) {
                JavaVEPlugin.log((Throwable)e);
            }
            imports.clear();
        }
    }

    public void insertContentToDocument() {
        if (this.isStateSet(8) || this.isStateSet(16)) {
            return;
        }
        if (JavaVEPlugin.isLoggingLevel((Level)Level.FINE)) {
            JavaVEPlugin.log((Object)("CodeExpressionRef: creating:\n" + this.getContent() + "\n"), (Level)Level.FINE);
        }
        Object object = this.fBean.getModel().getDocumentLock();
        synchronized (object) {
            this.setState(64, true);
            int docOff = this.getOffset() + this.getMethod().getOffset();
            this.updateDocument(docOff, 0, this.getContent());
            this.setState(64, false);
        }
    }

    public void refreshAST() {
        final Statement[] s = new Statement[1];
        ASTParser parser = ASTParser.newParser((int)2);
        parser.setSource(this.getContent().toCharArray());
        parser.setSourceRange(0, this.getContent().length());
        parser.setKind(2);
        ASTNode ast = parser.createAST(null);
        ASTVisitor visitor = new ASTVisitor(){

            public void endVisit(ExpressionStatement node) {
                s[0] = node;
            }

            public void endVisit(VariableDeclarationStatement node) {
                s[0] = node;
            }
        };
        ast.accept(visitor);
        if (s[0] == null) {
            if (JavaVEPlugin.isLoggingLevel((Level)Level.WARNING)) {
                JavaVEPlugin.log((Object)("CodeExpressionRef.refreshAST(): could notrefresh " + this.getContent()), (Level)Level.WARNING);
            }
        } else {
            this.fexpStmt = s[0];
        }
    }

    public boolean isStateSet(int state) {
        return (this.primGetState() & state) == state;
    }

    public boolean isAnyStateSet() {
        return this.primGetState() != 0;
    }

    public int isEquivalent(AbstractCodeRef code) throws CodeGenException {
        if (code instanceof CodeExpressionRef) {
            Class<?> clazz = code.getClass();
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.eclipse.ve.internal.java.codegen.model.CodeExpressionRef");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz.isAssignableFrom(clazz2)) {
                CodeExpressionRef exp1 = (CodeExpressionRef)code;
                if (exp1.equals(this)) {
                    return 1;
                }
                if (this.getBean() == null && exp1.getBean() != null) {
                    return -1;
                }
                if (this.getBean() != null && exp1.getBean() == null) {
                    return -1;
                }
                boolean beanNameEquivalency = this.getBean().getSimpleName().equals(exp1.getBean().getSimpleName());
                String expc1 = exp1.getMethodNameContent();
                String expc2 = this.getMethodNameContent();
                boolean expEquivalency = expc1.equals(expc2);
                if (beanNameEquivalency && expEquivalency) {
                    if (this.isStateSet(4)) {
                        if (exp1.isStateSet(4)) {
                            if (this.getCodeContent().equals(exp1.getCodeContent())) {
                                return 1;
                            }
                            return 0;
                        }
                        return -1;
                    }
                    if (exp1.isStateSet(4)) {
                        return -1;
                    }
                    if (this.getBean().getEObject() == null && exp1.getBean().getEObject() == null) {
                        throw new CodeGenException("Can not determine equivalency");
                    }
                    boolean thisSetProxy = false;
                    boolean exp1SetProcy = false;
                    if (this.getBean().getEObject() == null) {
                        thisSetProxy = true;
                        if (this.getBean().isProxy()) {
                            throw new CodeGenException("Proxy with no Ref Object");
                        }
                        this.getBean().setProxy(exp1.getBean());
                    } else if (exp1.getBean().getEObject() == null) {
                        exp1SetProcy = true;
                        if (exp1.getBean().isProxy()) {
                            throw new CodeGenException("Proxy with no Ref Object");
                        }
                        exp1.getBean().setProxy(this.getBean());
                    }
                    try {
                        Object[] h = this.getExpressionDecoder().getArgsHandles(this.getExprStmt());
                        Object[] hc = exp1.getExpressionDecoder().getArgsHandles(exp1.getExprStmt());
                        if (thisSetProxy) {
                            this.getBean().setProxy(null);
                        }
                        if (exp1SetProcy) {
                            exp1.getBean().setProxy(null);
                        }
                        if (h == null && hc != null || h != null && hc == null) {
                            return -1;
                        }
                        if (h == null && hc == null) {
                            if (this.getCodeContent().equals(exp1.getCodeContent())) {
                                return 1;
                            }
                            return 0;
                        }
                        if (h.length != hc.length) {
                            return -1;
                        }
                        int i = 0;
                        while (i < h.length) {
                            if (!h[i].equals(hc[i])) {
                                return -1;
                            }
                            ++i;
                        }
                        if (this.getCodeContent().equals(exp1.getCodeContent())) {
                            return 1;
                        }
                        return 0;
                    }
                    catch (Exception exception) {
                        if (JavaVEPlugin.isLoggingLevel((Level)Level.FINEST)) {
                            JavaVEPlugin.log((Object)("CodeExpressionRef.isEquivalent: could not compare :\n\t" + this + "\n\t" + exp1));
                        }
                        return -1;
                    }
                }
            }
        }
        return -1;
    }

    public String getMethodNameContent() {
        if (this.fexpStmt != null && this.fexpStmt instanceof ExpressionStatement) {
            Assignment assgn;
            Expression e = ((ExpressionStatement)this.fexpStmt).getExpression();
            if (e instanceof MethodInvocation) {
                MethodInvocation msg = (MethodInvocation)e;
                return msg.getName().getIdentifier();
            }
            if (e instanceof Assignment && (assgn = (Assignment)e).getRightHandSide() instanceof ClassInstanceCreation) {
                ClassInstanceCreation alloc = (ClassInstanceCreation)assgn.getRightHandSide();
                String allocS = alloc.toString();
                return allocS.substring(0, allocS.indexOf(alloc.getName().toString())).trim();
            }
        }
        if (this.fContentParser != null) {
            return this.fContentParser.getSelectorContent();
        }
        return null;
    }

    public void dispose() {
        if (!this.isStateSet(16) && this.primGetDecoder() != null) {
            this.primGetDecoder().dispose();
        }
        this.fDecoder = null;
        this.clearState();
        this.setState(16, true);
        this.setContent((ExpressionParser)null);
        if (this.fMethod != null) {
            this.fMethod.removeExpressionRef(this);
        }
        this.fMethod = null;
        if (this.fBean != null) {
            this.fBean.removeRefExpression(this);
            this.fBean.removeNoSrcExpresion(this);
        }
        this.fBean = null;
    }

    public void setProprity(IJavaFeatureMapper.VEexpressionPriority priority) {
    }

    private void primSetState(int flag) {
        this.fInternalState = flag;
    }

    public void clearState() {
        this.primSetState(0);
    }

    public void setStateFrom(CodeExpressionRef e) {
        this.primSetState(e.primGetState());
    }

    public void setState(int flag, boolean state) {
        if (state) {
            this.primSetState(this.primGetState() | flag);
        } else {
            this.primSetState(this.primGetState() & ~flag);
        }
    }

    public String toString() {
        String states = "{ States: ";
        if (this.isStateSet(1)) {
            states = states.concat("EXIST#");
        }
        if (this.isStateSet(256)) {
            states = states.concat("INLIMBO#");
        }
        if (this.isStateSet(32)) {
            states = states.concat("IMPLICIT#");
        }
        if (this.isStateSet(2)) {
            states = states.concat("INSYNC#");
        }
        if (this.isStateSet(4096)) {
            states = states.concat("INIT#");
        }
        if (this.isStateSet(128)) {
            states = states.concat("SRCLOCFIXED#");
        }
        if (this.isStateSet(64)) {
            states = states.concat("UPDATINGSRC#");
        }
        if (this.isStateSet(512)) {
            states = states.concat("NOTPERSISTED#");
        }
        if (this.isStateSet(1024)) {
            states = states.concat("MASTER#");
        }
        if (this.isStateSet(2048)) {
            states = states.concat("MASTER_DELETED#");
        }
        if (this.isStateSet(16)) {
            states = states.concat("DELETE#");
        }
        if (this.isStateSet(8)) {
            states = states.concat("STATE_NO_SRC#");
        }
        if (this.isStateSet(4)) {
            states = states.concat("STATE_NO_MODEL#");
        }
        states = states.concat("} Offset: " + Integer.toString(this.getOffset()));
        if (this.isStateSet(8) && this.fMasteredExpression != null) {
            return String.valueOf(this.fMasteredExpression.getContent()) + states;
        }
        return String.valueOf(super.toString()) + states;
    }

    public int primGetState() {
        return this.fInternalState;
    }

    public void setArguments(Object[] args) {
        this.fArguments = args;
    }

    public Object[] getArgs() {
        return this.fArguments;
    }

    public ExpressionParser getContentParser() {
        return this.fContentParser;
    }

    public ICodeGenSourceRange getTargetSourceRange() {
        if (this.fBean == null || this.fBean.getModel() == null || this.fBean.getModel().isStateSet(1)) {
            return null;
        }
        ISourceRange mSR = this.fBean.getModel().getWorkingCopyProvider().getSourceRange(this.fMethod.getMethodHandle());
        if (mSR == null) {
            return null;
        }
        CodeGenSourceRange result = new CodeGenSourceRange(mSR.getOffset() + this.getOffset(), this.getLen());
        result.setLineOffset(this.fBean.getModel().getWorkingCopyProvider().getLineNo(result.getOffset()));
        return result;
    }

    public void setSF(EStructuralFeature sf) {
        this.getExpDecoder();
        if (this.fDecoder != null) {
            this.fDecoder.setSF(sf);
        }
    }

    public EStructuralFeature getSF() {
        this.getExpDecoder();
        if (this.fDecoder != null) {
            return this.fDecoder.getSF();
        }
        return null;
    }

    protected IJVEDecoder primGetDecoder() {
        return this.getExpressionDecoder();
    }

    public void setExprStmt(Statement statement) {
        this.fexpStmt = statement;
    }

    public void setNoSrcExpression(boolean noSource) {
        this.setState(8, noSource);
        if (this.fBean != null) {
            if (noSource) {
                this.fBean.removeRefExpression(this);
                this.fBean.addNoSrcExpresion(this);
            } else {
                this.fBean.removeNoSrcExpresion(this);
                this.fBean.addRefExpression(this);
            }
        }
        if (this.getMethod() != null) {
            if (noSource) {
                this.getMethod().removeExpressionRef(this);
            } else {
                this.getMethod().addExpressionRef(this);
            }
        }
    }

    public Object[] getAddedInstances() {
        if (this.fDecoder != null) {
            return this.fDecoder.getAddedInstance();
        }
        return null;
    }

    public CodeExpressionRef getMasteredExpression() {
        return this.fMasteredExpression;
    }

    public void setMasteredExpression(CodeExpressionRef masterExpression) {
        this.fMasteredExpression = masterExpression;
        if (masterExpression == null) {
            this.setState(1024, false);
        } else {
            this.setState(1024, true);
        }
    }

    public int getOffset() {
        if (this.fMasteredExpression != null && this.isStateSet(8)) {
            return this.fMasteredExpression.getOffset();
        }
        return super.getOffset();
    }

    public List getReqImports() {
        return this.freqImports;
    }
}

