/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.codegen.model;

import java.util.Iterator;
import java.util.Vector;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.ve.internal.java.codegen.model.CodeMethodRef;
import org.eclipse.ve.internal.java.codegen.model.IBeanDeclModel;
import org.eclipse.ve.internal.java.codegen.util.TypeResolver;
import org.eclipse.ve.internal.jcm.BeanSubclassComposition;

public class CodeTypeRef {
    protected TypeDeclaration fdeclType = null;
    protected IType fType = null;
    protected ICompilationUnit fCU = null;
    protected String fName;
    protected IBeanDeclModel fBeanModel;
    protected Vector fMethods = new Vector();
    protected BeanSubclassComposition fbeanComposition = null;

    public CodeTypeRef(String typeName, IBeanDeclModel model) {
        this.fName = typeName;
        this.fBeanModel = model;
        if (model.getCompositionModel() != null) {
            this.fbeanComposition = model.getCompositionModel().getModelRoot();
        }
    }

    public CodeTypeRef(TypeDeclaration declType, IBeanDeclModel model) {
        this.fdeclType = declType;
        TypeResolver.ResolvedType resolveType = model.getResolver().resolveType((Name)declType.getName());
        this.fName = resolveType != null ? resolveType.getName() : declType.getName().getFullyQualifiedName();
        this.fBeanModel = model;
        this.fbeanComposition = model.getCompositionModel().getModelRoot();
    }

    public TypeDeclaration getTypeDecl() {
        return this.fdeclType;
    }

    public String toString() {
        return String.valueOf(super.toString()) + ":" + this.fName;
    }

    public IBeanDeclModel getBeanModel() {
        return this.fBeanModel;
    }

    public void addRefMethod(CodeMethodRef method) {
        if (!this.fMethods.contains(method)) {
            this.fMethods.add(method);
        }
    }

    public void removeRefMethod(CodeMethodRef method) {
        this.fMethods.remove(method);
    }

    public Iterator getMethods() {
        return this.fMethods.iterator();
    }

    public String getName() {
        return this.fName;
    }

    public String getSimpleName() {
        if (this.fName.indexOf(36) >= 0) {
            return this.fName.substring(this.fName.indexOf(36) + 1);
        }
        return this.fName;
    }

    public void dispose() {
        if (this.fMethods != null) {
            Object[] tmp = this.fMethods.toArray();
            int i = 0;
            while (i < tmp.length) {
                ((CodeMethodRef)tmp[i]).dispose();
                ++i;
            }
        }
        this.fMethods.clear();
    }

    public BeanSubclassComposition getBeanComposition() {
        return this.fbeanComposition;
    }
}

