/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.codegen.wizards;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.ve.internal.java.codegen.wizards.VisualElementModel;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;

public class CategoryModel {
    private List treeElements = new ArrayList();
    protected CategoryModel parent;
    private IConfigurationElement configElement;

    public CategoryModel() {
    }

    public CategoryModel(IConfigurationElement configElement) {
        this();
        this.configElement = configElement;
    }

    protected void addVisualElement(VisualElementModel element) {
        element.parent = this;
        this.treeElements.add(element);
    }

    public void removeVisualElement(VisualElementModel element) {
        this.treeElements.remove(element);
    }

    protected void addStyle(CategoryModel element) {
        element.parent = this;
        this.treeElements.add(element);
    }

    public void removeStyle(CategoryModel set) {
        this.treeElements.remove(set);
    }

    public String getName() {
        if (this.configElement != null) {
            return this.configElement.getAttribute("name");
        }
        return null;
    }

    public String getId() {
        if (this.configElement != null) {
            return this.configElement.getAttributeAsIs("id");
        }
        return null;
    }

    public Object getParent() {
        return this.parent;
    }

    public int getPriority() {
        String priority;
        if (this.configElement != null && (priority = this.configElement.getAttributeAsIs("priority")) != null) {
            try {
                return Integer.parseInt(priority);
            }
            catch (NumberFormatException nx) {
                JavaVEPlugin.log((Throwable)nx, (Level)Level.FINEST);
                return 10000;
            }
        }
        return 10000;
    }

    public boolean getDefaultExpand() {
        String defaultExpand = this.configElement.getAttributeAsIs("defaultExpand");
        if (defaultExpand != null) {
            return defaultExpand.equalsIgnoreCase("true");
        }
        return true;
    }

    public Object[] getChildren() {
        if (this.treeElements.size() > 0) {
            return this.treeElements.toArray();
        }
        return new Object[0];
    }

    public Object[] getStyles() {
        return this.treeElements.toArray();
    }
}

