/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.codegen.wizards;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogFieldGroup;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.jdt.ui.wizards.NewClassWizardPage;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ve.internal.java.codegen.core.CodegenMessages;
import org.eclipse.ve.internal.java.codegen.wizards.CategoryModel;
import org.eclipse.ve.internal.java.codegen.wizards.StyleTreeContentProvider;
import org.eclipse.ve.internal.java.codegen.wizards.StyleTreeLabelProvider;
import org.eclipse.ve.internal.java.codegen.wizards.VisualElementModel;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;

public class NewVisualClassWizardPage
extends NewClassWizardPage {
    TreeViewer styleTreeViewer;
    CategoryModel treeRoot;
    public static final String CREATE_MAIN = "createMain";
    public static final String CREATE_SUPER_CONSTRUCTORS = "createSuperConstructors";
    public static final String CREATE_INHERITED_ABSTRACT = "createInheritedAbstract";
    boolean isSettingSuperclass;
    private VisualElementModel selectedElement = null;
    private static final String DEFAULT_ELEMENT_KEY = "org.eclipse.ve.core.other-Object-java.lang.Object";
    private boolean useSuperClass;
    protected SelectionButtonDialogFieldGroup fMethodStubsButtonsField;
    protected StringButtonDialogField localSuperclassButtonDialogField;

    protected void setTreeState() {
        Object[] topLevel = this.treeRoot.getChildren();
        if (topLevel != null) {
            int i = 0;
            while (i < topLevel.length) {
                if (topLevel[i] instanceof CategoryModel) {
                    this.styleTreeViewer.setExpandedState((Object)((CategoryModel)topLevel[i]), ((CategoryModel)topLevel[i]).getDefaultExpand());
                }
                ++i;
            }
        }
    }

    protected void createTreeClassComposite(Composite composite, int nColumns) {
        Composite labelGroup = this.createComposite(composite, 5);
        ((GridLayout)labelGroup.getLayout()).marginHeight = 0;
        GridData labelData = (GridData)labelGroup.getLayoutData();
        labelData.horizontalSpan = 5;
        this.createLabel(labelGroup, CodegenMessages.getString("NewVisualClassCreationWizard.Style.Tree.Title"));
        this.styleTreeViewer = new TreeViewer(composite, 2052);
        GridData treeGridData = new GridData(768);
        treeGridData.verticalSpan = 4;
        treeGridData.widthHint = this.convertWidthInCharsToPixels(23);
        treeGridData.heightHint = this.convertHeightInCharsToPixels(16);
        this.styleTreeViewer.getTree().setLayoutData((Object)treeGridData);
        this.styleTreeViewer.setContentProvider((IContentProvider)new StyleTreeContentProvider());
        this.styleTreeViewer.setInput((Object)this.getInitalStyleInput());
        this.styleTreeViewer.setLabelProvider((IBaseLabelProvider)new StyleTreeLabelProvider());
        this.styleTreeViewer.setSorter((ViewerSorter)new TreePrioritySorter());
        this.setTreeState();
        if (this.selectedElement != null) {
            this.styleTreeViewer.setSelection((ISelection)new StructuredSelection((Object)this.selectedElement), true);
        }
        this.styleTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection() instanceof IStructuredSelection) {
                    NewVisualClassWizardPage.this.selectedElement = null;
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    Iterator iterator = selection.iterator();
                    while (iterator.hasNext()) {
                        Object domain = iterator.next();
                        if (!(domain instanceof VisualElementModel)) continue;
                        NewVisualClassWizardPage.this.setSuperClass(((VisualElementModel)domain).getSuperClass());
                        NewVisualClassWizardPage.this.selectedElement = (VisualElementModel)domain;
                    }
                }
            }
        });
    }

    protected void createSuperClassControls(Composite composite, int nColumns) {
        this.createTreeClassComposite(composite, nColumns);
        Composite controlsComp = this.createComposite(composite, nColumns);
        ((GridLayout)controlsComp.getLayout()).marginHeight = 0;
        GridData griddata = (GridData)controlsComp.getLayoutData();
        griddata.horizontalSpan = 3;
        griddata.horizontalIndent = 20;
        super.createSuperClassControls(controlsComp, nColumns);
        super.createSuperInterfacesControls(controlsComp, nColumns);
    }

    protected void createSuperInterfacesControls(Composite composite, int nColumns) {
    }

    private CategoryModel findParentStyle(String category, CategoryModel treeRoot) {
        Object[] iterator = treeRoot.getChildren();
        int i = 0;
        while (i < iterator.length) {
            if (iterator[i] instanceof CategoryModel && ((CategoryModel)iterator[i]).getId().equalsIgnoreCase(category)) {
                return (CategoryModel)iterator[i];
            }
            ++i;
        }
        return null;
    }

    private CategoryModel getInitalStyleInput() {
        String[] previousSelectedElementData = null;
        if (!this.useSuperClass) {
            Preferences preferences = JavaVEPlugin.getPlugin().getPluginPreferences();
            if (!preferences.getDefaultString("VISUAL_CLASS_WIZARD_SELECTED_ELEMENT_KEY").equals(DEFAULT_ELEMENT_KEY)) {
                preferences.setDefault("VISUAL_CLASS_WIZARD_SELECTED_ELEMENT_KEY", DEFAULT_ELEMENT_KEY);
            }
            String previousSelectedElement = preferences.getString("VISUAL_CLASS_WIZARD_SELECTED_ELEMENT_KEY");
            previousSelectedElementData = previousSelectedElement.split("-");
        }
        this.treeRoot = new CategoryModel();
        IExtensionPoint exp = Platform.getExtensionRegistry().getExtensionPoint(JavaVEPlugin.getPlugin().getBundle().getSymbolicName(), "newStyleComponent");
        IExtension[] extensions = exp.getExtensions();
        CategoryModel parentStyle = null;
        if (extensions != null && extensions.length > 0) {
            int ec = 0;
            while (ec < extensions.length) {
                IConfigurationElement[] configElms = extensions[ec].getConfigurationElements();
                int cc = 0;
                while (cc < configElms.length) {
                    IConfigurationElement celm = configElms[cc];
                    if (celm.getName().equalsIgnoreCase("Category")) {
                        this.treeRoot.addStyle(new CategoryModel(celm));
                    }
                    if (celm.getName().equalsIgnoreCase("visualElement")) {
                        parentStyle = this.findParentStyle(celm.getAttribute("category"), this.treeRoot);
                        VisualElementModel vem = new VisualElementModel(celm);
                        if (parentStyle != null) {
                            parentStyle.addVisualElement(vem);
                        } else {
                            this.treeRoot.addVisualElement(vem);
                        }
                        if (this.useSuperClass) {
                            if (vem.getSuperClass().equals(this.getSuperClass())) {
                                this.selectedElement = vem;
                            }
                        } else if (vem.getCategory().equals(previousSelectedElementData[0]) && vem.getName().equals(previousSelectedElementData[1])) {
                            this.selectedElement = vem;
                            this.setSuperClass(previousSelectedElementData[2], true);
                        }
                    }
                    ++cc;
                }
                ++ec;
            }
        }
        return this.treeRoot;
    }

    public void setSuperClass(String name) {
        this.useSuperClass = true;
        super.setSuperClass(name, true);
    }

    protected SelectionButtonDialogFieldGroup getMethodStubsButtonsField() {
        if (this.fMethodStubsButtonsField == null) {
            try {
                Class<?> newClassWizardPage = Class.forName("org.eclipse.jdt.ui.wizards.NewClassWizardPage");
                Field field = newClassWizardPage.getDeclaredField("fMethodStubsButtons");
                field.setAccessible(true);
                this.fMethodStubsButtonsField = (SelectionButtonDialogFieldGroup)field.get((Object)this);
            }
            catch (Exception exc) {
                JavaVEPlugin.log((Throwable)exc, (Level)Level.FINEST);
            }
        }
        return this.fMethodStubsButtonsField;
    }

    protected StringButtonDialogField getSuperclassButtonDialogField() {
        if (this.localSuperclassButtonDialogField == null) {
            try {
                Class<?> newClassWizardPage = Class.forName("org.eclipse.jdt.ui.wizards.NewTypeWizardPage");
                Field field = newClassWizardPage.getDeclaredField("fSuperClassDialogField");
                field.setAccessible(true);
                this.localSuperclassButtonDialogField = (StringButtonDialogField)field.get((Object)this);
            }
            catch (Exception exc) {
                JavaVEPlugin.log((Throwable)exc, (Level)Level.FINEST);
            }
        }
        return this.localSuperclassButtonDialogField;
    }

    protected void handleFieldChanged(String fieldName) {
        super.handleFieldChanged(fieldName);
    }

    protected Composite createComposite(Composite aParent, int numColumns) {
        Composite group = new Composite(aParent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = numColumns;
        gridLayout.marginWidth = 1;
        group.setLayout((Layout)gridLayout);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        group.setLayoutData((Object)data);
        return group;
    }

    protected Group createGroup(Composite aParent, String title, int numColumns) {
        Group group = new Group(aParent, 0);
        if (title != null) {
            group.setText(title);
        }
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = numColumns;
        group.setLayout((Layout)gridLayout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        group.setLayoutData((Object)data);
        return group;
    }

    protected void createLabel(Composite parent, String text) {
        Label spacer = new Label(parent, 0);
        if (text != null) {
            spacer.setText(text);
        }
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        spacer.setLayoutData((Object)data);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.createMethodStubSelectionControls(parent, 2);
    }

    private void createMethodStubSelectionControls(Composite composite, int nColumns) {
        SelectionButtonDialogFieldGroup fg = this.getMethodStubsButtonsField();
        if (fg == null) {
            return;
        }
        Label labelControl = fg.getLabelControl(composite);
        LayoutUtil.setHorizontalSpan((Control)labelControl, (int)nColumns);
        LayoutUtil.setHorizontalIndent((Control)labelControl, (int)20);
        Composite buttonGroup = fg.getSelectionButtonsGroup(composite);
        LayoutUtil.setHorizontalSpan((Control)buttonGroup, (int)nColumns);
        LayoutUtil.setHorizontalIndent((Control)buttonGroup, (int)60);
    }

    public HashMap getArgumentMatrix() {
        HashMap<String, String> argumentMatrix = new HashMap<String, String>();
        argumentMatrix.put(CREATE_MAIN, this.isCreateMain() ? "true" : "false");
        argumentMatrix.put(CREATE_SUPER_CONSTRUCTORS, this.isCreateConstructors() ? "true" : "false");
        argumentMatrix.put(CREATE_INHERITED_ABSTRACT, this.isCreateInherited() ? "true" : "false");
        return argumentMatrix;
    }

    public VisualElementModel getSelectedElement() {
        return this.selectedElement;
    }

    public class TreePrioritySorter
    extends ViewerSorter {
        public int category(Object element) {
            if (element instanceof CategoryModel) {
                return ((CategoryModel)element).getPriority();
            }
            return 20000;
        }
    }
}

