/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.codegen.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.jdt.internal.ui.wizards.NewClassCreationWizard;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ve.internal.java.codegen.core.CodegenMessages;
import org.eclipse.ve.internal.java.codegen.wizards.NewVisualClassCreationWizard;
import org.eclipse.ve.internal.java.codegen.wizards.VisualClassExampleWizardPage;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;

public class VisualClassExampleWizard
extends NewClassCreationWizard
implements IExecutableExtension {
    private VisualClassExampleWizardPage fPage;
    private String fExampleClassName;
    private String fPluginName = null;
    private String fContainerPlugin = null;
    private String fContainerName = null;

    public VisualClassExampleWizard() {
        this.setDefaultPageImageDescriptor(JavaVEPlugin.getWizardTitleImageDescriptor());
        this.setDialogSettings(JavaVEPlugin.getPlugin().getDialogSettings());
        this.setWindowTitle(CodegenMessages.getString("VisualClassExampleWizard.title"));
    }

    public void addPages() {
        this.fPage = new VisualClassExampleWizardPage();
        this.addPage((IWizardPage)this.fPage);
        this.fPage.init(this.getSelection());
        this.fPage.setSuperClass("javax.swing.JFrame", false);
        this.fPage.setTypeName(this.fExampleClassName, false);
        this.fPage.setPluginName(this.fPluginName);
    }

    protected void finishPage(IProgressMonitor monitor) throws InterruptedException, CoreException {
        this.fPage.createType(monitor);
        JavaModelUtil.toOriginal((ICompilationUnit)this.fPage.getCreatedType().getCompilationUnit());
        if (this.fContainerPlugin != null && this.fContainerName != null) {
            NewVisualClassCreationWizard.updateProjectClassPath(this.fContainerPlugin, this.fContainerName, this.fPage.getCreatedType().getJavaProject(), monitor);
        }
    }

    protected void openResource(IResource resource) {
        NewVisualClassCreationWizard.openResourceJVE(resource);
    }

    public void setInitializationData(IConfigurationElement element, String string, Object object) {
        if (!"class".equals(string)) {
            return;
        }
        if (object instanceof String) {
            this.setInitializationData(element.getDeclaringExtension().getNamespace(), (String)object);
        } else if (object instanceof Hashtable) {
            Hashtable hash = (Hashtable)object;
            if (hash.containsKey("exampleFile")) {
                this.fExampleClassName = (String)hash.get("exampleFile");
            }
            if (hash.containsKey("classpathContainerPlugin")) {
                this.fContainerPlugin = (String)hash.get("classpathContainerPlugin");
            }
            if (hash.containsKey("classpathContainerName")) {
                this.fContainerName = (String)hash.get("classpathContainerName");
            }
            this.setInitializationData(element.getDeclaringExtension().getNamespace(), this.fExampleClassName, this.fContainerPlugin, this.fContainerName);
        }
    }

    public void setInitializationData(String pluginName, String exampleClassName) {
        this.fPluginName = pluginName;
        this.fExampleClassName = exampleClassName;
    }

    protected void setInitializationData(String pluginName, String exampleClassName, String containerPlugin, String containerName) {
        this.setInitializationData(pluginName, exampleClassName);
        this.fContainerPlugin = containerPlugin;
        this.fContainerName = containerName;
    }

    protected boolean canRunForked() {
        return !this.fPage.isEnclosingTypeSelected();
    }

    public boolean performFinishNewElement() {
        IWorkspaceRunnable op = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
                try {
                    VisualClassExampleWizard.this.finishPage(monitor);
                }
                catch (InterruptedException e) {
                    throw new OperationCanceledException(e.getMessage());
                }
            }
        };
        try {
            this.getContainer().run(this.canRunForked(), true, (IRunnableWithProgress)new WorkbenchRunnableAdapter(op, this.getSchedulingRule()));
        }
        catch (InvocationTargetException e) {
            this.handleFinishException(this.getShell(), e);
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return true;
    }

    public boolean performFinish() {
        IResource resource;
        this.warnAboutTypeCommentDeprecation();
        boolean res = this.performFinishNewElement();
        if (res && (resource = this.fPage.getModifiedResource()) != null) {
            this.selectAndReveal(resource);
            this.openResource(resource);
        }
        return res;
    }
}

