/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.choosebean;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.corext.util.TypeInfo;
import org.eclipse.jdt.internal.ui.dialogs.TypeSelectionDialog;
import org.eclipse.jem.internal.beaninfo.core.Utilities;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jem.internal.proxy.core.ProxyPlugin;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FilteredList;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ve.internal.cde.core.CDEPlugin;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.cde.decorators.ClassDescriptorDecorator;
import org.eclipse.ve.internal.cde.emf.ClassDecoratorFeatureAccess;
import org.eclipse.ve.internal.cdm.DiagramData;
import org.eclipse.ve.internal.java.choosebean.ChooseBeanMessages;
import org.eclipse.ve.internal.java.choosebean.IChooseBeanContributor;
import org.eclipse.ve.internal.java.core.BeanUtilities;
import org.eclipse.ve.internal.java.core.JavaEditDomainHelper;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;
import org.eclipse.ve.internal.java.core.PrototypeFactory;
import org.eclipse.ve.internal.java.rules.IBeanNameProposalRule;
import org.eclipse.ve.internal.java.rules.RuledCommandBuilder;

public class ChooseBeanDialog
extends TypeSelectionDialog {
    public static final String JBCF_CHOOSEBEAN_SELHIST_KEY = "JBCF_CHOOSEBEAN_SELHIST_KEY";
    public static final Color green = Display.getCurrent().getSystemColor(6);
    public static final Color red = Display.getCurrent().getSystemColor(4);
    public static final String EmptyString = new String();
    private ResourceSet resourceSet;
    private IJavaProject project;
    private IPackageFragment pkg;
    private List selectionHistory;
    private IJavaSearchScope scope = null;
    private IChooseBeanContributor[] contributors = null;
    private int selectedContributor = -1;
    private Button[] typeChoices = null;
    private boolean disableOthers = false;
    private Text superFilterText = null;
    private Combo filterCombo = null;
    private Label className = null;
    private String beanLabelText = null;
    private Text beanLabel = null;
    private EditDomain feditDomain = null;
    private boolean classAreaVisability = true;
    private boolean beanLabelVisability = true;
    public static final String PI_CONTAINER = "container";
    public static final String PI_PLUGIN = "plugin";
    public static final IChooseBeanContributor[] NO_CONTRIBS = new IChooseBeanContributor[0];
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public ChooseBeanDialog(Shell shell, IPackageFragment packageFragment, IChooseBeanContributor[] contributors, int choice, boolean disableOthers) {
        super(shell, (IRunnableContext)PlatformUI.getWorkbench().getProgressService(), 5, SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{packageFragment.getJavaProject()}));
        this.selectedContributor = choice;
        this.pkg = packageFragment;
        this.project = packageFragment.getJavaProject();
        this.selectionHistory = new ArrayList();
        this.disableOthers = disableOthers;
        this.contributors = contributors != null ? contributors : this.determineContributors(this.project);
        this.setTitle(ChooseBeanMessages.getString("MainDialog.title"));
        this.setMessage(ChooseBeanMessages.getString("MainDialog.message"));
        this.setStatusLineAboveButtons(true);
        this.setMatchEmptyString(false);
        if (!this.anyContributors()) {
            this.selectedContributor = -1;
        } else if (!this.isValidContributor()) {
            this.selectedContributor = 0;
        }
        this.loadSelectionHistory();
    }

    private IChooseBeanContributor[] determineContributors(IJavaProject project) {
        HashMap containerIDs = new HashMap();
        HashMap pluginsIDs = new HashMap();
        try {
            ProxyPlugin.getPlugin().getIDsFound(project, containerIDs, new HashMap(), pluginsIDs, new HashMap());
            ArrayList<IChooseBeanContributor> contributorList = new ArrayList<IChooseBeanContributor>();
            IExtensionPoint exp = Platform.getExtensionRegistry().getExtensionPoint(JavaVEPlugin.getPlugin().getBundle().getSymbolicName(), "choosebean");
            IExtension[] extensions = exp.getExtensions();
            if (extensions.length > 0) {
                IExtension[] orderedExtensions = new IExtension[extensions.length];
                int index = 0;
                String veBaseBundleName = JavaVEPlugin.getPlugin().getBundle().getSymbolicName();
                int i = 0;
                while (i < extensions.length) {
                    if (extensions[i].getNamespace().equals(veBaseBundleName)) {
                        orderedExtensions[index++] = extensions[i];
                    }
                    ++i;
                }
                i = 0;
                while (i < extensions.length) {
                    if (!extensions[i].getNamespace().equals(veBaseBundleName)) {
                        orderedExtensions[index++] = extensions[i];
                    }
                    ++i;
                }
                int ec = 0;
                while (ec < orderedExtensions.length) {
                    IConfigurationElement[] configElms = orderedExtensions[ec].getConfigurationElements();
                    int cc = 0;
                    while (cc < configElms.length) {
                        IConfigurationElement celm = configElms[cc];
                        if (containerIDs.get(celm.getAttributeAsIs(PI_CONTAINER)) == Boolean.TRUE || pluginsIDs.get(celm.getAttributeAsIs(PI_PLUGIN)) == Boolean.TRUE) {
                            try {
                                IChooseBeanContributor contributor = (IChooseBeanContributor)celm.createExecutableExtension("class");
                                contributorList.add(contributor);
                            }
                            catch (CoreException e) {
                                JavaVEPlugin.log(e, Level.FINE);
                            }
                            catch (ClassCastException e) {
                                JavaVEPlugin.log(e, Level.FINE);
                            }
                        }
                        ++cc;
                    }
                    ++ec;
                }
            }
            return !contributorList.isEmpty() ? contributorList.toArray(new IChooseBeanContributor[contributorList.size()]) : NO_CONTRIBS;
        }
        catch (JavaModelException e) {
            JavaVEPlugin.log(e, Level.FINE);
            return NO_CONTRIBS;
        }
    }

    private void loadSelectionHistory() {
        try {
            String selhists = this.project.getProject().getPersistentProperty(this.getQualifiedName());
            if (selhists != null) {
                StringTokenizer spacer = new StringTokenizer(selhists, " ", false);
                while (spacer.hasMoreTokens()) {
                    this.selectionHistory.add(spacer.nextToken());
                }
            }
        }
        catch (CoreException coreException) {}
    }

    private void storeSelectionHistory() {
        try {
            StringBuffer buff = new StringBuffer();
            int i = 0;
            while (i < this.selectionHistory.size() && i < 10) {
                buff.append(this.selectionHistory.get(i) + " ");
                ++i;
            }
            this.project.getProject().setPersistentProperty(this.getQualifiedName(), buff.toString());
        }
        catch (CoreException coreException) {}
    }

    private QualifiedName getQualifiedName() {
        return new QualifiedName(JavaVEPlugin.getPlugin().getBundle().getSymbolicName(), JBCF_CHOOSEBEAN_SELHIST_KEY);
    }

    public ChooseBeanDialog(Shell shell, IFile file, ResourceSet resourceSet, IChooseBeanContributor[] contributors, int choice, boolean disableOthers) {
        this(shell, (IPackageFragment)JavaCore.create((IFile)file).getParent(), contributors, choice, disableOthers);
        this.resourceSet = resourceSet;
    }

    public ChooseBeanDialog(Shell shell, EditDomain ed, IChooseBeanContributor[] contributors, int choice, boolean disableOthers) {
        this(shell, ((FileEditorInput)ed.getEditorPart().getEditorInput()).getFile(), JavaEditDomainHelper.getResourceSet((EditDomain)ed), contributors, choice, disableOthers);
        this.feditDomain = ed;
    }

    protected boolean anyContributors() {
        return this.contributors.length > 0;
    }

    protected boolean isValidContributor() {
        return this.selectedContributor > -1 && this.selectedContributor < this.contributors.length;
    }

    protected FilteredList createFilteredList(Composite parent) {
        FilteredList list = super.createFilteredList(parent);
        if (this.isValidContributor()) {
            list.setFilterMatcher(this.contributors[this.selectedContributor].getFilter(this.project));
        }
        return list;
    }

    public Control createDialogArea(Composite parent) {
        Composite topComponent = new Composite(parent, 0);
        GridLayout topComponentLayout = new GridLayout();
        topComponent.setLayout((Layout)topComponentLayout);
        Group classGroup = new Group(topComponent, 0);
        GridData gd = new GridData(1808);
        classGroup.setLayoutData((Object)gd);
        classGroup.setText(ChooseBeanMessages.getString("SelectionAreaHelper.GroupTitle"));
        classGroup.setLayout((Layout)new GridLayout());
        Composite c = (Composite)super.createDialogArea((Composite)classGroup);
        if (c.getLayout() instanceof GridLayout) {
            GridLayout gl = (GridLayout)c.getLayout();
            gl.marginHeight = 0;
            gl.marginWidth = 0;
        }
        this.createClassArea((Composite)classGroup);
        this.createBeanLabelArea(topComponent);
        this.className = new Label(topComponent, 0);
        gd = new GridData(768);
        this.className.setLayoutData((Object)gd);
        return topComponent;
    }

    private void createBeanLabelArea(Composite parent) {
        int numCols = 2;
        Group group = new Group(parent, 0);
        group.setLayout((Layout)new GridLayout(numCols, false));
        group.setLayoutData((Object)new GridData(1808));
        group.setText(ChooseBeanMessages.getString("ChooseBeanDialog.Group.Properties.Title"));
        Label label = new Label((Composite)group, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = 1;
        label.setLayoutData((Object)gd);
        label.setText(ChooseBeanMessages.getString("ChooseBeanDialog.Group.Properties.VariableName.text"));
        this.beanLabel = new Text((Composite)group, 2052);
        gd = new GridData(768);
        gd.horizontalSpan = numCols - 1;
        this.beanLabel.setLayoutData((Object)gd);
        this.beanLabel.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (e.widget instanceof Text) {
                    Text text = (Text)e.widget;
                    ChooseBeanDialog.this.beanLabelText = text.getText();
                    ChooseBeanDialog.this.updateOkState();
                }
            }
        });
        if (this.resourceSet == null) {
            group.setEnabled(false);
            label.setEnabled(false);
            this.beanLabel.setEnabled(false);
        }
        group.setVisible(this.beanLabelVisability);
    }

    protected void createClassArea(Composite parent) {
        if (this.isValidContributor()) {
            int numEntries = this.contributors.length;
            Composite c = new Composite(parent, 0);
            GridData gd = new GridData();
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalAlignment = 4;
            c.setLayoutData((Object)gd);
            GridLayout cLayout = new GridLayout(Math.min(numEntries, 4), true);
            cLayout.marginWidth = this.convertHorizontalDLUsToPixels(7);
            cLayout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
            c.setLayout((Layout)cLayout);
            this.typeChoices = new Button[numEntries];
            int i = 0;
            while (i < this.typeChoices.length) {
                this.typeChoices[i] = new Button(c, 16);
                gd = new GridData();
                this.typeChoices[i].setLayoutData((Object)gd);
                this.typeChoices[i].setText(this.contributors[i].getName());
                this.typeChoices[i].addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        if (e.widget instanceof Button) {
                            Button choice = (Button)e.widget;
                            if (choice.getSelection()) {
                                if (ChooseBeanDialog.this.typeChoices != null) {
                                    int i = 0;
                                    while (i < ChooseBeanDialog.this.typeChoices.length) {
                                        if (choice.equals(ChooseBeanDialog.this.typeChoices[i])) {
                                            ChooseBeanDialog.this.selectedContributor = i;
                                        }
                                        ++i;
                                    }
                                }
                                ChooseBeanDialog.this.updateElements();
                            } else {
                                ChooseBeanDialog.this.selectedContributor = -1;
                            }
                        }
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                        this.widgetSelected(e);
                    }
                });
                if (this.disableOthers && this.selectedContributor != i) {
                    this.typeChoices[i].setEnabled(false);
                }
                ++i;
            }
            this.typeChoices[this.selectedContributor].setSelection(true);
            c.setVisible(this.classAreaVisability);
        }
    }

    private void updateElements() {
        if (this.isValidContributor()) {
            this.fFilteredList.setFilterMatcher(this.contributors[this.selectedContributor].getFilter(this.project));
        }
        this.setFilter(this.getFilter());
    }

    protected IJavaSearchScope getJavaSearchScope() {
        if (this.scope == null) {
            this.scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{this.project});
        }
        return this.scope;
    }

    public Object[] getResult() {
        Object[] results = super.getResult();
        if (this.resourceSet != null) {
            Object[] newResults = new Object[results.length * 2];
            int i = 0;
            while (i < results.length) {
                if (results[i] instanceof IType) {
                    IType type = (IType)results[i];
                    if (this.selectionHistory != null) {
                        String typeName = type.getElementName();
                        if (this.selectionHistory.contains(typeName)) {
                            this.selectionHistory.remove(typeName);
                        }
                        this.selectionHistory.add(0, typeName);
                        this.storeSelectionHistory();
                    }
                    String realFQN = type.getFullyQualifiedName('$');
                    PrototypeFactory prototypeFactory = null;
                    JavaHelpers eClass = Utilities.getJavaClass((String)realFQN, (ResourceSet)this.resourceSet);
                    try {
                        ClassDescriptorDecorator decorator;
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = Class.forName("org.eclipse.ve.internal.cde.decorators.ClassDescriptorDecorator");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if ((decorator = (ClassDescriptorDecorator)ClassDecoratorFeatureAccess.getDecoratorWithKeyedFeature((EClassifier)eClass, (Class)clazz, (String)"org.eclipse.ve.internal.prototypefactory")) != null) {
                            String prototypeFactoryName = (String)decorator.getKeyedValues().get((Object)"org.eclipse.ve.internal.prototypefactory");
                            prototypeFactory = (PrototypeFactory)CDEPlugin.createInstance(null, (String)prototypeFactoryName);
                        }
                    }
                    catch (Exception e) {
                        JavaVEPlugin.getPlugin().getLogger().log(Level.WARNING, e);
                    }
                    EObject eObject = null;
                    eObject = prototypeFactory == null ? eClass.getEPackage().getEFactoryInstance().create((EClass)eClass) : prototypeFactory.createPrototype((EClass)eClass);
                    this.setBeanName(eObject, this.beanLabelText);
                    newResults[i * 2] = eObject;
                    newResults[i * 2 + 1] = eClass;
                }
                ++i;
            }
            return newResults;
        }
        return results;
    }

    protected void setBeanName(EObject obj, String name) {
        if (obj != null) {
            RuledCommandBuilder commandBuilder = new RuledCommandBuilder(this.feditDomain);
            commandBuilder.append(BeanUtilities.getSetBeanNameCommand((IJavaInstance)obj, name, this.feditDomain));
            commandBuilder.getCommand().execute();
        }
    }

    protected String getFieldProposal(String className) {
        if (this.feditDomain != null && this.resourceSet != null) {
            DiagramData o = this.feditDomain.getDiagramData();
            IType javaElement = null;
            Iterator iter = o.eAdapters().iterator();
            while (iter.hasNext()) {
                Object je;
                Object a = iter.next();
                if (!(a instanceof IAdaptable)) continue;
                IAdaptable iAdaptable = (IAdaptable)a;
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.jdt.core.IJavaElement");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!((je = iAdaptable.getAdapter((Class)clazz)) instanceof IType)) continue;
                javaElement = (IType)je;
                break;
            }
            if (javaElement != null) {
                IBeanNameProposalRule pp = (IBeanNameProposalRule)this.feditDomain.getRuleRegistry().getRule("ruleBeanNameProposal");
                String result = pp.getProspectInstanceVariableName(className, new Object[]{javaElement}, this.resourceSet);
                return result == null ? EmptyString : result;
            }
        }
        return EmptyString;
    }

    protected void setClassName(String name, boolean validClass) {
        if (validClass) {
            this.className.setForeground(green);
        } else {
            this.className.setForeground(red);
        }
        if (name == null || name.length() == 0) {
            String t = name == null ? EmptyString : name;
            this.className.setText(t);
            this.beanLabel.setText(t);
        } else {
            if (validClass) {
                this.beanLabel.setText(this.getFieldProposal(name));
            } else {
                this.beanLabel.setText(EmptyString);
            }
            this.className.setText(name);
        }
    }

    protected EAnnotation findDecorator(EList decorators, Class decoratorType) {
        if (decorators == null) {
            return null;
        }
        int i = 0;
        while (i < decorators.size()) {
            EAnnotation o = (EAnnotation)decorators.get(i);
            if (decoratorType.isInstance(o)) {
                return o;
            }
            ++i;
        }
        return null;
    }

    protected IStatus getClassStatus(Object selected) {
        JavaModelException t = null;
        String message = new String();
        boolean isInstantiable = true;
        if (selected == null) {
            isInstantiable = false;
            this.setClassName(null, false);
            message = ChooseBeanMessages.getString("SelectionAreaHelper.SecondaryMsg.NoSelectionMade");
        } else {
            try {
                boolean constructorError;
                TypeInfo ti = (TypeInfo)selected;
                boolean isDefaultConstructorSearchRequired = true;
                if (this.resourceSet != null) {
                    ClassDescriptorDecorator decorator;
                    JavaHelpers selectedEMFClass = Utilities.getJavaClass((String)ti.getFullyQualifiedName(), (ResourceSet)this.resourceSet);
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.ve.internal.cde.decorators.ClassDescriptorDecorator");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((decorator = (ClassDescriptorDecorator)ClassDecoratorFeatureAccess.getDecoratorWithKeyedFeature((EClassifier)selectedEMFClass, (Class)clazz, (String)"org.eclipse.ve.internal.prototypefactory")) != null) {
                        isDefaultConstructorSearchRequired = false;
                    }
                }
                IType type = ti.resolveType(this.getJavaSearchScope());
                boolean isTypePublic = Flags.isPublic((int)type.getFlags());
                boolean isTypeAbstract = Flags.isAbstract((int)type.getFlags());
                boolean isInPresentPackage = type.getPackageFragment().getElementName().equals(this.pkg.getElementName());
                boolean isTypeStatic = Flags.isStatic((int)type.getFlags());
                boolean isTypeInner = type.getDeclaringType() != null;
                boolean isPublicNullConstructorPresent = false;
                boolean isAnyConstructorPresent = false;
                if (isDefaultConstructorSearchRequired) {
                    IMethod[] methods = type.getMethods();
                    int m = 0;
                    while (m < methods.length) {
                        if (methods[m].isConstructor() && methods[m].getParameterTypes().length < 1 && Flags.isPublic((int)methods[m].getFlags())) {
                            isPublicNullConstructorPresent = true;
                        }
                        if (methods[m].isConstructor()) {
                            isAnyConstructorPresent = true;
                        }
                        ++m;
                    }
                }
                boolean bl = constructorError = isDefaultConstructorSearchRequired && !isPublicNullConstructorPresent && isAnyConstructorPresent;
                if (constructorError) {
                    if (message.length() > 0) {
                        message = message.concat(" : ");
                    }
                    message = message.concat(ChooseBeanMessages.getString("SelectionAreaHelper.SecondaryMsg.NoPublicNullConstructor"));
                }
                if (!isTypePublic) {
                    if (message.length() > 0) {
                        message = message.concat(" : ");
                    }
                    message = message.concat(ChooseBeanMessages.getString("SelectionAreaHelper.SecondaryMsg.TypeNonPublic"));
                }
                if (isTypeAbstract) {
                    if (message.length() > 0) {
                        message = message.concat(" : ");
                    }
                    message = message.concat(ChooseBeanMessages.getString("ChooseBeanDialog.Message.AbstractType"));
                }
                if (isTypeInner && !isTypeStatic) {
                    if (message.length() > 0) {
                        message = message.concat(" : ");
                    }
                    message = message.concat(ChooseBeanMessages.getString("ChooseBeanDialog.Message.NonStaticType"));
                }
                boolean bl2 = isInstantiable = !constructorError && (isTypePublic || isInPresentPackage) && !isTypeAbstract && (!isTypeInner || isTypeInner && isTypeStatic);
                if (isInstantiable) {
                    message = new String();
                }
                this.setClassName(this.getFullSelectionName(ti), isInstantiable);
            }
            catch (JavaModelException e) {
                t = e;
                isInstantiable = false;
                if (message.length() > 0) {
                    message = message.concat(" : ");
                }
                message = ChooseBeanMessages.getString("SelectionAreaHelper.SecondaryMsg.Unknown_ERROR_");
            }
        }
        Status status = new Status(isInstantiable ? 0 : 4, JavaVEPlugin.getPlugin().getBundle().getSymbolicName(), 0, message, (Throwable)t);
        return status;
    }

    protected String getFullSelectionName(TypeInfo ti) {
        String falseFQN = ti.getFullyQualifiedName();
        String correctResolve = null;
        IType type = null;
        try {
            type = this.project.findType(falseFQN);
        }
        catch (JavaModelException javaModelException) {
            type = null;
        }
        if (type != null) {
            correctResolve = type.getFullyQualifiedName('$');
        }
        if (correctResolve == null) {
            correctResolve = falseFQN;
        }
        return correctResolve;
    }

    protected Text createFilterText(Composite parent) {
        Composite c = new Composite(parent, 0);
        GridData data = new GridData();
        data.heightHint = 0;
        data.widthHint = 0;
        c.setLayoutData((Object)data);
        this.superFilterText = super.createFilterText(c);
        this.filterCombo = new Combo(parent, 4);
        data = new GridData();
        data.grabExcessVerticalSpace = false;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        this.filterCombo.setLayoutData((Object)data);
        this.filterCombo.setText(this.getFilter() == null ? "" : this.getFilter());
        int i = 0;
        while (i < this.selectionHistory.size()) {
            if (this.selectionHistory.get(i) != null) {
                this.filterCombo.add((String)this.selectionHistory.get(i));
            }
            ++i;
        }
        this.filterCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ChooseBeanDialog.this.superFilterText.setText(ChooseBeanDialog.this.filterCombo.getText());
            }
        });
        this.filterCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ChooseBeanDialog.this.handleDefaultSelected();
            }
        });
        return this.superFilterText;
    }

    public void setFilter(String filter) {
        super.setFilter(filter);
        if (this.filterCombo != null) {
            this.filterCombo.setText(filter);
        }
    }

    public void create() {
        super.create();
        if (this.filterCombo != null) {
            this.filterCombo.setFocus();
        }
    }

    protected void handleEmptyList() {
        super.handleEmptyList();
        this.filterCombo.setEnabled(false);
    }

    protected Table createLowerList(Composite parent) {
        Table table = super.createLowerList(parent);
        table.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ChooseBeanDialog.this.updateStatus(ChooseBeanDialog.this.getClassStatus(ChooseBeanDialog.this.getLowerSelectedElement()));
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ChooseBeanDialog.this.updateStatus(ChooseBeanDialog.this.getClassStatus(ChooseBeanDialog.this.getLowerSelectedElement()));
            }
        });
        return table;
    }

    protected void handleSelectionChanged() {
        super.handleSelectionChanged();
        this.updateStatus(this.getClassStatus(this.getLowerSelectedElement()));
    }

    protected void updateOkState() {
        if (this.beanLabelText != null && this.beanLabelText.length() != 0 && !JavaConventions.validateFieldName((String)this.beanLabelText).isOK()) {
            Button okButton = this.getOkButton();
            if (okButton != null) {
                okButton.setEnabled(false);
            }
            return;
        }
        super.updateOkState();
    }

    protected void handleDefaultSelected() {
        if (this.getOkButton().isEnabled()) {
            super.handleDefaultSelected();
        }
    }

    public void setBeanLabelVisability(boolean beanLabelVisability) {
        this.beanLabelVisability = beanLabelVisability;
    }

    public void setClassAreaVisability(boolean classAreaVisability) {
        this.classAreaVisability = classAreaVisability;
    }
}

