/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.choosebean;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.internal.corext.util.TypeInfo;
import org.eclipse.jdt.internal.ui.util.StringMatcher;
import org.eclipse.ui.dialogs.FilteredList;

class TypeFilterMatcher
implements FilteredList.FilterMatcher {
    private List yesFQNs = null;
    private List noFQNs = null;
    private static final char END_SYMBOL = '<';
    private static final char ANY_STRING = '*';
    private StringMatcher fMatcher;
    private StringMatcher fQualifierMatcher;

    public TypeFilterMatcher() {
    }

    public TypeFilterMatcher(List yesFQNs, List noFQNs) {
        this.yesFQNs = yesFQNs;
        this.noFQNs = noFQNs;
        if (this.yesFQNs == null) {
            this.yesFQNs = new ArrayList();
        }
        if (this.noFQNs == null) {
            this.noFQNs = new ArrayList();
        }
    }

    public TypeFilterMatcher(List yesFQNs, List noFQNs, String initialTypeName) {
        this(yesFQNs, noFQNs);
        this.setFilter(initialTypeName, true, false);
    }

    public void setFilter(String pattern, boolean ignoreCase, boolean igoreWildCards) {
        int qualifierIndex = pattern.lastIndexOf(".");
        if (qualifierIndex == -1) {
            this.fQualifierMatcher = null;
            this.fMatcher = new StringMatcher(this.adjustPattern(pattern), ignoreCase, igoreWildCards);
        } else {
            this.fQualifierMatcher = new StringMatcher(pattern.substring(0, qualifierIndex), ignoreCase, igoreWildCards);
            this.fMatcher = new StringMatcher(this.adjustPattern(pattern.substring(qualifierIndex + 1)), ignoreCase, igoreWildCards);
        }
    }

    public boolean match(Object element) {
        if (!(element instanceof TypeInfo)) {
            return false;
        }
        TypeInfo type = (TypeInfo)element;
        if (!this.fMatcher.match(type.getTypeName())) {
            return false;
        }
        if (this.fQualifierMatcher == null) {
            if (this.yesFQNs == null || this.noFQNs == null) {
                return true;
            }
            if (this.noFQNs.contains(type.getFullyQualifiedName())) {
                return false;
            }
            return this.yesFQNs.contains(type.getFullyQualifiedName());
        }
        if (this.yesFQNs == null || this.noFQNs == null) {
            return this.fQualifierMatcher.match(type.getTypeContainerName());
        }
        return this.fQualifierMatcher.match(type.getTypeContainerName()) && !this.noFQNs.contains(type.getFullyQualifiedName()) && this.yesFQNs.contains(type.getFullyQualifiedName());
    }

    private String adjustPattern(String pattern) {
        int length = pattern.length();
        if (length > 0) {
            switch (pattern.charAt(length - 1)) {
                case '<': {
                    pattern = pattern.substring(0, length - 1);
                    break;
                }
                case '*': {
                    break;
                }
                default: {
                    pattern = String.valueOf(pattern) + '*';
                }
            }
        }
        return pattern;
    }
}

