/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.core;

import java.util.logging.Level;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jem.internal.proxy.core.IArrayBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanTypeProxy;
import org.eclipse.jem.internal.proxy.core.IStringBeanProxy;
import org.eclipse.jem.internal.proxy.core.ProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.core.ThrowableProxy;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.java.core.BeanProxyUtilities;
import org.eclipse.ve.internal.java.core.JavaEditDomainHelper;
import org.eclipse.ve.internal.java.core.JavaMessages;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;
import org.eclipse.ve.internal.propertysheet.INeedData;

public class EnumeratedLabelProvider
extends LabelProvider
implements INeedData {
    protected String[] fDisplayNames;
    protected String[] fInitStrings;
    protected JavaHelpers fFeatureType;
    protected EditDomain editDomain;

    protected IBeanProxy[] getEnumeratedValues() {
        ProxyFactoryRegistry registry = JavaEditDomainHelper.getBeanProxyDomain(this.editDomain).getProxyFactoryRegistry();
        IBeanProxy[] enumeratedValues = (IBeanProxy[])registry.getConstants((Object)this);
        if (enumeratedValues == null) {
            block6: {
                IBeanTypeProxy aBeanTypeProxy = registry.getBeanTypeProxyFactory().getBeanTypeProxy(this.fFeatureType.getQualifiedNameForReflection());
                enumeratedValues = new IBeanProxy[this.fInitStrings.length];
                int index = 0;
                try {
                    int i = 0;
                    while (i < this.fInitStrings.length) {
                        index = i;
                        enumeratedValues[i] = aBeanTypeProxy.newInstance(this.fInitStrings[i]);
                        ++i;
                    }
                }
                catch (ThrowableProxy exc) {
                    if (JavaVEPlugin.isLoggingLevel(Level.WARNING)) {
                        JavaVEPlugin.log("Unable to create enumeration value for " + this.fInitStrings[index], Level.WARNING);
                        JavaVEPlugin.log(exc, Level.WARNING);
                    }
                }
                catch (InstantiationException exc) {
                    if (!JavaVEPlugin.isLoggingLevel(Level.WARNING)) break block6;
                    JavaVEPlugin.log("Unable to create enumeration value for " + this.fInitStrings[index], Level.WARNING);
                    JavaVEPlugin.log(exc, Level.WARNING);
                }
            }
            registry.registerConstants((Object)this, (Object)enumeratedValues);
        }
        return enumeratedValues;
    }

    public EnumeratedLabelProvider(IArrayBeanProxy aBeanInfoValuesArray, JavaHelpers aFeatureType) {
        this.fFeatureType = aFeatureType;
        int length = aBeanInfoValuesArray.getLength();
        int j = 0;
        this.fDisplayNames = new String[length / 3];
        this.fInitStrings = new String[length / 3];
        try {
            int i = 0;
            while (i < length) {
                this.fDisplayNames[j] = ((IStringBeanProxy)aBeanInfoValuesArray.get(i)).stringValue();
                this.fInitStrings[j] = ((IStringBeanProxy)aBeanInfoValuesArray.get(i + 2)).stringValue();
                ++j;
                i += 3;
            }
        }
        catch (ThrowableProxy exc) {
            JavaVEPlugin.log("Unable to determine enumeration values", Level.WARNING);
            JavaVEPlugin.log(exc, Level.WARNING);
        }
    }

    public String getText(Object aJavaInstance) {
        IBeanProxy[] enumeratedValues = this.getEnumeratedValues();
        if (enumeratedValues == null) {
            return JavaMessages.getString("LabelProvider.Enumerated.getText_ERROR_");
        }
        IBeanProxy valueProxy = BeanProxyUtilities.getBeanProxy((IJavaInstance)aJavaInstance, JavaEditDomainHelper.getResourceSet((EditDomain)this.editDomain));
        int i = 0;
        while (i < enumeratedValues.length) {
            if (enumeratedValues[i] == null ? valueProxy == null : enumeratedValues[i].equals((Object)valueProxy)) {
                return this.fDisplayNames[i];
            }
            ++i;
        }
        return JavaMessages.getString("LabelProvider.Enumerated.getText_ERROR_");
    }

    public void setData(Object data) {
        this.editDomain = (EditDomain)data;
    }
}

