/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.core;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jem.internal.beaninfo.PropertyDecorator;
import org.eclipse.jem.internal.beaninfo.core.Utilities;
import org.eclipse.jem.internal.proxy.core.ThrowableProxy;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ve.internal.cde.core.CDEPlugin;
import org.eclipse.ve.internal.java.core.JavaMessages;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;

public interface IErrorHolder {
    public static final int ERROR_SEVERE = 3;
    public static final int ERROR_WARNING = 2;
    public static final int ERROR_INFO = 1;
    public static final int ERROR_NONE = 0;
    public static final Class ERROR_HOLDER_TYPE;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.eclipse.ve.internal.java.core.IErrorHolder");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        ERROR_HOLDER_TYPE = clazz;
    }

    public int getErrorStatus();

    public List getErrors();

    public static class ErrorType {
        protected String message;
        protected int severity;
        protected static Image fInformationErrorImage;
        protected static Image fInformationErrorImageOverlay;
        protected static Image fWarningErrorImage;
        protected static Image fWarningErrorImageOverlay;
        protected static Image fSevereErrorImage;
        protected static Image fSevereErrorImageOverlay;

        public ErrorType(String message, int severity) {
            this.message = message;
            this.severity = severity;
        }

        public String getMessage() {
            return this.message;
        }

        public int getSeverity() {
            return this.severity;
        }

        public Image getImage() {
            switch (this.severity) {
                case 3: {
                    return ErrorType.getSevereErrorImage();
                }
                case 2: {
                    return ErrorType.getWarningErrorImage();
                }
                case 1: {
                    return ErrorType.getInformationErrorImage();
                }
            }
            return null;
        }

        public static Image getSevereErrorImage() {
            if (fSevereErrorImage == null) {
                fSevereErrorImage = CDEPlugin.getImageFromPlugin((Plugin)JavaVEPlugin.getPlugin(), (String)"icons/full/cview16/error_obj.gif");
            }
            return fSevereErrorImage;
        }

        public static Image getWarningErrorImage() {
            if (fWarningErrorImage == null) {
                fWarningErrorImage = CDEPlugin.getImageFromPlugin((Plugin)JavaVEPlugin.getPlugin(), (String)"icons/full/cview16/warning_obj.gif");
            }
            return fWarningErrorImage;
        }

        public static Image getSevereErrorImageOverlay() {
            if (fSevereErrorImageOverlay == null) {
                fSevereErrorImageOverlay = CDEPlugin.getImageFromPlugin((Plugin)JavaVEPlugin.getPlugin(), (String)"icons/full/cview16/error_overlay.gif");
            }
            return fSevereErrorImageOverlay;
        }

        public static Image getWarningErrorImageOverlay() {
            if (fWarningErrorImageOverlay == null) {
                fWarningErrorImageOverlay = CDEPlugin.getImageFromPlugin((Plugin)JavaVEPlugin.getPlugin(), (String)"icons/full/cview16/warning_overlay.gif");
            }
            return fWarningErrorImageOverlay;
        }

        public static Image getInformationErrorImageOverlay() {
            if (fInformationErrorImageOverlay == null) {
                fInformationErrorImageOverlay = CDEPlugin.getImageFromPlugin((Plugin)JavaVEPlugin.getPlugin(), (String)"icons/full/cview16/info_overlay.gif");
            }
            return fInformationErrorImageOverlay;
        }

        public static Image getInformationErrorImage() {
            if (fInformationErrorImage == null) {
                fInformationErrorImage = CDEPlugin.getImageFromPlugin((Plugin)JavaVEPlugin.getPlugin(), (String)"icons/full/cview16/info_obj.gif");
            }
            return fInformationErrorImage;
        }
    }

    public static class ExceptionError
    extends ErrorType {
        public Throwable error;

        public ExceptionError(Throwable error, int severity) {
            super(null, severity);
            this.error = error;
        }

        public String getMessage() {
            if (this.error instanceof ThrowableProxy) {
                return MessageFormat.format(JavaMessages.getString("BeanProxyException.msg"), ((ThrowableProxy)this.error).getTypeProxy().getTypeName(), ((ThrowableProxy)this.error).getProxyLocalizedMessage());
            }
            return MessageFormat.format(JavaMessages.getString("BeanProxyException.msg"), this.error.getClass().getName(), this.error.getLocalizedMessage());
        }
    }

    public static class MultiPropertyError
    extends PropertyError {
        protected Object fObjectInError;

        public MultiPropertyError(Object errObject, Throwable error, EStructuralFeature sf) {
            this(errObject, error, 2, sf);
        }

        public MultiPropertyError(Object errObject, Throwable error, int severity, EStructuralFeature sf) {
            super(error, severity, sf);
            this.fObjectInError = errObject;
        }

        public Object getErrorObject() {
            return this.fObjectInError;
        }
    }

    public static class PropertyError
    extends ExceptionError {
        protected EStructuralFeature fStructuralFeature;

        public PropertyError(Throwable error, EStructuralFeature sf) {
            this(error, 2, sf);
        }

        public PropertyError(Throwable error, int severity, EStructuralFeature sf) {
            super(error, severity);
            this.fStructuralFeature = sf;
        }

        public String getMessage() {
            PropertyDecorator propertyDecorator = Utilities.getPropertyDecorator((EModelElement)this.fStructuralFeature);
            if (propertyDecorator != null) {
                return String.valueOf(propertyDecorator.getDisplayName()) + " : " + super.getMessage();
            }
            return String.valueOf(this.fStructuralFeature.getName()) + " : " + super.getMessage();
        }

        public EStructuralFeature getFeature() {
            return this.fStructuralFeature;
        }
    }
}

