/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.core;

import com.ibm.wtp.common.logger.proxy.Logger;
import com.ibm.wtp.logger.proxyrender.EclipseLogger;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jem.internal.proxy.core.ProxyPlugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ve.internal.cde.core.CDEPlugin;
import org.eclipse.ve.internal.java.vce.VCEPreferences;
import org.osgi.framework.BundleContext;

public class JavaVEPlugin
extends AbstractUIPlugin {
    public static final String PI_JBCF_REGISTRATIONS = "registrations";
    public static final String PI_CONTRIBUTION_EXTENSION_POINT = "org.eclipse.ve.java.core.contributors";
    public static final String PI_DESCRIPTION = "description";
    public static final String PI_LIBRARY = "library";
    public static final String PI_CONTAINER = "container";
    public static final String PI_PATH = "path";
    public static final String PI_CONTRIBUTOR = "contributor";
    public static final String PI_PALETTECATS = "palettecats";
    public static final String PI_RUNTIME = "runtime";
    public static final String PI_SOURCE = "source";
    public static final String PI_SOURCEPREFIX = "prefix";
    private static JavaVEPlugin PLUGIN;
    private static Logger logger;
    public static Image fJavaBeanImage;
    public static Image fAppletImage;
    public static Image CHECK_IMAGE;
    private static ImageDescriptor WIZARD_TITLE_DESC;
    public static final String SHOW_EVENTS = "SHOW_EVENTS";
    public static final int EVENTS_NONE = 0;
    public static final int EVENTS_BASIC = 1;
    public static final int EVENTS_EXPERT = 2;
    private Runnable javaVMControllerDisposer;
    protected Map containerToContributions = null;
    protected Map pluginToContributions = null;

    static {
        logger = null;
    }

    public JavaVEPlugin() {
        PLUGIN = this;
    }

    public static JavaVEPlugin getPlugin() {
        return PLUGIN;
    }

    public Logger getLogger() {
        if (logger == null) {
            logger = EclipseLogger.getEclipseLogger((Plugin)this);
        }
        return logger;
    }

    public static boolean isLoggingLevel(Level level) {
        return JavaVEPlugin.getPlugin().getLogger().isLoggingLevel(level);
    }

    public static void log(Object obj) {
        JavaVEPlugin.getPlugin().getLogger().log(obj);
    }

    public static void log(Object obj, Level level) {
        JavaVEPlugin.getPlugin().getLogger().log(obj, level);
    }

    public static void log(Throwable e) {
        JavaVEPlugin.getPlugin().getLogger().log(e);
    }

    public static void log(Throwable e, Level level) {
        JavaVEPlugin.getPlugin().getLogger().log(e, level);
    }

    public static void log(IStatus status) {
        JavaVEPlugin.getPlugin().getLogger().log((Object)status);
    }

    public static void log(IStatus status, Level logLevel) {
        JavaVEPlugin.getPlugin().getLogger().log((Object)status, logLevel);
    }

    public static Image getJavaBeanImage() {
        if (fJavaBeanImage == null) {
            fJavaBeanImage = CDEPlugin.getImageFromPlugin((Plugin)JavaVEPlugin.getPlugin(), (String)"icons/full/cview16/javabean.gif");
        }
        return fJavaBeanImage;
    }

    public static Image getAppletImage() {
        if (fAppletImage == null) {
            fAppletImage = CDEPlugin.getImageFromPlugin((Plugin)JavaVEPlugin.getPlugin(), (String)"icons/full/cview16/applet.gif");
        }
        return fAppletImage;
    }

    public static ImageDescriptor getWizardTitleImageDescriptor() {
        if (WIZARD_TITLE_DESC == null) {
            WIZARD_TITLE_DESC = CDEPlugin.getImageDescriptorFromPlugin((Plugin)JavaVEPlugin.getPlugin(), (String)"icons/full/wizban/javabean_wiz.gif");
        }
        return WIZARD_TITLE_DESC;
    }

    public static Image getCheckImage() {
        if (CHECK_IMAGE == null) {
            CHECK_IMAGE = CDEPlugin.getImageFromPlugin((Plugin)JavaVEPlugin.getPlugin(), (String)"icons/booleantrue.gif");
        }
        return CHECK_IMAGE;
    }

    public void start(BundleContext bc) throws Exception {
        super.start(bc);
        this.getPluginPreferences().setDefault(SHOW_EVENTS, 1);
        VCEPreferences.initializeDefaultPluginPreferences(this.getPluginPreferences());
    }

    public void setJavaVMControllerDisposer(Runnable disposer) {
        this.javaVMControllerDisposer = disposer;
    }

    public void stop(BundleContext context) throws Exception {
        if (this.javaVMControllerDisposer != null) {
            this.javaVMControllerDisposer.run();
            this.javaVMControllerDisposer = null;
        }
        super.stop(context);
    }

    public synchronized IConfigurationElement[] getContainerConfigurations(String containerid) {
        if (this.containerToContributions == null) {
            this.processProxyContributionExtensionPoint();
        }
        return (IConfigurationElement[])this.containerToContributions.get(containerid);
    }

    public synchronized IConfigurationElement[] getPluginConfigurations(String pluginid) {
        if (this.pluginToContributions == null) {
            this.processProxyContributionExtensionPoint();
        }
        return (IConfigurationElement[])this.pluginToContributions.get(pluginid);
    }

    protected synchronized void processProxyContributionExtensionPoint() {
        ProxyPlugin.ContributorExtensionPointInfo info = ProxyPlugin.processContributionExtensionPoint((String)PI_CONTRIBUTION_EXTENSION_POINT);
        this.containerToContributions = info.containerToContributions;
        this.pluginToContributions = info.pluginToContributions;
    }
}

