/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.core;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jem.internal.instantiation.JavaAllocation;
import org.eclipse.jem.internal.instantiation.base.IJavaDataTypeInstance;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanTypeProxy;
import org.eclipse.jem.internal.proxy.core.ThrowableProxy;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.ve.internal.java.core.IAllocationProcesser;
import org.eclipse.ve.internal.java.core.IBeanProxyDomain;
import org.eclipse.ve.internal.java.core.IBeanProxyHost;
import org.eclipse.ve.internal.java.core.IErrorHolder;
import org.eclipse.ve.internal.java.core.IErrorNotifier;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;

public class PrimitiveProxyAdapter
extends AdapterImpl
implements IBeanProxyHost {
    private IBeanProxy beanProxy;
    private boolean ownsProxy;
    protected IBeanProxyDomain domain;
    protected Throwable instantiationError;
    protected ListenerList errorListeners;

    public PrimitiveProxyAdapter(IBeanProxyDomain domain) {
        this.domain = domain;
    }

    public void releaseBeanProxy() {
        if (this.ownsProxy && this.getBeanProxy() != null && this.getBeanProxy().isValid()) {
            this.getBeanProxy().getProxyFactoryRegistry().releaseProxy(this.getBeanProxy());
        }
        this.beanProxy = null;
    }

    public void reinstantiateChild(IBeanProxyHost aChildHost) {
    }

    public IJavaInstance getBeanPropertyValue(EStructuralFeature aBeanPropertyFeature) {
        return null;
    }

    public IBeanProxy getBeanProxy() {
        return this.beanProxy;
    }

    public Map getOriginalSettingsTable() {
        return Collections.EMPTY_MAP;
    }

    public IBeanProxy instantiateBeanProxy() {
        block6: {
            if (this.beanProxy == null) {
                IJavaDataTypeInstance jTarget = (IJavaDataTypeInstance)this.target;
                if (jTarget.isSetAllocation()) {
                    JavaAllocation allocation = jTarget.getAllocation();
                    this.ownsProxy = true;
                    try {
                        this.beanProxy = this.getBeanProxyDomain().getAllocationProcesser().allocate(allocation);
                    }
                    catch (IAllocationProcesser.AllocationException e) {
                        this.processInstantiationError(e);
                    }
                    return this.beanProxy;
                }
                String qualifiedClassName = jTarget.getJavaType().getQualifiedNameForReflection();
                IBeanTypeProxy targetClass = this.domain.getProxyFactoryRegistry().getBeanTypeProxyFactory().getBeanTypeProxy(qualifiedClassName);
                try {
                    this.beanProxy = targetClass.newInstance();
                    this.ownsProxy = true;
                }
                catch (ThrowableProxy exc) {
                    this.processInstantiationError(exc);
                    if (!JavaVEPlugin.isLoggingLevel(Level.WARNING)) break block6;
                    JavaVEPlugin.log("Could not instantiate " + qualifiedClassName, Level.WARNING);
                    JavaVEPlugin.log(exc, Level.WARNING);
                }
            }
        }
        return this.beanProxy;
    }

    protected void processInstantiationError(Throwable exc) {
        this.instantiationError = exc;
        this.fireSeverityError(3);
    }

    protected void fireSeverityError(int severity) {
        if (this.errorListeners != null) {
            Object[] listeners = this.errorListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ((IErrorNotifier.ErrorListener)listeners[i]).errorStatusChanged();
                ++i;
            }
        }
    }

    public IBeanProxy instantiateBeanProxy(IBeanProxy proxy) {
        this.ownsProxy = false;
        this.beanProxy = proxy;
        return this.beanProxy;
    }

    public boolean isBeanProxyInstantiated() {
        return this.beanProxy != null;
    }

    public void revalidateBeanProxy() {
    }

    public void setBeanProxy(IBeanProxy beanProxy) {
        this.beanProxy = beanProxy;
        this.ownsProxy = false;
    }

    public void setOwnsProxy(boolean ownsProxy) {
        this.ownsProxy = ownsProxy;
    }

    public IBeanProxyDomain getBeanProxyDomain() {
        return this.domain;
    }

    public boolean isAdapterForType(Object type) {
        return IBeanProxyHost.BEAN_PROXY_TYPE == type || IErrorNotifier.ERROR_NOTIFIER_TYPE == type || IErrorHolder.ERROR_HOLDER_TYPE == type;
    }

    public int getErrorStatus() {
        if (this.instantiationError != null) {
            return 3;
        }
        return 0;
    }

    public List getErrors() {
        if (this.instantiationError != null) {
            return Collections.singletonList(new IErrorHolder.ExceptionError(this.instantiationError, 3));
        }
        return Collections.EMPTY_LIST;
    }

    public void addErrorListener(IErrorNotifier.ErrorListener aListener) {
        if (this.errorListeners == null) {
            this.errorListeners = new ListenerList(2);
        }
        this.errorListeners.add((Object)aListener);
    }

    public void removeErrorListener(IErrorNotifier.ErrorListener aListener) {
        if (this.errorListeners != null) {
            this.errorListeners.remove((Object)aListener);
        }
    }

    public void invalidateBeanProxy() {
    }

    public void validateBeanProxy() {
    }

    public IBeanProxy getBeanPropertyProxyValue(EStructuralFeature aBeanPropertyFeature) {
        return null;
    }

    public void applyBeanPropertyProxyValue(EStructuralFeature aBeanPropertyFeature, IBeanProxy aproxy) {
    }
}

