/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.core;

import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ve.internal.java.core.NumberTextVerifier;

public class Spinner
extends Composite {
    static final int BUTTON_WIDTH = 16;
    protected Text text;
    protected Button up;
    protected Button down;
    protected NumberTextVerifier verifier = new NumberTextVerifier();
    protected int minimum;
    protected int maximum;
    protected int fValue = 0;
    private boolean commandInProcess = false;
    private boolean settingText = false;
    private boolean selectAll = true;

    public Spinner(Composite parent, int style, int initialValue) {
        super(parent, style);
        this.text = new Text((Composite)this, style | 4 | 0x800);
        this.up = new Button((Composite)this, style | 4 | 0x80);
        this.down = new Button((Composite)this, style | 4 | 0x400);
        this.text.addVerifyListener((VerifyListener)this.verifier);
        this.text.addModifyListener(new ModifyListener(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void modifyText(ModifyEvent e) {
                Spinner.this.settingText = true;
                try {
                    Spinner.this.setValue(Spinner.this.verifier.getNewValue());
                }
                catch (Throwable throwable) {
                    Object var2_3 = null;
                    Spinner.this.settingText = false;
                    throw throwable;
                }
                {
                    Object var2_4 = null;
                }
                Spinner.this.settingText = false;
            }
        });
        this.text.addListener(31, new Listener(){

            public void handleEvent(Event e) {
                Spinner.this.traverse(e);
            }
        });
        this.text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                Spinner.this.text.selectAll();
            }
        });
        this.text.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                Spinner.this.text.selectAll();
            }
        });
        this.up.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                Spinner.this.forceTextFocus();
                Spinner.this.up();
            }
        });
        this.down.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                Spinner.this.forceTextFocus();
                Spinner.this.down();
            }
        });
        this.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                Spinner.this.resize();
            }
        });
        this.setMinimum(0);
        this.setMaximum(999);
        this.text.setFont(this.getFont());
        this.fValue = initialValue;
        this.setTextField();
    }

    void forceTextFocus() {
        if (!this.text.isFocusControl()) {
            this.text.forceFocus();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void traverse(Event e) {
        switch (e.detail) {
            case 32: {
                if (e.keyCode != 0x1000001) return;
                e.doit = true;
                e.detail = 0;
                this.selectAll = false;
                try {
                    this.up();
                }
                catch (Throwable throwable) {
                    Object var2_4 = null;
                    this.selectAll = true;
                    throw throwable;
                }
            }
            {
                Object var2_5 = null;
                this.selectAll = true;
                return;
            }
            case 64: {
                if (e.keyCode != 0x1000002) return;
                e.doit = true;
                e.detail = 0;
                this.selectAll = false;
                try {
                    this.down();
                    break;
                }
                catch (Throwable throwable) {
                    Object var2_6 = null;
                    this.selectAll = true;
                    throw throwable;
                }
            }
            default: {
                return;
            }
        }
        {
            Object var2_7 = null;
            this.selectAll = true;
            return;
        }
    }

    void up() {
        this.setValue(this.getValue() + 1);
    }

    void down() {
        this.setValue(this.getValue() - 1);
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.text.setFont(font);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setValue(int value) {
        block9: {
            block8: {
                if (this.commandInProcess) {
                    return;
                }
                this.commandInProcess = true;
                try {
                    try {
                        Integer.parseInt(String.valueOf(value));
                        if (value < this.minimum || value > this.maximum) {
                            this.setTextField();
                            Object var2_2 = null;
                            this.commandInProcess = false;
                            return;
                        }
                        if (this.fValue == value) {
                            break block8;
                        }
                        this.fValue = value;
                        this.setTextField();
                        this.notifyListeners(24, new Event());
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.setTextField();
                    }
                    break block9;
                }
                catch (Throwable throwable) {
                    Object var2_4 = null;
                    this.commandInProcess = false;
                    throw throwable;
                }
            }
            Object var2_3 = null;
            this.commandInProcess = false;
            return;
        }
        Object var2_5 = null;
        this.commandInProcess = false;
    }

    public int getValue() {
        return this.fValue;
    }

    protected void setTextField() {
        if (!this.settingText) {
            this.settingText = true;
            String valueString = String.valueOf(this.fValue);
            this.text.setText(valueString);
            if (this.selectAll) {
                this.text.selectAll();
            } else {
                this.text.setSelection(valueString.length() + 1);
            }
            this.settingText = false;
        }
    }

    public void setMaximum(int maximum) {
        this.checkWidget();
        this.maximum = maximum;
        this.verifier.setMax(maximum);
        this.resize();
    }

    public int getMaximum() {
        return this.maximum;
    }

    public void setMinimum(int minimum) {
        this.minimum = minimum;
        this.verifier.setMin(minimum);
    }

    public int getMinimum() {
        return this.minimum;
    }

    void resize() {
        Point pt = this.computeSize(-1, -1);
        int textWidth = pt.x - 16;
        int buttonHeight = pt.y / 2;
        this.text.setBounds(0, 0, textWidth, pt.y);
        this.up.setBounds(textWidth, 0, 16, buttonHeight);
        this.down.setBounds(textWidth, pt.y - buttonHeight, 16, buttonHeight);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        GC gc = new GC((Drawable)this.text);
        Point textExtent = gc.textExtent(String.valueOf(this.maximum));
        gc.dispose();
        Point pt = this.text.computeSize(textExtent.x, textExtent.y);
        int width = pt.x + 16;
        int height = pt.y;
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        return new Point(width, height);
    }

    public void addModifyListener(Listener listener) {
        if (listener != null) {
            this.addListener(24, listener);
        }
    }

    public void setEnabled(boolean enabled) {
        if (this.text != null && this.text.getEnabled() != enabled) {
            this.text.setEnabled(enabled);
        }
        if (this.up != null && this.up.getEnabled() != enabled) {
            this.up.setEnabled(enabled);
        }
        if (this.down != null && this.down.getEnabled() != enabled) {
            this.down.setEnabled(enabled);
        }
    }
}

