/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.rules;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.java.rules.IPropertyRule;
import org.eclipse.ve.internal.propertysheet.common.commands.AbstractCommand;

public class RuledPropertySetCommand
extends AbstractCommand {
    protected EditDomain domain;
    protected Object propertyValue;
    protected Object propertyId;
    protected Object undoValue;
    protected boolean originallyNotSet;
    protected IPropertySource target;
    protected Command presetCmd;
    protected Command postsetCmd;

    public RuledPropertySetCommand(EditDomain domain, IPropertySource target, Object propertyId, Object propertyValue) {
        this(null, domain, target, propertyId, propertyValue);
    }

    public RuledPropertySetCommand(String label, EditDomain domain, IPropertySource target, Object propertyId, Object propertyValue) {
        super(label);
        this.domain = domain;
        this.target = target;
        this.propertyId = propertyId;
        this.propertyValue = propertyValue;
    }

    public boolean prepare() {
        boolean bl = this.originallyNotSet = !this.target.isPropertySet(this.propertyId);
        if (!this.originallyNotSet) {
            this.undoValue = this.target.getPropertyValue(this.propertyId);
            if (this.undoValue instanceof IPropertySource) {
                this.undoValue = ((IPropertySource)this.undoValue).getEditableValue();
            }
        } else {
            this.undoValue = null;
        }
        if (this.target.getEditableValue() instanceof EObject) {
            if ((this.propertyValue == null || this.propertyValue instanceof EObject) && (this.originallyNotSet || this.undoValue != this.propertyValue)) {
                this.presetCmd = ((IPropertyRule)this.domain.getRuleRegistry().getRule(IPropertyRule.RULE_ID)).preSet(this.domain, (EObject)this.target.getEditableValue(), (EObject)this.propertyValue, null);
            }
            if (!this.originallyNotSet && this.undoValue instanceof EObject && this.undoValue != this.propertyValue) {
                this.postsetCmd = ((IPropertyRule)this.domain.getRuleRegistry().getRule(IPropertyRule.RULE_ID)).postSet(this.domain, (EObject)this.undoValue);
            }
        }
        return !(this.presetCmd != null && !this.presetCmd.canExecute() || this.postsetCmd != null && !this.postsetCmd.canExecute());
    }

    public void execute() {
        if (this.presetCmd != null) {
            this.presetCmd.execute();
        }
        this.target.setPropertyValue(this.propertyId, this.propertyValue);
        if (this.postsetCmd != null) {
            this.postsetCmd.execute();
        }
    }

    public void redo() {
        if (this.presetCmd != null) {
            this.presetCmd.redo();
        }
        this.target.setPropertyValue(this.propertyId, this.propertyValue);
        if (this.postsetCmd != null) {
            this.postsetCmd.redo();
        }
    }

    public void undo() {
        if (this.postsetCmd != null) {
            this.postsetCmd.undo();
        }
        if (this.originallyNotSet) {
            this.target.resetPropertyValue(this.propertyId);
        } else {
            this.target.setPropertyValue(this.propertyId, this.undoValue);
        }
        if (this.presetCmd != null) {
            this.presetCmd.undo();
        }
    }
}

