/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.rules;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.java.rules.IPropertyRule;
import org.eclipse.ve.internal.propertysheet.common.commands.AbstractCommand;

public class RuledRestoreDefaultPropertyCommand
extends AbstractCommand {
    protected EditDomain domain;
    protected Object propertyId;
    protected Object undoValue;
    protected boolean originallySet;
    protected IPropertySource target;
    protected Command postSetCmd;

    public RuledRestoreDefaultPropertyCommand(EditDomain domain, IPropertySource target, Object propertyId) {
        this(null, domain, target, propertyId);
    }

    public RuledRestoreDefaultPropertyCommand(String label, EditDomain domain, IPropertySource target, Object propertyId) {
        super(label);
        this.domain = domain;
        this.target = target;
        this.propertyId = propertyId;
    }

    public boolean prepare() {
        return true;
    }

    public void execute() {
        this.originallySet = this.target.isPropertySet(this.propertyId);
        if (this.originallySet) {
            this.undoValue = this.target.getPropertyValue(this.propertyId);
            if (this.undoValue instanceof IPropertySource) {
                this.undoValue = ((IPropertySource)this.undoValue).getEditableValue();
            }
            this.target.resetPropertyValue(this.propertyId);
            if (this.target.getEditableValue() instanceof EObject && this.undoValue instanceof EObject) {
                this.postSetCmd = ((IPropertyRule)this.domain.getRuleRegistry().getRule(IPropertyRule.RULE_ID)).postSet(this.domain, (EObject)this.undoValue);
                this.postSetCmd.execute();
            }
        } else {
            this.undoValue = null;
        }
    }

    public void redo() {
        this.target.resetPropertyValue(this.propertyId);
        if (this.postSetCmd != null) {
            this.postSetCmd.redo();
        }
    }

    public void undo() {
        if (this.originallySet) {
            if (this.postSetCmd != null) {
                this.postSetCmd.undo();
            }
            this.target.setPropertyValue(this.propertyId, this.undoValue);
        } else {
            this.target.resetPropertyValue(this.propertyId);
        }
    }
}

