/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.vce.launcher;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.search.IJavaSearchResultCollector;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.Assert;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;

public class JavaBeanSearchEngine {
    public static boolean typeIsABean(IType type) {
        boolean anyCtors = false;
        try {
            if (!type.isClass()) {
                return false;
            }
            IMethod[] methods = type.getMethods();
            int i = 0;
            while (i < methods.length) {
                IMethod method = methods[i];
                if (method.isConstructor()) {
                    String p1Type;
                    String[] parmTypes;
                    String parmType;
                    anyCtors = true;
                    if (method.getNumberOfParameters() == 0) {
                        return true;
                    }
                    if (method.getNumberOfParameters() == 1 ? ("Composite".equals(parmType = Signature.toString((String)method.getParameterTypes()[0])) || "org.eclipse.swt.widgets.Composite".equals(parmType)) && JavaBeanSearchEngine.inheritsFrom(type, "org.eclipse.swt.widgets", "Control") : method.getNumberOfParameters() == 2 && "int".equals(Signature.toString((String)(parmTypes = method.getParameterTypes())[1])) && ("Composite".equals(p1Type = Signature.toString((String)parmTypes[0])) || "org.eclipse.swt.widgets.Composite".equals(p1Type)) && JavaBeanSearchEngine.inheritsFrom(type, "org.eclipse.swt.widgets", "Control")) {
                        return true;
                    }
                } else if (method.isMainMethod()) {
                    return true;
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            JavaVEPlugin.log(e.getStatus(), Level.FINE);
            return false;
        }
        return !anyCtors;
    }

    private static boolean inheritsFrom(IType type, String superClassPkg, String superClassName) throws JavaModelException {
        String superName = null;
        String fullSuper = String.valueOf(superClassPkg) + '.' + superClassName;
        while (type != null && (superName = type.getSuperclassName()) != null) {
            if (fullSuper.equals(superName)) {
                return true;
            }
            IType stype = type.getJavaProject().findType(superName);
            if (stype == null) {
                String[][] superTypes = type.resolveType(superName);
                if (superTypes == null || superTypes.length > 1) {
                    return false;
                }
                if (superClassPkg.equals(superTypes[0][0]) && superClassName.equals(superTypes[0][1])) {
                    return true;
                }
                type = type.getJavaProject().findType(superTypes[0][0], superTypes[0][1]);
                continue;
            }
            if (stype.getFullyQualifiedName().equals(fullSuper)) {
                return true;
            }
            type = stype;
        }
        return false;
    }

    public IType[] searchJavaBeans(IProgressMonitor pm, IJavaElement elem, int style) throws JavaModelException {
        IJavaSearchScope scope;
        ArrayList typesFound = new ArrayList(200);
        ArrayList binaryRoots = new ArrayList(0);
        ArrayList sourceRoots = new ArrayList(0);
        boolean binaries = (style & 8) != 0;
        boolean externals = (style & 0x10) != 0;
        JavaBeanCollector collector = new JavaBeanCollector(typesFound, style, pm);
        if (elem != null) {
            if (elem instanceof IJavaProject || elem instanceof IPackageFragmentRoot) {
                this.gatherRoots(elem, binaryRoots, sourceRoots, binaries, externals);
            } else {
                scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{elem}, (boolean)false);
                new SearchEngine().search(ResourcesPlugin.getWorkspace(), "*", 0, 0, scope, (IJavaSearchResultCollector)collector);
            }
        } else {
            IJavaModel model = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
            IJavaProject[] projects = model.getJavaProjects();
            int i = 0;
            while (i < projects.length) {
                this.gatherRoots((IJavaElement)projects[i], binaryRoots, sourceRoots, binaries, externals);
                ++i;
            }
        }
        if (!sourceRoots.isEmpty()) {
            scope = SearchEngine.createJavaSearchScope((IJavaElement[])sourceRoots.toArray(new IJavaElement[sourceRoots.size()]), (boolean)false);
            new SearchEngine().search(ResourcesPlugin.getWorkspace(), "*", 0, 0, scope, (IJavaSearchResultCollector)collector);
        }
        if (!binaryRoots.isEmpty()) {
            scope = SearchEngine.createJavaSearchScope((IJavaElement[])binaryRoots.toArray(new IJavaElement[binaryRoots.size()]), (boolean)false);
            new SearchEngine().search(ResourcesPlugin.getWorkspace(), "*()", 3, 0, scope, (IJavaSearchResultCollector)collector);
        }
        return typesFound.toArray(new IType[typesFound.size()]);
    }

    protected void gatherRoots(IJavaElement elem, List binaryRoots, List sourceRoots, boolean binaries, boolean externals) throws JavaModelException {
        if (elem instanceof IJavaProject) {
            IPackageFragmentRoot[] roots = ((IJavaProject)elem).getPackageFragmentRoots();
            int i = 0;
            while (i < roots.length) {
                IPackageFragmentRoot root = roots[i];
                if (root.isArchive()) {
                    if (binaries) {
                        if (root.isExternal()) {
                            if (externals && !binaryRoots.contains(root)) {
                                binaryRoots.add(root);
                            }
                        } else if (!binaryRoots.contains(root)) {
                            binaryRoots.add(root);
                        }
                    }
                } else {
                    sourceRoots.add(root);
                }
                ++i;
            }
        } else if (elem instanceof IPackageFragmentRoot) {
            externals = true;
            binaries = true;
            IPackageFragmentRoot root = (IPackageFragmentRoot)elem;
            if (root.isArchive()) {
                if (binaries) {
                    if (root.isExternal()) {
                        if (externals && !binaryRoots.contains(root)) {
                            binaryRoots.add(root);
                        }
                    } else if (!binaryRoots.contains(root)) {
                        binaryRoots.add(root);
                    }
                }
            } else {
                sourceRoots.add(root);
            }
        }
    }

    public IType[] searchJavaBeans(IRunnableContext context, final IJavaElement elem, final int style) throws InvocationTargetException, InterruptedException {
        int allFlags = 24;
        Assert.isTrue(((style | allFlags) == allFlags ? 1 : 0) != 0);
        final IType[][] res = new IType[1][];
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor pm) throws InvocationTargetException {
                try {
                    res[0] = JavaBeanSearchEngine.this.searchJavaBeans(pm, elem, style);
                }
                catch (JavaModelException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        context.run(true, true, runnable);
        return res[0];
    }

    private static class JavaBeanCollector
    implements IJavaSearchResultCollector {
        private List fResult;
        private IProgressMonitor fProgressMonitor;

        public JavaBeanCollector(List result, int style, IProgressMonitor progressMonitor) {
            Assert.isNotNull((Object)result);
            this.fResult = result;
            this.fProgressMonitor = progressMonitor;
        }

        public void accept(IResource resource, int start, int end, IJavaElement enclosingElement, int accuracy) {
            if (enclosingElement instanceof IType) {
                IType curr = (IType)enclosingElement;
                if (JavaBeanSearchEngine.typeIsABean(curr)) {
                    this.fResult.add(curr);
                }
            } else if (enclosingElement instanceof IMethod) {
                try {
                    IType type;
                    if (Flags.isPublic((int)((IMethod)enclosingElement).getFlags()) && Flags.isPublic((int)(type = (IType)enclosingElement.getAncestor(7)).getFlags())) {
                        this.fResult.add(type);
                    }
                }
                catch (JavaModelException e) {
                    JavaVEPlugin.log(e.getStatus(), Level.FINE);
                }
            }
        }

        public IProgressMonitor getProgressMonitor() {
            return this.fProgressMonitor;
        }

        public void aboutToStart() {
        }

        public void done() {
        }
    }
}

