/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.vce.rules;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ve.internal.cde.rules.IRule;
import org.eclipse.ve.internal.java.vce.rules.EditorStyle;
import org.eclipse.ve.internal.java.vce.rules.IEditorStyle;
import org.eclipse.ve.internal.java.vce.rules.IEditorStylePrefUI;
import org.eclipse.ve.internal.java.vce.rules.IStyleRegistry;

public class JVEStyleRegistry
implements IStyleRegistry {
    public static final String RULE_OVERRIDE_ID = "org.eclipse.ve.java.core.style";
    public static final String EXT_ID = "id";
    private static final JVEStyleRegistry _Registry = new JVEStyleRegistry();
    private HashMap fStyles = new HashMap();

    protected JVEStyleRegistry() {
    }

    public IEditorStyle getStyle(String styleId) {
        IExtension[] extensions;
        IEditorStyle result = (IEditorStyle)this.fStyles.get(styleId);
        if (result != null) {
            return result;
        }
        IExtensionPoint xp = Platform.getExtensionRegistry().getExtensionPoint(RULE_OVERRIDE_ID);
        if (xp != null && (extensions = xp.getExtensions()).length > 0) {
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] ces = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < ces.length) {
                    IConfigurationElement ce = ces[j];
                    String id = ce.getAttribute(EXT_ID);
                    if (id.equals(styleId)) {
                        JVEStyleRegistry jVEStyleRegistry = this;
                        synchronized (jVEStyleRegistry) {
                            if (this.fStyles.get(id) == null) {
                                EditorStyle es = new EditorStyle(id, ce);
                                this.fStyles.put(id, es);
                                return es;
                            }
                            return (IEditorStyle)this.fStyles.get(id);
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
        if (result == null) {
            result = new NullStyle();
            this.fStyles.put(styleId, result);
        }
        return result;
    }

    public String[] getStyleIDs() {
        IExtension[] extensions;
        ArrayList<String> sl = new ArrayList<String>();
        IExtensionPoint xp = Platform.getExtensionRegistry().getExtensionPoint(RULE_OVERRIDE_ID);
        if (xp != null && (extensions = xp.getExtensions()).length > 0) {
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] ces = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < ces.length) {
                    IConfigurationElement ce = ces[j];
                    String id = ce.getAttribute(EXT_ID);
                    sl.add(id);
                    ++j;
                }
                ++i;
            }
        }
        String[] result = sl.toArray(new String[sl.size()]);
        return result;
    }

    public static IStyleRegistry getJVEStyleRegistry() {
        return _Registry;
    }

    private class NullStyle
    implements IEditorStyle {
        NullStyle() {
        }

        public String getDescription() {
            return null;
        }

        public String getPluginID() {
            return null;
        }

        public IEditorStylePrefUI getPrefUI() {
            return null;
        }

        public IRule getRule(String id) {
            return null;
        }

        public String getStyleID() {
            return null;
        }

        public Object getTemplate(String id) {
            return null;
        }
    }
}

