/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.vce.templates;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.batch.FileSystem;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblem;
import org.eclipse.jdt.internal.core.builder.ProblemFactory;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;
import org.eclipse.ve.internal.java.vce.templates.TemplateUtil;
import org.eclipse.ve.internal.java.vce.templates.TemplatesException;
import org.eclipse.ve.internal.java.vce.templates.VCETemplatesMessages;

public class JavaObjectEmiter {
    String fEncodeing = System.getProperty("Cp1252");
    char[] fSrc = null;
    String fClassName = null;
    String fClassPackage = null;
    IPath fDestinationPath = null;
    Class ftheClass = null;
    Class fsecondBestClass = null;
    ClassLoader fClassLoader = null;
    long fSrcTimeStamp = -1L;
    int index = 0;

    public JavaObjectEmiter(char[] Src, String className, String pkgName, IPath destinationPath, long srcTimeStamp) {
        this.fSrc = Src;
        this.fClassName = className;
        this.fClassPackage = pkgName;
        this.fDestinationPath = destinationPath;
        this.fSrcTimeStamp = srcTimeStamp;
    }

    public JavaObjectEmiter(String className, String pkgName, IPath destinationPath, long srcTimeStamp) {
        this(null, className, pkgName, destinationPath, srcTimeStamp);
    }

    protected void tick(int i, IProgressMonitor pm) {
        if (pm != null) {
            pm.worked(i);
        }
    }

    protected void tick(IProgressMonitor pm) {
        this.tick(1, pm);
    }

    public String getClassName() {
        if (this.index == 0) {
            return this.fClassName;
        }
        return String.valueOf(this.fClassName) + Integer.toString(this.index);
    }

    public String getFullClassName() {
        return this.fClassPackage.length() == 0 ? this.getClassName() : String.valueOf(this.fClassPackage) + "." + this.getClassName();
    }

    protected ClassLoader getClassLoader(ClassLoader cl) throws TemplatesException {
        if (this.fClassLoader != null) {
            return this.fClassLoader;
        }
        URL[] destUrl = null;
        try {
            destUrl = new URL[]{this.fDestinationPath.toFile().toURL()};
        }
        catch (MalformedURLException e) {
            throw new TemplatesException(e);
        }
        this.fClassLoader = URLClassLoader.newInstance(destUrl, cl);
        return this.fClassLoader;
    }

    protected Class getExistingClass(ClassLoader cl) {
        if (this.ftheClass != null) {
            return this.ftheClass;
        }
        while (true) {
            try {
                Class<?> clazz;
                this.fsecondBestClass = clazz = cl.loadClass(this.getFullClassName());
                long ts = TemplateUtil.getTimeStamp(clazz);
                if (ts >= this.fSrcTimeStamp) {
                    this.ftheClass = clazz;
                    return clazz;
                }
                if (JavaVEPlugin.isLoggingLevel(Level.FINEST)) {
                    JavaVEPlugin.log("JavaObjectEmitter: Did not found found existing class: " + clazz.getName(), Level.FINEST);
                }
                ++this.index;
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
        }
    }

    public Class getExistingClass(ClassLoader cl, IProgressMonitor pm) throws TemplatesException {
        if (this.ftheClass != null) {
            return this.ftheClass;
        }
        File dest = this.fDestinationPath.toFile();
        if (!dest.exists()) {
            dest.mkdir();
        }
        ClassLoader urlCl = this.getClassLoader(cl);
        this.ftheClass = this.getExistingClass(urlCl);
        return this.ftheClass;
    }

    public void refreshSourceClassname() throws TemplatesException {
        if (this.fSrc == null) {
            return;
        }
        IScanner scanner = ToolFactory.createScanner((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        scanner.setSource(this.fSrc);
        try {
            int token = scanner.getNextToken();
            while (token != 165 && token != 158) {
                token = scanner.getNextToken();
            }
            token = scanner.getNextToken();
            while (token != 5 && token != 158) {
                token = scanner.getNextToken();
            }
            if (token == 158) {
                throw new TemplatesException("Could not find class's name");
            }
            int left = scanner.getCurrentTokenStartPosition();
            int right = scanner.getCurrentTokenEndPosition() + 1;
            StringBuffer buf = new StringBuffer();
            buf.append(scanner.getSource());
            buf.replace(left, right, this.getClassName());
            this.fSrc = buf.toString().toCharArray();
        }
        catch (InvalidInputException e) {
            throw new TemplatesException(e.getMessage());
        }
    }

    public Class getClass(String[] classPath, ClassLoader cl, IProgressMonitor pm) throws TemplatesException {
        if (this.ftheClass != null) {
            return this.ftheClass;
        }
        if (this.getExistingClass(cl, pm) != null) {
            return this.ftheClass;
        }
        if (this.fSrc == null) {
            return null;
        }
        if (this.index > 0) {
            this.refreshSourceClassname();
        }
        if (JavaVEPlugin.isLoggingLevel(Level.FINEST)) {
            JavaVEPlugin.log("JavaObjectEmitter: Compiling a new class: " + this.getClassName(), Level.FINEST);
        }
        ICompilationUnit[] cu = new EmitterCompilationUnit[]{new EmitterCompilationUnit()};
        FileSystem env = new FileSystem(classPath, new String[0], this.fEncodeing);
        this.tick(pm);
        IErrorHandlingPolicy errorPolicy = DefaultErrorHandlingPolicies.exitOnFirstError();
        ProblemFactory problemFactory = ProblemFactory.getProblemFactory((Locale)Locale.getDefault());
        EmiterCompilerRequestor requestor = new EmiterCompilerRequestor();
        Compiler cmp = new Compiler((INameEnvironment)env, errorPolicy, (Map)JavaCore.getOptions(), (ICompilerRequestor)requestor, (IProblemFactory)problemFactory);
        this.tick(pm);
        cmp.compile(cu);
        if (requestor.getErrCount() > 0) {
            throw new TemplatesException("SyntaxError: " + requestor.getProblems()[0].getMessage());
        }
        this.tick(pm);
        env.cleanup();
        try {
            this.fClassLoader = null;
            this.ftheClass = this.getClassLoader(cl).loadClass(this.getFullClassName());
            this.tick(pm);
        }
        catch (Exception e) {
            throw new TemplatesException(e);
        }
        return this.ftheClass;
    }

    public Object generateObject(String[] classPath, ClassLoader cl, IProgressMonitor pm) throws TemplatesException {
        Object newInstance = null;
        try {
            newInstance = this.getClass(classPath, cl, pm).newInstance();
            this.tick(pm);
        }
        catch (TemplatesException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new TemplatesException(ex);
        }
        return newInstance;
    }

    public Object generateObjectFromExisting(ClassLoader cl, IProgressMonitor pm) throws TemplatesException {
        Object newInstance;
        try {
            Class clazz = this.getExistingClass(this.getClassLoader(cl));
            newInstance = clazz == null ? null : clazz.newInstance();
            this.tick(pm);
        }
        catch (Exception e) {
            throw new TemplatesException(e);
        }
        return newInstance;
    }

    public String getEncodeing() {
        return this.fEncodeing;
    }

    public void setEncodeing(String encodeing) {
        this.fEncodeing = encodeing;
    }

    public Class getSecondBestClass() {
        return this.fsecondBestClass;
    }

    public void setSrc(char[] src) throws TemplatesException {
        if (this.fSrc != null) {
            throw new TemplatesException("Can not overide existing source");
        }
        this.fSrc = src;
    }

    public String toString() {
        return "JavaObjectEmitter(" + this.getClassName() + "," + this.fSrcTimeStamp + ")";
    }

    public long getSrcTimeStamp() {
        return this.fSrcTimeStamp;
    }

    protected class EmiterCompilerRequestor
    implements ICompilerRequestor {
        protected IProblem[] fProblems = new IProblem[0];
        protected int ErrCount = 0;
        protected int WarnCount = 0;

        protected EmiterCompilerRequestor() {
        }

        public IProblem[] getProblems() {
            return this.fProblems;
        }

        public void createNewProblem(char[] originatingFileName, String message, int id, String[] stringArguments, int severity, int startPosition, int endPosition, int line) {
            DefaultProblem newProblem = new DefaultProblem(originatingFileName, message, id, stringArguments, severity, startPosition, endPosition, line);
            if (this.fProblems == null) {
                this.fProblems = new IProblem[1];
                this.fProblems[0] = newProblem;
            } else {
                IProblem[] temp = new IProblem[this.fProblems.length + 1];
                System.arraycopy(this.fProblems, 0, temp, 0, this.fProblems.length);
                temp[this.fProblems.length] = newProblem;
                this.fProblems = temp;
            }
            if (this.fProblems[this.fProblems.length - 1].isError()) {
                ++this.ErrCount;
            } else {
                ++this.WarnCount;
            }
        }

        public void createNewProblem(char[] originatingFileName, String message) {
            this.createNewProblem(originatingFileName, message, 0, null, 0, 0, 0, 0);
        }

        public void acceptResult(CompilationResult compilationResult) {
            try {
                if (compilationResult.hasErrors()) {
                    StringBuffer problem = new StringBuffer();
                    String newLine = System.getProperties().getProperty("line.separator");
                    problem.append(newLine);
                    this.fProblems = compilationResult.getProblems();
                    int i = 0;
                    while (i < this.fProblems.length) {
                        if (this.fProblems[i].isError()) {
                            ++this.ErrCount;
                        } else {
                            ++this.WarnCount;
                        }
                        ++i;
                    }
                } else {
                    IPath tempDir = JavaObjectEmiter.this.fDestinationPath;
                    ClassFile[] compiledFiles = compilationResult.getClassFiles();
                    ClassFile classFile = compiledFiles[0];
                    String classfilename = new String(classFile.fileName());
                    Path classfilepath = new Path(classfilename);
                    IPath filepath = tempDir.append((IPath)classfilepath);
                    IPath directory = filepath.removeLastSegments(1);
                    File actualDir = directory.toFile();
                    if (actualDir.exists() || actualDir.mkdirs()) {
                        File actualfile = tempDir.append((IPath)classfilepath).addFileExtension("class").toFile();
                        if (actualfile.exists()) {
                            actualfile.delete();
                        }
                        byte[] bytes = classFile.getBytes();
                        FileOutputStream output = new FileOutputStream(actualfile);
                        output.write(bytes);
                        output.close();
                    } else {
                        this.createNewProblem(directory.toOSString().toCharArray(), VCETemplatesMessages.getString("JavaObjectEmiter.Problem.DirectoryDoesntExist_ERROR_"), 0, null, 1, 0, 0, 0);
                    }
                }
            }
            catch (SecurityException se) {
                JavaVEPlugin.log(se);
                this.createNewProblem(JavaObjectEmiter.this.getClassName().toCharArray(), String.valueOf(VCETemplatesMessages.getString("JavaObjectEmiter.Problem.Security_EXC_")) + se.getMessage(), 0, null, 1, 0, 0, 0);
            }
            catch (IOException ioe) {
                JavaVEPlugin.log(ioe);
                this.createNewProblem(JavaObjectEmiter.this.getClassName().toCharArray(), String.valueOf(VCETemplatesMessages.getString("JavaObjectEmiter.Problem.IO_EXC_")) + ioe.getMessage(), 0, null, 1, 0, 0, 0);
            }
        }

        public int getErrCount() {
            return this.ErrCount;
        }
    }

    protected class EmitterCompilationUnit
    implements ICompilationUnit {
        protected EmitterCompilationUnit() {
        }

        public char[] getContents() {
            return JavaObjectEmiter.this.fSrc;
        }

        public char[] getMainTypeName() {
            return JavaObjectEmiter.this.getClassName().toCharArray();
        }

        public char[][] getPackageName() {
            return CharOperation.splitOn((char)'.', (char[])JavaObjectEmiter.this.fClassPackage.toCharArray());
        }

        public char[] getFileName() {
            IPath fileName = JavaObjectEmiter.this.fDestinationPath.append(JavaObjectEmiter.this.fClassName);
            return fileName.toOSString().toCharArray();
        }
    }
}

