/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.vce.templates;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.logging.Level;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.codegen.jet.JETCompiler;
import org.eclipse.emf.codegen.jet.JETException;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;
import org.eclipse.ve.internal.java.vce.templates.JavaObjectEmiter;
import org.eclipse.ve.internal.java.vce.templates.TemplatesException;

public class TemplateObjectEmitter {
    public static final String GENERATE_METHOD = "generate";
    String fEncodeing = System.getProperty("Cp1252");
    String[] fTemplateURIPath = null;
    String fTemplate = null;
    long fTemplateTimeStamp = -1L;
    String fClassName = null;
    String fPackageName = null;
    IPath fDestinationPath;
    JETCompiler fJetCompiler = null;
    boolean parsed = false;
    StringBuffer fGeneratedSource = null;
    JavaObjectEmiter fObjectEmitter = null;

    TemplateObjectEmitter(String[] templateURIPath, String template, IPath destinationPath) {
        this.fTemplateURIPath = templateURIPath;
        this.fTemplate = template;
        this.fDestinationPath = destinationPath;
        File t = new File(JETCompiler.find((String[])templateURIPath, (String)template));
        if (t.canRead()) {
            this.fTemplateTimeStamp = t.lastModified();
        }
    }

    TemplateObjectEmitter(String[] templateURIPath, String template, IPath destinationPath, String className) {
        this(templateURIPath, template, destinationPath);
        this.fClassName = className;
    }

    protected void tick(int i, IProgressMonitor pm) {
        if (pm != null) {
            pm.worked(i);
        }
    }

    protected void tick(IProgressMonitor pm) {
        this.tick(1, pm);
    }

    public String getClassName(IProgressMonitor pm) {
        if (this.fClassName != null) {
            return this.fClassName;
        }
        try {
            this.parseTemplate(pm);
            this.tick(pm);
            this.fClassName = this.getJetCompiler().getSkeleton().getClassName();
        }
        catch (JETException e) {
            JavaVEPlugin.log(e);
        }
        return this.fClassName;
    }

    public String getPackageName(IProgressMonitor pm) {
        if (this.fPackageName != null) {
            return this.fPackageName;
        }
        try {
            this.parseTemplate(pm);
            this.tick(pm);
            this.fPackageName = this.getJetCompiler().getSkeleton().getPackageName();
        }
        catch (JETException e) {
            JavaVEPlugin.log(e);
        }
        return this.fPackageName;
    }

    public String getFullClassName(IProgressMonitor pm) {
        String name = this.getClassName(pm);
        this.tick(pm);
        String result = null;
        try {
            result = String.valueOf(this.getJetCompiler().getSkeleton().getPackageName()) + "." + name;
        }
        catch (JETException jETException) {}
        return result;
    }

    protected JETCompiler getJetCompiler() throws JETException {
        if (this.fJetCompiler != null) {
            return this.fJetCompiler;
        }
        this.fJetCompiler = new JETCompiler(this.fTemplateURIPath, this.fTemplate);
        return this.fJetCompiler;
    }

    protected void parseTemplate(IProgressMonitor pm) throws JETException {
        if (!this.parsed) {
            if (JavaVEPlugin.isLoggingLevel(Level.FINEST)) {
                JavaVEPlugin.log("TemplateObjectEmitter: parsing: " + this.fTemplate, Level.FINEST);
            }
            JavaRuntime.getDefaultVMInstall();
            this.tick(pm);
            this.getJetCompiler().parse();
            this.tick(pm);
            this.parsed = true;
        }
    }

    protected void generateTemplate(IProgressMonitor pm) throws JETException {
        if (this.fGeneratedSource == null) {
            this.parseTemplate(pm);
            ByteArrayOutputStream generatedTemplate = new ByteArrayOutputStream();
            this.tick(pm);
            this.getJetCompiler().generate((OutputStream)generatedTemplate);
            if (JavaVEPlugin.isLoggingLevel(Level.FINEST)) {
                JavaVEPlugin.log("TemplateObjectEmitter: generating" + this.fTemplate, Level.FINEST);
            }
            ByteArrayInputStream contents = new ByteArrayInputStream(generatedTemplate.toByteArray());
            InputStreamReader reader = new InputStreamReader(contents);
            this.tick(pm);
            char[] buf = new char[4096];
            this.fGeneratedSource = new StringBuffer();
            try {
                int len = 0;
                while ((len = reader.read(buf, 0, 4096)) != -1) {
                    this.fGeneratedSource.append(buf, 0, len);
                }
            }
            catch (IOException e) {
                this.fGeneratedSource = null;
                throw new JETException(e.getMessage());
            }
        }
    }

    public String getObjectSource(IProgressMonitor pm) throws JETException {
        if (this.fGeneratedSource == null) {
            this.parseTemplate(pm);
            this.generateTemplate(pm);
        }
        return this.fGeneratedSource.toString();
    }

    protected Object getObject(String[] classPath, String newClassName, ClassLoader cl, IProgressMonitor pm) throws JETException, TemplatesException {
        Object o;
        if (this.fObjectEmitter == null) {
            if (this.fTemplateTimeStamp < 0L) {
                throw new TemplatesException("Invalid Template Time Stamp");
            }
            this.fObjectEmitter = new JavaObjectEmiter(null, this.getClassName(pm), this.getPackageName(pm), this.fDestinationPath, this.fTemplateTimeStamp);
            this.fObjectEmitter.setEncodeing(this.fEncodeing);
        }
        if ((o = this.fObjectEmitter.generateObjectFromExisting(cl, pm)) == null) {
            this.fObjectEmitter.setSrc(this.getObjectSource(pm).toCharArray());
            o = this.fObjectEmitter.generateObject(classPath, cl, pm);
        }
        return o;
    }

    public String getEncodeing() {
        return this.fEncodeing;
    }

    public void setEncodeing(String encodeing) {
        this.fEncodeing = encodeing;
        if (this.fObjectEmitter != null) {
            this.fObjectEmitter.setEncodeing(encodeing);
        }
    }

    public String toString() {
        return "TemplateObjectEmiter(" + this.fTemplate + "," + this.fTemplateTimeStamp + ")";
    }

    public long getTemplateTimeStamp() {
        return this.fTemplateTimeStamp;
    }
}

