/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.visual;

import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jem.internal.instantiation.base.IJavaObjectInstance;
import org.eclipse.jem.internal.instantiation.base.JavaInstantiation;
import org.eclipse.jem.internal.proxy.awt.IRectangleBeanProxy;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.cde.emf.EMFEditDomainHelper;
import org.eclipse.ve.internal.java.core.BeanProxyUtilities;
import org.eclipse.ve.internal.java.rules.RuledCommandBuilder;
import org.eclipse.ve.internal.propertysheet.common.commands.CommandWrapper;

public abstract class NullLayoutConstraintCommand
extends CommandWrapper {
    protected IJavaObjectInstance target;
    protected ResourceSet rset;
    protected Rectangle constraint;
    protected byte changed = 0;
    protected EditDomain domain;
    protected static final byte NO_CHANGE = 0;
    protected static final byte MOVED = 1;
    protected static final byte RESIZED = 2;

    public NullLayoutConstraintCommand(String label) {
        super(label);
    }

    public NullLayoutConstraintCommand() {
    }

    public void setTarget(IJavaObjectInstance target) {
        this.target = target;
    }

    public void setDomain(EditDomain domain) {
        this.domain = domain;
        this.rset = EMFEditDomainHelper.getResourceSet((EditDomain)domain);
    }

    public void setConstraint(Rectangle constraint, boolean moved, boolean resized) {
        if (moved) {
            this.changed = (byte)(this.changed | 1);
        }
        if (resized) {
            this.changed = (byte)(this.changed | 2);
        }
        this.constraint = constraint;
    }

    protected boolean prepare() {
        return this.target != null && this.rset != null && this.constraint != null;
    }

    public void execute() {
        RuledCommandBuilder cb = new RuledCommandBuilder(this.domain);
        EReference sfComponentBounds = JavaInstantiation.getReference((IJavaObjectInstance)this.target, (URI)this.getSFBounds());
        if (this.target.eIsSet((EStructuralFeature)sfComponentBounds)) {
            int height;
            int width;
            int y;
            int x;
            IRectangleBeanProxy oldBounds = (IRectangleBeanProxy)BeanProxyUtilities.getBeanProxy((IJavaInstance)((IJavaObjectInstance)this.target.eGet((EStructuralFeature)sfComponentBounds)), this.rset);
            if ((this.changed & 1) != 0) {
                x = this.constraint.x;
                y = this.constraint.y;
            } else {
                x = oldBounds.getX();
                y = oldBounds.getY();
            }
            if ((this.changed & 2) != 0) {
                width = this.constraint.width;
                height = this.constraint.height;
            } else {
                width = oldBounds.getWidth();
                height = oldBounds.getHeight();
            }
            IJavaInstance bounds = this.createBoundsInstance(x, y, width, height);
            cb.applyAttributeSetting((EObject)this.target, (EStructuralFeature)sfComponentBounds, (Object)bounds);
        } else {
            EReference sfComponentSize = JavaInstantiation.getReference((IJavaObjectInstance)this.target, (URI)this.getSFSize());
            if ((this.changed & 2) != 0 && (this.changed & 1) == 0) {
                IJavaInstance size = this.createSizeInstance(this.constraint.width, this.constraint.height);
                cb.applyAttributeSetting((EObject)this.target, (EStructuralFeature)sfComponentSize, (Object)size);
            } else {
                EReference sfComponentLocation = JavaInstantiation.getReference((IJavaObjectInstance)this.target, (URI)this.getSFLocation());
                if (this.target.eIsSet((EStructuralFeature)sfComponentSize) || this.target.eIsSet((EStructuralFeature)sfComponentLocation)) {
                    if ((this.changed & 2) != 0) {
                        IJavaInstance size = this.createSizeInstance(this.constraint.width, this.constraint.height);
                        cb.applyAttributeSetting((EObject)this.target, (EStructuralFeature)sfComponentSize, (Object)size);
                    }
                    if ((this.changed & 1) != 0) {
                        IJavaInstance loc = this.createLocationInstance(this.constraint.x, this.constraint.y);
                        cb.applyAttributeSetting((EObject)this.target, (EStructuralFeature)sfComponentLocation, (Object)loc);
                    }
                } else {
                    IJavaInstance bounds = this.createBoundsInstance(this.constraint.x, this.constraint.y, this.constraint.width, this.constraint.height);
                    cb.applyAttributeSetting((EObject)this.target, (EStructuralFeature)sfComponentBounds, (Object)bounds);
                }
            }
        }
        this.command = cb.getCommand();
        this.command.execute();
    }

    protected abstract IJavaInstance createLocationInstance(int var1, int var2);

    protected abstract IJavaInstance createBoundsInstance(int var1, int var2, int var3, int var4);

    protected abstract IJavaInstance createSizeInstance(int var1, int var2);

    protected abstract URI getSFBounds();

    protected abstract URI getSFSize();

    protected abstract URI getSFLocation();
}

