/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.visual;

import java.util.StringTokenizer;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jem.java.JavaRefFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.java.core.DefaultJavaClassCellEditor;
import org.eclipse.ve.internal.java.core.JavaEditDomainHelper;
import org.eclipse.ve.internal.java.core.JavaMessages;
import org.eclipse.ve.internal.java.visual.RectangleJavaClassLabelProvider;

public class RectangleJavaClassCellEditor
extends DefaultJavaClassCellEditor
implements IExecutableExtension {
    private String rectangleClassName;

    public RectangleJavaClassCellEditor(Composite aComposite) {
        super(aComposite);
    }

    protected String doGetString(Object value) {
        if (this.isInstance(value)) {
            return RectangleJavaClassLabelProvider.toString((IJavaInstance)value);
        }
        return null;
    }

    protected String getJavaInitializationString(String rectString) {
        StringTokenizer st = new StringTokenizer(rectString, ",");
        StringBuffer sb = new StringBuffer(rectString.length());
        sb.append("new ");
        sb.append(this.rectangleClassName);
        sb.append('(');
        sb.append(st.nextToken().trim());
        while (st.hasMoreTokens()) {
            sb.append(',');
            sb.append(st.nextToken().trim());
        }
        sb.append(')');
        return sb.toString();
    }

    protected String isCorrectString(String text) {
        StringTokenizer st = new StringTokenizer(text, ",");
        String[] tokenMsgs = new String[]{JavaMessages.getString("CellEditor.Rectangle.XErrorMsg_ERROR_"), JavaMessages.getString("CellEditor.Rectangle.YErrorMsg_ERROR_"), JavaMessages.getString("CellEditor.Rectangle.WidthErrorMsg_ERROR_"), JavaMessages.getString("CellEditor.Rectangle.HeightErrorMsg_ERROR_")};
        if (st.countTokens() != tokenMsgs.length) {
            return JavaMessages.getString("CellEditor.Rectangle.ErrorMsg_ERROR_");
        }
        int i = 0;
        while (i < tokenMsgs.length) {
            String field = st.nextToken().trim();
            try {
                Integer.decode(field);
            }
            catch (NumberFormatException numberFormatException) {
                return tokenMsgs[i];
            }
            ++i;
        }
        return null;
    }

    public void setData(Object data) {
        super.setData(data);
        this.setJavaType(JavaRefFactory.eINSTANCE.reflectType(this.rectangleClassName, JavaEditDomainHelper.getResourceSet((EditDomain)this.fEditDomain)));
    }

    public static String getJavaInitializationString(Rectangle rect, String aRectangleClassName) {
        return RectangleJavaClassCellEditor.getJavaInitializationString(rect.x, rect.y, rect.width, rect.height, aRectangleClassName);
    }

    public static String getJavaInitializationString(int x, int y, int width, int height, String aRectangleClassName) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("new ");
        buffer.append(aRectangleClassName);
        buffer.append('(');
        buffer.append(String.valueOf(x));
        buffer.append(',');
        buffer.append(String.valueOf(y));
        buffer.append(',');
        buffer.append(String.valueOf(width));
        buffer.append(',');
        buffer.append(String.valueOf(height));
        buffer.append(')');
        return buffer.toString();
    }

    public void setInitializationData(IConfigurationElement ce, String pName, Object initData) {
        if (initData instanceof String) {
            this.rectangleClassName = (String)initData;
        }
    }
}

