/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.vce.launcher.remotevm;

import java.applet.Applet;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.HashMap;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.eclipse.ve.internal.java.vce.launcher.remotevm.AppletFrame;
import org.eclipse.ve.internal.java.vce.launcher.remotevm.IAppletFrame;
import org.eclipse.ve.internal.java.vce.launcher.remotevm.ILauncher;
import org.eclipse.ve.internal.java.vce.launcher.remotevm.JAppletFrame;
import org.eclipse.ve.internal.java.vce.launcher.remotevm.VCELauncherMessages;

public class JFCLauncher
implements ILauncher {
    public static Point OFF_SCREEN = new Point(-10000, -10000);
    public static Point ON_SCREEN = new Point(0, 0);
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public boolean supportsLaunching(Class clazz) {
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("javax.swing.JComponent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!clazz2.isAssignableFrom(clazz)) {
            Class<?> clazz3 = class$1;
            if (clazz3 == null) {
                try {
                    clazz3 = class$1 = Class.forName("java.awt.Component");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (!clazz3.isAssignableFrom(clazz)) {
                Class<?> clazz4 = class$2;
                if (clazz4 == null) {
                    try {
                        clazz4 = class$2 = Class.forName("java.awt.Window");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!clazz4.isAssignableFrom(clazz)) {
                    Class<?> clazz5 = class$3;
                    if (clazz5 == null) {
                        try {
                            clazz5 = class$3 = Class.forName("java.applet.Applet");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (!clazz5.isAssignableFrom(clazz)) {
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public void launch(Class clazz, String[] args) {
        Object javaBean = null;
        try {
            Constructor ctor = clazz.getDeclaredConstructor(null);
            ctor.setAccessible(true);
            javaBean = ctor.newInstance(null);
        }
        catch (SecurityException e1) {
            System.out.println(MessageFormat.format(VCELauncherMessages.getString("BeansLauncher.Err.InvocationException_ERROR_"), clazz.getName()));
            e1.printStackTrace();
            System.exit(0);
        }
        catch (IllegalArgumentException e1) {
            System.out.println(MessageFormat.format(VCELauncherMessages.getString("BeansLauncher.Err.IllegalAccessException_ERROR_"), clazz.getName()));
            e1.printStackTrace();
            System.exit(0);
        }
        catch (NoSuchMethodException e1) {
            System.out.println(MessageFormat.format(VCELauncherMessages.getString("BeansLauncher.Err.InvocationException_ERROR_"), clazz.getName()));
            e1.printStackTrace();
            System.exit(0);
        }
        catch (InstantiationException e1) {
            System.out.println(MessageFormat.format(VCELauncherMessages.getString("BeansLauncher.Err.InvocationException_ERROR_"), clazz.getName()));
            e1.printStackTrace();
            System.exit(0);
        }
        catch (IllegalAccessException e1) {
            System.out.println(MessageFormat.format(VCELauncherMessages.getString("BeansLauncher.Err.IllegalAccessException_ERROR_"), clazz.getName()));
            e1.printStackTrace();
            System.exit(0);
        }
        catch (InvocationTargetException e1) {
            System.out.println(MessageFormat.format(VCELauncherMessages.getString("BeansLauncher.Err.InvocationException_ERROR_"), clazz.getName()));
            e1.printStackTrace();
            System.exit(0);
        }
        String lookAndFeelArg = System.getProperty("vce.launcher.lookandfeel");
        if (lookAndFeelArg != null && !lookAndFeelArg.equals("")) {
            try {
                UIManager.setLookAndFeel(lookAndFeelArg);
                SwingUtilities.updateComponentTreeUI(javaBean);
            }
            catch (Exception exc) {
                System.out.println(MessageFormat.format(VCELauncherMessages.getString("BeansLauncher.Err.SettingLookAndFeel_ERROR_"), lookAndFeelArg));
                exc.printStackTrace();
            }
        }
        if (javaBean instanceof Applet) {
            String projectURL = System.getProperty("vce.launcher.projecturl");
            JFCLauncher.launchApplet(clazz, projectURL);
        } else if (javaBean instanceof Window) {
            JFCLauncher.launchWindow(javaBean, javaBean, ((Component)javaBean).getSize());
        } else if (javaBean instanceof JComponent) {
            JFCLauncher.launchJComponent(javaBean);
        } else if (javaBean instanceof Component) {
            JFCLauncher.launchComponent(javaBean);
        }
    }

    protected static void launchJComponent(JComponent aJComponent) {
        JFrame frame = new JFrame(MessageFormat.format(VCELauncherMessages.getString("BeansLauncher.FrameTitle.LaunchJComponent"), aJComponent.getClass().getName()));
        Dimension aComponentSize = aJComponent.getSize();
        frame.getContentPane().add(aJComponent);
        JFCLauncher.launchWindow(frame, aJComponent, aComponentSize);
    }

    protected static void launchWindow(Window aWindow, Component aComponent, Dimension aComponentSize) {
        if (aWindow instanceof JFrame) {
            ((JFrame)aWindow).setDefaultCloseOperation(3);
        } else if (aWindow instanceof JDialog) {
            ((JDialog)aWindow).setDefaultCloseOperation(3);
        }
        aWindow.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent anEvent) {
                System.exit(0);
            }
        });
        aWindow.setLocation(OFF_SCREEN);
        aWindow.setVisible(true);
        JFCLauncher.sizeWindow(aWindow, aComponent, aComponentSize);
        aWindow.setLocation(ON_SCREEN);
        aWindow.validate();
    }

    protected static void launchComponent(Component aComponent) {
        Frame frame = new Frame(MessageFormat.format(VCELauncherMessages.getString("BeansLauncher.FrameTitle.LaunchComponent"), aComponent.getClass().getName()));
        Dimension aComponentSize = aComponent.getSize();
        frame.add(aComponent);
        JFCLauncher.launchWindow(frame, aComponent, aComponentSize);
    }

    protected static void sizeWindow(Window aWindow, Component aComponent, Dimension componentSize) {
        String pack = System.getProperty("pack");
        if (pack != null && pack.equals("true")) {
            aWindow.pack();
        } else if (aComponent != aWindow) {
            Insets insets = aWindow.getInsets();
            componentSize.width += insets.left + insets.right;
            componentSize.height += insets.top + insets.bottom;
            aWindow.setSize(componentSize);
        }
    }

    protected static void launchApplet(Class anAppletClass, String projectLocation) {
        String numberOfParmsString = System.getProperty("appletparmsnumber");
        HashMap<String, String> appletParms = new HashMap<String, String>();
        if (numberOfParmsString != null) {
            int numberOfParms = Integer.parseInt(numberOfParmsString);
            int i = 1;
            while (i <= numberOfParms) {
                String name = System.getProperty("appletparmname" + i);
                String value = System.getProperty("appletparmvalue" + i);
                appletParms.put(name, value);
                ++i;
            }
        }
        Object object = null;
        try {
            Constructor ctor = anAppletClass.getDeclaredConstructor(null);
            ctor.setAccessible(true);
            object = ctor.newInstance(null);
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        final Applet applet = object;
        Frame frame = null;
        if (applet instanceof JApplet) {
            frame = new JAppletFrame(VCELauncherMessages.getString("BeansLauncher.FrameTitle.LaunchApplet"), (JApplet)applet, appletParms);
            ((JFrame)frame).setDefaultCloseOperation(3);
        } else {
            frame = new AppletFrame(VCELauncherMessages.getString("BeansLauncher.FrameTitle.LaunchApplet"), applet, appletParms);
            frame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent event) {
                    applet.stop();
                    applet.destroy();
                    System.exit(0);
                }
            });
        }
        applet.init();
        Dimension aComponentSize = applet.getSize();
        frame.setLocation(OFF_SCREEN);
        frame.setVisible(true);
        Dimension additionalSize = ((IAppletFrame)((Object)frame)).getAdditionalSize();
        if (additionalSize != null) {
            aComponentSize.height += additionalSize.height;
            if (aComponentSize.width < additionalSize.width) {
                aComponentSize.width = additionalSize.width;
            }
        }
        if (aComponentSize.width == 0 && aComponentSize.height == 0) {
            aComponentSize = new Dimension(250, 250);
        }
        JFCLauncher.sizeWindow(frame, applet, aComponentSize);
        frame.setLocation(ON_SCREEN);
        applet.start();
        System.out.println(MessageFormat.format(VCELauncherMessages.getString("BeansLauncher.Msg.AppletStarted_INFO_"), anAppletClass.getName()));
        frame.validate();
    }
}

