/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.adapters.jdom;

import java.io.File;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jem.internal.adapters.jdom.JDOMSearchHelper;
import org.eclipse.jem.internal.java.adapters.JavaReflectionAdaptor;
import org.eclipse.jem.internal.java.adapters.nls.ResourceHandler;
import org.eclipse.jem.java.Field;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaRefPackage;
import org.eclipse.jem.java.Method;
import org.eclipse.jem.java.impl.JavaRefFactoryImpl;

public abstract class JDOMAdaptor
extends JavaReflectionAdaptor {
    protected static final JavaRefPackage JAVA_PACK = JavaRefFactoryImpl.getPackage();
    protected IJavaProject sourceProject;
    public static final int INVALID_LINENO = -1;
    protected final Integer fLINENOLock = new Integer(-1);
    private int fResolvedLineNo = -1;
    private int fResolvedColNo = -1;

    public JDOMAdaptor(Notifier target, IJavaProject workingProject) {
        super(target);
        this.setSourceProject(workingProject);
    }

    protected void clearSource() {
    }

    private void computeLineOffset(int charOffset, IBuffer buffer) {
        this.fResolvedLineNo = -1;
        this.fResolvedColNo = -1;
        if (buffer == null) {
            return;
        }
        char[] charBuff = buffer.getCharacters();
        if (charBuff == null) {
            return;
        }
        int LineCount = 0;
        int ColNo = 0;
        int i = 0;
        while (i <= charOffset) {
            ++ColNo;
            if (charBuff[i] == '\r') {
                ++LineCount;
                ColNo = 0;
                if (charBuff[i + 1] == '\n') {
                    ++i;
                }
            } else if (charBuff[i] == '\n') {
                ++LineCount;
                ColNo = 0;
            }
            ++i;
        }
        this.fResolvedColNo = ColNo;
        this.fResolvedLineNo = LineCount;
    }

    public static String computeMethodID(IMethod jdomMethod) {
        return JDOMAdaptor.computeMethodID(jdomMethod, jdomMethod.getDeclaringType(), null);
    }

    public static String computeMethodID(IMethod jdomMethod, IType type, Map typeCache) {
        StringBuffer out = new StringBuffer();
        out.append(type.getTypeQualifiedName());
        out.append('.');
        out.append(jdomMethod.getElementName());
        out.append('(');
        String[] parmTypeNames = jdomMethod.getParameterTypes();
        int i = 0;
        while (i < parmTypeNames.length) {
            String parmName = JDOMAdaptor.convertJDOMtypeName(parmTypeNames[i]);
            parmName = JDOMSearchHelper.getResolvedTypeName(parmName, type, typeCache);
            out.append(parmName);
            if (i < parmTypeNames.length - 1) {
                out.append(',');
            }
            ++i;
        }
        try {
            if (jdomMethod.isConstructor()) {
                out.append("_V");
            }
        }
        catch (JavaModelException javaModelException) {}
        return out.toString();
    }

    public static String computeMethodName(IMethod jdomMethod) {
        return jdomMethod.getElementName();
    }

    public void contentChanged() {
        Integer n = this.fLINENOLock;
        synchronized (n) {
            this.fResolvedLineNo = -1;
            this.fResolvedColNo = -1;
        }
    }

    public static String convertJDOMtypeName(String jdomTypeName) {
        return JDOMAdaptor.signatureToString(jdomTypeName);
    }

    public Field createJavaField(IField jdomField, XMIResource resource) {
        String name = jdomField.getElementName();
        Field newField = JavaReflectionAdaptor.getJavaFactory().createField();
        newField.setName(name);
        resource.setID((EObject)newField, String.valueOf(((JavaClass)this.getTarget()).getName()) + '.' + name);
        return newField;
    }

    public Method createJavaMethod(IMethod jdomMethod, XMIResource resource) {
        Method newMethod = JavaReflectionAdaptor.getJavaFactory().createMethod();
        newMethod.setName(JDOMAdaptor.computeMethodName(jdomMethod));
        resource.setID((EObject)newMethod, JDOMAdaptor.computeMethodID(jdomMethod, this.getType(), this.getTypeResolutionCache()));
        return newMethod;
    }

    protected IPath getBinaryPathFromQualifiedName(String qualifiedName) {
        return new Path(String.valueOf(qualifiedName.replace('.', File.separatorChar)) + ".class");
    }

    public IType getBinaryType(String qualifiedName) {
        try {
            IJavaElement found;
            if (this.getSourceProject() != null && (found = this.getSourceProject().findElement(this.getBinaryPathFromQualifiedName(qualifiedName))) != null) {
                return ((IClassFile)found).getType();
            }
        }
        catch (JavaModelException jme) {
            System.out.println(ResourceHandler.getString((String)"Error_Looking_Up_Type_ERROR_", (Object[])new Object[]{qualifiedName, jme.getMessage()}));
        }
        return null;
    }

    public int getColNo() {
        Integer n = this.fLINENOLock;
        synchronized (n) {
            if (this.fResolvedColNo == -1) {
                this.resolveLineColNo();
            }
        }
        return this.fResolvedColNo;
    }

    public int getLineNo() {
        Integer n = this.fLINENOLock;
        synchronized (n) {
            if (this.fResolvedLineNo == -1) {
                this.resolveLineColNo();
            }
        }
        return this.fResolvedLineNo;
    }

    public abstract Object getReflectionSource();

    public static String getResolvedTypeName(String typeName, IType declaringType) {
        String name = typeName;
        try {
            name = JDOMSearchHelper.resolveSimpleTypeName(declaringType, typeName);
        }
        catch (JavaModelException javaModelException) {}
        return name;
    }

    protected IJavaProject getSourceProject() {
        return this.sourceProject;
    }

    protected abstract IType getType();

    protected abstract Map getTypeResolutionCache();

    public void releaseSourceType() {
        this.flushReflectedValuesIfNecessary(true);
    }

    public Notification releaseSourceTypeNoNotification() {
        return this.flushReflectedValuesIfNecessaryNoNotification(true);
    }

    private void resolveLineColNo() {
        IMember rs = (IMember)this.getReflectionSource();
        if (rs != null) {
            int offset = -1;
            try {
                ISourceRange sr = rs.getNameRange();
                if (sr.getLength() <= 0) {
                    return;
                }
                offset = sr.getOffset();
            }
            catch (JavaModelException javaModelException) {
                return;
            }
            ICompilationUnit cu = rs.getCompilationUnit();
            if (cu != null) {
                try {
                    IBuffer buffer = cu.getBuffer();
                    this.computeLineOffset(offset, buffer);
                }
                catch (JavaModelException javaModelException) {}
            }
        }
    }

    protected void setSourceProject(IJavaProject workingProject) {
        this.sourceProject = workingProject;
    }

    public static String signatureToString(String signature) throws IllegalArgumentException {
        int newPos;
        boolean hasDollar = signature.indexOf(36) != -1;
        String result = Signature.toString((String)signature);
        if (hasDollar && (newPos = result.lastIndexOf(".")) != -1) {
            result = String.valueOf(result.substring(0, newPos)) + "$" + result.substring(newPos + 1);
        }
        return result;
    }

    protected String typeNameFromSignature(String sig) {
        return this.typeNameFromSignature(sig, this.getType());
    }

    protected String typeNameFromSignature(String sig, IType parent) {
        return JDOMAdaptor.typeNameFromSignature(sig, parent, this.getTypeResolutionCache());
    }

    public static String typeNameFromSignature(String sig, IType parent, Map typeCache) {
        String componentSignature = Signature.getElementType((String)sig);
        int arrayDimensions = Signature.getArrayCount((String)sig);
        String result = JDOMSearchHelper.getResolvedTypeName(JDOMAdaptor.signatureToString(componentSignature), parent, typeCache);
        int i = 0;
        while (i < arrayDimensions) {
            result = String.valueOf(result) + "[]";
            ++i;
        }
        return result;
    }

    public IType getType(String qualifiedName) {
        return JDOMSearchHelper.findType(qualifiedName, false, this.getSourceProject(), this);
    }
}

