/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.ide;

import java.net.URL;
import java.net.URLClassLoader;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.ICallbackRegistry;
import org.eclipse.jem.internal.proxy.core.ProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.core.ProxyPlugin;
import org.eclipse.jem.internal.proxy.ide.IDECallbackRegistry;
import org.eclipse.jem.internal.proxy.ide.IDEStandardBeanProxyFactory;
import org.eclipse.jem.internal.proxy.ide.IDEStandardBeanTypeProxyFactory;
import org.osgi.framework.Bundle;

public class IDEProxyFactoryRegistry
extends ProxyFactoryRegistry {
    protected String fName;
    protected ClassLoader fClassLoader;
    protected IDECallbackRegistry fCallbackRegistry;

    public static ClassLoader createSpecialLoader(String pluginName, URL[] otherURLs) {
        Bundle bundle = pluginName != null ? Platform.getBundle((String)pluginName) : null;
        URL[] mustHaveUrls = ProxyPlugin.getPlugin().urlLocalizeFromBundleAndFragments(ProxyPlugin.getPlugin().getBundle(), "vm/remotevm.jar");
        URL[] urls = null;
        if (otherURLs != null) {
            urls = new URL[otherURLs.length + mustHaveUrls.length];
            System.arraycopy(mustHaveUrls, 0, urls, 0, mustHaveUrls.length);
            System.arraycopy(otherURLs, 0, urls, mustHaveUrls.length, otherURLs.length);
        } else {
            urls = mustHaveUrls;
        }
        return bundle != null ? new IDESpecialClassLoader(urls, bundle) : new IDESpecialClassLoader(urls);
    }

    public IDEProxyFactoryRegistry(String aName, ClassLoader loader) {
        this.fName = aName;
        this.fClassLoader = loader;
    }

    ClassLoader getPluginClassLoader() {
        return this.fClassLoader;
    }

    protected void registryTerminated(boolean wait) {
    }

    Class loadClass(String aClassName) throws ClassNotFoundException, ExceptionInInitializerError, LinkageError {
        return this.fClassLoader.loadClass(aClassName);
    }

    public ICallbackRegistry getCallbackRegistry() {
        if (this.fCallbackRegistry == null) {
            this.fCallbackRegistry = new IDECallbackRegistry(this);
        }
        return this.fCallbackRegistry;
    }

    IBeanProxy getBeanProxy(Class returnType, Object bean) {
        IDEStandardBeanTypeProxyFactory proxyFactory = (IDEStandardBeanTypeProxyFactory)this.getBeanTypeProxyFactory();
        if (!returnType.isPrimitive()) {
            return IDEStandardBeanProxyFactory.createBeanProxy(this, bean);
        }
        if (returnType == Integer.TYPE) {
            return proxyFactory.intType.newBeanProxy(bean);
        }
        if (returnType == Boolean.TYPE) {
            return proxyFactory.booleanType.newBeanProxy(bean);
        }
        if (returnType == Float.TYPE) {
            return proxyFactory.floatType.newBeanProxy(bean);
        }
        if (returnType == Long.TYPE) {
            return proxyFactory.longType.newBeanProxy(bean);
        }
        if (returnType == Short.TYPE) {
            return proxyFactory.shortType.newBeanProxy(bean);
        }
        if (returnType == Double.TYPE) {
            return proxyFactory.doubleType.newBeanProxy(bean);
        }
        if (returnType == Byte.TYPE) {
            return proxyFactory.byteType.newBeanProxy(bean);
        }
        if (returnType == Character.TYPE) {
            return proxyFactory.charType.newBeanProxy(bean);
        }
        throw new RuntimeException("Unknown primitive type " + returnType.getName());
    }

    private static class IDESpecialClassLoader
    extends URLClassLoader {
        private Bundle bundle;
        private Bundle ideBundle = ProxyPlugin.getPlugin().getBundle();

        public IDESpecialClassLoader(URL[] urls, Bundle bundle) {
            super(urls, (ClassLoader)null);
            this.bundle = bundle;
        }

        public IDESpecialClassLoader(URL[] urls) {
            this(urls, (Bundle)null);
        }

        protected Class findClass(String name) throws ClassNotFoundException {
            try {
                return this.ideBundle.loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (this.bundle != null) {
                    try {
                        return this.bundle.loadClass(name);
                    }
                    catch (ClassNotFoundException classNotFoundException2) {}
                }
                return super.findClass(name);
            }
        }

        public URL findResource(String name) {
            URL r = this.ideBundle.getResource(name);
            if (r == null && this.bundle != null) {
                r = this.bundle.getResource(name);
            }
            return r != null ? r : super.findResource(name);
        }
    }
}

