/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.jfc.vm;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import org.eclipse.ve.internal.jfc.vm.FreeFormAWTContainer;
import org.eclipse.ve.internal.jfc.vm.VisualVMMessages;

public class FreeFormAWTDialog
extends Dialog {
    protected Frame fHostingFrame;
    protected boolean isValidating;
    protected Dimension minSize;
    protected boolean isDisposing = false;

    public FreeFormAWTDialog(int x, int y) {
        super(new Frame(VisualVMMessages.getString("FreeForm.Frame.Title")));
        this.setLayout(new FlowLayout(0, 0, 0));
        this.fHostingFrame = (Frame)this.getParent();
        this.setLocation(x, y);
        this.fHostingFrame.setLocation(x, y);
        this.setTitle(VisualVMMessages.getString("FreeForm.Dialog.Title"));
        this.fHostingFrame.setVisible(true);
        this.setFont(this.fHostingFrame.getFont());
        this.setBackground(this.fHostingFrame.getBackground());
        this.fHostingFrame.setVisible(false);
        this.setVisible(true);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                FreeFormAWTDialog.this.removeComponentListener(this);
                FreeFormAWTDialog.this.minSize = FreeFormAWTDialog.this.getSize();
            }
        });
    }

    public FreeFormAWTDialog(Frame parent) {
        super(parent);
    }

    public Component add(Component aComponent) {
        FreeFormAWTContainer aContainer = new FreeFormAWTContainer();
        aContainer.add(aComponent);
        super.add(aContainer);
        this.pack();
        return aComponent;
    }

    public void dispose() {
        if (!this.isDisposing) {
            this.isDisposing = true;
            super.dispose();
            if (this.fHostingFrame != null) {
                this.fHostingFrame.dispose();
            }
            this.isDisposing = false;
        }
    }

    protected FreeFormAWTContainer findContainer(Component aComponent) {
        int i = this.getComponentCount() - 1;
        while (i >= 0) {
            FreeFormAWTContainer freeFormContainer = (FreeFormAWTContainer)this.getComponent(i);
            if (freeFormContainer.getComponentCount() == 0) {
                super.remove(freeFormContainer);
            } else if (freeFormContainer.getComponent(0) == aComponent) {
                return freeFormContainer;
            }
            --i;
        }
        return null;
    }

    public void setUseComponentSize(Component aComponent, boolean useComponentSize) {
        FreeFormAWTContainer f = this.findContainer(aComponent);
        if (f != null) {
            f.setUseComponentSize(useComponentSize);
        }
    }

    public void remove(Component aComponent) {
        FreeFormAWTContainer f = this.findContainer(aComponent);
        if (f != null) {
            super.remove(f);
        }
        this.pack();
    }

    public void validate() {
        boolean valid = this.isValid();
        super.validate();
        if (!valid) {
            Object object = this.getTreeLock();
            synchronized (object) {
                if (!this.isValidating) {
                    this.isValidating = true;
                    if (this.minSize != null) {
                        this.pack();
                    }
                }
                this.isValidating = false;
            }
        }
    }

    public Dimension getPreferredSize() {
        Dimension calc = super.getPreferredSize();
        if (this.minSize != null) {
            calc.width = Math.max(this.minSize.width, calc.width);
            calc.height = Math.max(this.minSize.height, calc.height);
        }
        return calc;
    }
}

