/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.beaninfo.impl;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EAnnotationImpl;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.jem.internal.beaninfo.BeaninfoFactory;
import org.eclipse.jem.internal.beaninfo.BeaninfoPackage;
import org.eclipse.jem.internal.beaninfo.MethodDecorator;
import org.eclipse.jem.internal.beaninfo.MethodProxy;
import org.eclipse.jem.internal.beaninfo.ParameterDecorator;
import org.eclipse.jem.internal.beaninfo.adapters.BeaninfoProxyConstants;
import org.eclipse.jem.internal.beaninfo.impl.FeatureDecoratorImpl;
import org.eclipse.jem.internal.proxy.core.IArrayBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.ThrowableProxy;
import org.eclipse.jem.java.JavaParameter;
import org.eclipse.jem.java.Method;

public class MethodDecoratorImpl
extends FeatureDecoratorImpl
implements MethodDecorator {
    protected static final boolean PARMS_EXPLICIT_EDEFAULT = false;
    protected boolean fRetrievedParms = false;
    protected boolean fRetrievedParmsSuccessful = false;
    protected boolean parmsExplicit = false;
    protected EList parameterDescriptors = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    protected MethodDecoratorImpl() {
    }

    protected EClass eStaticClass() {
        return BeaninfoPackage.eINSTANCE.getMethodDecorator();
    }

    public EList getParameterDescriptors() {
        if (!this.isParmsExplicit()) {
            if (this.validProxy(this.fFeatureProxy) && !this.fRetrievedParms) {
                this.fRetrievedParms = true;
                EList parmsList = this.getParameterDescriptorsGen();
                try {
                    IArrayBeanProxy parms = (IArrayBeanProxy)BeaninfoProxyConstants.getConstants(this.fFeatureProxy.getProxyFactoryRegistry()).getParameterDescriptorsProxy().invoke(this.fFeatureProxy);
                    if (parms != null) {
                        List plist = this.getMethodParameters();
                        int plistLength = plist != null ? plist.size() : 0;
                        int parmsLength = Math.min(parms.getLength(), plistLength);
                        int i = 0;
                        while (i < parmsLength) {
                            IBeanProxy parm = parms.get(i);
                            ParameterDecorator pd = BeaninfoFactory.eINSTANCE.createParameterDecorator();
                            pd.setImplicitlyCreated(1);
                            pd.setDescriptorProxy(parm);
                            parmsList.add((Object)pd);
                            pd.setParameter((JavaParameter)plist.get(i));
                            ++i;
                        }
                        this.fRetrievedParmsSuccessful = true;
                        return parmsList;
                    }
                }
                catch (ThrowableProxy throwableProxy) {}
            }
            if (this.fRetrievedParmsSuccessful) {
                return this.getParameterDescriptorsGen();
            }
            return this.createDefaultParmsList();
        }
        return this.getParameterDescriptorsGen();
    }

    protected EList createDefaultParmsList() {
        EList parmsList = this.getParameterDescriptorsGen();
        parmsList.clear();
        List p = this.getMethodParameters();
        if (p == null) {
            return parmsList;
        }
        int psize = p.size();
        int i = 0;
        while (i < psize) {
            ParameterDecorator pd = BeaninfoFactory.eINSTANCE.createParameterDecorator();
            JavaParameter jp = (JavaParameter)p.get(i);
            pd.setName(jp.getName());
            pd.setParameter(jp);
            parmsList.add((Object)pd);
            ++i;
        }
        return parmsList;
    }

    protected void initializeParameters() {
        if (this.parameterDescriptors == null) {
            return;
        }
        List mp = this.getMethodParameters();
        if (mp == null || mp.isEmpty()) {
            return;
        }
        int psize = Math.min(this.parameterDescriptors.size(), mp.size());
        int i = 0;
        while (i < psize) {
            ((ParameterDecorator)this.parameterDescriptors.get(i)).setParameter((JavaParameter)mp.get(i));
            ++i;
        }
    }

    protected List getMethodParameters() {
        Method m = null;
        EModelElement d = this.getEModelElement();
        if (d instanceof Method) {
            m = (Method)d;
        } else if (d instanceof MethodProxy) {
            m = ((MethodProxy)d).getMethod();
        } else {
            return null;
        }
        if (m == null) {
            return null;
        }
        EList p = m.getParameters();
        return p;
    }

    public void setDescriptorProxy(IBeanProxy descriptorProxy) {
        if (this.fRetrievedParms) {
            this.getParameterDescriptorsGen().clear();
            this.fRetrievedParmsSuccessful = false;
            this.fRetrievedParms = false;
        }
        super.setDescriptorProxy(descriptorProxy);
    }

    public boolean isParmsExplicit() {
        return this.parmsExplicit;
    }

    public void setParmsExplicit(boolean newParmsExplicit) {
        boolean oldParmsExplicit = this.parmsExplicit;
        this.parmsExplicit = newParmsExplicit;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 15, oldParmsExplicit, this.parmsExplicit));
        }
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (parmsExplicit: ");
        result.append(this.parmsExplicit);
        result.append(')');
        return result.toString();
    }

    public EList getParameterDescriptorsGen() {
        if (this.parameterDescriptors == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jem.internal.beaninfo.ParameterDecorator");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.parameterDescriptors = new EObjectContainmentEList((Class)clazz, (InternalEObject)this, 16);
        }
        return this.parameterDescriptors;
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 0: {
                    return ((InternalEList)this.getEAnnotations()).basicAdd((Object)otherEnd, msgs);
                }
                case 3: {
                    if (this.eContainer != null) {
                        msgs = this.eBasicRemoveFromContainer(msgs);
                    }
                    return this.eBasicSetContainer(otherEnd, 3, msgs);
                }
            }
            return this.eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
        }
        if (this.eContainer != null) {
            msgs = this.eBasicRemoveFromContainer(msgs);
        }
        return this.eBasicSetContainer(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 0: {
                    return ((InternalEList)this.getEAnnotations()).basicRemove((Object)otherEnd, msgs);
                }
                case 2: {
                    return ((InternalEList)this.getDetails()).basicRemove((Object)otherEnd, msgs);
                }
                case 3: {
                    return this.eBasicSetContainer(null, 3, msgs);
                }
                case 4: {
                    return ((InternalEList)this.getContents()).basicRemove((Object)otherEnd, msgs);
                }
                case 14: {
                    return ((InternalEList)this.getAttributes()).basicRemove((Object)otherEnd, msgs);
                }
                case 16: {
                    return ((InternalEList)this.getParameterDescriptors()).basicRemove((Object)otherEnd, msgs);
                }
            }
            return this.eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
        }
        return this.eBasicSetContainer(null, featureID, msgs);
    }

    public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
        block6: {
            if (this.eContainerFeatureID < 0) break block6;
            switch (this.eContainerFeatureID) {
                case 3: {
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = class$1 = Class.forName("org.eclipse.emf.ecore.EModelElement");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    return this.eContainer.eInverseRemove((InternalEObject)this, 0, (Class)clazz, msgs);
                }
            }
            return this.eDynamicBasicRemoveFromContainer(msgs);
        }
        return this.eContainer.eInverseRemove((InternalEObject)this, -1 - this.eContainerFeatureID, null, msgs);
    }

    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.getEAnnotations();
            }
            case 1: {
                return this.getSource();
            }
            case 2: {
                return this.getDetails();
            }
            case 3: {
                return this.getEModelElement();
            }
            case 4: {
                return this.getContents();
            }
            case 5: {
                return this.getReferences();
            }
            case 6: {
                return this.getDisplayName();
            }
            case 7: {
                return this.getShortDescription();
            }
            case 8: {
                return this.getCategory();
            }
            case 9: {
                return this.isExpert() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 10: {
                return this.isHidden() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 11: {
                return this.isPreferred() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 12: {
                return this.isMergeIntrospection() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 13: {
                return this.isAttributesExplicit() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 14: {
                return this.getAttributes();
            }
            case 15: {
                return this.isParmsExplicit() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 16: {
                return this.getParameterDescriptors();
            }
        }
        return this.eDynamicGet(eFeature, resolve);
    }

    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.getEAnnotations().clear();
                this.getEAnnotations().addAll((Collection)newValue);
                return;
            }
            case 1: {
                this.setSource((String)newValue);
                return;
            }
            case 2: {
                this.getDetails().clear();
                this.getDetails().addAll((Collection)newValue);
                return;
            }
            case 3: {
                this.setEModelElement((EModelElement)newValue);
                return;
            }
            case 4: {
                this.getContents().clear();
                this.getContents().addAll((Collection)newValue);
                return;
            }
            case 5: {
                this.getReferences().clear();
                this.getReferences().addAll((Collection)newValue);
                return;
            }
            case 6: {
                this.setDisplayName((String)newValue);
                return;
            }
            case 7: {
                this.setShortDescription((String)newValue);
                return;
            }
            case 8: {
                this.setCategory((String)newValue);
                return;
            }
            case 9: {
                this.setExpert((Boolean)newValue);
                return;
            }
            case 10: {
                this.setHidden((Boolean)newValue);
                return;
            }
            case 11: {
                this.setPreferred((Boolean)newValue);
                return;
            }
            case 12: {
                this.setMergeIntrospection((Boolean)newValue);
                return;
            }
            case 13: {
                this.setAttributesExplicit((Boolean)newValue);
                return;
            }
            case 14: {
                this.getAttributes().clear();
                this.getAttributes().addAll((Collection)newValue);
                return;
            }
            case 15: {
                this.setParmsExplicit((Boolean)newValue);
                return;
            }
            case 16: {
                this.getParameterDescriptors().clear();
                this.getParameterDescriptors().addAll((Collection)newValue);
                return;
            }
        }
        this.eDynamicSet(eFeature, newValue);
    }

    public void eUnset(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.getEAnnotations().clear();
                return;
            }
            case 1: {
                this.setSource(EAnnotationImpl.SOURCE_EDEFAULT);
                return;
            }
            case 2: {
                this.getDetails().clear();
                return;
            }
            case 3: {
                this.setEModelElement(null);
                return;
            }
            case 4: {
                this.getContents().clear();
                return;
            }
            case 5: {
                this.getReferences().clear();
                return;
            }
            case 6: {
                this.unsetDisplayName();
                return;
            }
            case 7: {
                this.unsetShortDescription();
                return;
            }
            case 8: {
                this.setCategory(FeatureDecoratorImpl.CATEGORY_EDEFAULT);
                return;
            }
            case 9: {
                this.unsetExpert();
                return;
            }
            case 10: {
                this.unsetHidden();
                return;
            }
            case 11: {
                this.unsetPreferred();
                return;
            }
            case 12: {
                this.setMergeIntrospection(true);
                return;
            }
            case 13: {
                this.setAttributesExplicit(false);
                return;
            }
            case 14: {
                this.getAttributes().clear();
                return;
            }
            case 15: {
                this.setParmsExplicit(false);
                return;
            }
            case 16: {
                this.getParameterDescriptors().clear();
                return;
            }
        }
        this.eDynamicUnset(eFeature);
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.eAnnotations != null && !this.eAnnotations.isEmpty();
            }
            case 1: {
                return EAnnotationImpl.SOURCE_EDEFAULT == null ? this.source != null : !EAnnotationImpl.SOURCE_EDEFAULT.equals(this.source);
            }
            case 2: {
                return this.details != null && !this.details.isEmpty();
            }
            case 3: {
                return this.getEModelElement() != null;
            }
            case 4: {
                return this.contents != null && !this.contents.isEmpty();
            }
            case 5: {
                return this.references != null && !this.references.isEmpty();
            }
            case 6: {
                return this.isSetDisplayName();
            }
            case 7: {
                return this.isSetShortDescription();
            }
            case 8: {
                return FeatureDecoratorImpl.CATEGORY_EDEFAULT == null ? this.category != null : !FeatureDecoratorImpl.CATEGORY_EDEFAULT.equals(this.category);
            }
            case 9: {
                return this.isSetExpert();
            }
            case 10: {
                return this.isSetHidden();
            }
            case 11: {
                return this.isSetPreferred();
            }
            case 12: {
                return !this.mergeIntrospection;
            }
            case 13: {
                return this.attributesExplicit;
            }
            case 14: {
                return this.attributes != null && !this.attributes.isEmpty();
            }
            case 15: {
                return this.parmsExplicit;
            }
            case 16: {
                return this.parameterDescriptors != null && !this.parameterDescriptors.isEmpty();
            }
        }
        return this.eDynamicIsSet(eFeature);
    }
}

