/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.swt.targetvm;

import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ve.internal.swt.targetvm.PreventShellCloseMinimizeListener;

public class Environment {
    private static Display display;
    private static Thread t;
    private static Shell freeFormHost;

    private static void initialize() {
        if (display != null) {
            return;
        }
        Thread thread = t = new Thread("SWT UI Thread for VE"){

            public void run() {
                Thread thread = Thread.currentThread();
                synchronized (thread) {
                    Environment.display = new Display();
                    Thread.currentThread().notifyAll();
                }
                while (true) {
                    try {
                        if (display.readAndDispatch()) continue;
                        display.sleep();
                        continue;
                    }
                    catch (RuntimeException e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        };
        synchronized (thread) {
            t.start();
            while (true) {
                try {
                    t.wait();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }

    public static Display getDisplay() {
        Environment.initialize();
        return display;
    }

    public static Shell getFreeFormHost(int x, int y) {
        if (freeFormHost == null) {
            Shell dialogParent = new Shell(display);
            freeFormHost = new Shell(dialogParent, 1264);
            freeFormHost.setBounds(0, 0, 100, 100);
            freeFormHost.setLocation(x, y);
            freeFormHost.addShellListener((ShellListener)new PreventShellCloseMinimizeListener());
            freeFormHost.open();
        }
        return freeFormHost;
    }

    public static String getFontLabel(Font aFont) {
        FontData fontData = aFont.getFontData()[0];
        StringBuffer fontLabelBuffer = new StringBuffer();
        fontLabelBuffer.append(fontData.getName());
        fontLabelBuffer.append(',');
        boolean styleUsed = false;
        if ((fontData.getStyle() & 1) != 0) {
            fontLabelBuffer.append("Bold");
            styleUsed = true;
        }
        if ((fontData.getStyle() & 2) != 0) {
            if (styleUsed) {
                fontLabelBuffer.append(' ');
            }
            fontLabelBuffer.append("Italic");
            styleUsed = true;
        }
        if (styleUsed) {
            fontLabelBuffer.append(',');
        }
        fontLabelBuffer.append(String.valueOf(fontData.getHeight()));
        return fontLabelBuffer.toString();
    }
}

