/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.swt.targetvm.win32;

import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.ole.win32.OleFrame;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ve.internal.swt.targetvm.IImageCapture;

public class ImageCapture
implements IImageCapture {
    Control controlToCapture;

    public Image getImage(Control control, boolean includeChildren) {
        Image myImage = this.getImage(control);
        if (control instanceof Composite && includeChildren) {
            Point clientOrigin = ImageCapture.getClientOrigin(control);
            Composite composite = (Composite)control;
            Control[] children = composite.getChildren();
            GC myImageGC = new GC((Drawable)myImage);
            int i = children.length;
            while (i > 0) {
                if (children[i - 1].isVisible()) {
                    Image childImage = this.getImage(children[i - 1], true);
                    Rectangle bounds = childImage.getBounds();
                    bounds.toString();
                    Point childCorner = children[i - 1].getLocation();
                    childCorner.x += clientOrigin.x;
                    childCorner.y += clientOrigin.y;
                    myImageGC.drawImage(childImage, childCorner.x, childCorner.y);
                    childImage.dispose();
                }
                --i;
            }
            myImageGC.dispose();
        }
        return myImage;
    }

    public Image getImage(Control aControl) {
        Rectangle rect = aControl.getBounds();
        if (rect.width <= 0 || rect.height <= 0) {
            return new Image((Device)aControl.getDisplay(), 1, 1);
        }
        Image image = new Image((Device)aControl.getDisplay(), rect.width, rect.height);
        int WM_PRINT = 791;
        int PRF_NONCLIENT = 2;
        int PRF_CLIENT = 4;
        int PRF_ERASEBKGND = 8;
        int PRF_CHILDREN = 16;
        int print_bits = PRF_NONCLIENT | PRF_CLIENT | PRF_ERASEBKGND;
        if (aControl instanceof Table || aControl instanceof Browser || aControl instanceof OleFrame) {
            print_bits |= PRF_CHILDREN;
        }
        GC gc = new GC((Drawable)image);
        OS.SendMessage((int)aControl.handle, (int)WM_PRINT, (int)gc.handle, (int)print_bits);
        gc.dispose();
        return image;
    }

    public Shell createShellToCapture(Display display) {
        Shell shell = new Shell(display);
        Menu menuBar = new Menu((Decorations)shell, 2);
        shell.setMenuBar(menuBar);
        MenuItem fileItem = new MenuItem(menuBar, 64);
        fileItem.setText("File");
        Button b = new Button((Composite)shell, 8);
        b.setText("Foo");
        b.setBounds(20, 20, 50, 50);
        Group c = new Group((Composite)shell, 2048);
        c.setText("Group");
        c.setBackground(display.getSystemColor(5));
        c.setBounds(60, 40, 120, 80);
        c.setLayout((Layout)new GridLayout(1, false));
        Button male = new Button((Composite)c, 16);
        male.setText("Male");
        Button female = new Button((Composite)c, 16);
        female.setText("Female");
        c.layout();
        TabFolder tabFolder = new TabFolder((Composite)shell, 0);
        tabFolder.setBounds(20, 150, 150, 150);
        TabItem page1 = new TabItem(tabFolder, 0);
        List list = new List((Composite)tabFolder, 2048);
        list.add("First List Item");
        list.add("Second List Item");
        page1.setControl((Control)list);
        page1.setText("Page 1");
        TabItem page2 = new TabItem(tabFolder, 0);
        Label label1 = new Label((Composite)tabFolder, 0);
        label1.setText("Label");
        page2.setControl((Control)label1);
        page2.setText("Page 2");
        Table table = new Table((Composite)shell, 2048);
        TableColumn col1 = new TableColumn(table, 0);
        col1.setText("First");
        TableColumn col2 = new TableColumn(table, 0);
        col2.setText("Last");
        TableItem item1 = new TableItem(table, 0);
        item1.setText(new String[]{"Joe", "Gili"});
        TableItem item2 = new TableItem(table, 0);
        item2.setText(new String[]{"Winchester", "Mendel"});
        col1.pack();
        col2.pack();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        table.setBounds(200, 20, 100, 100);
        shell.setBackground(display.getSystemColor(9));
        shell.setText("Title");
        shell.setSize(400, 350);
        shell.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                System.out.println("PaintEvent called back clipped to " + e.gc.getClipping());
                e.gc.setForeground(e.display.getSystemColor(3));
                e.gc.drawLine(0, 0, 100, 100);
            }
        });
        this.controlToCapture = shell;
        return shell;
    }

    public Shell createShellToShowImage(Display display) {
        Shell targetShell = new Shell(display);
        targetShell.setLocation(500, 0);
        targetShell.setLayout((Layout)new GridLayout(1, false));
        Button grabButton = new Button((Composite)targetShell, 8);
        grabButton.setText("Grab image");
        Composite labelComposite = new Composite((Composite)targetShell, 0x100000);
        labelComposite.setBackground(display.getSystemColor(1));
        GridData data = new GridData(1808);
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.widthHint = 450;
        data.heightHint = 450;
        labelComposite.setLayoutData((Object)data);
        final Label l1 = new Label(labelComposite, 16384);
        l1.setBackground(display.getSystemColor(7));
        grabButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (l1.getImage() != null) {
                    l1.getImage().dispose();
                }
                Image newImage = ImageCapture.this.getImage(ImageCapture.this.controlToCapture, true);
                l1.setImage(newImage);
                l1.pack();
            }
        });
        targetShell.pack();
        return targetShell;
    }

    private static Point getClientOrigin(Control aControl) {
        Point displayClientOrigin = aControl.toDisplay(0, 0);
        Point locationRelativeToDisplay = aControl.getLocation();
        if (aControl.getParent() != null) {
            Point parentClientOrigin = aControl.getParent().toDisplay(0, 0);
            locationRelativeToDisplay = new Point(locationRelativeToDisplay.x + parentClientOrigin.x, locationRelativeToDisplay.y + parentClientOrigin.y);
        }
        return new Point(displayClientOrigin.x - locationRelativeToDisplay.x, displayClientOrigin.y - locationRelativeToDisplay.y);
    }
}

