/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.core;

import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.jem.internal.proxy.core.IArrayBeanTypeProxy;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanTypeProxy;
import org.eclipse.jem.internal.proxy.core.IExpression;
import org.eclipse.jem.internal.proxy.core.IStandardBeanProxyFactory;
import org.eclipse.jem.internal.proxy.core.ProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.core.ProxyMessages;
import org.eclipse.jem.internal.proxy.core.ThrowableProxy;
import org.eclipse.jem.internal.proxy.initParser.tree.IExpressionConstants;

public abstract class Expression
implements IExpression {
    private ArrayList controlStack = new ArrayList(30);
    protected final ProxyFactoryRegistry registry;
    protected final IStandardBeanProxyFactory beanProxyFactory;
    private static final Integer ARRAYACCESS = new Integer(1);
    private static final Integer ARRAYACCESS_INDEX_1 = new Integer(1);
    private static final Integer ARRAYCREATION = new Integer(2);
    private static final Integer ARRAY_CREATION_DIMENSION_1 = new Integer(1);
    private static final Integer ARRAY_CREATION_DIMENSION_0 = new Integer(0);
    private static final int ARRAY_INITIALIZER = -1;
    private static final Integer ARRAYINITIALIZER = new Integer(3);
    private static final Integer ARRAYINITIALIZER_COUNT_0 = new Integer(0);
    private static final Integer ARRAYINITIALIZER_COUNT_1 = new Integer(1);
    private static final Integer ARRAYINITIALIZER_COUNT_2 = new Integer(2);
    private static final Integer CAST = new Integer(4);
    private static final Integer CLASSINSTANCECREATION = new Integer(6);
    private static final Integer CLASS_INSTANCE_CREATION_ARGUMENTS_1 = new Integer(1);
    private static final Integer CLASS_INSTANCE_CREATION_ARGUMENTS_0 = new Integer(0);
    private static final Integer CONDITIONAL = new Integer(5);
    private static final Integer CONDITIONAL_TEST = new Integer(7);
    private static final Integer CONDITIONAL_TRUEEXP = new Integer(8);
    private static final Integer CONDITIONAL_FALSEXP = new Integer(9);
    private static final Integer PREFIX = new Integer(11);
    private static final Integer[] PREFIX_OPERATORS = new Integer[4];
    private static final Integer INFIX;
    private static final Integer IN_LEFT;
    private static final Integer IN_OTHER;
    private static final Integer IN_LAST;
    private static final Integer[] INFIX_OPERATORS;
    private static final Integer INSTANCEOF;
    private static final Integer FIELDACCESS;
    private static final Integer METHODINVOCATION;
    private static final Integer METHOD_ARGUMENTS_1;
    private static final Integer METHOD_ARGUMENTS_0;
    private int[] nextForExpressionStack = new int[30];
    private int nextForExpressionStackPos = -1;
    private static final int INVALID = -2;
    private String invalidMsg = null;
    private static final int PROCESS_EXPRESSION = Integer.MIN_VALUE;

    static {
        Expression.PREFIX_OPERATORS[0] = new Integer(0);
        Expression.PREFIX_OPERATORS[1] = new Integer(1);
        Expression.PREFIX_OPERATORS[2] = new Integer(2);
        Expression.PREFIX_OPERATORS[3] = new Integer(3);
        INFIX = new Integer(9);
        IN_LEFT = new Integer(0);
        IN_OTHER = new Integer(1);
        IN_LAST = new Integer(2);
        INFIX_OPERATORS = new Integer[19];
        Expression.INFIX_OPERATORS[15] = new Integer(15);
        Expression.INFIX_OPERATORS[17] = new Integer(17);
        Expression.INFIX_OPERATORS[18] = new Integer(18);
        Expression.INFIX_OPERATORS[1] = new Integer(1);
        Expression.INFIX_OPERATORS[12] = new Integer(12);
        Expression.INFIX_OPERATORS[9] = new Integer(9);
        Expression.INFIX_OPERATORS[11] = new Integer(11);
        Expression.INFIX_OPERATORS[5] = new Integer(5);
        Expression.INFIX_OPERATORS[8] = new Integer(8);
        Expression.INFIX_OPERATORS[10] = new Integer(10);
        Expression.INFIX_OPERATORS[4] = new Integer(4);
        Expression.INFIX_OPERATORS[13] = new Integer(13);
        Expression.INFIX_OPERATORS[16] = new Integer(16);
        Expression.INFIX_OPERATORS[3] = new Integer(3);
        Expression.INFIX_OPERATORS[2] = new Integer(2);
        Expression.INFIX_OPERATORS[6] = new Integer(6);
        Expression.INFIX_OPERATORS[7] = new Integer(7);
        Expression.INFIX_OPERATORS[0] = new Integer(0);
        Expression.INFIX_OPERATORS[14] = new Integer(14);
        INSTANCEOF = new Integer(8);
        FIELDACCESS = new Integer(7);
        METHODINVOCATION = new Integer(10);
        METHOD_ARGUMENTS_1 = new Integer(1);
        METHOD_ARGUMENTS_0 = new Integer(0);
    }

    protected final void push(Object o) {
        this.controlStack.add(o);
    }

    protected final Object pop() {
        return this.controlStack.remove(this.controlStack.size() - 1);
    }

    protected final Object peek(int fromTop) {
        return this.controlStack.get(this.controlStack.size() - fromTop);
    }

    protected final void checkForExpression(int forExpression) throws IllegalStateException {
        if (this.nextForExpressionStackPos != -2) {
            if (this.nextForExpressionStackPos == -1 ? forExpression == 0 : this.nextForExpressionStack[this.nextForExpressionStackPos--] == forExpression) {
                return;
            }
        } else {
            String expMsg = this.invalidMsg != null ? MessageFormat.format(ProxyMessages.getString("Expression.InInvalidStateDueTo_EXC_"), this.invalidMsg) : ProxyMessages.getString("Expression.InInvalidState_EXC_");
            throw new IllegalStateException(expMsg);
        }
        this.nextForExpressionStackPos = -2;
        throw new IllegalStateException(ProxyMessages.getString("Expression.TypeSentInInvalidOrder_EXC_"));
    }

    protected final boolean peekForExpression(int forExpression) {
        return this.nextForExpressionStackPos != -2 && (this.nextForExpressionStackPos == -1 ? forExpression == 0 : this.nextForExpressionStack[this.nextForExpressionStackPos] == forExpression);
    }

    protected final void markInvalid() {
        this.nextForExpressionStackPos = -2;
        this.controlStack.clear();
        this.closeProxy();
    }

    protected final void markInvalid(String msg) {
        this.invalidMsg = msg;
        this.markInvalid();
    }

    private boolean expressionReady() {
        if (this.nextForExpressionStackPos >= 0 && this.nextForExpressionStack[this.nextForExpressionStackPos] == Integer.MIN_VALUE) {
            this.checkForExpression(Integer.MIN_VALUE);
            return true;
        }
        return false;
    }

    private void pushForExpression(int nextExpression) {
        if (++this.nextForExpressionStackPos >= this.nextForExpressionStack.length) {
            int[] newStack = new int[this.nextForExpressionStackPos * 2];
            System.arraycopy(this.nextForExpressionStack, 0, newStack, 0, this.nextForExpressionStack.length);
            this.nextForExpressionStack = newStack;
        }
        this.nextForExpressionStack[this.nextForExpressionStackPos] = nextExpression;
    }

    private void processExpression() throws ThrowableProxy, IExpressionConstants.NoExpressionValueException {
        while (this.expressionReady()) {
            try {
                int expType = (Integer)this.pop();
                switch (expType) {
                    case 4: {
                        this.pushCastToProxy(this.pop());
                        break;
                    }
                    case 8: {
                        this.pushInstanceofToProxy(this.pop());
                        break;
                    }
                    case 11: {
                        this.pushPrefixToProxy((Integer)this.pop());
                        break;
                    }
                    case 9: {
                        this.pushInfixToProxy((Integer)this.pop(), (Integer)this.pop());
                        break;
                    }
                    case 1: {
                        this.pushArrayAccessToProxy((Integer)this.pop());
                        break;
                    }
                    case 2: {
                        this.pushArrayCreationToProxy(this.pop(), (Integer)this.pop());
                        break;
                    }
                    case 3: {
                        this.pushArrayInitializerToProxy(this.pop(), (Integer)this.pop());
                        break;
                    }
                    case 6: {
                        this.pushClassInstanceCreationToProxy(this.pop(), (Integer)this.pop());
                        break;
                    }
                    case 7: {
                        this.pushFieldAccessToProxy((String)this.pop(), (Boolean)this.pop());
                        break;
                    }
                    case 10: {
                        this.pushMethodInvocationToProxy((String)this.pop(), (Boolean)this.pop(), (Integer)this.pop());
                        break;
                    }
                    case 5: {
                        this.pushConditionalToProxy((Integer)this.pop());
                        break;
                    }
                    default: {
                        this.internalProcessUnknownExpressionType(expType);
                        break;
                    }
                }
            }
            catch (ThrowableProxy e) {
                this.markInvalid();
                throw e;
            }
            catch (IExpressionConstants.NoExpressionValueException e) {
                this.markInvalid();
                throw e;
            }
            catch (RuntimeException e) {
                this.markInvalid();
                throw e;
            }
        }
    }

    private void internalProcessUnknownExpressionType(int expressionType) throws IllegalArgumentException {
        if (!this.processUnknownExpressionType(expressionType)) {
            throw new IllegalArgumentException();
        }
    }

    protected boolean processUnknownExpressionType(int expressionType) {
        return false;
    }

    protected Expression(ProxyFactoryRegistry registry) {
        this.registry = registry;
        this.beanProxyFactory = this.registry.getBeanProxyFactory();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void invokeExpression() throws ThrowableProxy, IllegalStateException, IExpressionConstants.NoExpressionValueException {
        try {
            this.checkForExpression(0);
            this.pushInvoke();
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.markInvalid();
            throw throwable;
        }
        {
            Object var1_3 = null;
            this.markInvalid();
            return;
        }
    }

    public final IBeanProxy getExpressionValue() throws ThrowableProxy, IExpressionConstants.NoExpressionValueException, IllegalStateException {
        try {
            this.checkForExpression(0);
            IBeanProxy iBeanProxy = this.pullProxyValue();
            Object var1_2 = null;
            this.markInvalid();
            return iBeanProxy;
        }
        catch (Throwable throwable) {
            Object var1_3 = null;
            this.markInvalid();
            throw throwable;
        }
    }

    public final void createArrayAccess(int forExpression, int indexCount) throws IllegalStateException, ThrowableProxy, IExpressionConstants.NoExpressionValueException {
        try {
            this.checkForExpression(forExpression);
            this.pushForExpression(Integer.MIN_VALUE);
            int i = indexCount;
            while (i-- > 0) {
                this.pushForExpression(2);
            }
            this.pushForExpression(1);
            this.push(indexCount == 1 ? ARRAYACCESS_INDEX_1 : new Integer(indexCount));
            this.push(ARRAYACCESS);
            this.processExpression();
        }
        catch (ThrowableProxy e) {
            this.markInvalid();
            throw e;
        }
        catch (IExpressionConstants.NoExpressionValueException e) {
            this.markInvalid();
            throw e;
        }
        catch (RuntimeException e) {
            this.markInvalid();
            throw e;
        }
    }

    public final void createArrayCreation(int forExpression, String type, int dimensionExpressionCount) throws ThrowableProxy, IllegalStateException, IExpressionConstants.NoExpressionValueException {
        try {
            this.checkForExpression(forExpression);
            this.pushArrayCreation(type, dimensionExpressionCount);
            this.processExpression();
        }
        catch (ThrowableProxy e) {
            this.markInvalid();
            throw e;
        }
        catch (IExpressionConstants.NoExpressionValueException e) {
            this.markInvalid();
            throw e;
        }
        catch (RuntimeException e) {
            this.markInvalid();
            throw e;
        }
    }

    public final void createArrayCreation(int forExpression, IBeanTypeProxy type, int dimensionExpressionCount) throws ThrowableProxy, IllegalStateException, IExpressionConstants.NoExpressionValueException {
        try {
            this.checkForExpression(forExpression);
            this.pushArrayCreation(type, dimensionExpressionCount);
            this.processExpression();
        }
        catch (ThrowableProxy e) {
            this.markInvalid();
            throw e;
        }
        catch (IExpressionConstants.NoExpressionValueException e) {
            this.markInvalid();
            throw e;
        }
        catch (RuntimeException e) {
            this.markInvalid();
            throw e;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void pushArrayCreation(Object type, int dimensionExpressionCount) {
        block5: {
            switch (dimensionExpressionCount) {
                case 0: {
                    this.push(Expression.ARRAY_CREATION_DIMENSION_0);
                    break;
                }
                case 1: {
                    this.push(Expression.ARRAY_CREATION_DIMENSION_1);
                    break;
                }
                default: {
                    this.push(new Integer(dimensionExpressionCount));
                }
            }
            this.push(type);
            this.push(Expression.ARRAYCREATION);
            this.pushForExpression(-2147483648);
            if (dimensionExpressionCount != 0) ** GOTO lbl17
            this.pushForExpression(-1);
            break block5;
lbl-1000:
            // 1 sources

            {
                this.pushForExpression(3);
lbl17:
                // 2 sources

                ** while (dimensionExpressionCount-- > 0)
            }
        }
    }

    public final void createArrayInitializer(int expressionCount) throws ThrowableProxy, IllegalStateException, IExpressionConstants.NoExpressionValueException {
        try {
            if (this.peekForExpression(-1)) {
                this.checkForExpression(-1);
            } else {
                this.checkForExpression(4);
            }
            Object arrayType = this.peek(2);
            switch (expressionCount) {
                case 0: {
                    this.push(ARRAYINITIALIZER_COUNT_0);
                    break;
                }
                case 1: {
                    this.push(ARRAYINITIALIZER_COUNT_1);
                    break;
                }
                case 2: {
                    this.push(ARRAYINITIALIZER_COUNT_2);
                    break;
                }
                default: {
                    this.push(new Integer(expressionCount));
                }
            }
            if (arrayType instanceof String) {
                String at = (String)arrayType;
                int i = at.lastIndexOf("[]");
                if (i == -1) {
                    throw new IllegalArgumentException(MessageFormat.format(ProxyMessages.getString("Expression.ArrayTypeNotAnArray_EXC_"), arrayType));
                }
                arrayType = at.substring(0, i);
            } else if (arrayType instanceof IArrayBeanTypeProxy) {
                arrayType = ((IArrayBeanTypeProxy)arrayType).getComponentType();
            } else {
                throw new IllegalArgumentException(MessageFormat.format(ProxyMessages.getString("Expression.ArrayTypeNotAnArray_EXC_"), arrayType));
            }
            this.push(arrayType);
            this.push(ARRAYINITIALIZER);
            this.pushForExpression(Integer.MIN_VALUE);
            while (expressionCount-- > 0) {
                this.pushForExpression(4);
            }
            this.processExpression();
        }
        catch (ThrowableProxy e) {
            this.markInvalid();
            throw e;
        }
        catch (IExpressionConstants.NoExpressionValueException e) {
            this.markInvalid();
            throw e;
        }
        catch (RuntimeException e) {
            this.markInvalid();
            throw e;
        }
    }

    public final void createCastExpression(int forExpression, String type) throws IllegalStateException, ThrowableProxy, IExpressionConstants.NoExpressionValueException {
        this.pushCast(forExpression, type);
    }

    public final void createCastExpression(int forExpression, IBeanTypeProxy type) throws IllegalStateException, ThrowableProxy, IExpressionConstants.NoExpressionValueException {
        this.pushCast(forExpression, type);
    }

    private void pushCast(int forExpression, Object type) throws ThrowableProxy, IExpressionConstants.NoExpressionValueException {
        try {
            this.checkForExpression(forExpression);
            this.push(type);
            this.push(CAST);
            this.pushForExpression(Integer.MIN_VALUE);
            this.pushForExpression(5);
            this.processExpression();
        }
        catch (ThrowableProxy e) {
            this.markInvalid();
            throw e;
        }
        catch (IExpressionConstants.NoExpressionValueException e) {
            this.markInvalid();
            throw e;
        }
        catch (RuntimeException e) {
            this.markInvalid();
            throw e;
        }
    }

    public final void createClassInstanceCreation(int forExpression, String type, int argumentCount) throws ThrowableProxy, IllegalStateException, IExpressionConstants.NoExpressionValueException {
        this.pushClassInstanceCreation(forExpression, type, argumentCount);
    }

    public final void createClassInstanceCreation(int forExpression, IBeanTypeProxy type, int argumentCount) throws ThrowableProxy, IllegalStateException, IExpressionConstants.NoExpressionValueException {
        this.pushClassInstanceCreation(forExpression, type, argumentCount);
    }

    private void pushClassInstanceCreation(int forExpression, Object type, int argumentCount) throws ThrowableProxy, IExpressionConstants.NoExpressionValueException {
        try {
            this.checkForExpression(forExpression);
            switch (argumentCount) {
                case 0: {
                    this.push(CLASS_INSTANCE_CREATION_ARGUMENTS_0);
                    break;
                }
                case 1: {
                    this.push(CLASS_INSTANCE_CREATION_ARGUMENTS_1);
                    break;
                }
                default: {
                    this.push(new Integer(argumentCount));
                }
            }
            this.push(type);
            this.push(CLASSINSTANCECREATION);
            this.pushForExpression(Integer.MIN_VALUE);
            while (argumentCount-- > 0) {
                this.pushForExpression(6);
            }
            this.processExpression();
        }
        catch (ThrowableProxy e) {
            this.markInvalid();
            throw e;
        }
        catch (IExpressionConstants.NoExpressionValueException e) {
            this.markInvalid();
            throw e;
        }
        catch (RuntimeException e) {
            this.markInvalid();
            throw e;
        }
    }

    public final void createConditionalExpression(int forExpression) throws IllegalStateException, ThrowableProxy, IExpressionConstants.NoExpressionValueException {
        try {
            this.checkForExpression(forExpression);
            this.pushForExpression(Integer.MIN_VALUE);
            this.pushForExpression(9);
            this.pushForExpression(Integer.MIN_VALUE);
            this.pushForExpression(8);
            this.pushForExpression(Integer.MIN_VALUE);
            this.pushForExpression(7);
            this.push(CONDITIONAL_FALSEXP);
            this.push(CONDITIONAL);
            this.push(CONDITIONAL_TRUEEXP);
            this.push(CONDITIONAL);
            this.push(CONDITIONAL_TEST);
            this.push(CONDITIONAL);
            this.processExpression();
        }
        catch (ThrowableProxy e) {
            this.markInvalid();
            throw e;
        }
        catch (IExpressionConstants.NoExpressionValueException e) {
            this.markInvalid();
            throw e;
        }
        catch (RuntimeException e) {
            this.markInvalid();
            throw e;
        }
    }

    public final void createFieldAccess(int forExpression, String fieldName, boolean hasReceiver) throws ThrowableProxy, IllegalStateException, IExpressionConstants.NoExpressionValueException {
        try {
            this.checkForExpression(forExpression);
            if (!hasReceiver) {
                throw new IllegalArgumentException(ProxyMessages.getString("Expression.CannotHandleNoReceiveOnFieldAccess_EXC_"));
            }
            this.push(hasReceiver ? Boolean.TRUE : Boolean.FALSE);
            this.push(fieldName);
            this.push(FIELDACCESS);
            this.pushForExpression(Integer.MIN_VALUE);
            if (hasReceiver) {
                this.pushForExpression(10);
            }
            this.processExpression();
        }
        catch (ThrowableProxy e) {
            this.markInvalid();
            throw e;
        }
        catch (IExpressionConstants.NoExpressionValueException e) {
            this.markInvalid();
            throw e;
        }
        catch (RuntimeException e) {
            this.markInvalid();
            throw e;
        }
    }

    public final void createInfixExpression(int forExpression, int operator, int extendedOperandCount) throws IllegalStateException, ThrowableProxy, IExpressionConstants.NoExpressionValueException {
        try {
            this.checkForExpression(forExpression);
            Integer inoperator = INFIX_OPERATORS[operator];
            this.push(IN_LAST);
            this.push(inoperator);
            this.push(INFIX);
            int i = extendedOperandCount;
            while (i-- > 0) {
                this.push(IN_OTHER);
                this.push(inoperator);
                this.push(INFIX);
            }
            this.push(IN_LEFT);
            this.push(inoperator);
            this.push(INFIX);
            i = extendedOperandCount;
            while (i-- > 0) {
                this.pushForExpression(Integer.MIN_VALUE);
                this.pushForExpression(13);
            }
            this.pushForExpression(Integer.MIN_VALUE);
            this.pushForExpression(12);
            this.pushForExpression(Integer.MIN_VALUE);
            this.pushForExpression(11);
            this.processExpression();
        }
        catch (ThrowableProxy e) {
            this.markInvalid();
            throw e;
        }
        catch (IExpressionConstants.NoExpressionValueException e) {
            this.markInvalid();
            throw e;
        }
        catch (RuntimeException e) {
            this.markInvalid();
            throw e;
        }
    }

    public final void createInstanceofExpression(int forExpression, String type) throws IllegalStateException, ThrowableProxy, IExpressionConstants.NoExpressionValueException {
        this.pushInstanceof(forExpression, type);
    }

    public final void createInstanceofExpression(int forExpression, IBeanTypeProxy type) throws IllegalStateException, ThrowableProxy, IExpressionConstants.NoExpressionValueException {
        this.pushInstanceof(forExpression, type);
    }

    private void pushInstanceof(int forExpression, Object type) throws ThrowableProxy, IExpressionConstants.NoExpressionValueException {
        try {
            this.checkForExpression(forExpression);
            this.push(type);
            this.push(INSTANCEOF);
            this.pushForExpression(Integer.MIN_VALUE);
            this.pushForExpression(14);
            this.processExpression();
        }
        catch (ThrowableProxy e) {
            this.markInvalid();
            throw e;
        }
        catch (IExpressionConstants.NoExpressionValueException e) {
            this.markInvalid();
            throw e;
        }
        catch (RuntimeException e) {
            this.markInvalid();
            throw e;
        }
    }

    public final void createMethodInvocation(int forExpression, String name, boolean hasReceiver, int argumentCount) throws ThrowableProxy, IllegalStateException, IExpressionConstants.NoExpressionValueException {
        try {
            this.checkForExpression(forExpression);
            if (!hasReceiver) {
                throw new IllegalArgumentException(MessageFormat.format(ProxyMessages.getString("Expression.MethodsNeedReceiver_EXC_"), name));
            }
            switch (argumentCount) {
                case 0: {
                    this.push(METHOD_ARGUMENTS_0);
                    break;
                }
                case 1: {
                    this.push(METHOD_ARGUMENTS_1);
                    break;
                }
                default: {
                    this.push(new Integer(argumentCount));
                }
            }
            this.push(hasReceiver ? Boolean.TRUE : Boolean.FALSE);
            this.push(name);
            this.push(METHODINVOCATION);
            this.pushForExpression(Integer.MIN_VALUE);
            while (argumentCount-- > 0) {
                this.pushForExpression(16);
            }
            if (hasReceiver) {
                this.pushForExpression(15);
            }
            this.processExpression();
        }
        catch (ThrowableProxy e) {
            throw e;
        }
        catch (IExpressionConstants.NoExpressionValueException e) {
            this.markInvalid();
            throw e;
        }
        catch (RuntimeException e) {
            this.markInvalid();
            throw e;
        }
    }

    public final void createPrefixExpression(int forExpression, int operator) throws IllegalStateException, ThrowableProxy, IExpressionConstants.NoExpressionValueException {
        try {
            this.checkForExpression(forExpression);
            this.push(PREFIX_OPERATORS[operator]);
            this.push(PREFIX);
            this.pushForExpression(Integer.MIN_VALUE);
            this.pushForExpression(17);
            this.processExpression();
        }
        catch (ThrowableProxy e) {
            throw e;
        }
        catch (IExpressionConstants.NoExpressionValueException e) {
            this.markInvalid();
            throw e;
        }
        catch (RuntimeException e) {
            this.markInvalid();
            throw e;
        }
    }

    public final void createNull(int forExpression) throws IllegalStateException, ThrowableProxy, IExpressionConstants.NoExpressionValueException {
        try {
            this.checkForExpression(forExpression);
            this.pushToProxy(null);
            this.processExpression();
        }
        catch (ThrowableProxy e) {
            this.markInvalid();
            throw e;
        }
        catch (IExpressionConstants.NoExpressionValueException e) {
            this.markInvalid();
            throw e;
        }
        catch (RuntimeException e) {
            this.markInvalid();
            throw e;
        }
    }

    public final void createTypeLiteral(int forExpression, String type) throws IllegalStateException, ThrowableProxy, IExpressionConstants.NoExpressionValueException {
        try {
            this.checkForExpression(forExpression);
            this.pushTypeLiteralToProxy(type);
            this.processExpression();
        }
        catch (ThrowableProxy e) {
            this.markInvalid();
            throw e;
        }
        catch (IExpressionConstants.NoExpressionValueException e) {
            this.markInvalid();
            throw e;
        }
        catch (RuntimeException e) {
            this.markInvalid();
            throw e;
        }
    }

    public final void createTypeReceiver(String type) throws ThrowableProxy, IllegalStateException, IExpressionConstants.NoExpressionValueException {
        this.pushTypeReceiver(type);
    }

    public final void createTypeReceiver(IBeanTypeProxy type) throws ThrowableProxy, IllegalStateException, IExpressionConstants.NoExpressionValueException {
        this.pushTypeReceiver(type);
    }

    private void pushTypeReceiver(Object type) throws ThrowableProxy, IExpressionConstants.NoExpressionValueException {
        try {
            if (this.peekForExpression(10)) {
                this.checkForExpression(10);
            } else {
                this.checkForExpression(15);
            }
            this.pushTypeReceiverToProxy(type);
            this.processExpression();
        }
        catch (ThrowableProxy e) {
            this.markInvalid();
            throw e;
        }
        catch (IExpressionConstants.NoExpressionValueException e) {
            this.markInvalid();
            throw e;
        }
        catch (RuntimeException e) {
            this.markInvalid();
            throw e;
        }
    }

    public final void createPrimitiveLiteral(int forExpression, boolean value) throws IllegalStateException, ThrowableProxy, IExpressionConstants.NoExpressionValueException {
        try {
            this.checkForExpression(forExpression);
            this.pushToProxy(this.beanProxyFactory.createBeanProxyWith(value));
            this.processExpression();
        }
        catch (ThrowableProxy e) {
            this.markInvalid();
            throw e;
        }
        catch (IExpressionConstants.NoExpressionValueException e) {
            this.markInvalid();
            throw e;
        }
        catch (RuntimeException e) {
            this.markInvalid();
            throw e;
        }
    }

    public final void createPrimitiveLiteral(int forExpression, char value) throws IllegalStateException, ThrowableProxy, IExpressionConstants.NoExpressionValueException {
        try {
            this.checkForExpression(forExpression);
            this.pushToProxy(this.beanProxyFactory.createBeanProxyWith(value));
            this.processExpression();
        }
        catch (ThrowableProxy e) {
            this.markInvalid();
            throw e;
        }
        catch (IExpressionConstants.NoExpressionValueException e) {
            this.markInvalid();
            throw e;
        }
        catch (RuntimeException e) {
            this.markInvalid();
            throw e;
        }
    }

    public final void createPrimitiveLiteral(int forExpression, byte value) throws IllegalStateException, ThrowableProxy, IExpressionConstants.NoExpressionValueException {
        try {
            this.checkForExpression(forExpression);
            this.pushToProxy(this.beanProxyFactory.createBeanProxyWith(value));
            this.processExpression();
        }
        catch (ThrowableProxy e) {
            this.markInvalid();
            throw e;
        }
        catch (IExpressionConstants.NoExpressionValueException e) {
            this.markInvalid();
            throw e;
        }
        catch (RuntimeException e) {
            this.markInvalid();
            throw e;
        }
    }

    public final void createPrimitiveLiteral(int forExpression, double value) throws IllegalStateException, ThrowableProxy, IExpressionConstants.NoExpressionValueException {
        try {
            this.checkForExpression(forExpression);
            this.pushToProxy(this.beanProxyFactory.createBeanProxyWith(value));
            this.processExpression();
        }
        catch (ThrowableProxy e) {
            this.markInvalid();
            throw e;
        }
        catch (IExpressionConstants.NoExpressionValueException e) {
            this.markInvalid();
            throw e;
        }
        catch (RuntimeException e) {
            this.markInvalid();
            throw e;
        }
    }

    public final void createPrimitiveLiteral(int forExpression, float value) throws IllegalStateException, ThrowableProxy, IExpressionConstants.NoExpressionValueException {
        try {
            this.checkForExpression(forExpression);
            this.pushToProxy(this.beanProxyFactory.createBeanProxyWith(value));
            this.processExpression();
        }
        catch (ThrowableProxy e) {
            this.markInvalid();
            throw e;
        }
        catch (IExpressionConstants.NoExpressionValueException e) {
            this.markInvalid();
            throw e;
        }
        catch (RuntimeException e) {
            this.markInvalid();
            throw e;
        }
    }

    public final void createPrimitiveLiteral(int forExpression, int value) throws IllegalStateException, ThrowableProxy, IExpressionConstants.NoExpressionValueException {
        try {
            this.checkForExpression(forExpression);
            this.pushToProxy(this.beanProxyFactory.createBeanProxyWith(value));
            this.processExpression();
        }
        catch (ThrowableProxy e) {
            this.markInvalid();
            throw e;
        }
        catch (IExpressionConstants.NoExpressionValueException e) {
            this.markInvalid();
            throw e;
        }
        catch (RuntimeException e) {
            this.markInvalid();
            throw e;
        }
    }

    public final void createPrimitiveLiteral(int forExpression, long value) throws IllegalStateException, ThrowableProxy, IExpressionConstants.NoExpressionValueException {
        try {
            this.checkForExpression(forExpression);
            this.pushToProxy(this.beanProxyFactory.createBeanProxyWith(value));
            this.processExpression();
        }
        catch (ThrowableProxy e) {
            this.markInvalid();
            throw e;
        }
        catch (IExpressionConstants.NoExpressionValueException e) {
            this.markInvalid();
            throw e;
        }
        catch (RuntimeException e) {
            this.markInvalid();
            throw e;
        }
    }

    public final void createPrimitiveLiteral(int forExpression, short value) throws IllegalStateException, ThrowableProxy, IExpressionConstants.NoExpressionValueException {
        try {
            this.checkForExpression(forExpression);
            this.pushToProxy(this.beanProxyFactory.createBeanProxyWith(value));
            this.processExpression();
        }
        catch (ThrowableProxy e) {
            this.markInvalid();
            throw e;
        }
        catch (IExpressionConstants.NoExpressionValueException e) {
            this.markInvalid();
            throw e;
        }
        catch (RuntimeException e) {
            this.markInvalid();
            throw e;
        }
    }

    public final void createStringLiteral(int forExpression, String value) throws IllegalStateException, ThrowableProxy, IExpressionConstants.NoExpressionValueException {
        try {
            this.checkForExpression(forExpression);
            this.pushToProxy(this.beanProxyFactory.createBeanProxyWith(value));
            this.processExpression();
        }
        catch (ThrowableProxy e) {
            this.markInvalid();
            throw e;
        }
        catch (IExpressionConstants.NoExpressionValueException e) {
            this.markInvalid();
            throw e;
        }
        catch (RuntimeException e) {
            this.markInvalid();
            throw e;
        }
    }

    public final void createProxyExpression(int forExpression, IBeanProxy proxy) throws IllegalStateException, ThrowableProxy, IExpressionConstants.NoExpressionValueException {
        try {
            this.checkForExpression(forExpression);
            this.pushToProxy(proxy);
            this.processExpression();
        }
        catch (ThrowableProxy e) {
            this.markInvalid();
            throw e;
        }
        catch (IExpressionConstants.NoExpressionValueException e) {
            this.markInvalid();
            throw e;
        }
        catch (RuntimeException e) {
            this.markInvalid();
            throw e;
        }
    }

    protected abstract void pushToProxy(IBeanProxy var1) throws ThrowableProxy;

    protected abstract void closeProxy();

    protected abstract void pushInvoke() throws ThrowableProxy, IExpressionConstants.NoExpressionValueException;

    protected abstract IBeanProxy pullProxyValue() throws ThrowableProxy, IExpressionConstants.NoExpressionValueException;

    protected abstract void pushCastToProxy(Object var1) throws ThrowableProxy, IExpressionConstants.NoExpressionValueException;

    protected abstract void pushInstanceofToProxy(Object var1) throws ThrowableProxy, IExpressionConstants.NoExpressionValueException;

    protected abstract void pushInfixToProxy(int var1, int var2) throws ThrowableProxy, IExpressionConstants.NoExpressionValueException;

    protected abstract void pushPrefixToProxy(int var1) throws ThrowableProxy, IExpressionConstants.NoExpressionValueException;

    protected abstract void pushTypeLiteralToProxy(String var1) throws ThrowableProxy;

    protected abstract void pushArrayAccessToProxy(int var1) throws ThrowableProxy, IExpressionConstants.NoExpressionValueException;

    protected abstract void pushArrayCreationToProxy(Object var1, int var2) throws ThrowableProxy, IExpressionConstants.NoExpressionValueException;

    protected abstract void pushArrayInitializerToProxy(Object var1, int var2) throws ThrowableProxy, IExpressionConstants.NoExpressionValueException;

    protected abstract void pushClassInstanceCreationToProxy(Object var1, int var2) throws ThrowableProxy, IExpressionConstants.NoExpressionValueException;

    protected abstract void pushTypeReceiverToProxy(Object var1) throws ThrowableProxy;

    protected abstract void pushFieldAccessToProxy(String var1, boolean var2) throws ThrowableProxy, IExpressionConstants.NoExpressionValueException;

    protected abstract void pushMethodInvocationToProxy(String var1, boolean var2, int var3) throws ThrowableProxy, IExpressionConstants.NoExpressionValueException;

    protected abstract void pushConditionalToProxy(int var1) throws ThrowableProxy, IExpressionConstants.NoExpressionValueException;
}

