/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.propertysheet;

import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ve.internal.propertysheet.MinmaxValidator;
import org.eclipse.ve.internal.propertysheet.ObjectCellEditor;
import org.eclipse.ve.internal.propertysheet.PropertysheetMessages;

public class NumberCellEditor
extends ObjectCellEditor
implements IExecutableExtension {
    public static final int NUMBER = 0;
    public static final int BYTE = 1;
    public static final int DOUBLE = 2;
    public static final int FLOAT = 3;
    public static final int INTEGER = 4;
    public static final int LONG = 5;
    public static final int SHORT = 6;
    protected static final MinmaxValidator[] sMinMaxValidators;
    protected static final String sNotNumberError;
    protected static final String sNotIntegerError;
    protected NumberFormat fFormatter = NumberFormat.getInstance();
    protected int fNumberType;

    static {
        MinmaxValidator[] minmaxValidatorArray = new MinmaxValidator[7];
        minmaxValidatorArray[1] = new MinmaxValidator((Number)new Byte(-128), new Byte(127));
        minmaxValidatorArray[2] = new MinmaxValidator((Number)new Double(Double.MIN_VALUE), new Double(Double.MAX_VALUE));
        minmaxValidatorArray[3] = new MinmaxValidator((Number)new Float(Float.MIN_VALUE), new Float(Float.MAX_VALUE));
        minmaxValidatorArray[4] = new MinmaxValidator((Number)new Integer(Integer.MIN_VALUE), new Integer(Integer.MAX_VALUE));
        minmaxValidatorArray[5] = new MinmaxValidator((Number)new Long(Long.MIN_VALUE), new Long(Long.MAX_VALUE));
        minmaxValidatorArray[6] = new MinmaxValidator((Number)new Short(Short.MIN_VALUE), new Short(Short.MAX_VALUE));
        sMinMaxValidators = minmaxValidatorArray;
        sNotNumberError = PropertysheetMessages.getString("not_number_WARN_");
        sNotIntegerError = PropertysheetMessages.getString("not_integer_WARN_");
    }

    public NumberCellEditor(Composite parent) {
        super(parent);
        this.fFormatter.setMaximumFractionDigits(20);
        this.fFormatter.setMaximumIntegerDigits(20);
        this.fNumberType = 0;
    }

    public void setInitializationData(IConfigurationElement ce, String pName, Object initData) {
        if (initData instanceof String) {
            String type = ((String)initData).trim();
            if ("byte".equalsIgnoreCase(type)) {
                this.setType(1);
            } else if ("double".equalsIgnoreCase(type)) {
                this.setType(2);
            } else if ("float".equalsIgnoreCase(type)) {
                this.setType(3);
            } else if ("integer".equalsIgnoreCase(type)) {
                this.setType(4);
            } else if ("long".equalsIgnoreCase(type)) {
                this.setType(5);
            } else if ("short".equalsIgnoreCase(type)) {
                this.setType(6);
            }
        }
    }

    public void setType(int type) {
        switch (type) {
            case 0: 
            case 2: 
            case 3: {
                this.fFormatter.setParseIntegerOnly(false);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                this.fFormatter.setParseIntegerOnly(true);
                break;
            }
            default: {
                return;
            }
        }
        this.fNumberType = type;
    }

    protected String isCorrectObject(Object value) {
        return value == null || value instanceof Number ? null : (this.fFormatter.isParseIntegerOnly() ? sNotIntegerError : sNotNumberError);
    }

    protected String isCorrectString(String value) {
        Number result;
        block12: {
            String text = value.trim();
            result = null;
            if (!(this.fNumberType != 2 && this.fNumberType != 3 || text.indexOf(101) == -1 && text.indexOf(69) == -1)) {
                try {
                    if (this.fNumberType == 2) {
                        result = new Double(Double.parseDouble(text));
                        break block12;
                    }
                    result = new Float(Float.parseFloat(text));
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                ParsePosition parsePosition = new ParsePosition(0);
                result = this.fFormatter.parse(text, parsePosition);
                if (parsePosition.getErrorIndex() != -1 || parsePosition.getIndex() != text.length()) {
                    result = null;
                }
                if (this.fNumberType == 5 && result instanceof Double) {
                    Number number = result = result.doubleValue() < 0.0 ? MinmaxValidator.LONG_UNDERFLOW : MinmaxValidator.LONG_OVERFLOW;
                }
            }
        }
        if (result != null) {
            MinmaxValidator v = sMinMaxValidators[this.fNumberType];
            if (this.fNumberType == 2 || this.fNumberType == 3) {
                double d = result.doubleValue();
                if (d == 0.0 || d == -0.0) {
                    return null;
                }
                result = new Double(Math.abs(d));
            }
            if (v != null) {
                String e = v.isValid(result);
                if (e == null || e.length() == 0) {
                    return null;
                }
                return e;
            }
        }
        return this.fFormatter.isParseIntegerOnly() ? sNotIntegerError : sNotNumberError;
    }

    protected Object doGetObject(String v) {
        try {
            if (v == null) {
                return v;
            }
            Number n = null;
            switch (this.fNumberType) {
                case 1: {
                    n = new Byte(this.fFormatter.parse(v).byteValue());
                    break;
                }
                case 2: {
                    if (v.indexOf(69) == -1 && v.indexOf(101) == -1) {
                        n = new Double(this.fFormatter.parse(v).doubleValue());
                        break;
                    }
                    n = new Double(Double.parseDouble(v));
                    break;
                }
                case 3: {
                    if (v.indexOf(69) == -1 && v.indexOf(101) == -1) {
                        n = new Float(this.fFormatter.parse(v).floatValue());
                        break;
                    }
                    n = new Float(Float.parseFloat(v));
                    break;
                }
                case 4: {
                    n = new Integer(this.fFormatter.parse(v).intValue());
                    break;
                }
                case 5: {
                    n = new Long(this.fFormatter.parse(v).longValue());
                    break;
                }
                case 6: {
                    n = new Short(this.fFormatter.parse(v).shortValue());
                }
            }
            return n;
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    protected String doGetString(Object value) {
        if (value instanceof Number) {
            switch (this.fNumberType) {
                case 2: 
                case 3: {
                    String result = this.fFormatter.format(value);
                    try {
                        Number roundTrip = this.fFormatter.parse(result);
                        if (roundTrip.doubleValue() != ((Number)value).doubleValue()) {
                            result = value.toString();
                        }
                    }
                    catch (ParseException parseException) {
                        result = value.toString();
                    }
                    return result;
                }
            }
            return this.fFormatter.format(value);
        }
        return null;
    }
}

