/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.initParser.tree;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.jem.internal.proxy.initParser.EvaluationException;
import org.eclipse.jem.internal.proxy.initParser.MethodHelper;
import org.eclipse.jem.internal.proxy.initParser.tree.IExpressionConstants;
import org.eclipse.jem.internal.proxy.initParser.tree.InitparserTreeMessages;

public class ExpressionProcesser {
    private ArrayList expressionStack = new ArrayList(10);
    private ArrayList expressionTypeStack = new ArrayList(10);
    protected int ignoreExpression = 0;
    private static final String[] PRE_OPER_TO_STRING = new String[4];
    protected static final int BOOLEAN = 0;
    protected static final int BYTE = 1;
    protected static final int SHORT = 2;
    protected static final int CHAR = 3;
    protected static final int INT = 4;
    protected static final int LONG = 5;
    protected static final int FLOAT = 6;
    protected static final int DOUBLE = 7;
    private static final String[] IN_OPER_TO_STRING;
    static /* synthetic */ Class class$0;

    static {
        ExpressionProcesser.PRE_OPER_TO_STRING[0] = "+";
        ExpressionProcesser.PRE_OPER_TO_STRING[1] = "-";
        ExpressionProcesser.PRE_OPER_TO_STRING[2] = "~";
        ExpressionProcesser.PRE_OPER_TO_STRING[3] = "!";
        IN_OPER_TO_STRING = new String[19];
        ExpressionProcesser.IN_OPER_TO_STRING[15] = "&";
        ExpressionProcesser.IN_OPER_TO_STRING[17] = "&&";
        ExpressionProcesser.IN_OPER_TO_STRING[18] = "||";
        ExpressionProcesser.IN_OPER_TO_STRING[1] = "/";
        ExpressionProcesser.IN_OPER_TO_STRING[12] = "==";
        ExpressionProcesser.IN_OPER_TO_STRING[9] = ">";
        ExpressionProcesser.IN_OPER_TO_STRING[11] = ">=";
        ExpressionProcesser.IN_OPER_TO_STRING[5] = "<<";
        ExpressionProcesser.IN_OPER_TO_STRING[8] = "<";
        ExpressionProcesser.IN_OPER_TO_STRING[10] = "<=";
        ExpressionProcesser.IN_OPER_TO_STRING[4] = "-";
        ExpressionProcesser.IN_OPER_TO_STRING[13] = "!=";
        ExpressionProcesser.IN_OPER_TO_STRING[16] = "|";
        ExpressionProcesser.IN_OPER_TO_STRING[3] = "+";
        ExpressionProcesser.IN_OPER_TO_STRING[2] = "%";
        ExpressionProcesser.IN_OPER_TO_STRING[6] = ">>";
        ExpressionProcesser.IN_OPER_TO_STRING[7] = ">>>";
        ExpressionProcesser.IN_OPER_TO_STRING[0] = "*";
        ExpressionProcesser.IN_OPER_TO_STRING[14] = "^";
    }

    protected final void pushExpressionValue(Object o, Class type) {
        this.expressionStack.add(o);
        this.expressionTypeStack.add(type);
    }

    protected final Object popExpression() throws IExpressionConstants.NoExpressionValueException {
        try {
            return this.expressionStack.remove(this.expressionStack.size() - 1);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IExpressionConstants.NoExpressionValueException();
        }
    }

    protected final Object getExpression(int fromTop) throws IExpressionConstants.NoExpressionValueException {
        try {
            return this.expressionStack.get(this.expressionStack.size() - fromTop);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IExpressionConstants.NoExpressionValueException();
        }
    }

    protected final void popExpressions(int count) throws IExpressionConstants.NoExpressionValueException {
        try {
            int remove = this.expressionStack.size() - 1;
            while (count-- > 0) {
                this.expressionStack.remove(remove--);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IExpressionConstants.NoExpressionValueException();
        }
    }

    protected final Class popExpressionType(boolean allowVoid) throws IExpressionConstants.NoExpressionValueException {
        try {
            Class result = (Class)this.expressionTypeStack.remove(this.expressionTypeStack.size() - 1);
            if (!allowVoid && result == Void.TYPE) {
                throw new IExpressionConstants.NoExpressionValueException();
            }
            return result;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IExpressionConstants.NoExpressionValueException();
        }
    }

    protected final Class getExpressionType(int fromTop, boolean allowVoid) throws IExpressionConstants.NoExpressionValueException {
        try {
            Class result = (Class)this.expressionTypeStack.get(this.expressionTypeStack.size() - fromTop);
            if (!allowVoid && result == Void.TYPE) {
                throw new IExpressionConstants.NoExpressionValueException();
            }
            return result;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IExpressionConstants.NoExpressionValueException();
        }
    }

    protected final void popExpressionTypes(int count) throws IExpressionConstants.NoExpressionValueException {
        try {
            int remove = this.expressionTypeStack.size() - 1;
            while (count-- > 0) {
                this.expressionTypeStack.remove(remove--);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IExpressionConstants.NoExpressionValueException();
        }
    }

    public final void close() {
        this.expressionStack.clear();
        this.expressionTypeStack.clear();
    }

    public final void pullValue(Object[] value) throws IExpressionConstants.NoExpressionValueException {
        value[0] = this.popExpression();
        value[1] = this.popExpressionType(false);
        this.close();
    }

    public final void pushExpression(Object o, Class t) {
        if (this.ignoreExpression > 0) {
            return;
        }
        this.pushExpressionValue(o, t);
    }

    public final void pushCast(Class type) throws IExpressionConstants.NoExpressionValueException, ClassCastException {
        if (this.ignoreExpression > 0) {
            return;
        }
        Object exp = this.popExpression();
        Class exptype = this.popExpressionType(false);
        this.pushExpressionValue(this.castBean(type, exp, exptype), type);
    }

    protected final Object castBean(Class returnType, Object bean, Class beanType) throws ClassCastException {
        if (bean == null) {
            if (!returnType.isPrimitive()) {
                return bean;
            }
            this.throwClassCast(returnType, bean);
        } else {
            if (returnType.equals(bean.getClass())) {
                return bean;
            }
            if (!returnType.isPrimitive()) {
                if (!beanType.isPrimitive() && returnType.isInstance(bean)) {
                    return bean;
                }
                this.throwClassCast(returnType, bean);
            } else {
                if (!beanType.isPrimitive()) {
                    this.throwClassCast(returnType, bean);
                }
                if (returnType == Boolean.TYPE) {
                    if (bean instanceof Boolean) {
                        return bean;
                    }
                    this.throwClassCast(returnType, bean);
                } else if (bean instanceof Number) {
                    if (returnType == Integer.TYPE) {
                        if (bean instanceof Integer) {
                            return bean;
                        }
                        return new Integer(((Number)bean).intValue());
                    }
                    if (returnType == Byte.TYPE) {
                        if (bean instanceof Byte) {
                            return bean;
                        }
                        return new Byte(((Number)bean).byteValue());
                    }
                    if (returnType == Character.TYPE) {
                        if (bean instanceof Character) {
                            return bean;
                        }
                        return new Character((char)((Number)bean).intValue());
                    }
                    if (returnType == Double.TYPE) {
                        if (bean instanceof Double) {
                            return bean;
                        }
                        return new Double(((Number)bean).doubleValue());
                    }
                    if (returnType == Float.TYPE) {
                        if (bean instanceof Float) {
                            return bean;
                        }
                        return new Float(((Number)bean).floatValue());
                    }
                    if (returnType == Long.TYPE) {
                        if (bean instanceof Long) {
                            return bean;
                        }
                        return new Long(((Number)bean).longValue());
                    }
                    if (returnType == Short.TYPE) {
                        if (bean instanceof Short) {
                            return bean;
                        }
                        return new Short(((Number)bean).shortValue());
                    }
                    this.throwClassCast(returnType, bean);
                } else if (bean instanceof Character) {
                    if (returnType == Character.TYPE) {
                        return bean;
                    }
                    if (returnType == Integer.TYPE) {
                        return new Integer(((Character)bean).charValue());
                    }
                    if (returnType == Byte.TYPE) {
                        return new Byte((byte)((Character)bean).charValue());
                    }
                    if (returnType == Double.TYPE) {
                        return new Double(((Character)bean).charValue());
                    }
                    if (returnType == Float.TYPE) {
                        return new Float(((Character)bean).charValue());
                    }
                    if (returnType == Long.TYPE) {
                        return new Long(((Character)bean).charValue());
                    }
                    if (returnType == Short.TYPE) {
                        return new Short((short)((Character)bean).charValue());
                    }
                    this.throwClassCast(returnType, bean);
                } else {
                    this.throwClassCast(returnType, bean);
                }
            }
        }
        return null;
    }

    private void throwClassCast(Class returnType, Object bean) throws ClassCastException {
        throw new ClassCastException(MessageFormat.format(InitparserTreeMessages.getString("ExpressionProcesser.CannotCastXToY_EXC_"), bean != null ? bean.getClass().getName() : null, returnType.getName()));
    }

    protected final Class getPrimitiveType(Object bean) {
        if (bean instanceof Boolean) {
            return Boolean.TYPE;
        }
        if (bean instanceof Integer) {
            return Integer.TYPE;
        }
        if (bean instanceof Byte) {
            return Byte.TYPE;
        }
        if (bean instanceof Character) {
            return Character.TYPE;
        }
        if (bean instanceof Double) {
            return Double.TYPE;
        }
        if (bean instanceof Float) {
            return Float.TYPE;
        }
        if (bean instanceof Long) {
            return Long.TYPE;
        }
        if (bean instanceof Short) {
            return Short.TYPE;
        }
        throw new IllegalArgumentException(bean != null ? bean.getClass().getName() : "null");
    }

    public final void pushInstanceof(Class type) throws IExpressionConstants.NoExpressionValueException {
        Class exptype;
        if (this.ignoreExpression > 0) {
            return;
        }
        Object exp = this.popExpression();
        this.pushExpressionValue(this.isInstance(type, exp, exptype = this.popExpressionType(false)) ? Boolean.TRUE : Boolean.FALSE, Boolean.TYPE);
    }

    protected final boolean isInstance(Class type, Object bean, Class beanType) {
        if (type.isPrimitive()) {
            return beanType.isPrimitive() && type == beanType;
        }
        return type.isInstance(bean);
    }

    public final void pushPrefix(int operator) throws IExpressionConstants.NoExpressionValueException {
        if (this.ignoreExpression > 0) {
            return;
        }
        if (operator == 0) {
            return;
        }
        Object exp = this.popExpression();
        Class exptype = this.popExpressionType(false);
        if (!exptype.isPrimitive()) {
            this.throwInvalidPrefix(operator, exp);
        }
        int primTypeEnum = this.getEnumForPrimitive(exptype);
        block0 : switch (operator) {
            case 1: {
                switch (primTypeEnum) {
                    case 0: {
                        this.throwInvalidPrefix(operator, exp);
                    }
                    case 1: {
                        exp = new Integer(-((Number)exp).byteValue());
                        break;
                    }
                    case 3: {
                        exp = new Integer(-((Character)exp).charValue());
                        break;
                    }
                    case 7: {
                        exp = new Double(-((Number)exp).doubleValue());
                        break;
                    }
                    case 6: {
                        exp = new Float(-((Number)exp).floatValue());
                        break;
                    }
                    case 4: {
                        exp = new Integer(-((Number)exp).intValue());
                        break;
                    }
                    case 5: {
                        exp = new Long(-((Number)exp).longValue());
                        break;
                    }
                    case 2: {
                        exp = new Integer(-((Number)exp).shortValue());
                    }
                }
                exptype = this.getPrimitiveType(exp);
                break;
            }
            case 2: {
                switch (primTypeEnum) {
                    case 0: 
                    case 6: 
                    case 7: {
                        this.throwInvalidPrefix(operator, exp);
                    }
                    case 1: {
                        exp = new Integer(~((Number)exp).byteValue());
                        break;
                    }
                    case 3: {
                        exp = new Integer(~((Character)exp).charValue());
                        break;
                    }
                    case 4: {
                        exp = new Integer(~((Number)exp).intValue());
                        break;
                    }
                    case 5: {
                        exp = new Long(((Number)exp).longValue() ^ 0xFFFFFFFFFFFFFFFFL);
                        break;
                    }
                    case 2: {
                        exp = new Integer(~((Number)exp).shortValue());
                    }
                }
                exptype = this.getPrimitiveType(exp);
                break;
            }
            case 3: {
                switch (primTypeEnum) {
                    case 0: {
                        exp = (Boolean)exp == false ? Boolean.TRUE : Boolean.FALSE;
                        break block0;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        this.throwInvalidPrefix(operator, exp);
                    }
                }
            }
        }
        this.pushExpressionValue(exp, exptype);
    }

    protected final int getEnumForPrimitive(Class primitiveType) {
        if (primitiveType == Boolean.TYPE) {
            return 0;
        }
        if (primitiveType == Integer.TYPE) {
            return 4;
        }
        if (primitiveType == Byte.TYPE) {
            return 1;
        }
        if (primitiveType == Character.TYPE) {
            return 3;
        }
        if (primitiveType == Double.TYPE) {
            return 7;
        }
        if (primitiveType == Float.TYPE) {
            return 6;
        }
        if (primitiveType == Long.TYPE) {
            return 5;
        }
        if (primitiveType == Short.TYPE) {
            return 2;
        }
        throw new IllegalArgumentException();
    }

    private void throwInvalidPrefix(int operator, Object exp) throws IllegalArgumentException {
        throw new IllegalArgumentException(MessageFormat.format(InitparserTreeMessages.getString("ExpressionProcesser.InvalidOperandOfPrefixOperator_EXC_"), exp != null ? exp.toString() : null, PRE_OPER_TO_STRING[operator]));
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public final void pushInfix(int operator, int operandType) throws IExpressionConstants.NoExpressionValueException {
        v0 = wasIgnoring = this.ignoreExpression > 0;
        if (wasIgnoring) {
            if (operandType == 0) {
                ++this.ignoreExpression;
            } else if (operandType == 2) {
                --this.ignoreExpression;
            }
        }
        if (this.ignoreExpression > 0) {
            return;
        }
        if (wasIgnoring && operandType == 2) {
            return;
        }
        right = null;
        rightType = null;
        if (operandType != 0) {
            right = this.popExpression();
            rightType = this.popExpressionType(false);
        }
        value = this.popExpression();
        valueType /* !! */  = this.popExpressionType(false);
        switch (operator) {
            case 15: {
                if (operandType == 0) break;
                this.testValidBitType(valueType /* !! */ , 15);
                this.testValidBitType(rightType, 15);
                if (valueType /* !! */  == Long.TYPE || rightType == Long.TYPE) {
                    value = new Long(this.getLong(value) & this.getLong(right));
                    valueType /* !! */  = Long.TYPE;
                    break;
                }
                value = new Integer(this.getInt(value) & this.getInt(right));
                valueType /* !! */  = Integer.TYPE;
                break;
            }
            case 17: {
                if (operandType != 0) {
                    value = right;
                    valueType /* !! */  = rightType;
                }
                if (valueType /* !! */  != Boolean.TYPE) {
                    this.throwInvalidInfix(operator, value);
                }
                if (((Boolean)value).booleanValue() || operandType == 2) break;
                ++this.ignoreExpression;
                break;
            }
            case 18: {
                if (operandType != 0) {
                    value = right;
                    valueType /* !! */  = rightType;
                }
                if (valueType /* !! */  != Boolean.TYPE) {
                    this.throwInvalidInfix(operator, value);
                }
                if (!((Boolean)value).booleanValue() || operandType == 2) break;
                ++this.ignoreExpression;
                break;
            }
            case 1: {
                if (operandType == 0) break;
                this.testValidArithmeticType(valueType /* !! */ , 1);
                this.testValidArithmeticType(rightType, 1);
                if (valueType /* !! */  == Double.TYPE || rightType == Double.TYPE) {
                    value = new Double(this.getDouble(value) / this.getDouble(right));
                    valueType /* !! */  = Double.TYPE;
                    break;
                }
                if (valueType /* !! */  == Float.TYPE || rightType == Float.TYPE) {
                    value = new Float(this.getFloat(value) / this.getFloat(right));
                    valueType /* !! */  = Float.TYPE;
                    break;
                }
                if (valueType /* !! */  == Long.TYPE || rightType == Long.TYPE) {
                    value = new Long(this.getLong(value) / this.getLong(right));
                    valueType /* !! */  = Long.TYPE;
                    break;
                }
                value = new Integer(this.getInt(value) / this.getInt(right));
                valueType /* !! */  = Integer.TYPE;
                break;
            }
            case 12: {
                if (operandType == 0) break;
                value = valueType /* !! */ .isPrimitive() && rightType.isPrimitive() ? (valueType /* !! */  == Boolean.TYPE || rightType == Boolean.TYPE ? (valueType /* !! */  != Boolean.TYPE || valueType /* !! */  != Boolean.TYPE ? Boolean.FALSE : (((Boolean)value).booleanValue() == ((Boolean)right).booleanValue() ? Boolean.TRUE : Boolean.FALSE)) : (valueType /* !! */  == Double.TYPE || rightType == Double.TYPE ? (this.getDouble(value) == this.getDouble(right) ? Boolean.TRUE : Boolean.FALSE) : (valueType /* !! */  == Float.TYPE || rightType == Float.TYPE ? (this.getFloat(value) == this.getFloat(right) ? Boolean.TRUE : Boolean.FALSE) : (valueType /* !! */  == Long.TYPE || rightType == Long.TYPE ? (this.getLong(value) == this.getLong(right) ? Boolean.TRUE : Boolean.FALSE) : (this.getInt(value) == this.getInt(right) ? Boolean.TRUE : Boolean.FALSE))))) : (valueType /* !! */ .isPrimitive() != false || rightType.isPrimitive() != false ? Boolean.FALSE : (value == right ? Boolean.TRUE : Boolean.FALSE));
                valueType /* !! */  = Boolean.TYPE;
                break;
            }
            case 9: {
                if (operandType == 0) break;
                this.testValidArithmeticType(valueType /* !! */ , 9);
                this.testValidArithmeticType(rightType, 9);
                value = valueType /* !! */  == Double.TYPE || rightType == Double.TYPE ? (this.getDouble(value) > this.getDouble(right) ? Boolean.TRUE : Boolean.FALSE) : (valueType /* !! */  == Float.TYPE || rightType == Float.TYPE ? (this.getFloat(value) > this.getFloat(right) ? Boolean.TRUE : Boolean.FALSE) : (valueType /* !! */  == Long.TYPE || rightType == Long.TYPE ? (this.getLong(value) > this.getLong(right) ? Boolean.TRUE : Boolean.FALSE) : (this.getInt(value) > this.getInt(right) ? Boolean.TRUE : Boolean.FALSE)));
                valueType /* !! */  = Boolean.TYPE;
                break;
            }
            case 11: {
                if (operandType == 0) break;
                this.testValidArithmeticType(valueType /* !! */ , 11);
                this.testValidArithmeticType(rightType, 11);
                value = valueType /* !! */  == Double.TYPE || rightType == Double.TYPE ? (this.getDouble(value) >= this.getDouble(right) ? Boolean.TRUE : Boolean.FALSE) : (valueType /* !! */  == Float.TYPE || rightType == Float.TYPE ? (this.getFloat(value) >= this.getFloat(right) ? Boolean.TRUE : Boolean.FALSE) : (valueType /* !! */  == Long.TYPE || rightType == Long.TYPE ? (this.getLong(value) >= this.getLong(right) ? Boolean.TRUE : Boolean.FALSE) : (this.getInt(value) >= this.getInt(right) ? Boolean.TRUE : Boolean.FALSE)));
                valueType /* !! */  = Boolean.TYPE;
                break;
            }
            case 5: {
                if (operandType == 0) break;
                this.testValidBitType(valueType /* !! */ , 5);
                this.testValidBitType(rightType, 5);
                if (valueType /* !! */  == Long.TYPE || rightType == Long.TYPE) {
                    value = new Long(this.getLong(value) << (int)this.getLong(right));
                    valueType /* !! */  = Long.TYPE;
                    break;
                }
                value = new Integer(this.getInt(value) << this.getInt(right));
                valueType /* !! */  = Integer.TYPE;
                break;
            }
            case 8: {
                if (operandType == 0) break;
                this.testValidArithmeticType(valueType /* !! */ , 8);
                this.testValidArithmeticType(rightType, 8);
                value = valueType /* !! */  == Double.TYPE || rightType == Double.TYPE ? (this.getDouble(value) < this.getDouble(right) ? Boolean.TRUE : Boolean.FALSE) : (valueType /* !! */  == Float.TYPE || rightType == Float.TYPE ? (this.getFloat(value) < this.getFloat(right) ? Boolean.TRUE : Boolean.FALSE) : (valueType /* !! */  == Long.TYPE || rightType == Long.TYPE ? (this.getLong(value) < this.getLong(right) ? Boolean.TRUE : Boolean.FALSE) : (this.getInt(value) < this.getInt(right) ? Boolean.TRUE : Boolean.FALSE)));
                valueType /* !! */  = Boolean.TYPE;
                break;
            }
            case 10: {
                if (operandType == 0) break;
                this.testValidArithmeticType(valueType /* !! */ , 10);
                this.testValidArithmeticType(rightType, 10);
                value = valueType /* !! */  == Double.TYPE || rightType == Double.TYPE ? (this.getDouble(value) <= this.getDouble(right) ? Boolean.TRUE : Boolean.FALSE) : (valueType /* !! */  == Float.TYPE || rightType == Float.TYPE ? (this.getFloat(value) <= this.getFloat(right) ? Boolean.TRUE : Boolean.FALSE) : (valueType /* !! */  == Long.TYPE || rightType == Long.TYPE ? (this.getLong(value) <= this.getLong(right) ? Boolean.TRUE : Boolean.FALSE) : (this.getInt(value) <= this.getInt(right) ? Boolean.TRUE : Boolean.FALSE)));
                valueType /* !! */  = Boolean.TYPE;
                break;
            }
            case 4: {
                if (operandType == 0) break;
                this.testValidArithmeticType(valueType /* !! */ , 4);
                this.testValidArithmeticType(rightType, 4);
                if (valueType /* !! */  == Double.TYPE || rightType == Double.TYPE) {
                    value = new Double(this.getDouble(value) - this.getDouble(right));
                    valueType /* !! */  = Double.TYPE;
                    break;
                }
                if (valueType /* !! */  == Float.TYPE || rightType == Float.TYPE) {
                    value = new Float(this.getFloat(value) - this.getFloat(right));
                    valueType /* !! */  = Float.TYPE;
                    break;
                }
                if (valueType /* !! */  == Long.TYPE || rightType == Long.TYPE) {
                    value = new Long(this.getLong(value) - this.getLong(right));
                    valueType /* !! */  = Long.TYPE;
                    break;
                }
                value = new Integer(this.getInt(value) - this.getInt(right));
                valueType /* !! */  = Integer.TYPE;
                break;
            }
            case 13: {
                if (operandType == 0) break;
                value = valueType /* !! */ .isPrimitive() && rightType.isPrimitive() ? (valueType /* !! */  == Boolean.TYPE || rightType == Boolean.TYPE ? (valueType /* !! */  != Boolean.TYPE || valueType /* !! */  != Boolean.TYPE ? Boolean.TRUE : (((Boolean)value).booleanValue() != ((Boolean)right).booleanValue() ? Boolean.TRUE : Boolean.FALSE)) : (valueType /* !! */  == Double.TYPE || rightType == Double.TYPE ? (this.getDouble(value) != this.getDouble(right) ? Boolean.TRUE : Boolean.FALSE) : (valueType /* !! */  == Float.TYPE || rightType == Float.TYPE ? (this.getFloat(value) != this.getFloat(right) ? Boolean.TRUE : Boolean.FALSE) : (valueType /* !! */  == Long.TYPE || rightType == Long.TYPE ? (this.getLong(value) != this.getLong(right) ? Boolean.TRUE : Boolean.FALSE) : (this.getInt(value) != this.getInt(right) ? Boolean.TRUE : Boolean.FALSE))))) : (valueType /* !! */ .isPrimitive() != false || rightType.isPrimitive() != false ? Boolean.TRUE : (value != right ? Boolean.TRUE : Boolean.FALSE));
                valueType /* !! */  = Boolean.TYPE;
                break;
            }
            case 16: {
                if (operandType == 0) break;
                this.testValidBitType(valueType /* !! */ , 16);
                this.testValidBitType(rightType, 16);
                if (valueType /* !! */  == Long.TYPE || rightType == Long.TYPE) {
                    value = new Long(this.getLong(value) | this.getLong(right));
                    valueType /* !! */  = Long.TYPE;
                    break;
                }
                value = new Integer(this.getInt(value) | this.getInt(right));
                valueType /* !! */  = Integer.TYPE;
                break;
            }
            case 3: {
                if (operandType != 0) ** GOTO lbl159
                v1 = ExpressionProcesser.class$0;
                if (v1 == null) {
                    try {
                        v1 = ExpressionProcesser.class$0 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException v2) {
                        throw new NoClassDefFoundError(v2.getMessage());
                    }
                }
                if (valueType /* !! */  != v1) break;
                value = new StringBuffer((String)value);
                break;
lbl159:
                // 1 sources

                this.testValidPlusType(valueType /* !! */ , rightType);
                v3 = ExpressionProcesser.class$0;
                if (v3 == null) {
                    try {
                        v3 = ExpressionProcesser.class$0 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException v4) {
                        throw new NoClassDefFoundError(v4.getMessage());
                    }
                }
                if (valueType /* !! */  == v3) ** GOTO lbl176
                v5 = ExpressionProcesser.class$0;
                if (v5 == null) {
                    try {
                        v5 = ExpressionProcesser.class$0 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException v6) {
                        throw new NoClassDefFoundError(v6.getMessage());
                    }
                }
                if (rightType != v5) ** GOTO lbl203
lbl176:
                // 2 sources

                sb = null;
                v7 = ExpressionProcesser.class$0;
                if (v7 == null) {
                    try {
                        v7 = ExpressionProcesser.class$0 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException v8) {
                        throw new NoClassDefFoundError(v8.getMessage());
                    }
                }
                if (valueType /* !! */  != v7) ** GOTO lbl187
                sb = (StringBuffer)value;
                ** GOTO lbl199
lbl187:
                // 1 sources

                sb = new StringBuffer(((String)right).length() + 16);
                this.appendToBuffer(sb, value, valueType /* !! */ );
                value = sb;
                v9 /* !! */  = ExpressionProcesser.class$0;
                if (v9 /* !! */  == null) {
                    try {
                        ExpressionProcesser.class$0 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException v10) {
                        throw new NoClassDefFoundError(v10.getMessage());
                    }
                    v9 /* !! */  = ExpressionProcesser.class$0;
                }
                valueType /* !! */  = v9 /* !! */ ;
lbl199:
                // 2 sources

                this.appendToBuffer(sb, right, rightType);
                if (operandType != 2) break;
                value = sb.toString();
                break;
lbl203:
                // 1 sources

                if (valueType /* !! */  == Double.TYPE || rightType == Double.TYPE) {
                    value = new Double(this.getDouble(value) + this.getDouble(right));
                    valueType /* !! */  = Double.TYPE;
                    break;
                }
                if (valueType /* !! */  == Float.TYPE || rightType == Float.TYPE) {
                    value = new Float(this.getFloat(value) + this.getFloat(right));
                    valueType /* !! */  = Float.TYPE;
                    break;
                }
                if (valueType /* !! */  == Long.TYPE || rightType == Long.TYPE) {
                    value = new Long(this.getLong(value) + this.getLong(right));
                    valueType /* !! */  = Long.TYPE;
                    break;
                }
                value = new Integer(this.getInt(value) + this.getInt(right));
                valueType /* !! */  = Integer.TYPE;
                break;
            }
            case 2: {
                if (operandType == 0) break;
                this.testValidArithmeticType(valueType /* !! */ , 2);
                this.testValidArithmeticType(rightType, 2);
                if (valueType /* !! */  == Double.TYPE || rightType == Double.TYPE) {
                    value = new Double(this.getDouble(value) % this.getDouble(right));
                    valueType /* !! */  = Double.TYPE;
                    break;
                }
                if (valueType /* !! */  == Float.TYPE || rightType == Float.TYPE) {
                    value = new Float(this.getFloat(value) % this.getFloat(right));
                    valueType /* !! */  = Float.TYPE;
                    break;
                }
                if (valueType /* !! */  == Long.TYPE || rightType == Long.TYPE) {
                    value = new Long(this.getLong(value) % this.getLong(right));
                    valueType /* !! */  = Long.TYPE;
                    break;
                }
                value = new Integer(this.getInt(value) % this.getInt(right));
                valueType /* !! */  = Integer.TYPE;
                break;
            }
            case 6: {
                if (operandType == 0) break;
                this.testValidBitType(valueType /* !! */ , 6);
                this.testValidBitType(rightType, 6);
                if (valueType /* !! */  == Long.TYPE || rightType == Long.TYPE) {
                    value = new Long(this.getLong(value) >> (int)this.getLong(right));
                    valueType /* !! */  = Long.TYPE;
                    break;
                }
                value = new Integer(this.getInt(value) >> this.getInt(right));
                valueType /* !! */  = Integer.TYPE;
                break;
            }
            case 7: {
                if (operandType == 0) break;
                this.testValidBitType(valueType /* !! */ , 7);
                this.testValidBitType(rightType, 7);
                if (valueType /* !! */  == Long.TYPE || rightType == Long.TYPE) {
                    value = new Long(this.getLong(value) >>> (int)this.getLong(right));
                    valueType /* !! */  = Long.TYPE;
                    break;
                }
                value = new Integer(this.getInt(value) >>> this.getInt(right));
                valueType /* !! */  = Integer.TYPE;
                break;
            }
            case 0: {
                if (operandType == 0) break;
                this.testValidArithmeticType(valueType /* !! */ , 0);
                this.testValidArithmeticType(rightType, 0);
                if (valueType /* !! */  == Double.TYPE || rightType == Double.TYPE) {
                    value = new Double(this.getDouble(value) * this.getDouble(right));
                    valueType /* !! */  = Double.TYPE;
                    break;
                }
                if (valueType /* !! */  == Float.TYPE || rightType == Float.TYPE) {
                    value = new Float(this.getFloat(value) * this.getFloat(right));
                    valueType /* !! */  = Float.TYPE;
                    break;
                }
                if (valueType /* !! */  == Long.TYPE || rightType == Long.TYPE) {
                    value = new Long(this.getLong(value) * this.getLong(right));
                    valueType /* !! */  = Long.TYPE;
                    break;
                }
                value = new Integer(this.getInt(value) * this.getInt(right));
                valueType /* !! */  = Integer.TYPE;
                break;
            }
            case 14: {
                if (operandType == 0) break;
                this.testValidBitType(valueType /* !! */ , 14);
                this.testValidBitType(rightType, 14);
                if (valueType /* !! */  == Long.TYPE || rightType == Long.TYPE) {
                    value = new Long(this.getLong(value) ^ this.getLong(right));
                    valueType /* !! */  = Long.TYPE;
                    break;
                }
                value = new Integer(this.getInt(value) ^ this.getInt(right));
                valueType /* !! */  = Integer.TYPE;
            }
        }
        this.pushExpressionValue(value, valueType /* !! */ );
    }

    protected final int getInt(Object bean) {
        return bean instanceof Number ? ((Number)bean).intValue() : (int)((Character)bean).charValue();
    }

    protected final float getFloat(Object bean) {
        return bean instanceof Number ? ((Number)bean).floatValue() : (float)((Character)bean).charValue();
    }

    protected final double getDouble(Object bean) {
        return bean instanceof Number ? ((Number)bean).doubleValue() : (double)((Character)bean).charValue();
    }

    protected final long getLong(Object bean) {
        return bean instanceof Number ? ((Number)bean).longValue() : (long)((Character)bean).charValue();
    }

    private void throwInvalidInfix(int operator, Object value) throws IllegalArgumentException {
        throw new IllegalArgumentException(MessageFormat.format(InitparserTreeMessages.getString("ExpressionProcesser.InvalidOperandOfOperator_EXC_"), value != null ? value.toString() : null, IN_OPER_TO_STRING[operator]));
    }

    private void testValidBitType(Class type, int operator) {
        if (!type.isPrimitive() || type == Boolean.TYPE || type == Double.TYPE || type == Float.TYPE) {
            this.throwInvalidInfix(operator, type);
        }
    }

    private void testValidArithmeticType(Class type, int operator) {
        if (!type.isPrimitive() || type == Boolean.TYPE) {
            this.throwInvalidInfix(operator, type);
        }
    }

    private void testValidPlusType(Class left, Class right) {
        block12: {
            block11: {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (left == clazz) break block11;
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$0 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (right != clazz2) break block12;
            }
            return;
        }
        this.testValidArithmeticType(left, 3);
        this.testValidArithmeticType(right, 3);
    }

    private void appendToBuffer(StringBuffer sb, Object value, Class valueType) {
        if (value == null) {
            sb.append((Object)null);
        } else {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (valueType == clazz) {
                sb.append((String)value);
            } else if (valueType.isPrimitive()) {
                switch (this.getEnumForPrimitive(valueType)) {
                    case 0: {
                        sb.append((Boolean)value);
                        break;
                    }
                    case 1: {
                        sb.append(((Number)value).byteValue());
                        break;
                    }
                    case 3: {
                        sb.append(((Character)value).charValue());
                        break;
                    }
                    case 7: {
                        sb.append(((Number)value).doubleValue());
                        break;
                    }
                    case 6: {
                        sb.append(((Number)value).floatValue());
                        break;
                    }
                    case 4: {
                        sb.append(((Number)value).intValue());
                        break;
                    }
                    case 5: {
                        sb.append(((Number)value).longValue());
                        break;
                    }
                    case 2: {
                        sb.append(((Number)value).shortValue());
                    }
                }
            } else {
                sb.append(value);
            }
        }
    }

    public final void pushArrayAccess(int indexCount) throws IExpressionConstants.NoExpressionValueException {
        Object value;
        Class[] componentTypes;
        if (this.ignoreExpression > 0) {
            return;
        }
        int[] arguments = new int[indexCount];
        int i = indexCount - 1;
        while (i >= 0) {
            Object index = this.popExpression();
            Class indexType = this.popExpressionType(false);
            if (indexType.isPrimitive() && (indexType == Integer.TYPE || indexType == Short.TYPE || indexType == Character.TYPE || indexType == Byte.TYPE)) {
                arguments[i] = this.getInt(index);
            } else {
                this.throwClassCast(Integer.TYPE, index);
            }
            --i;
        }
        Object array = this.popExpression();
        Class<?> arrayType = this.popExpressionType(false);
        if (arrayType.isArray()) {
            int dimcount = 0;
            componentTypes = new Class[indexCount];
            Class<?> componentType = arrayType;
            while (dimcount < indexCount && componentType.isArray()) {
                componentTypes[dimcount++] = componentType = componentType.getComponentType();
            }
            if (dimcount < indexCount) {
                throw new IllegalArgumentException(MessageFormat.format(InitparserTreeMessages.getString("ExpressionProcesser.XIsGreaterThanNumberOfDimensionsInArray_EXC_"), new Integer(indexCount), new Integer(dimcount)));
            }
            value = array;
            int i2 = 0;
            while (i2 < indexCount) {
                value = Array.get(value, arguments[i2]);
                ++i2;
            }
        } else {
            throw new IllegalArgumentException(MessageFormat.format(InitparserTreeMessages.getString("ExpressionProcesser.NotAnArray_EXC_"), arrayType));
        }
        this.pushExpressionValue(value, componentTypes[indexCount - 1]);
    }

    public final void pushArrayCreation(Class arrayType, int dimensionCount) throws IExpressionConstants.NoExpressionValueException {
        if (this.ignoreExpression > 0) {
            return;
        }
        if (dimensionCount != 0) {
            Class<?> componentType = arrayType;
            int i = 0;
            while (i < dimensionCount && componentType != null) {
                componentType = componentType.getComponentType();
                ++i;
            }
            if (componentType == null) {
                throw new IllegalArgumentException(MessageFormat.format(InitparserTreeMessages.getString("ExpressionProcesser.ArraytypeHasFewerDimensionsThanRequested_EXC_"), arrayType, new Integer(dimensionCount)));
            }
            int[] dimInit = new int[dimensionCount];
            int i2 = dimensionCount - 1;
            while (i2 >= 0) {
                Object index = this.popExpression();
                Class dimType = this.popExpressionType(false);
                if (dimType.isPrimitive() && (dimType == Integer.TYPE || dimType == Short.TYPE || dimType == Character.TYPE || dimType == Byte.TYPE)) {
                    dimInit[i2] = this.getInt(index);
                } else {
                    this.throwClassCast(Integer.TYPE, index);
                }
                --i2;
            }
            Object array = Array.newInstance(componentType, dimInit);
            this.pushExpressionValue(array, arrayType);
        }
    }

    public final void pushArrayInitializer(Class arrayType, int expressionCount) throws IExpressionConstants.NoExpressionValueException {
        if (this.ignoreExpression > 0) {
            return;
        }
        Object[] dimValues = null;
        if (expressionCount > 0) {
            dimValues = new Object[expressionCount];
            int i = expressionCount - 1;
            while (i >= 0) {
                Object dimValue = dimValues[i] = this.popExpression();
                Class dimType = this.popExpressionType(false);
                if (arrayType.isPrimitive()) {
                    if (dimValue == null || !dimType.isPrimitive()) {
                        this.throwClassCast(arrayType, dimType);
                    }
                    if (arrayType != dimType) {
                        int compEnum = this.getEnumForPrimitive(arrayType);
                        int dimEnum = this.getEnumForPrimitive(dimType);
                        if (compEnum == 0 || dimEnum == 0) {
                            this.throwClassCast(arrayType, dimType);
                        }
                        int dimValueAsInt = this.getInt(dimValue);
                        switch (compEnum) {
                            case 1: {
                                if (dimEnum > 4 || dimValueAsInt > 127 || dimValueAsInt < -128) {
                                    this.throwClassCast(arrayType, dimType);
                                }
                                dimValues[i] = new Byte((byte)dimValueAsInt);
                                break;
                            }
                            case 2: {
                                if (dimEnum > 4 || dimValueAsInt > Short.MAX_VALUE || dimValueAsInt < Short.MIN_VALUE) {
                                    this.throwClassCast(arrayType, dimType);
                                }
                                dimValues[i] = new Short((short)dimValueAsInt);
                                break;
                            }
                            case 3: {
                                if (dimEnum > 4 || dimValueAsInt > 65535 || dimValueAsInt < 0) {
                                    this.throwClassCast(arrayType, dimType);
                                }
                                dimValues[i] = new Character((char)dimValueAsInt);
                                break;
                            }
                            case 4: {
                                if (dimEnum > 4) {
                                    this.throwClassCast(arrayType, dimType);
                                }
                                dimValues[i] = new Integer(dimValueAsInt);
                                break;
                            }
                            case 5: {
                                if (dimEnum > 5) {
                                    this.throwClassCast(arrayType, dimType);
                                }
                                dimValues[i] = new Long(this.getLong(dimValue));
                                break;
                            }
                            case 6: {
                                if (dimEnum > 6) {
                                    this.throwClassCast(arrayType, dimType);
                                }
                                dimValues[i] = new Float(this.getFloat(dimValue));
                                break;
                            }
                            case 7: {
                                dimValues[i] = new Double(this.getDouble(dimValue));
                            }
                        }
                    }
                } else if (dimType != MethodHelper.NULL_TYPE && !arrayType.isAssignableFrom(dimType)) {
                    this.throwClassCast(arrayType, dimType);
                }
                --i;
            }
        }
        Object array = Array.newInstance(arrayType, new int[]{expressionCount});
        int i = 0;
        while (i < expressionCount) {
            Array.set(array, i, dimValues[i]);
            ++i;
        }
        this.pushExpressionValue(array, array.getClass());
    }

    public final void pushClassInstanceCreation(Class type, int argumentCount) throws IExpressionConstants.NoExpressionValueException, EvaluationException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        if (this.ignoreExpression > 0) {
            return;
        }
        Object value = null;
        if (argumentCount > 0) {
            Object[] args = new Object[argumentCount];
            Class[] argTypes = new Class[argumentCount];
            int i = argumentCount - 1;
            while (i >= 0) {
                args[i] = this.popExpression();
                argTypes[i] = this.popExpressionType(false);
                --i;
            }
            Constructor ctor = MethodHelper.findCompatibleConstructor(type, argTypes);
            value = ctor.newInstance(args);
        } else {
            value = type.newInstance();
        }
        this.pushExpressionValue(value, type);
    }

    public final void pushFieldAccess(String fieldName, boolean hasReceiver) throws IExpressionConstants.NoExpressionValueException, SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        if (this.ignoreExpression > 0) {
            return;
        }
        Object receiver = this.popExpression();
        Class receiverType = this.popExpressionType(false);
        Field field = receiverType.getField(fieldName);
        Object value = field.get(receiver);
        Class<?> valueType = field.getType();
        this.pushExpressionValue(value, valueType);
    }

    public final void pushMethodInvocation(String methodName, boolean hasReceiver, int argCount) throws IExpressionConstants.NoExpressionValueException, EvaluationException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (this.ignoreExpression > 0) {
            return;
        }
        Object[] args = new Object[argCount];
        Class[] argTypes = new Class[argCount];
        int i = argCount - 1;
        while (i >= 0) {
            args[i] = this.popExpression();
            argTypes[i] = this.popExpressionType(false);
            --i;
        }
        Object receiver = this.popExpression();
        Class receiverType = this.popExpressionType(false);
        Method method = MethodHelper.findCompatibleMethod(receiverType, methodName, argTypes);
        Object value = method.invoke(receiver, args);
        this.pushExpressionValue(value, method.getReturnType());
    }

    public final void pushConditional(int expressionType) throws IExpressionConstants.NoExpressionValueException {
        boolean wasIgnoring;
        boolean bl = wasIgnoring = this.ignoreExpression > 0;
        if (wasIgnoring) {
            this.ignoreExpression = expressionType == 7 ? (this.ignoreExpression += 2) : --this.ignoreExpression;
            if (this.ignoreExpression > 0) {
                return;
            }
        }
        switch (expressionType) {
            case 7: {
                Object condition = this.popExpression();
                Class type = this.popExpressionType(false);
                if (type != Boolean.TYPE) {
                    this.throwClassCast(Boolean.TYPE, condition);
                }
                if (((Boolean)condition).booleanValue()) break;
                ++this.ignoreExpression;
                break;
            }
            case 8: {
                if (wasIgnoring) break;
                ++this.ignoreExpression;
                break;
            }
        }
    }
}

