/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.swt;

import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.jem.internal.instantiation.InstantiationFactory;
import org.eclipse.jem.internal.instantiation.JavaAllocation;
import org.eclipse.jem.internal.instantiation.PTClassInstanceCreation;
import org.eclipse.jem.internal.instantiation.PTExpression;
import org.eclipse.jem.internal.instantiation.PTFieldAccess;
import org.eclipse.jem.internal.instantiation.PTInstanceReference;
import org.eclipse.jem.internal.instantiation.PTName;
import org.eclipse.jem.internal.instantiation.ParseTreeAllocation;
import org.eclipse.jem.internal.instantiation.base.IJavaObjectInstance;
import org.eclipse.jem.internal.instantiation.base.JavaInstantiation;
import org.eclipse.ve.internal.cde.commands.ApplyAttributeSettingCommand;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.java.core.JavaEditDomainHelper;
import org.eclipse.ve.internal.java.visual.VisualContainerPolicy;
import org.eclipse.ve.internal.propertysheet.common.commands.AbstractCommand;
import org.eclipse.ve.internal.propertysheet.common.commands.CompoundCommand;
import org.eclipse.ve.internal.swt.BeanSWTUtilities;
import org.eclipse.ve.internal.swt.SWTConstants;

public class CompositeContainerPolicy
extends VisualContainerPolicy {
    protected EReference sfLayoutData;

    public CompositeContainerPolicy(EditDomain domain) {
        super(JavaInstantiation.getSFeature((ResourceSet)JavaEditDomainHelper.getResourceSet((EditDomain)domain), (URI)SWTConstants.SF_COMPOSITE_CONTROLS), domain);
        ResourceSet rset = JavaEditDomainHelper.getResourceSet((EditDomain)domain);
        this.sfLayoutData = JavaInstantiation.getReference((ResourceSet)rset, (URI)SWTConstants.SF_CONTROL_LAYOUTDATA);
    }

    public Command getCreateCommand(Object child, Object positionBeforeChild) {
        Command result = super.getCreateCommand(child, positionBeforeChild);
        IJavaObjectInstance javaChild = (IJavaObjectInstance)child;
        if (javaChild.getAllocation() != null) {
            EnsureCorrectParentCommand insertCorrectParentCommand = new EnsureCorrectParentCommand((IJavaObjectInstance)child);
            return insertCorrectParentCommand.chain(result);
        }
        return this.createInitStringCommand((IJavaObjectInstance)child).chain(result);
    }

    private Command createInitStringCommand(IJavaObjectInstance child) {
        PTClassInstanceCreation ic = InstantiationFactory.eINSTANCE.createPTClassInstanceCreation();
        ic.setType(child.getJavaType().getJavaName());
        PTInstanceReference ir = InstantiationFactory.eINSTANCE.createPTInstanceReference();
        ir.setObject((IJavaObjectInstance)this.getContainer());
        PTFieldAccess fa = InstantiationFactory.eINSTANCE.createPTFieldAccess();
        PTName name = InstantiationFactory.eINSTANCE.createPTName("org.eclipse.swt.SWT");
        fa.setField("NONE");
        fa.setReceiver((PTExpression)name);
        ic.getArguments().add((Object)ir);
        ic.getArguments().add((Object)fa);
        ParseTreeAllocation alloc = InstantiationFactory.eINSTANCE.createParseTreeAllocation((PTExpression)ic);
        ApplyAttributeSettingCommand applyCmd = new ApplyAttributeSettingCommand();
        applyCmd.setTarget((EObject)child);
        applyCmd.setAttribute(child.eClass().getEStructuralFeature("allocation"));
        applyCmd.setAttributeSettingValue((Object)alloc);
        return applyCmd;
    }

    public Command getOrphanChildrenCommand(List children) {
        CompoundCommand cmd = new CompoundCommand();
        Iterator iter = children.iterator();
        while (iter.hasNext()) {
            IJavaObjectInstance child = (IJavaObjectInstance)iter.next();
            cmd.append((Command)new EnsureCorrectParentCommand(child));
        }
        cmd.append(super.getOrphanChildrenCommand(children));
        return cmd;
    }

    protected Command primAddCommand(List children, Object positionBeforeChild, EStructuralFeature containmentSF) {
        CompoundCommand cmd = new CompoundCommand();
        Iterator iter = children.iterator();
        while (iter.hasNext()) {
            IJavaObjectInstance child = (IJavaObjectInstance)iter.next();
            if (!BeanSWTUtilities.isValidBeanLocation(this.domain, (EObject)child, (EObject)this.container)) {
                return UnexecutableCommand.INSTANCE;
            }
            cmd.append((Command)new EnsureCorrectParentCommand(child));
        }
        cmd.append(super.primAddCommand(children, positionBeforeChild, containmentSF));
        return cmd;
    }

    public Command getCreateCommand(Object constraintComponent, Object childComponent, Object position) {
        return null;
    }

    public Command getAddCommand(List componentConstraints, List childrenComponents, Object position) {
        return null;
    }

    public class EnsureCorrectParentCommand
    extends AbstractCommand {
        private IJavaObjectInstance javaChild;

        public EnsureCorrectParentCommand(IJavaObjectInstance aChild) {
            this.javaChild = aChild;
        }

        public void execute() {
            if (this.javaChild.getAllocation() != null) {
                PTClassInstanceCreation classInstanceCreation;
                IJavaObjectInstance correctParent = (IJavaObjectInstance)CompositeContainerPolicy.this.getContainer();
                PTExpression expression = ((ParseTreeAllocation)this.javaChild.getAllocation()).getExpression();
                if (expression instanceof PTClassInstanceCreation && (classInstanceCreation = (PTClassInstanceCreation)expression).getArguments().size() == 2) {
                    PTInstanceReference instanceReference;
                    Object firstArgument = classInstanceCreation.getArguments().get(0);
                    if (firstArgument instanceof PTName && ((PTName)firstArgument).getName().equals("{parentComposite}")) {
                        PTInstanceReference parentRef = InstantiationFactory.eINSTANCE.createPTInstanceReference();
                        parentRef.setObject(correctParent);
                        classInstanceCreation.getArguments().remove(0);
                        classInstanceCreation.getArguments().add(0, (Object)parentRef);
                        ParseTreeAllocation newAlloc = InstantiationFactory.eINSTANCE.createParseTreeAllocation();
                        newAlloc.setExpression(expression);
                        this.javaChild.setAllocation((JavaAllocation)newAlloc);
                    } else if (firstArgument instanceof PTInstanceReference && (instanceReference = (PTInstanceReference)firstArgument).getObject() != correctParent) {
                        instanceReference.setObject(correctParent);
                        ParseTreeAllocation newAlloc = InstantiationFactory.eINSTANCE.createParseTreeAllocation();
                        newAlloc.setExpression(expression);
                        this.javaChild.setAllocation((JavaAllocation)newAlloc);
                    }
                }
            }
        }

        protected boolean prepare() {
            return true;
        }
    }
}

