/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.swt;

import java.io.DataInputStream;
import java.io.InputStream;
import java.util.logging.Level;
import org.eclipse.core.runtime.Platform;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jem.internal.proxy.awt.IRectangleBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanTypeProxy;
import org.eclipse.jem.internal.proxy.core.ICallback;
import org.eclipse.jem.internal.proxy.core.IIntegerBeanProxy;
import org.eclipse.jem.internal.proxy.core.IMethodProxy;
import org.eclipse.jem.internal.proxy.core.ThrowableProxy;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ve.internal.cde.core.IVisualComponentListener;
import org.eclipse.ve.internal.cde.core.VisualComponentSupport;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;

public class ControlManager
implements ICallback {
    private IMethodProxy fClientBoxMethodProxy;
    private IMethodProxy fControlManagerBoundsMethodProxy;
    public static final int CO_RESIZED = 1;
    public static final int CO_MOVED = 2;
    public static final int CO_REFRESHED = 3;
    public static final int IMAGE_INITIAL_LENGTH = 4;
    public static final int IMAGE_FINISHED = 5;
    public static final int IMAGE_COLOR_MASKS = 6;
    protected VisualComponentSupport vcSupport = new VisualComponentSupport();
    protected IBeanProxy fControlManagerProxy;
    protected IBeanProxy fControlBeanProxy;
    protected int fWidth;
    protected int fHeight;
    protected int fX;
    protected int fY;
    private DataCollector fDataCollector;

    public void addComponentListener(IVisualComponentListener aListener) {
        this.vcSupport.addComponentListener(aListener);
    }

    public void removeComponentListener(IVisualComponentListener aListener) {
        this.vcSupport.removeComponentListener(aListener);
    }

    public void release() {
        if (this.fControlManagerProxy != null && this.fControlManagerProxy.isValid()) {
            if (this.fControlBeanProxy != null) {
                this.invoke_setControlManager(this.fControlManagerProxy, null);
            }
            this.fControlManagerProxy.getProxyFactoryRegistry().getCallbackRegistry().deregisterCallback(this.fControlManagerProxy);
        }
    }

    public void setControlBeanProxy(IBeanProxy aControlBeanProxy) {
        if (this.fControlBeanProxy != null) {
            this.invoke_setControlManager(this.fControlManagerProxy, null);
        }
        this.fControlBeanProxy = aControlBeanProxy;
        if (this.fControlBeanProxy != null) {
            try {
                if (this.fControlManagerProxy == null) {
                    IBeanTypeProxy componentManagerType = null;
                    if ("win32".equals(Platform.getOS())) {
                        componentManagerType = this.fControlBeanProxy.getProxyFactoryRegistry().getBeanTypeProxyFactory().getBeanTypeProxy("org.eclipse.ve.internal.swt.targetvm.win32.Win32ControlManager");
                    } else if ("gtk".equals(Platform.getWS())) {
                        componentManagerType = this.fControlBeanProxy.getProxyFactoryRegistry().getBeanTypeProxyFactory().getBeanTypeProxy("org.eclipse.ve.internal.swt.targetvm.unix.GTKControlManager");
                    }
                    this.fControlManagerProxy = componentManagerType.newInstance();
                    aControlBeanProxy.getProxyFactoryRegistry().getCallbackRegistry().registerCallback(this.fControlManagerProxy, (ICallback)this);
                }
                this.invoke_setControlManager(this.fControlManagerProxy, this.fControlBeanProxy);
            }
            catch (ThrowableProxy e) {
                JavaVEPlugin.log((Throwable)e, (Level)Level.WARNING);
            }
        }
    }

    private void invoke_setControlManager(IBeanProxy controlManagerProxy, IBeanProxy controlBeanProxy) {
        IMethodProxy setControlMethodProxy = controlManagerProxy.getTypeProxy().getMethodProxy("setControl", "org.eclipse.swt.widgets.Control");
        setControlMethodProxy.invokeCatchThrowableExceptions(controlManagerProxy, controlBeanProxy);
    }

    public Object calledBack(int msgID, IBeanProxy parm) {
        switch (msgID) {
            case 3: {
                this.fireControlRefreshed();
                break;
            }
            case 5: {
                this.fDataCollector.setComplete();
            }
        }
        return null;
    }

    public Object calledBack(int msgID, Object parm) {
        return null;
    }

    public void calledBackStream(int msgID, InputStream is) {
        switch (msgID) {
            case 0: {
                DataInputStream dataInput = new DataInputStream(is);
                try {
                    int nextInt = dataInput.read();
                    while (nextInt != -1) {
                        this.fDataCollector.write(nextInt);
                        nextInt = dataInput.read();
                    }
                }
                catch (Exception exc) {
                    JavaVEPlugin.log((Throwable)exc, (Level)Level.WARNING);
                }
                break;
            }
            default: {
                if (!JavaVEPlugin.isLoggingLevel((Level)Level.WARNING)) break;
                JavaVEPlugin.log((Object)("Invalid callback in ImageDataCollector=" + msgID), (Level)Level.WARNING);
            }
        }
    }

    public ImageData getImageData() {
        return this.fDataCollector == null ? null : this.fDataCollector.getImageData();
    }

    public Object calledBack(int msgID, Object[] parms) {
        switch (msgID) {
            case 1: {
                this.componentResized(((IIntegerBeanProxy)parms[0]).intValue(), ((IIntegerBeanProxy)parms[1]).intValue());
                break;
            }
            case 2: {
                this.componentMoved(((IIntegerBeanProxy)parms[0]).intValue(), ((IIntegerBeanProxy)parms[1]).intValue());
                break;
            }
            case 4: {
                this.fDataCollector = new DataCollector();
                this.fDataCollector.setLength(((IIntegerBeanProxy)parms[0]).intValue());
                this.fDataCollector.setSize(((IIntegerBeanProxy)parms[1]).intValue(), ((IIntegerBeanProxy)parms[2]).intValue());
                break;
            }
            case 6: {
                this.fDataCollector.depth = ((IIntegerBeanProxy)parms[0]).intValue();
                this.fDataCollector.redMask = ((IIntegerBeanProxy)parms[1]).intValue();
                this.fDataCollector.greenMask = ((IIntegerBeanProxy)parms[2]).intValue();
                this.fDataCollector.blueMask = ((IIntegerBeanProxy)parms[3]).intValue();
            }
        }
        return null;
    }

    protected void componentResized(int width, int height) {
        this.vcSupport.fireComponentResized(width, height);
        this.fWidth = width;
        this.fHeight = height;
    }

    protected void componentMoved(int x, int y) {
        this.vcSupport.fireComponentMoved(x, y);
        this.fX = x;
        this.fY = y;
    }

    protected void componentHidden() {
        this.vcSupport.fireComponentHidden();
    }

    protected void componentShown() {
        this.vcSupport.fireComponentShown();
    }

    public Dimension getSize() {
        return new Dimension(this.fWidth, this.fHeight);
    }

    public Point getLocation() {
        return new Point(this.fX, this.fY);
    }

    public Rectangle getBounds() {
        if (this.fControlManagerProxy != null && this.fControlBeanProxy != null) {
            IRectangleBeanProxy boundsProxy = (IRectangleBeanProxy)this.getControlManagerBoundsMethodProxy().invokeCatchThrowableExceptions(this.fControlManagerProxy);
            return boundsProxy != null ? new Rectangle(boundsProxy.getX(), boundsProxy.getY(), boundsProxy.getWidth(), boundsProxy.getHeight()) : new Rectangle(0, 0, 0, 0);
        }
        return new Rectangle(0, 0, 0, 0);
    }

    public void fireControlRefreshed() {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                ControlManager.this.vcSupport.fireComponentRefreshed();
            }
        });
    }

    public void dispose() {
        if (this.fControlManagerProxy != null) {
            if (this.fControlManagerProxy.isValid()) {
                this.invoke_setControlManager(this.fControlManagerProxy, null);
                this.fControlManagerProxy.getProxyFactoryRegistry().getCallbackRegistry().deregisterCallback(this.fControlManagerProxy);
                this.fControlManagerProxy.getProxyFactoryRegistry().releaseProxy(this.fControlManagerProxy);
            }
            this.fControlManagerProxy = null;
        }
    }

    private IMethodProxy getControlManagerBoundsMethodProxy() {
        if (this.fControlManagerBoundsMethodProxy == null) {
            this.fControlManagerBoundsMethodProxy = this.fControlManagerProxy.getTypeProxy().getMethodProxy("getBounds");
        }
        return this.fControlManagerBoundsMethodProxy;
    }

    public Rectangle getClientBox() {
        if (this.fControlManagerProxy != null && this.fControlBeanProxy != null) {
            IRectangleBeanProxy fClientBoxBeanProxy;
            if (this.fClientBoxMethodProxy == null) {
                this.fClientBoxMethodProxy = this.fControlManagerProxy.getTypeProxy().getMethodProxy("getClientBox");
            }
            return (fClientBoxBeanProxy = (IRectangleBeanProxy)this.fClientBoxMethodProxy.invokeCatchThrowableExceptions(this.fControlManagerProxy)) != null ? new Rectangle(fClientBoxBeanProxy.getX(), fClientBoxBeanProxy.getY(), fClientBoxBeanProxy.getWidth(), fClientBoxBeanProxy.getHeight()) : null;
        }
        return null;
    }

    public void captureImage() {
        if (this.fControlManagerProxy != null && this.fControlBeanProxy != null) {
            IMethodProxy collectImageMethodProxy = this.fControlManagerProxy.getTypeProxy().getMethodProxy("captureImage");
            collectImageMethodProxy.invokeCatchThrowableExceptions(this.fControlManagerProxy);
        }
    }

    class DataCollector {
        int fPointer;
        int fWidth;
        int fHeight;
        int[] data;
        boolean isComplete;
        ImageData fImageData;
        int depth;
        int redMask;
        int greenMask;
        int blueMask;

        DataCollector() {
        }

        public void setLength(int length) {
            this.data = new int[length];
        }

        public void setSize(int width, int height) {
            this.fWidth = width;
            this.fHeight = height;
        }

        public void write(int i) {
            this.data[this.fPointer] = i;
            ++this.fPointer;
        }

        public void setComplete() {
            this.isComplete = true;
        }

        public ImageData getImageData() {
            if (this.isComplete && this.fImageData == null) {
                this.fImageData = new ImageData(this.fWidth, this.fHeight, this.depth, new PaletteData(this.redMask, this.greenMask, this.blueMask));
                byte[] bytes = new byte[this.data.length];
                int i = 0;
                while (i < this.data.length) {
                    bytes[i] = (byte)this.data[i];
                    ++i;
                }
                this.fImageData.data = bytes;
            }
            return this.fImageData;
        }
    }
}

