/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.swt;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridLayout;

public class GridLayoutGridFigure
extends Figure {
    Rectangle clientArea = new Rectangle();
    Point mousePosition = null;
    int[] columnWidths = null;
    int[] rowHeights = null;
    int[] expandableColumns = null;
    int[] expandableRows = null;
    int[] columnPositions = null;
    int[] rowPositions = null;
    Point[] rowStartPositions = null;
    Point[] rowEndPositions = null;
    Point[] columnStartPositions = null;
    Point[] columnEndPositions = null;
    int marginWidth;
    int marginHeight;
    int verticalSpacing;
    int horizontalSpacing;
    int bonusWidth = 0;
    int bonusHeight = 0;
    boolean columnsEqualWidth = false;

    public GridLayoutGridFigure(Rectangle bounds, int[][] layoutDimensions, int[][] expandableDimensions, boolean columnsEqualWidth, Rectangle spacing, Rectangle clientArea) {
        this.setBounds(bounds);
        this.clientArea = clientArea;
        this.columnsEqualWidth = columnsEqualWidth;
        if (spacing == null) {
            GridLayout example = new GridLayout();
            this.marginWidth = example.marginWidth;
            this.marginHeight = example.marginHeight;
            this.horizontalSpacing = example.horizontalSpacing;
            this.verticalSpacing = example.verticalSpacing;
        } else {
            this.marginWidth = spacing.x;
            this.marginHeight = spacing.y;
            this.horizontalSpacing = spacing.width;
            this.verticalSpacing = spacing.height;
        }
        if (layoutDimensions != null) {
            this.columnWidths = layoutDimensions[0];
            this.rowHeights = layoutDimensions[1];
            if (expandableDimensions != null) {
                this.expandableColumns = expandableDimensions[0];
                this.expandableRows = expandableDimensions[1];
                this.calculateBonusSizes();
            }
            this.calculateColumnDividers();
            this.calculateRowDividers();
        }
    }

    protected void paintFigure(Graphics g) {
        Color orgColor = g.getForegroundColor();
        g.setForegroundColor(ColorConstants.red);
        g.setLineStyle(3);
        this.drawColumnDividers(g);
        this.drawRowDividers(g);
        g.setForegroundColor(orgColor);
    }

    private void calculateBonusSizes() {
        int i;
        if (this.clientArea == null || this.expandableColumns == null || this.expandableRows == null) {
            return;
        }
        if (this.expandableColumns.length != 0) {
            int containerWidth = 0;
            i = 0;
            while (i < this.columnWidths.length) {
                containerWidth += this.columnWidths[i];
                ++i;
            }
            containerWidth += this.marginWidth * 2;
            this.bonusWidth = (this.clientArea.width - (containerWidth += this.horizontalSpacing * (this.columnWidths.length - 1))) / this.expandableColumns.length;
        }
        if (this.expandableRows.length != 0) {
            int containerHeight = 0;
            i = 0;
            while (i < this.rowHeights.length) {
                containerHeight += this.rowHeights[i];
                ++i;
            }
            containerHeight += this.marginHeight * 2;
            this.bonusHeight = (this.clientArea.height - (containerHeight += this.verticalSpacing * (this.rowHeights.length - 1))) / this.expandableRows.length;
        }
    }

    protected void calculateColumnDividers() {
        if (this.rowHeights == null || this.columnWidths == null || this.clientArea == null) {
            return;
        }
        int spacingTop = (int)Math.ceil((double)this.horizontalSpacing / 2.0);
        int spacingBottom = (int)Math.floor((double)this.horizontalSpacing / 2.0);
        boolean isExpanding = this.bonusWidth != 0;
        int equalWidth = 0;
        Rectangle r = this.getBounds();
        int containerHeight = 0;
        this.columnPositions = new int[this.columnWidths.length + 1];
        this.columnStartPositions = new Point[this.columnWidths.length + 1];
        this.columnEndPositions = new Point[this.columnWidths.length + 1];
        if (this.bonusHeight != 0) {
            containerHeight = this.clientArea.height;
        } else {
            int i = 0;
            while (i < this.rowHeights.length) {
                containerHeight += this.rowHeights[i];
                ++i;
            }
            containerHeight += this.marginHeight * 2;
            containerHeight += this.verticalSpacing * (this.rowHeights.length - 1);
        }
        int xPos = r.x + this.clientArea.x;
        int yMin = r.y + this.clientArea.y;
        int yMax = r.y + this.clientArea.y + containerHeight;
        if (this.columnsEqualWidth) {
            int padding = this.marginWidth * 2 + this.horizontalSpacing * (this.columnWidths.length - 1);
            equalWidth = (this.clientArea.width - padding) / this.columnWidths.length;
        }
        this.columnPositions[0] = xPos;
        this.columnStartPositions[0] = new Point(xPos, yMin);
        this.columnEndPositions[0] = new Point(xPos, yMax);
        xPos += this.marginWidth;
        int i = 0;
        while (i < this.columnWidths.length) {
            if (this.columnsEqualWidth) {
                xPos += equalWidth;
            } else {
                xPos += this.columnWidths[i];
                if (isExpanding && this.arrayContains(this.expandableColumns, i)) {
                    xPos += this.bonusWidth;
                }
            }
            xPos = i != this.columnWidths.length - 1 ? (xPos += spacingTop) : (xPos += this.marginWidth);
            if (xPos >= r.x + r.width) {
                xPos = r.x + r.width - 1;
            }
            Point startPoint = new Point(xPos, yMin);
            Point endPoint = new Point(xPos, yMax);
            this.columnPositions[i + 1] = xPos;
            this.columnStartPositions[i + 1] = startPoint;
            this.columnEndPositions[i + 1] = endPoint;
            xPos += spacingBottom;
            ++i;
        }
    }

    protected void drawColumnDividers(Graphics g) {
        if (this.columnStartPositions == null && this.columnEndPositions == null) {
            return;
        }
        int i = 0;
        while (i < this.columnStartPositions.length) {
            g.drawLine(this.columnStartPositions[i], this.columnEndPositions[i]);
            ++i;
        }
    }

    protected void calculateRowDividers() {
        if (this.rowHeights == null || this.columnWidths == null || this.clientArea == null) {
            return;
        }
        int spacingLeft = (int)Math.ceil((double)this.verticalSpacing / 2.0);
        int spacingRight = (int)Math.floor((double)this.verticalSpacing / 2.0);
        boolean isExpanding = this.bonusHeight != 0;
        Rectangle r = this.getBounds();
        int containerWidth = 0;
        this.rowPositions = new int[this.rowHeights.length + 1];
        this.rowStartPositions = new Point[this.rowHeights.length + 1];
        this.rowEndPositions = new Point[this.rowHeights.length + 1];
        if (this.bonusWidth != 0) {
            containerWidth = this.clientArea.width;
        } else {
            int i = 0;
            while (i < this.columnWidths.length) {
                containerWidth += this.columnWidths[i];
                ++i;
            }
            containerWidth += this.marginWidth * 2;
            containerWidth += this.horizontalSpacing * (this.columnWidths.length - 1);
        }
        int yPos = r.y + this.clientArea.y;
        int xMin = r.x + this.clientArea.x;
        int xMax = r.x + this.clientArea.x + containerWidth;
        this.rowPositions[0] = yPos;
        this.rowStartPositions[0] = new Point(xMin, yPos);
        this.rowEndPositions[0] = new Point(xMax, yPos);
        yPos += this.marginHeight;
        int i = 0;
        while (i < this.rowHeights.length) {
            yPos += this.rowHeights[i];
            if (isExpanding && this.arrayContains(this.expandableRows, i)) {
                yPos += this.bonusHeight;
            }
            if (yPos >= r.y + r.height) {
                yPos = r.y + r.height - 1;
            }
            yPos = i != this.rowHeights.length - 1 ? (yPos += spacingLeft) : (yPos += this.marginHeight);
            Point startPoint = new Point(xMin, yPos);
            Point endPoint = new Point(xMax, yPos);
            this.rowPositions[i + 1] = yPos;
            this.rowStartPositions[i + 1] = startPoint;
            this.rowEndPositions[i + 1] = endPoint;
            yPos += spacingRight;
            ++i;
        }
    }

    protected void drawRowDividers(Graphics g) {
        if (this.rowStartPositions == null && this.rowEndPositions == null) {
            return;
        }
        int i = 0;
        while (i < this.rowStartPositions.length) {
            g.drawLine(this.rowStartPositions[i], this.rowEndPositions[i]);
            ++i;
        }
    }

    private boolean arrayContains(int[] array, int value) {
        int i = 0;
        while (i < array.length) {
            if (array[i] == value) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Point getCellLocation(Point p) {
        return this.getCellLocation(p.x, p.y);
    }

    public Point getCellLocation(int x, int y) {
        return this.getCellLocation(x, y, false, false);
    }

    public Point getCellLocation(int x, int y, boolean includeEmptyColumns, boolean includeEmptyRows) {
        int j;
        if (this.rowPositions == null || this.columnPositions == null) {
            return new Point(0, 0);
        }
        int gridx = 0;
        int gridy = 0;
        boolean foundx = false;
        boolean foundy = false;
        int i = 0;
        while (i < this.columnPositions.length - 1) {
            int xpos = this.columnPositions[i];
            if (x >= xpos && x < this.columnPositions[i + 1]) {
                gridx = i;
                if (includeEmptyColumns) {
                    j = i;
                    while (j >= 0 && this.columnPositions[i] == this.columnPositions[j]) {
                        --j;
                    }
                    gridx = j + 1;
                }
                foundx = true;
                break;
            }
            ++i;
        }
        i = 0;
        while (i < this.rowPositions.length - 1) {
            int ypos = this.rowPositions[i];
            if (y >= ypos && y < this.rowPositions[i + 1]) {
                gridy = i;
                if (includeEmptyRows) {
                    j = i;
                    while (j >= 0 && this.rowPositions[i] == this.rowPositions[j]) {
                        --j;
                    }
                    gridy = j + 1;
                }
                foundy = true;
                break;
            }
            ++i;
        }
        if (!foundx && x >= this.columnPositions[this.columnPositions.length - 1]) {
            gridx = this.columnPositions.length - 2;
        }
        if (!foundy && y >= this.rowPositions[this.rowPositions.length - 1]) {
            gridy = this.rowPositions.length - 2;
        }
        return new Point(gridx, gridy);
    }

    public int getRowHeight(int row) {
        if (this.rowHeights == null || row < 0 || row >= this.rowHeights.length) {
            return -1;
        }
        return this.rowHeights[row];
    }

    public Rectangle getCellBounds(int x, int y) {
        if (this.rowPositions == null || this.columnPositions == null) {
            return new Rectangle();
        }
        int cellxpos = 0;
        int cellypos = 0;
        int cellwidth = 0;
        int cellheight = 0;
        int i = 0;
        while (i < this.columnPositions.length - 1) {
            int xpos = this.columnPositions[i];
            if (x >= xpos && x < this.columnPositions[i + 1]) {
                cellxpos = xpos;
                cellwidth = this.columnPositions[i + 1] - xpos;
                break;
            }
            ++i;
        }
        i = 0;
        while (i < this.rowPositions.length - 1) {
            int ypos = this.rowPositions[i];
            if (y >= ypos && y < this.rowPositions[i + 1]) {
                cellypos = ypos;
                cellheight = this.rowPositions[i + 1] - ypos;
                break;
            }
            ++i;
        }
        return new Rectangle(cellxpos, cellypos, cellwidth, cellheight);
    }

    public Rectangle getGridBroundsForCellBounds(Rectangle cellsBounds) {
        Rectangle r = new Rectangle();
        if (this.rowPositions != null && this.columnPositions != null && cellsBounds.y <= this.rowPositions.length - 1 && cellsBounds.x <= this.columnPositions.length - 1) {
            r.x = this.columnPositions[cellsBounds.x];
            r.y = this.rowPositions[cellsBounds.y];
            r.width = cellsBounds.x + cellsBounds.width > this.columnPositions.length - 1 ? this.columnPositions[this.columnPositions.length - 1] : this.columnPositions[cellsBounds.x + cellsBounds.width];
            r.width -= r.x;
            r.height = cellsBounds.y + cellsBounds.height > this.rowPositions.length - 1 ? this.rowPositions[this.rowPositions.length - 1] : this.rowPositions[cellsBounds.y + cellsBounds.height];
            r.height -= r.y;
        }
        return r;
    }

    public Point getColumnStartPosition(int x) {
        if (this.columnStartPositions != null) {
            int i = 0;
            while (i < this.columnPositions.length) {
                int xpos = this.columnPositions[i];
                if (xpos <= x && x <= xpos + 3) {
                    return this.columnStartPositions[i];
                }
                ++i;
            }
        }
        return new Point(0, 0);
    }

    public Point getColumnEndPosition(int x) {
        if (this.columnEndPositions != null) {
            int i = 0;
            while (i < this.columnPositions.length) {
                int xpos = this.columnPositions[i];
                if (xpos <= x && x <= xpos + 3) {
                    return this.columnEndPositions[i];
                }
                ++i;
            }
        }
        return new Point(0, 0);
    }

    public Point getRowStartPosition(int y) {
        if (this.rowStartPositions != null) {
            int i = 0;
            while (i < this.rowPositions.length) {
                int ypos = this.rowPositions[i];
                if (ypos <= y && y < ypos + 3) {
                    return this.rowStartPositions[i];
                }
                ++i;
            }
        }
        return new Point(0, 0);
    }

    public Point getRowEndPosition(int y) {
        if (this.rowStartPositions != null) {
            int i = 0;
            while (i < this.rowPositions.length) {
                int ypos = this.rowPositions[i];
                if (ypos <= y && y < ypos + 3) {
                    return this.rowEndPositions[i];
                }
                ++i;
            }
        }
        return new Point(0, 0);
    }

    public void setLayoutDimensions(int[][] dim) {
        if (dim == null) {
            return;
        }
        this.columnWidths = dim[0];
        this.rowHeights = dim[1];
        this.calculateColumnDividers();
        this.calculateRowDividers();
        this.invalidate();
    }
}

